// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package kinesisanalyticsv2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DeleteApplicationVpcConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The name of an existing application.
	//
	// ApplicationName is a required field
	ApplicationName *string `min:"1" type:"string" required:"true"`

	// The current application version ID. You can retrieve the application version
	// ID using DescribeApplication.
	//
	// CurrentApplicationVersionId is a required field
	CurrentApplicationVersionId *int64 `min:"1" type:"long" required:"true"`

	// The ID of the VPC configuration to delete.
	//
	// VpcConfigurationId is a required field
	VpcConfigurationId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteApplicationVpcConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteApplicationVpcConfigurationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteApplicationVpcConfigurationInput"}

	if s.ApplicationName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ApplicationName", 1))
	}

	if s.CurrentApplicationVersionId == nil {
		invalidParams.Add(aws.NewErrParamRequired("CurrentApplicationVersionId"))
	}
	if s.CurrentApplicationVersionId != nil && *s.CurrentApplicationVersionId < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("CurrentApplicationVersionId", 1))
	}

	if s.VpcConfigurationId == nil {
		invalidParams.Add(aws.NewErrParamRequired("VpcConfigurationId"))
	}
	if s.VpcConfigurationId != nil && len(*s.VpcConfigurationId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("VpcConfigurationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteApplicationVpcConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the Kinesis Data Analytics application.
	ApplicationARN *string `min:"1" type:"string"`

	// The updated version ID of the application.
	ApplicationVersionId *int64 `min:"1" type:"long"`
}

// String returns the string representation
func (s DeleteApplicationVpcConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteApplicationVpcConfiguration = "DeleteApplicationVpcConfiguration"

// DeleteApplicationVpcConfigurationRequest returns a request value for making API operation for
// Amazon Kinesis Analytics.
//
// Removes a VPC configuration from a Kinesis Data Analytics application.
//
//    // Example sending a request using DeleteApplicationVpcConfigurationRequest.
//    req := client.DeleteApplicationVpcConfigurationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/DeleteApplicationVpcConfiguration
func (c *Client) DeleteApplicationVpcConfigurationRequest(input *DeleteApplicationVpcConfigurationInput) DeleteApplicationVpcConfigurationRequest {
	op := &aws.Operation{
		Name:       opDeleteApplicationVpcConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteApplicationVpcConfigurationInput{}
	}

	req := c.newRequest(op, input, &DeleteApplicationVpcConfigurationOutput{})

	return DeleteApplicationVpcConfigurationRequest{Request: req, Input: input, Copy: c.DeleteApplicationVpcConfigurationRequest}
}

// DeleteApplicationVpcConfigurationRequest is the request type for the
// DeleteApplicationVpcConfiguration API operation.
type DeleteApplicationVpcConfigurationRequest struct {
	*aws.Request
	Input *DeleteApplicationVpcConfigurationInput
	Copy  func(*DeleteApplicationVpcConfigurationInput) DeleteApplicationVpcConfigurationRequest
}

// Send marshals and sends the DeleteApplicationVpcConfiguration API request.
func (r DeleteApplicationVpcConfigurationRequest) Send(ctx context.Context) (*DeleteApplicationVpcConfigurationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteApplicationVpcConfigurationResponse{
		DeleteApplicationVpcConfigurationOutput: r.Request.Data.(*DeleteApplicationVpcConfigurationOutput),
		response:                                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteApplicationVpcConfigurationResponse is the response type for the
// DeleteApplicationVpcConfiguration API operation.
type DeleteApplicationVpcConfigurationResponse struct {
	*DeleteApplicationVpcConfigurationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteApplicationVpcConfiguration request.
func (r *DeleteApplicationVpcConfigurationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
