// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package kinesisvideomedia

import (
	"context"
	"io"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type GetMediaInput struct {
	_ struct{} `type:"structure"`

	// Identifies the starting chunk to get from the specified stream.
	//
	// StartSelector is a required field
	StartSelector *StartSelector `type:"structure" required:"true"`

	// The ARN of the stream from where you want to get the media content. If you
	// don't specify the streamARN, you must specify the streamName.
	StreamARN *string `min:"1" type:"string"`

	// The Kinesis video stream name from where you want to get the media content.
	// If you don't specify the streamName, you must specify the streamARN.
	StreamName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GetMediaInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetMediaInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetMediaInput"}

	if s.StartSelector == nil {
		invalidParams.Add(aws.NewErrParamRequired("StartSelector"))
	}
	if s.StreamARN != nil && len(*s.StreamARN) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("StreamARN", 1))
	}
	if s.StreamName != nil && len(*s.StreamName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("StreamName", 1))
	}
	if s.StartSelector != nil {
		if err := s.StartSelector.Validate(); err != nil {
			invalidParams.AddNested("StartSelector", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetMediaInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.StartSelector != nil {
		v := s.StartSelector

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "StartSelector", v, metadata)
	}
	if s.StreamARN != nil {
		v := *s.StreamARN

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StreamARN", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StreamName != nil {
		v := *s.StreamName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StreamName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type GetMediaOutput struct {
	_ struct{} `type:"structure" payload:"Payload"`

	// The content type of the requested media.
	ContentType *string `location:"header" locationName:"Content-Type" min:"1" type:"string"`

	// The payload Kinesis Video Streams returns is a sequence of chunks from the
	// specified stream. For information about the chunks, see . The chunks that
	// Kinesis Video Streams returns in the GetMedia call also include the following
	// additional Matroska (MKV) tags:
	//
	//    * AWS_KINESISVIDEO_CONTINUATION_TOKEN (UTF-8 string) - In the event your
	//    GetMedia call terminates, you can use this continuation token in your
	//    next request to get the next chunk where the last request terminated.
	//
	//    * AWS_KINESISVIDEO_MILLIS_BEHIND_NOW (UTF-8 string) - Client applications
	//    can use this tag value to determine how far behind the chunk returned
	//    in the response is from the latest chunk on the stream.
	//
	//    * AWS_KINESISVIDEO_FRAGMENT_NUMBER - Fragment number returned in the chunk.
	//
	//    * AWS_KINESISVIDEO_SERVER_TIMESTAMP - Server timestamp of the fragment.
	//
	//    * AWS_KINESISVIDEO_PRODUCER_TIMESTAMP - Producer timestamp of the fragment.
	//
	// The following tags will be present if an error occurs:
	//
	//    * AWS_KINESISVIDEO_ERROR_CODE - String description of an error that caused
	//    GetMedia to stop.
	//
	//    * AWS_KINESISVIDEO_ERROR_ID: Integer code of the error.
	//
	// The error codes are as follows:
	//
	//    * 3002 - Error writing to the stream
	//
	//    * 4000 - Requested fragment is not found
	//
	//    * 4500 - Access denied for the stream's KMS key
	//
	//    * 4501 - Stream's KMS key is disabled
	//
	//    * 4502 - Validation error on the stream's KMS key
	//
	//    * 4503 - KMS key specified in the stream is unavailable
	//
	//    * 4504 - Invalid usage of the KMS key specified in the stream
	//
	//    * 4505 - Invalid state of the KMS key specified in the stream
	//
	//    * 4506 - Unable to find the KMS key specified in the stream
	//
	//    * 5000 - Internal error
	Payload io.ReadCloser `type:"blob"`
}

// String returns the string representation
func (s GetMediaOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetMediaOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.ContentType != nil {
		v := *s.ContentType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	// Skipping Payload Output type's body not valid.
	return nil
}

const opGetMedia = "GetMedia"

// GetMediaRequest returns a request value for making API operation for
// Amazon Kinesis Video Streams Media.
//
// Use this API to retrieve media content from a Kinesis video stream. In the
// request, you identify the stream name or stream Amazon Resource Name (ARN),
// and the starting chunk. Kinesis Video Streams then returns a stream of chunks
// in order by fragment number.
//
// You must first call the GetDataEndpoint API to get an endpoint. Then send
// the GetMedia requests to this endpoint using the --endpoint-url parameter
// (https://docs.aws.amazon.com/cli/latest/reference/).
//
// When you put media data (fragments) on a stream, Kinesis Video Streams stores
// each incoming fragment and related metadata in what is called a "chunk."
// For more information, see PutMedia (https://docs.aws.amazon.com/kinesisvideostreams/latest/dg/API_dataplane_PutMedia.html).
// The GetMedia API returns a stream of these chunks starting from the chunk
// that you specify in the request.
//
// The following limits apply when using the GetMedia API:
//
//    * A client can call GetMedia up to five times per second per stream.
//
//    * Kinesis Video Streams sends media data at a rate of up to 25 megabytes
//    per second (or 200 megabits per second) during a GetMedia session.
//
// If an error is thrown after invoking a Kinesis Video Streams media API, in
// addition to the HTTP status code and the response body, it includes the following
// pieces of information:
//
//    * x-amz-ErrorType HTTP header – contains a more specific error type
//    in addition to what the HTTP status code provides.
//
//    * x-amz-RequestId HTTP header – if you want to report an issue to AWS,
//    the support team can better diagnose the problem if given the Request
//    Id.
//
// Both the HTTP status code and the ErrorType header can be utilized to make
// programmatic decisions about whether errors are retry-able and under what
// conditions, as well as provide information on what actions the client programmer
// might need to take in order to successfully try again.
//
// For more information, see the Errors section at the bottom of this topic,
// as well as Common Errors (https://docs.aws.amazon.com/kinesisvideostreams/latest/dg/CommonErrors.html).
//
//    // Example sending a request using GetMediaRequest.
//    req := client.GetMediaRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesis-video-media-2017-09-30/GetMedia
func (c *Client) GetMediaRequest(input *GetMediaInput) GetMediaRequest {
	op := &aws.Operation{
		Name:       opGetMedia,
		HTTPMethod: "POST",
		HTTPPath:   "/getMedia",
	}

	if input == nil {
		input = &GetMediaInput{}
	}

	req := c.newRequest(op, input, &GetMediaOutput{})

	return GetMediaRequest{Request: req, Input: input, Copy: c.GetMediaRequest}
}

// GetMediaRequest is the request type for the
// GetMedia API operation.
type GetMediaRequest struct {
	*aws.Request
	Input *GetMediaInput
	Copy  func(*GetMediaInput) GetMediaRequest
}

// Send marshals and sends the GetMedia API request.
func (r GetMediaRequest) Send(ctx context.Context) (*GetMediaResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetMediaResponse{
		GetMediaOutput: r.Request.Data.(*GetMediaOutput),
		response:       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetMediaResponse is the response type for the
// GetMedia API operation.
type GetMediaResponse struct {
	*GetMediaOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetMedia request.
func (r *GetMediaResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
