// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package kms

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

type DisableKeyRotationInput struct {
	_ struct{} `type:"structure"`

	// Identifies a symmetric customer master key (CMK). You cannot enable automatic
	// rotation of asymmetric CMKs (https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html#asymmetric-cmks),
	// CMKs with imported key material (https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys.html),
	// or CMKs in a custom key store (https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html).
	//
	// Specify the key ID or the Amazon Resource Name (ARN) of the CMK.
	//
	// For example:
	//
	//    * Key ID: 1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//    * Key ARN: arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab
	//
	// To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey.
	//
	// KeyId is a required field
	KeyId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DisableKeyRotationInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisableKeyRotationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DisableKeyRotationInput"}

	if s.KeyId == nil {
		invalidParams.Add(aws.NewErrParamRequired("KeyId"))
	}
	if s.KeyId != nil && len(*s.KeyId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("KeyId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DisableKeyRotationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisableKeyRotationOutput) String() string {
	return awsutil.Prettify(s)
}

const opDisableKeyRotation = "DisableKeyRotation"

// DisableKeyRotationRequest returns a request value for making API operation for
// AWS Key Management Service.
//
// Disables automatic rotation of the key material (https://docs.aws.amazon.com/kms/latest/developerguide/rotate-keys.html)
// for the specified symmetric customer master key (CMK).
//
// You cannot enable automatic rotation of asymmetric CMKs, CMKs with imported
// key material, or CMKs in a custom key store (https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html).
// You cannot perform this operation on a CMK in a different AWS account.
//
// The CMK that you use for this operation must be in a compatible key state.
// For details, see How Key State Affects Use of a Customer Master Key (https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
// in the AWS Key Management Service Developer Guide.
//
//    // Example sending a request using DisableKeyRotationRequest.
//    req := client.DisableKeyRotationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/DisableKeyRotation
func (c *Client) DisableKeyRotationRequest(input *DisableKeyRotationInput) DisableKeyRotationRequest {
	op := &aws.Operation{
		Name:       opDisableKeyRotation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisableKeyRotationInput{}
	}

	req := c.newRequest(op, input, &DisableKeyRotationOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)

	return DisableKeyRotationRequest{Request: req, Input: input, Copy: c.DisableKeyRotationRequest}
}

// DisableKeyRotationRequest is the request type for the
// DisableKeyRotation API operation.
type DisableKeyRotationRequest struct {
	*aws.Request
	Input *DisableKeyRotationInput
	Copy  func(*DisableKeyRotationInput) DisableKeyRotationRequest
}

// Send marshals and sends the DisableKeyRotation API request.
func (r DisableKeyRotationRequest) Send(ctx context.Context) (*DisableKeyRotationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DisableKeyRotationResponse{
		DisableKeyRotationOutput: r.Request.Data.(*DisableKeyRotationOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DisableKeyRotationResponse is the response type for the
// DisableKeyRotation API operation.
type DisableKeyRotationResponse struct {
	*DisableKeyRotationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DisableKeyRotation request.
func (r *DisableKeyRotationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
