// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package lexmodelbuildingserviceiface provides an interface to enable mocking the Amazon Lex Model Building Service service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package lexmodelbuildingserviceiface

import (
	"github.com/aws/aws-sdk-go-v2/service/lexmodelbuildingservice"
)

// ClientAPI provides an interface to enable mocking the
// lexmodelbuildingservice.Client methods. This make unit testing your code that
// calls out to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // Amazon Lex Model Building Service.
//    func myFunc(svc lexmodelbuildingserviceiface.ClientAPI) bool {
//        // Make svc.CreateBotVersion request
//    }
//
//    func main() {
//        cfg, err := external.LoadDefaultAWSConfig()
//        if err != nil {
//            panic("failed to load config, " + err.Error())
//        }
//
//        svc := lexmodelbuildingservice.New(cfg)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockClientClient struct {
//        lexmodelbuildingserviceiface.ClientPI
//    }
//    func (m *mockClientClient) CreateBotVersion(input *lexmodelbuildingservice.CreateBotVersionInput) (*lexmodelbuildingservice.CreateBotVersionOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockClientClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type ClientAPI interface {
	CreateBotVersionRequest(*lexmodelbuildingservice.CreateBotVersionInput) lexmodelbuildingservice.CreateBotVersionRequest

	CreateIntentVersionRequest(*lexmodelbuildingservice.CreateIntentVersionInput) lexmodelbuildingservice.CreateIntentVersionRequest

	CreateSlotTypeVersionRequest(*lexmodelbuildingservice.CreateSlotTypeVersionInput) lexmodelbuildingservice.CreateSlotTypeVersionRequest

	DeleteBotRequest(*lexmodelbuildingservice.DeleteBotInput) lexmodelbuildingservice.DeleteBotRequest

	DeleteBotAliasRequest(*lexmodelbuildingservice.DeleteBotAliasInput) lexmodelbuildingservice.DeleteBotAliasRequest

	DeleteBotChannelAssociationRequest(*lexmodelbuildingservice.DeleteBotChannelAssociationInput) lexmodelbuildingservice.DeleteBotChannelAssociationRequest

	DeleteBotVersionRequest(*lexmodelbuildingservice.DeleteBotVersionInput) lexmodelbuildingservice.DeleteBotVersionRequest

	DeleteIntentRequest(*lexmodelbuildingservice.DeleteIntentInput) lexmodelbuildingservice.DeleteIntentRequest

	DeleteIntentVersionRequest(*lexmodelbuildingservice.DeleteIntentVersionInput) lexmodelbuildingservice.DeleteIntentVersionRequest

	DeleteSlotTypeRequest(*lexmodelbuildingservice.DeleteSlotTypeInput) lexmodelbuildingservice.DeleteSlotTypeRequest

	DeleteSlotTypeVersionRequest(*lexmodelbuildingservice.DeleteSlotTypeVersionInput) lexmodelbuildingservice.DeleteSlotTypeVersionRequest

	DeleteUtterancesRequest(*lexmodelbuildingservice.DeleteUtterancesInput) lexmodelbuildingservice.DeleteUtterancesRequest

	GetBotRequest(*lexmodelbuildingservice.GetBotInput) lexmodelbuildingservice.GetBotRequest

	GetBotAliasRequest(*lexmodelbuildingservice.GetBotAliasInput) lexmodelbuildingservice.GetBotAliasRequest

	GetBotAliasesRequest(*lexmodelbuildingservice.GetBotAliasesInput) lexmodelbuildingservice.GetBotAliasesRequest

	GetBotChannelAssociationRequest(*lexmodelbuildingservice.GetBotChannelAssociationInput) lexmodelbuildingservice.GetBotChannelAssociationRequest

	GetBotChannelAssociationsRequest(*lexmodelbuildingservice.GetBotChannelAssociationsInput) lexmodelbuildingservice.GetBotChannelAssociationsRequest

	GetBotVersionsRequest(*lexmodelbuildingservice.GetBotVersionsInput) lexmodelbuildingservice.GetBotVersionsRequest

	GetBotsRequest(*lexmodelbuildingservice.GetBotsInput) lexmodelbuildingservice.GetBotsRequest

	GetBuiltinIntentRequest(*lexmodelbuildingservice.GetBuiltinIntentInput) lexmodelbuildingservice.GetBuiltinIntentRequest

	GetBuiltinIntentsRequest(*lexmodelbuildingservice.GetBuiltinIntentsInput) lexmodelbuildingservice.GetBuiltinIntentsRequest

	GetBuiltinSlotTypesRequest(*lexmodelbuildingservice.GetBuiltinSlotTypesInput) lexmodelbuildingservice.GetBuiltinSlotTypesRequest

	GetExportRequest(*lexmodelbuildingservice.GetExportInput) lexmodelbuildingservice.GetExportRequest

	GetImportRequest(*lexmodelbuildingservice.GetImportInput) lexmodelbuildingservice.GetImportRequest

	GetIntentRequest(*lexmodelbuildingservice.GetIntentInput) lexmodelbuildingservice.GetIntentRequest

	GetIntentVersionsRequest(*lexmodelbuildingservice.GetIntentVersionsInput) lexmodelbuildingservice.GetIntentVersionsRequest

	GetIntentsRequest(*lexmodelbuildingservice.GetIntentsInput) lexmodelbuildingservice.GetIntentsRequest

	GetSlotTypeRequest(*lexmodelbuildingservice.GetSlotTypeInput) lexmodelbuildingservice.GetSlotTypeRequest

	GetSlotTypeVersionsRequest(*lexmodelbuildingservice.GetSlotTypeVersionsInput) lexmodelbuildingservice.GetSlotTypeVersionsRequest

	GetSlotTypesRequest(*lexmodelbuildingservice.GetSlotTypesInput) lexmodelbuildingservice.GetSlotTypesRequest

	GetUtterancesViewRequest(*lexmodelbuildingservice.GetUtterancesViewInput) lexmodelbuildingservice.GetUtterancesViewRequest

	ListTagsForResourceRequest(*lexmodelbuildingservice.ListTagsForResourceInput) lexmodelbuildingservice.ListTagsForResourceRequest

	PutBotRequest(*lexmodelbuildingservice.PutBotInput) lexmodelbuildingservice.PutBotRequest

	PutBotAliasRequest(*lexmodelbuildingservice.PutBotAliasInput) lexmodelbuildingservice.PutBotAliasRequest

	PutIntentRequest(*lexmodelbuildingservice.PutIntentInput) lexmodelbuildingservice.PutIntentRequest

	PutSlotTypeRequest(*lexmodelbuildingservice.PutSlotTypeInput) lexmodelbuildingservice.PutSlotTypeRequest

	StartImportRequest(*lexmodelbuildingservice.StartImportInput) lexmodelbuildingservice.StartImportRequest

	TagResourceRequest(*lexmodelbuildingservice.TagResourceInput) lexmodelbuildingservice.TagResourceRequest

	UntagResourceRequest(*lexmodelbuildingservice.UntagResourceInput) lexmodelbuildingservice.UntagResourceRequest
}

var _ ClientAPI = (*lexmodelbuildingservice.Client)(nil)
