// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package licensemanager

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type UpdateServiceSettingsInput struct {
	_ struct{} `type:"structure"`

	// Activates cross-account discovery.
	EnableCrossAccountsDiscovery *bool `type:"boolean"`

	// Enables integration with AWS Organizations for cross-account discovery.
	OrganizationConfiguration *OrganizationConfiguration `type:"structure"`

	// Amazon Resource Name (ARN) of the Amazon S3 bucket where the License Manager
	// information is stored.
	S3BucketArn *string `type:"string"`

	// Amazon Resource Name (ARN) of the Amazon SNS topic used for License Manager
	// alerts.
	SnsTopicArn *string `type:"string"`
}

// String returns the string representation
func (s UpdateServiceSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateServiceSettingsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateServiceSettingsInput"}
	if s.OrganizationConfiguration != nil {
		if err := s.OrganizationConfiguration.Validate(); err != nil {
			invalidParams.AddNested("OrganizationConfiguration", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type UpdateServiceSettingsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateServiceSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateServiceSettings = "UpdateServiceSettings"

// UpdateServiceSettingsRequest returns a request value for making API operation for
// AWS License Manager.
//
// Updates License Manager settings for the current Region.
//
//    // Example sending a request using UpdateServiceSettingsRequest.
//    req := client.UpdateServiceSettingsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/UpdateServiceSettings
func (c *Client) UpdateServiceSettingsRequest(input *UpdateServiceSettingsInput) UpdateServiceSettingsRequest {
	op := &aws.Operation{
		Name:       opUpdateServiceSettings,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateServiceSettingsInput{}
	}

	req := c.newRequest(op, input, &UpdateServiceSettingsOutput{})

	return UpdateServiceSettingsRequest{Request: req, Input: input, Copy: c.UpdateServiceSettingsRequest}
}

// UpdateServiceSettingsRequest is the request type for the
// UpdateServiceSettings API operation.
type UpdateServiceSettingsRequest struct {
	*aws.Request
	Input *UpdateServiceSettingsInput
	Copy  func(*UpdateServiceSettingsInput) UpdateServiceSettingsRequest
}

// Send marshals and sends the UpdateServiceSettings API request.
func (r UpdateServiceSettingsRequest) Send(ctx context.Context) (*UpdateServiceSettingsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateServiceSettingsResponse{
		UpdateServiceSettingsOutput: r.Request.Data.(*UpdateServiceSettingsOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateServiceSettingsResponse is the response type for the
// UpdateServiceSettings API operation.
type UpdateServiceSettingsResponse struct {
	*UpdateServiceSettingsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateServiceSettings request.
func (r *UpdateServiceSettingsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
