// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package lightsail

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DeleteLoadBalancerInput struct {
	_ struct{} `type:"structure"`

	// The name of the load balancer you want to delete.
	//
	// LoadBalancerName is a required field
	LoadBalancerName *string `locationName:"loadBalancerName" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteLoadBalancerInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteLoadBalancerInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteLoadBalancerInput"}

	if s.LoadBalancerName == nil {
		invalidParams.Add(aws.NewErrParamRequired("LoadBalancerName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteLoadBalancerOutput struct {
	_ struct{} `type:"structure"`

	// An array of objects that describe the result of the action, such as the status
	// of the request, the timestamp of the request, and the resources affected
	// by the request.
	Operations []Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s DeleteLoadBalancerOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteLoadBalancer = "DeleteLoadBalancer"

// DeleteLoadBalancerRequest returns a request value for making API operation for
// Amazon Lightsail.
//
// Deletes a Lightsail load balancer and all its associated SSL/TLS certificates.
// Once the load balancer is deleted, you will need to create a new load balancer,
// create a new certificate, and verify domain ownership again.
//
// The delete load balancer operation supports tag-based access control via
// resource tags applied to the resource identified by load balancer name. For
// more information, see the Lightsail Dev Guide (https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags).
//
//    // Example sending a request using DeleteLoadBalancerRequest.
//    req := client.DeleteLoadBalancerRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteLoadBalancer
func (c *Client) DeleteLoadBalancerRequest(input *DeleteLoadBalancerInput) DeleteLoadBalancerRequest {
	op := &aws.Operation{
		Name:       opDeleteLoadBalancer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteLoadBalancerInput{}
	}

	req := c.newRequest(op, input, &DeleteLoadBalancerOutput{})

	return DeleteLoadBalancerRequest{Request: req, Input: input, Copy: c.DeleteLoadBalancerRequest}
}

// DeleteLoadBalancerRequest is the request type for the
// DeleteLoadBalancer API operation.
type DeleteLoadBalancerRequest struct {
	*aws.Request
	Input *DeleteLoadBalancerInput
	Copy  func(*DeleteLoadBalancerInput) DeleteLoadBalancerRequest
}

// Send marshals and sends the DeleteLoadBalancer API request.
func (r DeleteLoadBalancerRequest) Send(ctx context.Context) (*DeleteLoadBalancerResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteLoadBalancerResponse{
		DeleteLoadBalancerOutput: r.Request.Data.(*DeleteLoadBalancerOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteLoadBalancerResponse is the response type for the
// DeleteLoadBalancer API operation.
type DeleteLoadBalancerResponse struct {
	*DeleteLoadBalancerOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteLoadBalancer request.
func (r *DeleteLoadBalancerResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
