// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package lightsail

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetInstanceInput struct {
	_ struct{} `type:"structure"`

	// The name of the instance.
	//
	// InstanceName is a required field
	InstanceName *string `locationName:"instanceName" type:"string" required:"true"`
}

// String returns the string representation
func (s GetInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetInstanceInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetInstanceInput"}

	if s.InstanceName == nil {
		invalidParams.Add(aws.NewErrParamRequired("InstanceName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetInstanceOutput struct {
	_ struct{} `type:"structure"`

	// An array of key-value pairs containing information about the specified instance.
	Instance *Instance `locationName:"instance" type:"structure"`
}

// String returns the string representation
func (s GetInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetInstance = "GetInstance"

// GetInstanceRequest returns a request value for making API operation for
// Amazon Lightsail.
//
// Returns information about a specific Amazon Lightsail instance, which is
// a virtual private server.
//
//    // Example sending a request using GetInstanceRequest.
//    req := client.GetInstanceRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstance
func (c *Client) GetInstanceRequest(input *GetInstanceInput) GetInstanceRequest {
	op := &aws.Operation{
		Name:       opGetInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetInstanceInput{}
	}

	req := c.newRequest(op, input, &GetInstanceOutput{})

	return GetInstanceRequest{Request: req, Input: input, Copy: c.GetInstanceRequest}
}

// GetInstanceRequest is the request type for the
// GetInstance API operation.
type GetInstanceRequest struct {
	*aws.Request
	Input *GetInstanceInput
	Copy  func(*GetInstanceInput) GetInstanceRequest
}

// Send marshals and sends the GetInstance API request.
func (r GetInstanceRequest) Send(ctx context.Context) (*GetInstanceResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetInstanceResponse{
		GetInstanceOutput: r.Request.Data.(*GetInstanceOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetInstanceResponse is the response type for the
// GetInstance API operation.
type GetInstanceResponse struct {
	*GetInstanceOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetInstance request.
func (r *GetInstanceResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
