// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package lightsail

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type PutAlarmInput struct {
	_ struct{} `type:"structure"`

	// The name for the alarm. Specify the name of an existing alarm to update,
	// and overwrite the previous configuration of the alarm.
	//
	// AlarmName is a required field
	AlarmName *string `locationName:"alarmName" type:"string" required:"true"`

	// The arithmetic operation to use when comparing the specified statistic to
	// the threshold. The specified statistic value is used as the first operand.
	//
	// ComparisonOperator is a required field
	ComparisonOperator ComparisonOperator `locationName:"comparisonOperator" type:"string" required:"true" enum:"true"`

	// The contact protocols to use for the alarm, such as Email, SMS (text messaging),
	// or both.
	//
	// A notification is sent via the specified contact protocol if notifications
	// are enabled for the alarm, and when the alarm is triggered.
	//
	// A notification is not sent if a contact protocol is not specified, if the
	// specified contact protocol is not configured in the AWS Region, or if notifications
	// are not enabled for the alarm using the notificationEnabled paramater.
	//
	// Use the CreateContactMethod action to configure a contact protocol in an
	// AWS Region.
	ContactProtocols []ContactProtocol `locationName:"contactProtocols" type:"list"`

	// The number of data points that must be not within the specified threshold
	// to trigger the alarm. If you are setting an "M out of N" alarm, this value
	// (datapointsToAlarm) is the M.
	DatapointsToAlarm *int64 `locationName:"datapointsToAlarm" type:"integer"`

	// The number of most recent periods over which data is compared to the specified
	// threshold. If you are setting an "M out of N" alarm, this value (evaluationPeriods)
	// is the N.
	//
	// If you are setting an alarm that requires that a number of consecutive data
	// points be breaching to trigger the alarm, this value specifies the rolling
	// period of time in which data points are evaluated.
	//
	// Each evaluation period is five minutes long. For example, specify an evaluation
	// period of 24 to evaluate a metric over a rolling period of two hours.
	//
	// You can specify a minimum valuation period of 1 (5 minutes), and a maximum
	// evaluation period of 288 (24 hours).
	//
	// EvaluationPeriods is a required field
	EvaluationPeriods *int64 `locationName:"evaluationPeriods" type:"integer" required:"true"`

	// The name of the metric to associate with the alarm.
	//
	// You can configure up to two alarms per metric.
	//
	// The following metrics are available for each resource type:
	//
	//    * Instances: BurstCapacityPercentage, BurstCapacityTime, CPUUtilization,
	//    NetworkIn, NetworkOut, StatusCheckFailed, StatusCheckFailed_Instance,
	//    and StatusCheckFailed_System.
	//
	//    * Load balancers: ClientTLSNegotiationErrorCount, HealthyHostCount, UnhealthyHostCount,
	//    HTTPCode_LB_4XX_Count, HTTPCode_LB_5XX_Count, HTTPCode_Instance_2XX_Count,
	//    HTTPCode_Instance_3XX_Count, HTTPCode_Instance_4XX_Count, HTTPCode_Instance_5XX_Count,
	//    InstanceResponseTime, RejectedConnectionCount, and RequestCount.
	//
	//    * Relational databases: CPUUtilization, DatabaseConnections, DiskQueueDepth,
	//    FreeStorageSpace, NetworkReceiveThroughput, and NetworkTransmitThroughput.
	//
	// For more information about these metrics, see Metrics available in Lightsail
	// (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-resource-health-metrics#available-metrics).
	//
	// MetricName is a required field
	MetricName MetricName `locationName:"metricName" type:"string" required:"true" enum:"true"`

	// The name of the Lightsail resource that will be monitored.
	//
	// Instances, load balancers, and relational databases are the only Lightsail
	// resources that can currently be monitored by alarms.
	//
	// MonitoredResourceName is a required field
	MonitoredResourceName *string `locationName:"monitoredResourceName" type:"string" required:"true"`

	// Indicates whether the alarm is enabled.
	//
	// Notifications are enabled by default if you don't specify this parameter.
	NotificationEnabled *bool `locationName:"notificationEnabled" type:"boolean"`

	// The alarm states that trigger a notification.
	//
	// An alarm has the following possible states:
	//
	//    * ALARM - The metric is outside of the defined threshold.
	//
	//    * INSUFFICIENT_DATA - The alarm has just started, the metric is not available,
	//    or not enough data is available for the metric to determine the alarm
	//    state.
	//
	//    * OK - The metric is within the defined threshold.
	//
	// When you specify a notification trigger, the ALARM state must be specified.
	// The INSUFFICIENT_DATA and OK states can be specified in addition to the ALARM
	// state.
	//
	//    * If you specify OK as an alarm trigger, a notification is sent when the
	//    alarm switches from an ALARM or INSUFFICIENT_DATA alarm state to an OK
	//    state. This can be thought of as an all clear alarm notification.
	//
	//    * If you specify INSUFFICIENT_DATA as the alarm trigger, a notification
	//    is sent when the alarm switches from an OK or ALARM alarm state to an
	//    INSUFFICIENT_DATA state.
	//
	// The notification trigger defaults to ALARM if you don't specify this parameter.
	NotificationTriggers []AlarmState `locationName:"notificationTriggers" type:"list"`

	// The value against which the specified statistic is compared.
	//
	// Threshold is a required field
	Threshold *float64 `locationName:"threshold" type:"double" required:"true"`

	// Sets how this alarm will handle missing data points.
	//
	// An alarm can treat missing data in the following ways:
	//
	//    * breaching - Assume the missing data is not within the threshold. Missing
	//    data counts towards the number of times the metric is not within the threshold.
	//
	//    * notBreaching - Assume the missing data is within the threshold. Missing
	//    data does not count towards the number of times the metric is not within
	//    the threshold.
	//
	//    * ignore - Ignore the missing data. Maintains the current alarm state.
	//
	//    * missing - Missing data is treated as missing.
	//
	// If treatMissingData is not specified, the default behavior of missing is
	// used.
	TreatMissingData TreatMissingData `locationName:"treatMissingData" type:"string" enum:"true"`
}

// String returns the string representation
func (s PutAlarmInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutAlarmInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutAlarmInput"}

	if s.AlarmName == nil {
		invalidParams.Add(aws.NewErrParamRequired("AlarmName"))
	}
	if len(s.ComparisonOperator) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("ComparisonOperator"))
	}

	if s.EvaluationPeriods == nil {
		invalidParams.Add(aws.NewErrParamRequired("EvaluationPeriods"))
	}
	if len(s.MetricName) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("MetricName"))
	}

	if s.MonitoredResourceName == nil {
		invalidParams.Add(aws.NewErrParamRequired("MonitoredResourceName"))
	}

	if s.Threshold == nil {
		invalidParams.Add(aws.NewErrParamRequired("Threshold"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type PutAlarmOutput struct {
	_ struct{} `type:"structure"`

	// An array of objects that describe the result of the action, such as the status
	// of the request, the timestamp of the request, and the resources affected
	// by the request.
	Operations []Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s PutAlarmOutput) String() string {
	return awsutil.Prettify(s)
}

const opPutAlarm = "PutAlarm"

// PutAlarmRequest returns a request value for making API operation for
// Amazon Lightsail.
//
// Creates or updates an alarm, and associates it with the specified metric.
//
// An alarm is used to monitor a single metric for one of your resources. When
// a metric condition is met, the alarm can notify you by email, SMS text message,
// and a banner displayed on the Amazon Lightsail console. For more information,
// see Alarms in Amazon Lightsail (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-alarms).
//
// When this action creates an alarm, the alarm state is immediately set to
// INSUFFICIENT_DATA. The alarm is then evaluated and its state is set appropriately.
// Any actions associated with the new state are then executed.
//
// When you update an existing alarm, its state is left unchanged, but the update
// completely overwrites the previous configuration of the alarm. The alarm
// is then evaluated with the updated configuration.
//
//    // Example sending a request using PutAlarmRequest.
//    req := client.PutAlarmRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/PutAlarm
func (c *Client) PutAlarmRequest(input *PutAlarmInput) PutAlarmRequest {
	op := &aws.Operation{
		Name:       opPutAlarm,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutAlarmInput{}
	}

	req := c.newRequest(op, input, &PutAlarmOutput{})

	return PutAlarmRequest{Request: req, Input: input, Copy: c.PutAlarmRequest}
}

// PutAlarmRequest is the request type for the
// PutAlarm API operation.
type PutAlarmRequest struct {
	*aws.Request
	Input *PutAlarmInput
	Copy  func(*PutAlarmInput) PutAlarmRequest
}

// Send marshals and sends the PutAlarm API request.
func (r PutAlarmRequest) Send(ctx context.Context) (*PutAlarmResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &PutAlarmResponse{
		PutAlarmOutput: r.Request.Data.(*PutAlarmOutput),
		response:       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// PutAlarmResponse is the response type for the
// PutAlarm API operation.
type PutAlarmResponse struct {
	*PutAlarmOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// PutAlarm request.
func (r *PutAlarmResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
