// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package machinelearning

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type UpdateEvaluationInput struct {
	_ struct{} `type:"structure"`

	// The ID assigned to the Evaluation during creation.
	//
	// EvaluationId is a required field
	EvaluationId *string `min:"1" type:"string" required:"true"`

	// A new user-supplied name or description of the Evaluation that will replace
	// the current content.
	//
	// EvaluationName is a required field
	EvaluationName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateEvaluationInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateEvaluationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateEvaluationInput"}

	if s.EvaluationId == nil {
		invalidParams.Add(aws.NewErrParamRequired("EvaluationId"))
	}
	if s.EvaluationId != nil && len(*s.EvaluationId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("EvaluationId", 1))
	}

	if s.EvaluationName == nil {
		invalidParams.Add(aws.NewErrParamRequired("EvaluationName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the output of an UpdateEvaluation operation.
//
// You can see the updated content by using the GetEvaluation operation.
type UpdateEvaluationOutput struct {
	_ struct{} `type:"structure"`

	// The ID assigned to the Evaluation during creation. This value should be identical
	// to the value of the Evaluation in the request.
	EvaluationId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateEvaluationOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateEvaluation = "UpdateEvaluation"

// UpdateEvaluationRequest returns a request value for making API operation for
// Amazon Machine Learning.
//
// Updates the EvaluationName of an Evaluation.
//
// You can use the GetEvaluation operation to view the contents of the updated
// data element.
//
//    // Example sending a request using UpdateEvaluationRequest.
//    req := client.UpdateEvaluationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) UpdateEvaluationRequest(input *UpdateEvaluationInput) UpdateEvaluationRequest {
	op := &aws.Operation{
		Name:       opUpdateEvaluation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateEvaluationInput{}
	}

	req := c.newRequest(op, input, &UpdateEvaluationOutput{})

	return UpdateEvaluationRequest{Request: req, Input: input, Copy: c.UpdateEvaluationRequest}
}

// UpdateEvaluationRequest is the request type for the
// UpdateEvaluation API operation.
type UpdateEvaluationRequest struct {
	*aws.Request
	Input *UpdateEvaluationInput
	Copy  func(*UpdateEvaluationInput) UpdateEvaluationRequest
}

// Send marshals and sends the UpdateEvaluation API request.
func (r UpdateEvaluationRequest) Send(ctx context.Context) (*UpdateEvaluationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateEvaluationResponse{
		UpdateEvaluationOutput: r.Request.Data.(*UpdateEvaluationOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateEvaluationResponse is the response type for the
// UpdateEvaluation API operation.
type UpdateEvaluationResponse struct {
	*UpdateEvaluationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateEvaluation request.
func (r *UpdateEvaluationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
