// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package macie2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Specifies the scope, schedule, and other settings for a classification job.
// You can't delete or change the settings for a classification job after you
// create it. In Amazon Macie, classification jobs are immutable. This ensures
// accurate data classification results for audits or investigations.
type CreateClassificationJobInput struct {
	_ struct{} `type:"structure"`

	// ClientToken is a required field
	ClientToken *string `locationName:"clientToken" type:"string" required:"true" idempotencyToken:"true"`

	CustomDataIdentifierIds []string `locationName:"customDataIdentifierIds" type:"list"`

	Description *string `locationName:"description" type:"string"`

	InitialRun *bool `locationName:"initialRun" type:"boolean"`

	// The schedule for running a classification job. Valid values are:
	//
	// JobType is a required field
	JobType JobType `locationName:"jobType" type:"string" required:"true" enum:"true"`

	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// Specifies which S3 buckets contain the objects that a classification job
	// analyzes, and the scope of that analysis.
	//
	// S3JobDefinition is a required field
	S3JobDefinition *S3JobDefinition `locationName:"s3JobDefinition" type:"structure" required:"true"`

	SamplingPercentage *int64 `locationName:"samplingPercentage" type:"integer"`

	// Specifies the recurrence pattern for running a classification job.
	ScheduleFrequency *JobScheduleFrequency `locationName:"scheduleFrequency" type:"structure"`

	// A string-to-string map of key-value pairs that specifies the tags (keys and
	// values) for a classification job, custom data identifier, findings filter,
	// or member account.
	Tags map[string]string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s CreateClassificationJobInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateClassificationJobInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateClassificationJobInput"}

	if s.ClientToken == nil {
		invalidParams.Add(aws.NewErrParamRequired("ClientToken"))
	}
	if len(s.JobType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("JobType"))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}

	if s.S3JobDefinition == nil {
		invalidParams.Add(aws.NewErrParamRequired("S3JobDefinition"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateClassificationJobInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	var ClientToken string
	if s.ClientToken != nil {
		ClientToken = *s.ClientToken
	} else {
		ClientToken = protocol.GetIdempotencyToken()
	}
	{
		v := ClientToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "clientToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CustomDataIdentifierIds != nil {
		v := s.CustomDataIdentifierIds

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "customDataIdentifierIds", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.InitialRun != nil {
		v := *s.InitialRun

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "initialRun", protocol.BoolValue(v), metadata)
	}
	if len(s.JobType) > 0 {
		v := s.JobType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "jobType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.S3JobDefinition != nil {
		v := s.S3JobDefinition

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "s3JobDefinition", v, metadata)
	}
	if s.SamplingPercentage != nil {
		v := *s.SamplingPercentage

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "samplingPercentage", protocol.Int64Value(v), metadata)
	}
	if s.ScheduleFrequency != nil {
		v := s.ScheduleFrequency

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "scheduleFrequency", v, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	return nil
}

// Provides information about a classification job that was created in response
// to a request.
type CreateClassificationJobOutput struct {
	_ struct{} `type:"structure"`

	JobArn *string `locationName:"jobArn" type:"string"`

	JobId *string `locationName:"jobId" type:"string"`
}

// String returns the string representation
func (s CreateClassificationJobOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateClassificationJobOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.JobArn != nil {
		v := *s.JobArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "jobArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.JobId != nil {
		v := *s.JobId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "jobId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opCreateClassificationJob = "CreateClassificationJob"

// CreateClassificationJobRequest returns a request value for making API operation for
// Amazon Macie 2.
//
// Creates and defines the settings for a classification job.
//
//    // Example sending a request using CreateClassificationJobRequest.
//    req := client.CreateClassificationJobRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/CreateClassificationJob
func (c *Client) CreateClassificationJobRequest(input *CreateClassificationJobInput) CreateClassificationJobRequest {
	op := &aws.Operation{
		Name:       opCreateClassificationJob,
		HTTPMethod: "POST",
		HTTPPath:   "/jobs",
	}

	if input == nil {
		input = &CreateClassificationJobInput{}
	}

	req := c.newRequest(op, input, &CreateClassificationJobOutput{})

	return CreateClassificationJobRequest{Request: req, Input: input, Copy: c.CreateClassificationJobRequest}
}

// CreateClassificationJobRequest is the request type for the
// CreateClassificationJob API operation.
type CreateClassificationJobRequest struct {
	*aws.Request
	Input *CreateClassificationJobInput
	Copy  func(*CreateClassificationJobInput) CreateClassificationJobRequest
}

// Send marshals and sends the CreateClassificationJob API request.
func (r CreateClassificationJobRequest) Send(ctx context.Context) (*CreateClassificationJobResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateClassificationJobResponse{
		CreateClassificationJobOutput: r.Request.Data.(*CreateClassificationJobOutput),
		response:                      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateClassificationJobResponse is the response type for the
// CreateClassificationJob API operation.
type CreateClassificationJobResponse struct {
	*CreateClassificationJobOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateClassificationJob request.
func (r *CreateClassificationJobResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
