// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package macie2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DisableMacieInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisableMacieInput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DisableMacieInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	return nil
}

type DisableMacieOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisableMacieOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DisableMacieOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDisableMacie = "DisableMacie"

// DisableMacieRequest returns a request value for making API operation for
// Amazon Macie 2.
//
// Disables an Amazon Macie account and deletes Macie resources for the account.
//
//    // Example sending a request using DisableMacieRequest.
//    req := client.DisableMacieRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/DisableMacie
func (c *Client) DisableMacieRequest(input *DisableMacieInput) DisableMacieRequest {
	op := &aws.Operation{
		Name:       opDisableMacie,
		HTTPMethod: "DELETE",
		HTTPPath:   "/macie",
	}

	if input == nil {
		input = &DisableMacieInput{}
	}

	req := c.newRequest(op, input, &DisableMacieOutput{})

	return DisableMacieRequest{Request: req, Input: input, Copy: c.DisableMacieRequest}
}

// DisableMacieRequest is the request type for the
// DisableMacie API operation.
type DisableMacieRequest struct {
	*aws.Request
	Input *DisableMacieInput
	Copy  func(*DisableMacieInput) DisableMacieRequest
}

// Send marshals and sends the DisableMacie API request.
func (r DisableMacieRequest) Send(ctx context.Context) (*DisableMacieResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DisableMacieResponse{
		DisableMacieOutput: r.Request.Data.(*DisableMacieOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DisableMacieResponse is the response type for the
// DisableMacie API operation.
type DisableMacieResponse struct {
	*DisableMacieOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DisableMacie request.
func (r *DisableMacieResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
