// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package macie2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DisableOrganizationAdminAccountInput struct {
	_ struct{} `type:"structure"`

	// AdminAccountId is a required field
	AdminAccountId *string `location:"querystring" locationName:"adminAccountId" type:"string" required:"true"`
}

// String returns the string representation
func (s DisableOrganizationAdminAccountInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisableOrganizationAdminAccountInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DisableOrganizationAdminAccountInput"}

	if s.AdminAccountId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AdminAccountId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DisableOrganizationAdminAccountInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.AdminAccountId != nil {
		v := *s.AdminAccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "adminAccountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DisableOrganizationAdminAccountOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisableOrganizationAdminAccountOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DisableOrganizationAdminAccountOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDisableOrganizationAdminAccount = "DisableOrganizationAdminAccount"

// DisableOrganizationAdminAccountRequest returns a request value for making API operation for
// Amazon Macie 2.
//
// Disables an account as a delegated administrator of Amazon Macie for an AWS
// organization.
//
//    // Example sending a request using DisableOrganizationAdminAccountRequest.
//    req := client.DisableOrganizationAdminAccountRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/DisableOrganizationAdminAccount
func (c *Client) DisableOrganizationAdminAccountRequest(input *DisableOrganizationAdminAccountInput) DisableOrganizationAdminAccountRequest {
	op := &aws.Operation{
		Name:       opDisableOrganizationAdminAccount,
		HTTPMethod: "DELETE",
		HTTPPath:   "/admin",
	}

	if input == nil {
		input = &DisableOrganizationAdminAccountInput{}
	}

	req := c.newRequest(op, input, &DisableOrganizationAdminAccountOutput{})

	return DisableOrganizationAdminAccountRequest{Request: req, Input: input, Copy: c.DisableOrganizationAdminAccountRequest}
}

// DisableOrganizationAdminAccountRequest is the request type for the
// DisableOrganizationAdminAccount API operation.
type DisableOrganizationAdminAccountRequest struct {
	*aws.Request
	Input *DisableOrganizationAdminAccountInput
	Copy  func(*DisableOrganizationAdminAccountInput) DisableOrganizationAdminAccountRequest
}

// Send marshals and sends the DisableOrganizationAdminAccount API request.
func (r DisableOrganizationAdminAccountRequest) Send(ctx context.Context) (*DisableOrganizationAdminAccountResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DisableOrganizationAdminAccountResponse{
		DisableOrganizationAdminAccountOutput: r.Request.Data.(*DisableOrganizationAdminAccountOutput),
		response:                              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DisableOrganizationAdminAccountResponse is the response type for the
// DisableOrganizationAdminAccount API operation.
type DisableOrganizationAdminAccountResponse struct {
	*DisableOrganizationAdminAccountOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DisableOrganizationAdminAccount request.
func (r *DisableOrganizationAdminAccountResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
