// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package macie2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Changes the status or configuration settings for an Amazon Macie account.
type UpdateMacieSessionInput struct {
	_ struct{} `type:"structure"`

	// The frequency with which Amazon Macie publishes updates to policy findings
	// for an account. This includes publishing updates to AWS Security Hub and
	// Amazon EventBridge (formerly called Amazon CloudWatch Events). Valid values
	// are:
	FindingPublishingFrequency FindingPublishingFrequency `locationName:"findingPublishingFrequency" type:"string" enum:"true"`

	// The status of an Amazon Macie account. Valid values are:
	Status MacieStatus `locationName:"status" type:"string" enum:"true"`
}

// String returns the string representation
func (s UpdateMacieSessionInput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateMacieSessionInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if len(s.FindingPublishingFrequency) > 0 {
		v := s.FindingPublishingFrequency

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "findingPublishingFrequency", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

type UpdateMacieSessionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateMacieSessionOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateMacieSessionOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opUpdateMacieSession = "UpdateMacieSession"

// UpdateMacieSessionRequest returns a request value for making API operation for
// Amazon Macie 2.
//
// Suspends or re-enables an Amazon Macie account, or updates the configuration
// settings for a Macie account.
//
//    // Example sending a request using UpdateMacieSessionRequest.
//    req := client.UpdateMacieSessionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/UpdateMacieSession
func (c *Client) UpdateMacieSessionRequest(input *UpdateMacieSessionInput) UpdateMacieSessionRequest {
	op := &aws.Operation{
		Name:       opUpdateMacieSession,
		HTTPMethod: "PATCH",
		HTTPPath:   "/macie",
	}

	if input == nil {
		input = &UpdateMacieSessionInput{}
	}

	req := c.newRequest(op, input, &UpdateMacieSessionOutput{})

	return UpdateMacieSessionRequest{Request: req, Input: input, Copy: c.UpdateMacieSessionRequest}
}

// UpdateMacieSessionRequest is the request type for the
// UpdateMacieSession API operation.
type UpdateMacieSessionRequest struct {
	*aws.Request
	Input *UpdateMacieSessionInput
	Copy  func(*UpdateMacieSessionInput) UpdateMacieSessionRequest
}

// Send marshals and sends the UpdateMacieSession API request.
func (r UpdateMacieSessionRequest) Send(ctx context.Context) (*UpdateMacieSessionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateMacieSessionResponse{
		UpdateMacieSessionOutput: r.Request.Data.(*UpdateMacieSessionOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateMacieSessionResponse is the response type for the
// UpdateMacieSession API operation.
type UpdateMacieSessionResponse struct {
	*UpdateMacieSessionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateMacieSession request.
func (r *UpdateMacieSessionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
