// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package macie2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Suspends (pauses) or re-enables an Amazon Macie member account.
type UpdateMemberSessionInput struct {
	_ struct{} `type:"structure"`

	// Id is a required field
	Id *string `location:"uri" locationName:"id" type:"string" required:"true"`

	// The status of an Amazon Macie account. Valid values are:
	//
	// Status is a required field
	Status MacieStatus `locationName:"status" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s UpdateMemberSessionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateMemberSessionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateMemberSessionInput"}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}
	if len(s.Status) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Status"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateMemberSessionInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type UpdateMemberSessionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateMemberSessionOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateMemberSessionOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opUpdateMemberSession = "UpdateMemberSession"

// UpdateMemberSessionRequest returns a request value for making API operation for
// Amazon Macie 2.
//
// Enables an Amazon Macie master account to suspend or re-enable a member account.
//
//    // Example sending a request using UpdateMemberSessionRequest.
//    req := client.UpdateMemberSessionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/UpdateMemberSession
func (c *Client) UpdateMemberSessionRequest(input *UpdateMemberSessionInput) UpdateMemberSessionRequest {
	op := &aws.Operation{
		Name:       opUpdateMemberSession,
		HTTPMethod: "PATCH",
		HTTPPath:   "/macie/members/{id}",
	}

	if input == nil {
		input = &UpdateMemberSessionInput{}
	}

	req := c.newRequest(op, input, &UpdateMemberSessionOutput{})

	return UpdateMemberSessionRequest{Request: req, Input: input, Copy: c.UpdateMemberSessionRequest}
}

// UpdateMemberSessionRequest is the request type for the
// UpdateMemberSession API operation.
type UpdateMemberSessionRequest struct {
	*aws.Request
	Input *UpdateMemberSessionInput
	Copy  func(*UpdateMemberSessionInput) UpdateMemberSessionRequest
}

// Send marshals and sends the UpdateMemberSession API request.
func (r UpdateMemberSessionRequest) Send(ctx context.Context) (*UpdateMemberSessionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateMemberSessionResponse{
		UpdateMemberSessionOutput: r.Request.Data.(*UpdateMemberSessionOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateMemberSessionResponse is the response type for the
// UpdateMemberSession API operation.
type UpdateMemberSessionResponse struct {
	*UpdateMemberSessionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateMemberSession request.
func (r *UpdateMemberSessionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
