// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package mediaconnect

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type RemoveFlowVpcInterfaceInput struct {
	_ struct{} `type:"structure"`

	// FlowArn is a required field
	FlowArn *string `location:"uri" locationName:"flowArn" type:"string" required:"true"`

	// VpcInterfaceName is a required field
	VpcInterfaceName *string `location:"uri" locationName:"vpcInterfaceName" type:"string" required:"true"`
}

// String returns the string representation
func (s RemoveFlowVpcInterfaceInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemoveFlowVpcInterfaceInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RemoveFlowVpcInterfaceInput"}

	if s.FlowArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("FlowArn"))
	}

	if s.VpcInterfaceName == nil {
		invalidParams.Add(aws.NewErrParamRequired("VpcInterfaceName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RemoveFlowVpcInterfaceInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.FlowArn != nil {
		v := *s.FlowArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "flowArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.VpcInterfaceName != nil {
		v := *s.VpcInterfaceName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "vpcInterfaceName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The result of a successful RemoveFlowVpcInterface request including the flow
// ARN and the VPC interface name that was removed.
type RemoveFlowVpcInterfaceOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the flow that is associated with the VPC interface you removed.
	FlowArn *string `locationName:"flowArn" type:"string"`

	// IDs of network interfaces associated with the removed VPC interface that
	// Media Connect was unable to remove.
	NonDeletedNetworkInterfaceIds []string `locationName:"nonDeletedNetworkInterfaceIds" type:"list"`

	// The name of the VPC interface that was removed.
	VpcInterfaceName *string `locationName:"vpcInterfaceName" type:"string"`
}

// String returns the string representation
func (s RemoveFlowVpcInterfaceOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RemoveFlowVpcInterfaceOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.FlowArn != nil {
		v := *s.FlowArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "flowArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.NonDeletedNetworkInterfaceIds != nil {
		v := s.NonDeletedNetworkInterfaceIds

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "nonDeletedNetworkInterfaceIds", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.VpcInterfaceName != nil {
		v := *s.VpcInterfaceName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "vpcInterfaceName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opRemoveFlowVpcInterface = "RemoveFlowVpcInterface"

// RemoveFlowVpcInterfaceRequest returns a request value for making API operation for
// AWS MediaConnect.
//
// Removes a VPC Interface from an existing flow. This request can be made only
// on a VPC interface that does not have a Source or Output associated with
// it. If the VPC interface is referenced by a Source or Output, you must first
// delete or update the Source or Output to no longer reference the VPC interface.
//
//    // Example sending a request using RemoveFlowVpcInterfaceRequest.
//    req := client.RemoveFlowVpcInterfaceRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/RemoveFlowVpcInterface
func (c *Client) RemoveFlowVpcInterfaceRequest(input *RemoveFlowVpcInterfaceInput) RemoveFlowVpcInterfaceRequest {
	op := &aws.Operation{
		Name:       opRemoveFlowVpcInterface,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/flows/{flowArn}/vpcInterfaces/{vpcInterfaceName}",
	}

	if input == nil {
		input = &RemoveFlowVpcInterfaceInput{}
	}

	req := c.newRequest(op, input, &RemoveFlowVpcInterfaceOutput{})

	return RemoveFlowVpcInterfaceRequest{Request: req, Input: input, Copy: c.RemoveFlowVpcInterfaceRequest}
}

// RemoveFlowVpcInterfaceRequest is the request type for the
// RemoveFlowVpcInterface API operation.
type RemoveFlowVpcInterfaceRequest struct {
	*aws.Request
	Input *RemoveFlowVpcInterfaceInput
	Copy  func(*RemoveFlowVpcInterfaceInput) RemoveFlowVpcInterfaceRequest
}

// Send marshals and sends the RemoveFlowVpcInterface API request.
func (r RemoveFlowVpcInterfaceRequest) Send(ctx context.Context) (*RemoveFlowVpcInterfaceResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &RemoveFlowVpcInterfaceResponse{
		RemoveFlowVpcInterfaceOutput: r.Request.Data.(*RemoveFlowVpcInterfaceOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// RemoveFlowVpcInterfaceResponse is the response type for the
// RemoveFlowVpcInterface API operation.
type RemoveFlowVpcInterfaceResponse struct {
	*RemoveFlowVpcInterfaceOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// RemoveFlowVpcInterface request.
func (r *RemoveFlowVpcInterfaceResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
