// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package mediaconvert

// Choose BROADCASTER_MIXED_AD when the input contains pre-mixed main audio
// + audio description (AD) as a stereo pair. The value for AudioType will be
// set to 3, which signals to downstream systems that this stream contains "broadcaster
// mixed AD". Note that the input received by the encoder must contain pre-mixed
// audio; the encoder does not perform the mixing. When you choose BROADCASTER_MIXED_AD,
// the encoder ignores any values you provide in AudioType and FollowInputAudioType.
// Choose NORMAL when the input does not contain pre-mixed audio + audio description
// (AD). In this case, the encoder will use any values you provide for AudioType
// and FollowInputAudioType.
type AacAudioDescriptionBroadcasterMix string

// Enum values for AacAudioDescriptionBroadcasterMix
const (
	AacAudioDescriptionBroadcasterMixBroadcasterMixedAd AacAudioDescriptionBroadcasterMix = "BROADCASTER_MIXED_AD"
	AacAudioDescriptionBroadcasterMixNormal             AacAudioDescriptionBroadcasterMix = "NORMAL"
)

func (enum AacAudioDescriptionBroadcasterMix) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum AacAudioDescriptionBroadcasterMix) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// AAC Profile.
type AacCodecProfile string

// Enum values for AacCodecProfile
const (
	AacCodecProfileLc   AacCodecProfile = "LC"
	AacCodecProfileHev1 AacCodecProfile = "HEV1"
	AacCodecProfileHev2 AacCodecProfile = "HEV2"
)

func (enum AacCodecProfile) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum AacCodecProfile) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Mono (Audio Description), Mono, Stereo, or 5.1 channel layout. Valid values
// depend on rate control mode and profile. "1.0 - Audio Description (Receiver
// Mix)" setting receives a stereo description plus control track and emits
// a mono AAC encode of the description track, with control data emitted in
// the PES header as per ETSI TS 101 154 Annex E.
type AacCodingMode string

// Enum values for AacCodingMode
const (
	AacCodingModeAdReceiverMix AacCodingMode = "AD_RECEIVER_MIX"
	AacCodingModeCodingMode10  AacCodingMode = "CODING_MODE_1_0"
	AacCodingModeCodingMode11  AacCodingMode = "CODING_MODE_1_1"
	AacCodingModeCodingMode20  AacCodingMode = "CODING_MODE_2_0"
	AacCodingModeCodingMode51  AacCodingMode = "CODING_MODE_5_1"
)

func (enum AacCodingMode) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum AacCodingMode) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Rate Control Mode.
type AacRateControlMode string

// Enum values for AacRateControlMode
const (
	AacRateControlModeCbr AacRateControlMode = "CBR"
	AacRateControlModeVbr AacRateControlMode = "VBR"
)

func (enum AacRateControlMode) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum AacRateControlMode) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Enables LATM/LOAS AAC output. Note that if you use LATM/LOAS AAC in an output,
// you must choose "No container" for the output container.
type AacRawFormat string

// Enum values for AacRawFormat
const (
	AacRawFormatLatmLoas AacRawFormat = "LATM_LOAS"
	AacRawFormatNone     AacRawFormat = "NONE"
)

func (enum AacRawFormat) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum AacRawFormat) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Use MPEG-2 AAC instead of MPEG-4 AAC audio for raw or MPEG-2 Transport Stream
// containers.
type AacSpecification string

// Enum values for AacSpecification
const (
	AacSpecificationMpeg2 AacSpecification = "MPEG2"
	AacSpecificationMpeg4 AacSpecification = "MPEG4"
)

func (enum AacSpecification) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum AacSpecification) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// VBR Quality Level - Only used if rate_control_mode is VBR.
type AacVbrQuality string

// Enum values for AacVbrQuality
const (
	AacVbrQualityLow        AacVbrQuality = "LOW"
	AacVbrQualityMediumLow  AacVbrQuality = "MEDIUM_LOW"
	AacVbrQualityMediumHigh AacVbrQuality = "MEDIUM_HIGH"
	AacVbrQualityHigh       AacVbrQuality = "HIGH"
)

func (enum AacVbrQuality) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum AacVbrQuality) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Specify the bitstream mode for the AC-3 stream that the encoder emits. For
// more information about the AC3 bitstream mode, see ATSC A/52-2012 (Annex
// E).
type Ac3BitstreamMode string

// Enum values for Ac3BitstreamMode
const (
	Ac3BitstreamModeCompleteMain     Ac3BitstreamMode = "COMPLETE_MAIN"
	Ac3BitstreamModeCommentary       Ac3BitstreamMode = "COMMENTARY"
	Ac3BitstreamModeDialogue         Ac3BitstreamMode = "DIALOGUE"
	Ac3BitstreamModeEmergency        Ac3BitstreamMode = "EMERGENCY"
	Ac3BitstreamModeHearingImpaired  Ac3BitstreamMode = "HEARING_IMPAIRED"
	Ac3BitstreamModeMusicAndEffects  Ac3BitstreamMode = "MUSIC_AND_EFFECTS"
	Ac3BitstreamModeVisuallyImpaired Ac3BitstreamMode = "VISUALLY_IMPAIRED"
	Ac3BitstreamModeVoiceOver        Ac3BitstreamMode = "VOICE_OVER"
)

func (enum Ac3BitstreamMode) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum Ac3BitstreamMode) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Dolby Digital coding mode. Determines number of channels.
type Ac3CodingMode string

// Enum values for Ac3CodingMode
const (
	Ac3CodingModeCodingMode10    Ac3CodingMode = "CODING_MODE_1_0"
	Ac3CodingModeCodingMode11    Ac3CodingMode = "CODING_MODE_1_1"
	Ac3CodingModeCodingMode20    Ac3CodingMode = "CODING_MODE_2_0"
	Ac3CodingModeCodingMode32Lfe Ac3CodingMode = "CODING_MODE_3_2_LFE"
)

func (enum Ac3CodingMode) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum Ac3CodingMode) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// If set to FILM_STANDARD, adds dynamic range compression signaling to the
// output bitstream as defined in the Dolby Digital specification.
type Ac3DynamicRangeCompressionProfile string

// Enum values for Ac3DynamicRangeCompressionProfile
const (
	Ac3DynamicRangeCompressionProfileFilmStandard Ac3DynamicRangeCompressionProfile = "FILM_STANDARD"
	Ac3DynamicRangeCompressionProfileNone         Ac3DynamicRangeCompressionProfile = "NONE"
)

func (enum Ac3DynamicRangeCompressionProfile) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum Ac3DynamicRangeCompressionProfile) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Applies a 120Hz lowpass filter to the LFE channel prior to encoding. Only
// valid with 3_2_LFE coding mode.
type Ac3LfeFilter string

// Enum values for Ac3LfeFilter
const (
	Ac3LfeFilterEnabled  Ac3LfeFilter = "ENABLED"
	Ac3LfeFilterDisabled Ac3LfeFilter = "DISABLED"
)

func (enum Ac3LfeFilter) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum Ac3LfeFilter) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// When set to FOLLOW_INPUT, encoder metadata will be sourced from the DD, DD+,
// or DolbyE decoder that supplied this audio data. If audio was not supplied
// from one of these streams, then the static metadata settings will be used.
type Ac3MetadataControl string

// Enum values for Ac3MetadataControl
const (
	Ac3MetadataControlFollowInput   Ac3MetadataControl = "FOLLOW_INPUT"
	Ac3MetadataControlUseConfigured Ac3MetadataControl = "USE_CONFIGURED"
)

func (enum Ac3MetadataControl) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum Ac3MetadataControl) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Specify whether the service runs your job with accelerated transcoding. Choose
// DISABLED if you don't want accelerated transcoding. Choose ENABLED if you
// want your job to run with accelerated transcoding and to fail if your input
// files or your job settings aren't compatible with accelerated transcoding.
// Choose PREFERRED if you want your job to run with accelerated transcoding
// if the job is compatible with the feature and to run at standard speed if
// it's not.
type AccelerationMode string

// Enum values for AccelerationMode
const (
	AccelerationModeDisabled  AccelerationMode = "DISABLED"
	AccelerationModeEnabled   AccelerationMode = "ENABLED"
	AccelerationModePreferred AccelerationMode = "PREFERRED"
)

func (enum AccelerationMode) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum AccelerationMode) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Describes whether the current job is running with accelerated transcoding.
// For jobs that have Acceleration (AccelerationMode) set to DISABLED, AccelerationStatus
// is always NOT_APPLICABLE. For jobs that have Acceleration (AccelerationMode)
// set to ENABLED or PREFERRED, AccelerationStatus is one of the other states.
// AccelerationStatus is IN_PROGRESS initially, while the service determines
// whether the input files and job settings are compatible with accelerated
// transcoding. If they are, AcclerationStatus is ACCELERATED. If your input
// files and job settings aren't compatible with accelerated transcoding, the
// service either fails your job or runs it without accelerated transcoding,
// depending on how you set Acceleration (AccelerationMode). When the service
// runs your job without accelerated transcoding, AccelerationStatus is NOT_ACCELERATED.
type AccelerationStatus string

// Enum values for AccelerationStatus
const (
	AccelerationStatusNotApplicable  AccelerationStatus = "NOT_APPLICABLE"
	AccelerationStatusInProgress     AccelerationStatus = "IN_PROGRESS"
	AccelerationStatusAccelerated    AccelerationStatus = "ACCELERATED"
	AccelerationStatusNotAccelerated AccelerationStatus = "NOT_ACCELERATED"
)

func (enum AccelerationStatus) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum AccelerationStatus) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// This setting only applies to H.264, H.265, and MPEG2 outputs. Use Insert
// AFD signaling (AfdSignaling) to specify whether the service includes AFD
// values in the output video data and what those values are. * Choose None
// to remove all AFD values from this output. * Choose Fixed to ignore input
// AFD values and instead encode the value specified in the job. * Choose Auto
// to calculate output AFD values based on the input AFD scaler data.
type AfdSignaling string

// Enum values for AfdSignaling
const (
	AfdSignalingNone  AfdSignaling = "NONE"
	AfdSignalingAuto  AfdSignaling = "AUTO"
	AfdSignalingFixed AfdSignaling = "FIXED"
)

func (enum AfdSignaling) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum AfdSignaling) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Ignore this setting unless this input is a QuickTime animation with an alpha
// channel. Use this setting to create separate Key and Fill outputs. In each
// output, specify which part of the input MediaConvert uses. Leave this setting
// at the default value DISCARD to delete the alpha channel and preserve the
// video. Set it to REMAP_TO_LUMA to delete the video and map the alpha channel
// to the luma channel of your outputs.
type AlphaBehavior string

// Enum values for AlphaBehavior
const (
	AlphaBehaviorDiscard     AlphaBehavior = "DISCARD"
	AlphaBehaviorRemapToLuma AlphaBehavior = "REMAP_TO_LUMA"
)

func (enum AlphaBehavior) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum AlphaBehavior) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Specify whether this set of input captions appears in your outputs in both
// 608 and 708 format. If you choose Upconvert (UPCONVERT), MediaConvert includes
// the captions data in two ways: it passes the 608 data through using the 608
// compatibility bytes fields of the 708 wrapper, and it also translates the
// 608 data into 708.
type AncillaryConvert608To708 string

// Enum values for AncillaryConvert608To708
const (
	AncillaryConvert608To708Upconvert AncillaryConvert608To708 = "UPCONVERT"
	AncillaryConvert608To708Disabled  AncillaryConvert608To708 = "DISABLED"
)

func (enum AncillaryConvert608To708) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum AncillaryConvert608To708) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// By default, the service terminates any unterminated captions at the end of
// each input. If you want the caption to continue onto your next input, disable
// this setting.
type AncillaryTerminateCaptions string

// Enum values for AncillaryTerminateCaptions
const (
	AncillaryTerminateCaptionsEndOfInput AncillaryTerminateCaptions = "END_OF_INPUT"
	AncillaryTerminateCaptionsDisabled   AncillaryTerminateCaptions = "DISABLED"
)

func (enum AncillaryTerminateCaptions) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum AncillaryTerminateCaptions) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// The anti-alias filter is automatically applied to all outputs. The service
// no longer accepts the value DISABLED for AntiAlias. If you specify that in
// your job, the service will ignore the setting.
type AntiAlias string

// Enum values for AntiAlias
const (
	AntiAliasDisabled AntiAlias = "DISABLED"
	AntiAliasEnabled  AntiAlias = "ENABLED"
)

func (enum AntiAlias) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum AntiAlias) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Type of Audio codec.
type AudioCodec string

// Enum values for AudioCodec
const (
	AudioCodecAac         AudioCodec = "AAC"
	AudioCodecMp2         AudioCodec = "MP2"
	AudioCodecMp3         AudioCodec = "MP3"
	AudioCodecWav         AudioCodec = "WAV"
	AudioCodecAiff        AudioCodec = "AIFF"
	AudioCodecAc3         AudioCodec = "AC3"
	AudioCodecEac3        AudioCodec = "EAC3"
	AudioCodecEac3Atmos   AudioCodec = "EAC3_ATMOS"
	AudioCodecVorbis      AudioCodec = "VORBIS"
	AudioCodecOpus        AudioCodec = "OPUS"
	AudioCodecPassthrough AudioCodec = "PASSTHROUGH"
)

func (enum AudioCodec) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum AudioCodec) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Enable this setting on one audio selector to set it as the default for the
// job. The service uses this default for outputs where it can't find the specified
// input audio. If you don't set a default, those outputs have no audio.
type AudioDefaultSelection string

// Enum values for AudioDefaultSelection
const (
	AudioDefaultSelectionDefault    AudioDefaultSelection = "DEFAULT"
	AudioDefaultSelectionNotDefault AudioDefaultSelection = "NOT_DEFAULT"
)

func (enum AudioDefaultSelection) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum AudioDefaultSelection) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Specify which source for language code takes precedence for this audio track.
// When you choose Follow input (FOLLOW_INPUT), the service uses the language
// code from the input track if it's present. If there's no languge code on
// the input track, the service uses the code that you specify in the setting
// Language code (languageCode or customLanguageCode). When you choose Use configured
// (USE_CONFIGURED), the service uses the language code that you specify.
type AudioLanguageCodeControl string

// Enum values for AudioLanguageCodeControl
const (
	AudioLanguageCodeControlFollowInput   AudioLanguageCodeControl = "FOLLOW_INPUT"
	AudioLanguageCodeControlUseConfigured AudioLanguageCodeControl = "USE_CONFIGURED"
)

func (enum AudioLanguageCodeControl) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum AudioLanguageCodeControl) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Choose one of the following audio normalization algorithms: ITU-R BS.1770-1:
// Ungated loudness. A measurement of ungated average loudness for an entire
// piece of content, suitable for measurement of short-form content under ATSC
// recommendation A/85. Supports up to 5.1 audio channels. ITU-R BS.1770-2:
// Gated loudness. A measurement of gated average loudness compliant with the
// requirements of EBU-R128. Supports up to 5.1 audio channels. ITU-R BS.1770-3:
// Modified peak. The same loudness measurement algorithm as 1770-2, with an
// updated true peak measurement. ITU-R BS.1770-4: Higher channel count. Allows
// for more audio channels than the other algorithms, including configurations
// such as 7.1.
type AudioNormalizationAlgorithm string

// Enum values for AudioNormalizationAlgorithm
const (
	AudioNormalizationAlgorithmItuBs17701 AudioNormalizationAlgorithm = "ITU_BS_1770_1"
	AudioNormalizationAlgorithmItuBs17702 AudioNormalizationAlgorithm = "ITU_BS_1770_2"
	AudioNormalizationAlgorithmItuBs17703 AudioNormalizationAlgorithm = "ITU_BS_1770_3"
	AudioNormalizationAlgorithmItuBs17704 AudioNormalizationAlgorithm = "ITU_BS_1770_4"
)

func (enum AudioNormalizationAlgorithm) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum AudioNormalizationAlgorithm) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// When enabled the output audio is corrected using the chosen algorithm. If
// disabled, the audio will be measured but not adjusted.
type AudioNormalizationAlgorithmControl string

// Enum values for AudioNormalizationAlgorithmControl
const (
	AudioNormalizationAlgorithmControlCorrectAudio AudioNormalizationAlgorithmControl = "CORRECT_AUDIO"
	AudioNormalizationAlgorithmControlMeasureOnly  AudioNormalizationAlgorithmControl = "MEASURE_ONLY"
)

func (enum AudioNormalizationAlgorithmControl) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum AudioNormalizationAlgorithmControl) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// If set to LOG, log each output's audio track loudness to a CSV file.
type AudioNormalizationLoudnessLogging string

// Enum values for AudioNormalizationLoudnessLogging
const (
	AudioNormalizationLoudnessLoggingLog     AudioNormalizationLoudnessLogging = "LOG"
	AudioNormalizationLoudnessLoggingDontLog AudioNormalizationLoudnessLogging = "DONT_LOG"
)

func (enum AudioNormalizationLoudnessLogging) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum AudioNormalizationLoudnessLogging) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// If set to TRUE_PEAK, calculate and log the TruePeak for each output's audio
// track loudness.
type AudioNormalizationPeakCalculation string

// Enum values for AudioNormalizationPeakCalculation
const (
	AudioNormalizationPeakCalculationTruePeak AudioNormalizationPeakCalculation = "TRUE_PEAK"
	AudioNormalizationPeakCalculationNone     AudioNormalizationPeakCalculation = "NONE"
)

func (enum AudioNormalizationPeakCalculation) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum AudioNormalizationPeakCalculation) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Specifies the type of the audio selector.
type AudioSelectorType string

// Enum values for AudioSelectorType
const (
	AudioSelectorTypePid          AudioSelectorType = "PID"
	AudioSelectorTypeTrack        AudioSelectorType = "TRACK"
	AudioSelectorTypeLanguageCode AudioSelectorType = "LANGUAGE_CODE"
)

func (enum AudioSelectorType) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum AudioSelectorType) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// When set to FOLLOW_INPUT, if the input contains an ISO 639 audio_type, then
// that value is passed through to the output. If the input contains no ISO
// 639 audio_type, the value in Audio Type is included in the output. Otherwise
// the value in Audio Type is included in the output. Note that this field and
// audioType are both ignored if audioDescriptionBroadcasterMix is set to BROADCASTER_MIXED_AD.
type AudioTypeControl string

// Enum values for AudioTypeControl
const (
	AudioTypeControlFollowInput   AudioTypeControl = "FOLLOW_INPUT"
	AudioTypeControlUseConfigured AudioTypeControl = "USE_CONFIGURED"
)

func (enum AudioTypeControl) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum AudioTypeControl) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Adaptive quantization. Allows intra-frame quantizers to vary to improve visual
// quality.
type Av1AdaptiveQuantization string

// Enum values for Av1AdaptiveQuantization
const (
	Av1AdaptiveQuantizationOff    Av1AdaptiveQuantization = "OFF"
	Av1AdaptiveQuantizationLow    Av1AdaptiveQuantization = "LOW"
	Av1AdaptiveQuantizationMedium Av1AdaptiveQuantization = "MEDIUM"
	Av1AdaptiveQuantizationHigh   Av1AdaptiveQuantization = "HIGH"
	Av1AdaptiveQuantizationHigher Av1AdaptiveQuantization = "HIGHER"
	Av1AdaptiveQuantizationMax    Av1AdaptiveQuantization = "MAX"
)

func (enum Av1AdaptiveQuantization) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum Av1AdaptiveQuantization) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// If you are using the console, use the Framerate setting to specify the frame
// rate for this output. If you want to keep the same frame rate as the input
// video, choose Follow source. If you want to do frame rate conversion, choose
// a frame rate from the dropdown list or choose Custom. The framerates shown
// in the dropdown list are decimal approximations of fractions. If you choose
// Custom, specify your frame rate as a fraction. If you are creating your transcoding
// job specification as a JSON file without the console, use FramerateControl
// to specify which value the service uses for the frame rate for this output.
// Choose INITIALIZE_FROM_SOURCE if you want the service to use the frame rate
// from the input. Choose SPECIFIED if you want the service to use the frame
// rate you specify in the settings FramerateNumerator and FramerateDenominator.
type Av1FramerateControl string

// Enum values for Av1FramerateControl
const (
	Av1FramerateControlInitializeFromSource Av1FramerateControl = "INITIALIZE_FROM_SOURCE"
	Av1FramerateControlSpecified            Av1FramerateControl = "SPECIFIED"
)

func (enum Av1FramerateControl) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum Av1FramerateControl) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Optional. Specify how the transcoder performs framerate conversion. The default
// behavior is to use duplicate drop conversion.
type Av1FramerateConversionAlgorithm string

// Enum values for Av1FramerateConversionAlgorithm
const (
	Av1FramerateConversionAlgorithmDuplicateDrop Av1FramerateConversionAlgorithm = "DUPLICATE_DROP"
	Av1FramerateConversionAlgorithmInterpolate   Av1FramerateConversionAlgorithm = "INTERPOLATE"
)

func (enum Av1FramerateConversionAlgorithm) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum Av1FramerateConversionAlgorithm) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// 'With AV1 outputs, for rate control mode, MediaConvert supports only quality-defined
// variable bitrate (QVBR). You can''t use CBR or VBR.'
type Av1RateControlMode string

// Enum values for Av1RateControlMode
const (
	Av1RateControlModeQvbr Av1RateControlMode = "QVBR"
)

func (enum Av1RateControlMode) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum Av1RateControlMode) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Adjust quantization within each frame based on spatial variation of content
// complexity.
type Av1SpatialAdaptiveQuantization string

// Enum values for Av1SpatialAdaptiveQuantization
const (
	Av1SpatialAdaptiveQuantizationDisabled Av1SpatialAdaptiveQuantization = "DISABLED"
	Av1SpatialAdaptiveQuantizationEnabled  Av1SpatialAdaptiveQuantization = "ENABLED"
)

func (enum Av1SpatialAdaptiveQuantization) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum Av1SpatialAdaptiveQuantization) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// The tag type that AWS Billing and Cost Management will use to sort your AWS
// Elemental MediaConvert costs on any billing report that you set up.
type BillingTagsSource string

// Enum values for BillingTagsSource
const (
	BillingTagsSourceQueue       BillingTagsSource = "QUEUE"
	BillingTagsSourcePreset      BillingTagsSource = "PRESET"
	BillingTagsSourceJobTemplate BillingTagsSource = "JOB_TEMPLATE"
	BillingTagsSourceJob         BillingTagsSource = "JOB"
)

func (enum BillingTagsSource) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum BillingTagsSource) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// If no explicit x_position or y_position is provided, setting alignment to
// centered will place the captions at the bottom center of the output. Similarly,
// setting a left alignment will align captions to the bottom left of the output.
// If x and y positions are given in conjunction with the alignment parameter,
// the font will be justified (either left or centered) relative to those coordinates.
// This option is not valid for source captions that are STL, 608/embedded or
// teletext. These source settings are already pre-defined by the caption stream.
// All burn-in and DVB-Sub font settings must match.
type BurninSubtitleAlignment string

// Enum values for BurninSubtitleAlignment
const (
	BurninSubtitleAlignmentCentered BurninSubtitleAlignment = "CENTERED"
	BurninSubtitleAlignmentLeft     BurninSubtitleAlignment = "LEFT"
)

func (enum BurninSubtitleAlignment) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum BurninSubtitleAlignment) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Specifies the color of the rectangle behind the captions.All burn-in and
// DVB-Sub font settings must match.
type BurninSubtitleBackgroundColor string

// Enum values for BurninSubtitleBackgroundColor
const (
	BurninSubtitleBackgroundColorNone  BurninSubtitleBackgroundColor = "NONE"
	BurninSubtitleBackgroundColorBlack BurninSubtitleBackgroundColor = "BLACK"
	BurninSubtitleBackgroundColorWhite BurninSubtitleBackgroundColor = "WHITE"
)

func (enum BurninSubtitleBackgroundColor) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum BurninSubtitleBackgroundColor) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Specifies the color of the burned-in captions. This option is not valid for
// source captions that are STL, 608/embedded or teletext. These source settings
// are already pre-defined by the caption stream. All burn-in and DVB-Sub font
// settings must match.
type BurninSubtitleFontColor string

// Enum values for BurninSubtitleFontColor
const (
	BurninSubtitleFontColorWhite  BurninSubtitleFontColor = "WHITE"
	BurninSubtitleFontColorBlack  BurninSubtitleFontColor = "BLACK"
	BurninSubtitleFontColorYellow BurninSubtitleFontColor = "YELLOW"
	BurninSubtitleFontColorRed    BurninSubtitleFontColor = "RED"
	BurninSubtitleFontColorGreen  BurninSubtitleFontColor = "GREEN"
	BurninSubtitleFontColorBlue   BurninSubtitleFontColor = "BLUE"
)

func (enum BurninSubtitleFontColor) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum BurninSubtitleFontColor) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Specifies font outline color. This option is not valid for source captions
// that are either 608/embedded or teletext. These source settings are already
// pre-defined by the caption stream. All burn-in and DVB-Sub font settings
// must match.
type BurninSubtitleOutlineColor string

// Enum values for BurninSubtitleOutlineColor
const (
	BurninSubtitleOutlineColorBlack  BurninSubtitleOutlineColor = "BLACK"
	BurninSubtitleOutlineColorWhite  BurninSubtitleOutlineColor = "WHITE"
	BurninSubtitleOutlineColorYellow BurninSubtitleOutlineColor = "YELLOW"
	BurninSubtitleOutlineColorRed    BurninSubtitleOutlineColor = "RED"
	BurninSubtitleOutlineColorGreen  BurninSubtitleOutlineColor = "GREEN"
	BurninSubtitleOutlineColorBlue   BurninSubtitleOutlineColor = "BLUE"
)

func (enum BurninSubtitleOutlineColor) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum BurninSubtitleOutlineColor) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Specifies the color of the shadow cast by the captions.All burn-in and DVB-Sub
// font settings must match.
type BurninSubtitleShadowColor string

// Enum values for BurninSubtitleShadowColor
const (
	BurninSubtitleShadowColorNone  BurninSubtitleShadowColor = "NONE"
	BurninSubtitleShadowColorBlack BurninSubtitleShadowColor = "BLACK"
	BurninSubtitleShadowColorWhite BurninSubtitleShadowColor = "WHITE"
)

func (enum BurninSubtitleShadowColor) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum BurninSubtitleShadowColor) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Only applies to jobs with input captions in Teletext or STL formats. Specify
// whether the spacing between letters in your captions is set by the captions
// grid or varies depending on letter width. Choose fixed grid to conform to
// the spacing specified in the captions file more accurately. Choose proportional
// to make the text easier to read if the captions are closed caption.
type BurninSubtitleTeletextSpacing string

// Enum values for BurninSubtitleTeletextSpacing
const (
	BurninSubtitleTeletextSpacingFixedGrid    BurninSubtitleTeletextSpacing = "FIXED_GRID"
	BurninSubtitleTeletextSpacingProportional BurninSubtitleTeletextSpacing = "PROPORTIONAL"
)

func (enum BurninSubtitleTeletextSpacing) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum BurninSubtitleTeletextSpacing) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Specify the format for this set of captions on this output. The default format
// is embedded without SCTE-20. Other options are embedded with SCTE-20, burn-in,
// DVB-sub, IMSC, SCC, SRT, teletext, TTML, and web-VTT. If you are using SCTE-20,
// choose SCTE-20 plus embedded (SCTE20_PLUS_EMBEDDED) to create an output that
// complies with the SCTE-43 spec. To create a non-compliant output where the
// embedded captions come first, choose Embedded plus SCTE-20 (EMBEDDED_PLUS_SCTE20).
type CaptionDestinationType string

// Enum values for CaptionDestinationType
const (
	CaptionDestinationTypeBurnIn             CaptionDestinationType = "BURN_IN"
	CaptionDestinationTypeDvbSub             CaptionDestinationType = "DVB_SUB"
	CaptionDestinationTypeEmbedded           CaptionDestinationType = "EMBEDDED"
	CaptionDestinationTypeEmbeddedPlusScte20 CaptionDestinationType = "EMBEDDED_PLUS_SCTE20"
	CaptionDestinationTypeImsc               CaptionDestinationType = "IMSC"
	CaptionDestinationTypeScte20PlusEmbedded CaptionDestinationType = "SCTE20_PLUS_EMBEDDED"
	CaptionDestinationTypeScc                CaptionDestinationType = "SCC"
	CaptionDestinationTypeSrt                CaptionDestinationType = "SRT"
	CaptionDestinationTypeSmi                CaptionDestinationType = "SMI"
	CaptionDestinationTypeTeletext           CaptionDestinationType = "TELETEXT"
	CaptionDestinationTypeTtml               CaptionDestinationType = "TTML"
	CaptionDestinationTypeWebvtt             CaptionDestinationType = "WEBVTT"
)

func (enum CaptionDestinationType) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum CaptionDestinationType) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Use Source (SourceType) to identify the format of your input captions. The
// service cannot auto-detect caption format.
type CaptionSourceType string

// Enum values for CaptionSourceType
const (
	CaptionSourceTypeAncillary  CaptionSourceType = "ANCILLARY"
	CaptionSourceTypeDvbSub     CaptionSourceType = "DVB_SUB"
	CaptionSourceTypeEmbedded   CaptionSourceType = "EMBEDDED"
	CaptionSourceTypeScte20     CaptionSourceType = "SCTE20"
	CaptionSourceTypeScc        CaptionSourceType = "SCC"
	CaptionSourceTypeTtml       CaptionSourceType = "TTML"
	CaptionSourceTypeStl        CaptionSourceType = "STL"
	CaptionSourceTypeSrt        CaptionSourceType = "SRT"
	CaptionSourceTypeSmi        CaptionSourceType = "SMI"
	CaptionSourceTypeTeletext   CaptionSourceType = "TELETEXT"
	CaptionSourceTypeNullSource CaptionSourceType = "NULL_SOURCE"
	CaptionSourceTypeImsc       CaptionSourceType = "IMSC"
)

func (enum CaptionSourceType) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum CaptionSourceType) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// When set to ENABLED, sets #EXT-X-ALLOW-CACHE:no tag, which prevents client
// from saving media segments for later replay.
type CmafClientCache string

// Enum values for CmafClientCache
const (
	CmafClientCacheDisabled CmafClientCache = "DISABLED"
	CmafClientCacheEnabled  CmafClientCache = "ENABLED"
)

func (enum CmafClientCache) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum CmafClientCache) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Specification to use (RFC-6381 or the default RFC-4281) during m3u8 playlist
// generation.
type CmafCodecSpecification string

// Enum values for CmafCodecSpecification
const (
	CmafCodecSpecificationRfc6381 CmafCodecSpecification = "RFC_6381"
	CmafCodecSpecificationRfc4281 CmafCodecSpecification = "RFC_4281"
)

func (enum CmafCodecSpecification) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum CmafCodecSpecification) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Specify the encryption scheme that you want the service to use when encrypting
// your CMAF segments. Choose AES-CBC subsample (SAMPLE-AES) or AES_CTR (AES-CTR).
type CmafEncryptionType string

// Enum values for CmafEncryptionType
const (
	CmafEncryptionTypeSampleAes CmafEncryptionType = "SAMPLE_AES"
	CmafEncryptionTypeAesCtr    CmafEncryptionType = "AES_CTR"
)

func (enum CmafEncryptionType) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum CmafEncryptionType) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// When you use DRM with CMAF outputs, choose whether the service writes the
// 128-bit encryption initialization vector in the HLS and DASH manifests.
type CmafInitializationVectorInManifest string

// Enum values for CmafInitializationVectorInManifest
const (
	CmafInitializationVectorInManifestInclude CmafInitializationVectorInManifest = "INCLUDE"
	CmafInitializationVectorInManifestExclude CmafInitializationVectorInManifest = "EXCLUDE"
)

func (enum CmafInitializationVectorInManifest) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum CmafInitializationVectorInManifest) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Specify whether your DRM encryption key is static or from a key provider
// that follows the SPEKE standard. For more information about SPEKE, see https://docs.aws.amazon.com/speke/latest/documentation/what-is-speke.html.
type CmafKeyProviderType string

// Enum values for CmafKeyProviderType
const (
	CmafKeyProviderTypeSpeke     CmafKeyProviderType = "SPEKE"
	CmafKeyProviderTypeStaticKey CmafKeyProviderType = "STATIC_KEY"
)

func (enum CmafKeyProviderType) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum CmafKeyProviderType) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// When set to GZIP, compresses HLS playlist.
type CmafManifestCompression string

// Enum values for CmafManifestCompression
const (
	CmafManifestCompressionGzip CmafManifestCompression = "GZIP"
	CmafManifestCompressionNone CmafManifestCompression = "NONE"
)

func (enum CmafManifestCompression) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum CmafManifestCompression) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Indicates whether the output manifest should use floating point values for
// segment duration.
type CmafManifestDurationFormat string

// Enum values for CmafManifestDurationFormat
const (
	CmafManifestDurationFormatFloatingPoint CmafManifestDurationFormat = "FLOATING_POINT"
	CmafManifestDurationFormatInteger       CmafManifestDurationFormat = "INTEGER"
)

func (enum CmafManifestDurationFormat) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum CmafManifestDurationFormat) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Specify whether your DASH profile is on-demand or main. When you choose Main
// profile (MAIN_PROFILE), the service signals urn:mpeg:dash:profile:isoff-main:2011
// in your .mpd DASH manifest. When you choose On-demand (ON_DEMAND_PROFILE),
// the service signals urn:mpeg:dash:profile:isoff-on-demand:2011 in your .mpd.
// When you choose On-demand, you must also set the output group setting Segment
// control (SegmentControl) to Single file (SINGLE_FILE).
type CmafMpdProfile string

// Enum values for CmafMpdProfile
const (
	CmafMpdProfileMainProfile     CmafMpdProfile = "MAIN_PROFILE"
	CmafMpdProfileOnDemandProfile CmafMpdProfile = "ON_DEMAND_PROFILE"
)

func (enum CmafMpdProfile) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum CmafMpdProfile) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// When set to SINGLE_FILE, a single output file is generated, which is internally
// segmented using the Fragment Length and Segment Length. When set to SEGMENTED_FILES,
// separate segment files will be created.
type CmafSegmentControl string

// Enum values for CmafSegmentControl
const (
	CmafSegmentControlSingleFile     CmafSegmentControl = "SINGLE_FILE"
	CmafSegmentControlSegmentedFiles CmafSegmentControl = "SEGMENTED_FILES"
)

func (enum CmafSegmentControl) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum CmafSegmentControl) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Include or exclude RESOLUTION attribute for video in EXT-X-STREAM-INF tag
// of variant manifest.
type CmafStreamInfResolution string

// Enum values for CmafStreamInfResolution
const (
	CmafStreamInfResolutionInclude CmafStreamInfResolution = "INCLUDE"
	CmafStreamInfResolutionExclude CmafStreamInfResolution = "EXCLUDE"
)

func (enum CmafStreamInfResolution) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum CmafStreamInfResolution) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// When set to ENABLED, a DASH MPD manifest will be generated for this output.
type CmafWriteDASHManifest string

// Enum values for CmafWriteDASHManifest
const (
	CmafWriteDASHManifestDisabled CmafWriteDASHManifest = "DISABLED"
	CmafWriteDASHManifestEnabled  CmafWriteDASHManifest = "ENABLED"
)

func (enum CmafWriteDASHManifest) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum CmafWriteDASHManifest) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// When set to ENABLED, an Apple HLS manifest will be generated for this output.
type CmafWriteHLSManifest string

// Enum values for CmafWriteHLSManifest
const (
	CmafWriteHLSManifestDisabled CmafWriteHLSManifest = "DISABLED"
	CmafWriteHLSManifestEnabled  CmafWriteHLSManifest = "ENABLED"
)

func (enum CmafWriteHLSManifest) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum CmafWriteHLSManifest) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// When you enable Precise segment duration in DASH manifests (writeSegmentTimelineInRepresentation),
// your DASH manifest shows precise segment durations. The segment duration
// information appears inside the SegmentTimeline element, inside SegmentTemplate
// at the Representation level. When this feature isn't enabled, the segment
// durations in your DASH manifest are approximate. The segment duration information
// appears in the duration attribute of the SegmentTemplate element.
type CmafWriteSegmentTimelineInRepresentation string

// Enum values for CmafWriteSegmentTimelineInRepresentation
const (
	CmafWriteSegmentTimelineInRepresentationEnabled  CmafWriteSegmentTimelineInRepresentation = "ENABLED"
	CmafWriteSegmentTimelineInRepresentationDisabled CmafWriteSegmentTimelineInRepresentation = "DISABLED"
)

func (enum CmafWriteSegmentTimelineInRepresentation) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum CmafWriteSegmentTimelineInRepresentation) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Use this setting only when you specify SCTE-35 markers from ESAM. Choose
// INSERT to put SCTE-35 markers in this output at the insertion points that
// you specify in an ESAM XML document. Provide the document in the setting
// SCC XML (sccXml).
type CmfcScte35Esam string

// Enum values for CmfcScte35Esam
const (
	CmfcScte35EsamInsert CmfcScte35Esam = "INSERT"
	CmfcScte35EsamNone   CmfcScte35Esam = "NONE"
)

func (enum CmfcScte35Esam) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum CmfcScte35Esam) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Ignore this setting unless you have SCTE-35 markers in your input video file.
// Choose Passthrough (PASSTHROUGH) if you want SCTE-35 markers that appear
// in your input to also appear in this output. Choose None (NONE) if you don't
// want those SCTE-35 markers in this output.
type CmfcScte35Source string

// Enum values for CmfcScte35Source
const (
	CmfcScte35SourcePassthrough CmfcScte35Source = "PASSTHROUGH"
	CmfcScte35SourceNone        CmfcScte35Source = "NONE"
)

func (enum CmfcScte35Source) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum CmfcScte35Source) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Choose Insert (INSERT) for this setting to include color metadata in this
// output. Choose Ignore (IGNORE) to exclude color metadata from this output.
// If you don't specify a value, the service sets this to Insert by default.
type ColorMetadata string

// Enum values for ColorMetadata
const (
	ColorMetadataIgnore ColorMetadata = "IGNORE"
	ColorMetadataInsert ColorMetadata = "INSERT"
)

func (enum ColorMetadata) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum ColorMetadata) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// If your input video has accurate color space metadata, or if you don't know
// about color space, leave this set to the default value Follow (FOLLOW). The
// service will automatically detect your input color space. If your input video
// has metadata indicating the wrong color space, specify the accurate color
// space here. If your input video is HDR 10 and the SMPTE ST 2086 Mastering
// Display Color Volume static metadata isn't present in your video stream,
// or if that metadata is present but not accurate, choose Force HDR 10 (FORCE_HDR10)
// here and specify correct values in the input HDR 10 metadata (Hdr10Metadata)
// settings. For more information about MediaConvert HDR jobs, see https://docs.aws.amazon.com/console/mediaconvert/hdr.
type ColorSpace string

// Enum values for ColorSpace
const (
	ColorSpaceFollow  ColorSpace = "FOLLOW"
	ColorSpaceRec601  ColorSpace = "REC_601"
	ColorSpaceRec709  ColorSpace = "REC_709"
	ColorSpaceHdr10   ColorSpace = "HDR10"
	ColorSpaceHlg2020 ColorSpace = "HLG_2020"
)

func (enum ColorSpace) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum ColorSpace) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Specify the color space you want for this output. The service supports conversion
// between HDR formats, between SDR formats, from SDR to HDR, and from HDR to
// SDR. SDR to HDR conversion doesn't upgrade the dynamic range. The converted
// video has an HDR format, but visually appears the same as an unconverted
// output. HDR to SDR conversion uses Elemental tone mapping technology to approximate
// the outcome of manually regrading from HDR to SDR.
type ColorSpaceConversion string

// Enum values for ColorSpaceConversion
const (
	ColorSpaceConversionNone         ColorSpaceConversion = "NONE"
	ColorSpaceConversionForce601     ColorSpaceConversion = "FORCE_601"
	ColorSpaceConversionForce709     ColorSpaceConversion = "FORCE_709"
	ColorSpaceConversionForceHdr10   ColorSpaceConversion = "FORCE_HDR10"
	ColorSpaceConversionForceHlg2020 ColorSpaceConversion = "FORCE_HLG_2020"
)

func (enum ColorSpaceConversion) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum ColorSpaceConversion) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// There are two sources for color metadata, the input file and the job input
// settings Color space (ColorSpace) and HDR master display information settings(Hdr10Metadata).
// The Color space usage setting determines which takes precedence. Choose Force
// (FORCE) to use color metadata from the input job settings. If you don't specify
// values for those settings, the service defaults to using metadata from your
// input. FALLBACK - Choose Fallback (FALLBACK) to use color metadata from the
// source when it is present. If there's no color metadata in your input file,
// the service defaults to using values you specify in the input settings.
type ColorSpaceUsage string

// Enum values for ColorSpaceUsage
const (
	ColorSpaceUsageForce    ColorSpaceUsage = "FORCE"
	ColorSpaceUsageFallback ColorSpaceUsage = "FALLBACK"
)

func (enum ColorSpaceUsage) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum ColorSpaceUsage) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// The length of the term of your reserved queue pricing plan commitment.
type Commitment string

// Enum values for Commitment
const (
	CommitmentOneYear Commitment = "ONE_YEAR"
)

func (enum Commitment) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum Commitment) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Container for this output. Some containers require a container settings object.
// If not specified, the default object will be created.
type ContainerType string

// Enum values for ContainerType
const (
	ContainerTypeF4v  ContainerType = "F4V"
	ContainerTypeIsmv ContainerType = "ISMV"
	ContainerTypeM2ts ContainerType = "M2TS"
	ContainerTypeM3u8 ContainerType = "M3U8"
	ContainerTypeCmfc ContainerType = "CMFC"
	ContainerTypeMov  ContainerType = "MOV"
	ContainerTypeMp4  ContainerType = "MP4"
	ContainerTypeMpd  ContainerType = "MPD"
	ContainerTypeMxf  ContainerType = "MXF"
	ContainerTypeWebm ContainerType = "WEBM"
	ContainerTypeRaw  ContainerType = "RAW"
)

func (enum ContainerType) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum ContainerType) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Supports HbbTV specification as indicated
type DashIsoHbbtvCompliance string

// Enum values for DashIsoHbbtvCompliance
const (
	DashIsoHbbtvComplianceHbbtv15 DashIsoHbbtvCompliance = "HBBTV_1_5"
	DashIsoHbbtvComplianceNone    DashIsoHbbtvCompliance = "NONE"
)

func (enum DashIsoHbbtvCompliance) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum DashIsoHbbtvCompliance) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Specify whether your DASH profile is on-demand or main. When you choose Main
// profile (MAIN_PROFILE), the service signals urn:mpeg:dash:profile:isoff-main:2011
// in your .mpd DASH manifest. When you choose On-demand (ON_DEMAND_PROFILE),
// the service signals urn:mpeg:dash:profile:isoff-on-demand:2011 in your .mpd.
// When you choose On-demand, you must also set the output group setting Segment
// control (SegmentControl) to Single file (SINGLE_FILE).
type DashIsoMpdProfile string

// Enum values for DashIsoMpdProfile
const (
	DashIsoMpdProfileMainProfile     DashIsoMpdProfile = "MAIN_PROFILE"
	DashIsoMpdProfileOnDemandProfile DashIsoMpdProfile = "ON_DEMAND_PROFILE"
)

func (enum DashIsoMpdProfile) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum DashIsoMpdProfile) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// This setting can improve the compatibility of your output with video players
// on obsolete devices. It applies only to DASH H.264 outputs with DRM encryption.
// Choose Unencrypted SEI (UNENCRYPTED_SEI) only to correct problems with playback
// on older devices. Otherwise, keep the default setting CENC v1 (CENC_V1).
// If you choose Unencrypted SEI, for that output, the service will exclude
// the access unit delimiter and will leave the SEI NAL units unencrypted.
type DashIsoPlaybackDeviceCompatibility string

// Enum values for DashIsoPlaybackDeviceCompatibility
const (
	DashIsoPlaybackDeviceCompatibilityCencV1         DashIsoPlaybackDeviceCompatibility = "CENC_V1"
	DashIsoPlaybackDeviceCompatibilityUnencryptedSei DashIsoPlaybackDeviceCompatibility = "UNENCRYPTED_SEI"
)

func (enum DashIsoPlaybackDeviceCompatibility) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum DashIsoPlaybackDeviceCompatibility) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// When set to SINGLE_FILE, a single output file is generated, which is internally
// segmented using the Fragment Length and Segment Length. When set to SEGMENTED_FILES,
// separate segment files will be created.
type DashIsoSegmentControl string

// Enum values for DashIsoSegmentControl
const (
	DashIsoSegmentControlSingleFile     DashIsoSegmentControl = "SINGLE_FILE"
	DashIsoSegmentControlSegmentedFiles DashIsoSegmentControl = "SEGMENTED_FILES"
)

func (enum DashIsoSegmentControl) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum DashIsoSegmentControl) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// When you enable Precise segment duration in manifests (writeSegmentTimelineInRepresentation),
// your DASH manifest shows precise segment durations. The segment duration
// information appears inside the SegmentTimeline element, inside SegmentTemplate
// at the Representation level. When this feature isn't enabled, the segment
// durations in your DASH manifest are approximate. The segment duration information
// appears in the duration attribute of the SegmentTemplate element.
type DashIsoWriteSegmentTimelineInRepresentation string

// Enum values for DashIsoWriteSegmentTimelineInRepresentation
const (
	DashIsoWriteSegmentTimelineInRepresentationEnabled  DashIsoWriteSegmentTimelineInRepresentation = "ENABLED"
	DashIsoWriteSegmentTimelineInRepresentationDisabled DashIsoWriteSegmentTimelineInRepresentation = "DISABLED"
)

func (enum DashIsoWriteSegmentTimelineInRepresentation) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum DashIsoWriteSegmentTimelineInRepresentation) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Specify the encryption mode that you used to encrypt your input files.
type DecryptionMode string

// Enum values for DecryptionMode
const (
	DecryptionModeAesCtr DecryptionMode = "AES_CTR"
	DecryptionModeAesCbc DecryptionMode = "AES_CBC"
	DecryptionModeAesGcm DecryptionMode = "AES_GCM"
)

func (enum DecryptionMode) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum DecryptionMode) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Only applies when you set Deinterlacer (DeinterlaceMode) to Deinterlace (DEINTERLACE)
// or Adaptive (ADAPTIVE). Motion adaptive interpolate (INTERPOLATE) produces
// sharper pictures, while blend (BLEND) produces smoother motion. Use (INTERPOLATE_TICKER)
// OR (BLEND_TICKER) if your source file includes a ticker, such as a scrolling
// headline at the bottom of the frame.
type DeinterlaceAlgorithm string

// Enum values for DeinterlaceAlgorithm
const (
	DeinterlaceAlgorithmInterpolate       DeinterlaceAlgorithm = "INTERPOLATE"
	DeinterlaceAlgorithmInterpolateTicker DeinterlaceAlgorithm = "INTERPOLATE_TICKER"
	DeinterlaceAlgorithmBlend             DeinterlaceAlgorithm = "BLEND"
	DeinterlaceAlgorithmBlendTicker       DeinterlaceAlgorithm = "BLEND_TICKER"
)

func (enum DeinterlaceAlgorithm) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum DeinterlaceAlgorithm) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// - When set to NORMAL (default), the deinterlacer does not convert frames
// that are tagged in metadata as progressive. It will only convert those that
// are tagged as some other type. - When set to FORCE_ALL_FRAMES, the deinterlacer
// converts every frame to progressive - even those that are already tagged
// as progressive. Turn Force mode on only if there is a good chance that the
// metadata has tagged frames as progressive when they are not progressive.
// Do not turn on otherwise; processing frames that are already progressive
// into progressive will probably result in lower quality video.
type DeinterlacerControl string

// Enum values for DeinterlacerControl
const (
	DeinterlacerControlForceAllFrames DeinterlacerControl = "FORCE_ALL_FRAMES"
	DeinterlacerControlNormal         DeinterlacerControl = "NORMAL"
)

func (enum DeinterlacerControl) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum DeinterlacerControl) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Use Deinterlacer (DeinterlaceMode) to choose how the service will do deinterlacing.
// Default is Deinterlace. - Deinterlace converts interlaced to progressive.
// - Inverse telecine converts Hard Telecine 29.97i to progressive 23.976p.
// - Adaptive auto-detects and converts to progressive.
type DeinterlacerMode string

// Enum values for DeinterlacerMode
const (
	DeinterlacerModeDeinterlace     DeinterlacerMode = "DEINTERLACE"
	DeinterlacerModeInverseTelecine DeinterlacerMode = "INVERSE_TELECINE"
	DeinterlacerModeAdaptive        DeinterlacerMode = "ADAPTIVE"
)

func (enum DeinterlacerMode) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum DeinterlacerMode) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Optional field, defaults to DEFAULT. Specify DEFAULT for this operation to
// return your endpoints if any exist, or to create an endpoint for you and
// return it if one doesn't already exist. Specify GET_ONLY to return your endpoints
// if any exist, or an empty list if none exist.
type DescribeEndpointsMode string

// Enum values for DescribeEndpointsMode
const (
	DescribeEndpointsModeDefault DescribeEndpointsMode = "DEFAULT"
	DescribeEndpointsModeGetOnly DescribeEndpointsMode = "GET_ONLY"
)

func (enum DescribeEndpointsMode) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum DescribeEndpointsMode) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Use Dolby Vision Mode to choose how the service will handle Dolby Vision
// MaxCLL and MaxFALL properies.
type DolbyVisionLevel6Mode string

// Enum values for DolbyVisionLevel6Mode
const (
	DolbyVisionLevel6ModePassthrough DolbyVisionLevel6Mode = "PASSTHROUGH"
	DolbyVisionLevel6ModeRecalculate DolbyVisionLevel6Mode = "RECALCULATE"
	DolbyVisionLevel6ModeSpecify     DolbyVisionLevel6Mode = "SPECIFY"
)

func (enum DolbyVisionLevel6Mode) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum DolbyVisionLevel6Mode) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// In the current MediaConvert implementation, the Dolby Vision profile is always
// 5 (PROFILE_5). Therefore, all of your inputs must contain Dolby Vision frame
// interleaved data.
type DolbyVisionProfile string

// Enum values for DolbyVisionProfile
const (
	DolbyVisionProfileProfile5 DolbyVisionProfile = "PROFILE_5"
)

func (enum DolbyVisionProfile) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum DolbyVisionProfile) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Applies only to 29.97 fps outputs. When this feature is enabled, the service
// will use drop-frame timecode on outputs. If it is not possible to use drop-frame
// timecode, the system will fall back to non-drop-frame. This setting is enabled
// by default when Timecode insertion (TimecodeInsertion) is enabled.
type DropFrameTimecode string

// Enum values for DropFrameTimecode
const (
	DropFrameTimecodeDisabled DropFrameTimecode = "DISABLED"
	DropFrameTimecodeEnabled  DropFrameTimecode = "ENABLED"
)

func (enum DropFrameTimecode) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum DropFrameTimecode) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// If no explicit x_position or y_position is provided, setting alignment to
// centered will place the captions at the bottom center of the output. Similarly,
// setting a left alignment will align captions to the bottom left of the output.
// If x and y positions are given in conjunction with the alignment parameter,
// the font will be justified (either left or centered) relative to those coordinates.
// This option is not valid for source captions that are STL, 608/embedded or
// teletext. These source settings are already pre-defined by the caption stream.
// All burn-in and DVB-Sub font settings must match.
type DvbSubtitleAlignment string

// Enum values for DvbSubtitleAlignment
const (
	DvbSubtitleAlignmentCentered DvbSubtitleAlignment = "CENTERED"
	DvbSubtitleAlignmentLeft     DvbSubtitleAlignment = "LEFT"
)

func (enum DvbSubtitleAlignment) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum DvbSubtitleAlignment) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Specifies the color of the rectangle behind the captions.All burn-in and
// DVB-Sub font settings must match.
type DvbSubtitleBackgroundColor string

// Enum values for DvbSubtitleBackgroundColor
const (
	DvbSubtitleBackgroundColorNone  DvbSubtitleBackgroundColor = "NONE"
	DvbSubtitleBackgroundColorBlack DvbSubtitleBackgroundColor = "BLACK"
	DvbSubtitleBackgroundColorWhite DvbSubtitleBackgroundColor = "WHITE"
)

func (enum DvbSubtitleBackgroundColor) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum DvbSubtitleBackgroundColor) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Specifies the color of the burned-in captions. This option is not valid for
// source captions that are STL, 608/embedded or teletext. These source settings
// are already pre-defined by the caption stream. All burn-in and DVB-Sub font
// settings must match.
type DvbSubtitleFontColor string

// Enum values for DvbSubtitleFontColor
const (
	DvbSubtitleFontColorWhite  DvbSubtitleFontColor = "WHITE"
	DvbSubtitleFontColorBlack  DvbSubtitleFontColor = "BLACK"
	DvbSubtitleFontColorYellow DvbSubtitleFontColor = "YELLOW"
	DvbSubtitleFontColorRed    DvbSubtitleFontColor = "RED"
	DvbSubtitleFontColorGreen  DvbSubtitleFontColor = "GREEN"
	DvbSubtitleFontColorBlue   DvbSubtitleFontColor = "BLUE"
)

func (enum DvbSubtitleFontColor) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum DvbSubtitleFontColor) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Specifies font outline color. This option is not valid for source captions
// that are either 608/embedded or teletext. These source settings are already
// pre-defined by the caption stream. All burn-in and DVB-Sub font settings
// must match.
type DvbSubtitleOutlineColor string

// Enum values for DvbSubtitleOutlineColor
const (
	DvbSubtitleOutlineColorBlack  DvbSubtitleOutlineColor = "BLACK"
	DvbSubtitleOutlineColorWhite  DvbSubtitleOutlineColor = "WHITE"
	DvbSubtitleOutlineColorYellow DvbSubtitleOutlineColor = "YELLOW"
	DvbSubtitleOutlineColorRed    DvbSubtitleOutlineColor = "RED"
	DvbSubtitleOutlineColorGreen  DvbSubtitleOutlineColor = "GREEN"
	DvbSubtitleOutlineColorBlue   DvbSubtitleOutlineColor = "BLUE"
)

func (enum DvbSubtitleOutlineColor) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum DvbSubtitleOutlineColor) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Specifies the color of the shadow cast by the captions.All burn-in and DVB-Sub
// font settings must match.
type DvbSubtitleShadowColor string

// Enum values for DvbSubtitleShadowColor
const (
	DvbSubtitleShadowColorNone  DvbSubtitleShadowColor = "NONE"
	DvbSubtitleShadowColorBlack DvbSubtitleShadowColor = "BLACK"
	DvbSubtitleShadowColorWhite DvbSubtitleShadowColor = "WHITE"
)

func (enum DvbSubtitleShadowColor) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum DvbSubtitleShadowColor) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Only applies to jobs with input captions in Teletext or STL formats. Specify
// whether the spacing between letters in your captions is set by the captions
// grid or varies depending on letter width. Choose fixed grid to conform to
// the spacing specified in the captions file more accurately. Choose proportional
// to make the text easier to read if the captions are closed caption.
type DvbSubtitleTeletextSpacing string

// Enum values for DvbSubtitleTeletextSpacing
const (
	DvbSubtitleTeletextSpacingFixedGrid    DvbSubtitleTeletextSpacing = "FIXED_GRID"
	DvbSubtitleTeletextSpacingProportional DvbSubtitleTeletextSpacing = "PROPORTIONAL"
)

func (enum DvbSubtitleTeletextSpacing) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum DvbSubtitleTeletextSpacing) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Specify whether your DVB subtitles are standard or for hearing impaired.
// Choose hearing impaired if your subtitles include audio descriptions and
// dialogue. Choose standard if your subtitles include only dialogue.
type DvbSubtitlingType string

// Enum values for DvbSubtitlingType
const (
	DvbSubtitlingTypeHearingImpaired DvbSubtitlingType = "HEARING_IMPAIRED"
	DvbSubtitlingTypeStandard        DvbSubtitlingType = "STANDARD"
)

func (enum DvbSubtitlingType) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum DvbSubtitlingType) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Specify the bitstream mode for the E-AC-3 stream that the encoder emits.
// For more information about the EAC3 bitstream mode, see ATSC A/52-2012 (Annex
// E).
type Eac3AtmosBitstreamMode string

// Enum values for Eac3AtmosBitstreamMode
const (
	Eac3AtmosBitstreamModeCompleteMain Eac3AtmosBitstreamMode = "COMPLETE_MAIN"
)

func (enum Eac3AtmosBitstreamMode) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum Eac3AtmosBitstreamMode) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// The coding mode for Dolby Digital Plus JOC (Atmos) is always 9.1.6 (CODING_MODE_9_1_6).
type Eac3AtmosCodingMode string

// Enum values for Eac3AtmosCodingMode
const (
	Eac3AtmosCodingModeCodingMode916 Eac3AtmosCodingMode = "CODING_MODE_9_1_6"
)

func (enum Eac3AtmosCodingMode) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum Eac3AtmosCodingMode) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Enable Dolby Dialogue Intelligence to adjust loudness based on dialogue analysis.
type Eac3AtmosDialogueIntelligence string

// Enum values for Eac3AtmosDialogueIntelligence
const (
	Eac3AtmosDialogueIntelligenceEnabled  Eac3AtmosDialogueIntelligence = "ENABLED"
	Eac3AtmosDialogueIntelligenceDisabled Eac3AtmosDialogueIntelligence = "DISABLED"
)

func (enum Eac3AtmosDialogueIntelligence) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum Eac3AtmosDialogueIntelligence) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Specify the absolute peak level for a signal with dynamic range compression.
type Eac3AtmosDynamicRangeCompressionLine string

// Enum values for Eac3AtmosDynamicRangeCompressionLine
const (
	Eac3AtmosDynamicRangeCompressionLineNone          Eac3AtmosDynamicRangeCompressionLine = "NONE"
	Eac3AtmosDynamicRangeCompressionLineFilmStandard  Eac3AtmosDynamicRangeCompressionLine = "FILM_STANDARD"
	Eac3AtmosDynamicRangeCompressionLineFilmLight     Eac3AtmosDynamicRangeCompressionLine = "FILM_LIGHT"
	Eac3AtmosDynamicRangeCompressionLineMusicStandard Eac3AtmosDynamicRangeCompressionLine = "MUSIC_STANDARD"
	Eac3AtmosDynamicRangeCompressionLineMusicLight    Eac3AtmosDynamicRangeCompressionLine = "MUSIC_LIGHT"
	Eac3AtmosDynamicRangeCompressionLineSpeech        Eac3AtmosDynamicRangeCompressionLine = "SPEECH"
)

func (enum Eac3AtmosDynamicRangeCompressionLine) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum Eac3AtmosDynamicRangeCompressionLine) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Specify how the service limits the audio dynamic range when compressing the
// audio.
type Eac3AtmosDynamicRangeCompressionRf string

// Enum values for Eac3AtmosDynamicRangeCompressionRf
const (
	Eac3AtmosDynamicRangeCompressionRfNone          Eac3AtmosDynamicRangeCompressionRf = "NONE"
	Eac3AtmosDynamicRangeCompressionRfFilmStandard  Eac3AtmosDynamicRangeCompressionRf = "FILM_STANDARD"
	Eac3AtmosDynamicRangeCompressionRfFilmLight     Eac3AtmosDynamicRangeCompressionRf = "FILM_LIGHT"
	Eac3AtmosDynamicRangeCompressionRfMusicStandard Eac3AtmosDynamicRangeCompressionRf = "MUSIC_STANDARD"
	Eac3AtmosDynamicRangeCompressionRfMusicLight    Eac3AtmosDynamicRangeCompressionRf = "MUSIC_LIGHT"
	Eac3AtmosDynamicRangeCompressionRfSpeech        Eac3AtmosDynamicRangeCompressionRf = "SPEECH"
)

func (enum Eac3AtmosDynamicRangeCompressionRf) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum Eac3AtmosDynamicRangeCompressionRf) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Choose how the service meters the loudness of your audio.
type Eac3AtmosMeteringMode string

// Enum values for Eac3AtmosMeteringMode
const (
	Eac3AtmosMeteringModeLeqA       Eac3AtmosMeteringMode = "LEQ_A"
	Eac3AtmosMeteringModeItuBs17701 Eac3AtmosMeteringMode = "ITU_BS_1770_1"
	Eac3AtmosMeteringModeItuBs17702 Eac3AtmosMeteringMode = "ITU_BS_1770_2"
	Eac3AtmosMeteringModeItuBs17703 Eac3AtmosMeteringMode = "ITU_BS_1770_3"
	Eac3AtmosMeteringModeItuBs17704 Eac3AtmosMeteringMode = "ITU_BS_1770_4"
)

func (enum Eac3AtmosMeteringMode) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum Eac3AtmosMeteringMode) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Choose how the service does stereo downmixing.
type Eac3AtmosStereoDownmix string

// Enum values for Eac3AtmosStereoDownmix
const (
	Eac3AtmosStereoDownmixNotIndicated Eac3AtmosStereoDownmix = "NOT_INDICATED"
	Eac3AtmosStereoDownmixStereo       Eac3AtmosStereoDownmix = "STEREO"
	Eac3AtmosStereoDownmixSurround     Eac3AtmosStereoDownmix = "SURROUND"
	Eac3AtmosStereoDownmixDpl2         Eac3AtmosStereoDownmix = "DPL2"
)

func (enum Eac3AtmosStereoDownmix) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum Eac3AtmosStereoDownmix) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Specify whether your input audio has an additional center rear surround channel
// matrix encoded into your left and right surround channels.
type Eac3AtmosSurroundExMode string

// Enum values for Eac3AtmosSurroundExMode
const (
	Eac3AtmosSurroundExModeNotIndicated Eac3AtmosSurroundExMode = "NOT_INDICATED"
	Eac3AtmosSurroundExModeEnabled      Eac3AtmosSurroundExMode = "ENABLED"
	Eac3AtmosSurroundExModeDisabled     Eac3AtmosSurroundExMode = "DISABLED"
)

func (enum Eac3AtmosSurroundExMode) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum Eac3AtmosSurroundExMode) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// If set to ATTENUATE_3_DB, applies a 3 dB attenuation to the surround channels.
// Only used for 3/2 coding mode.
type Eac3AttenuationControl string

// Enum values for Eac3AttenuationControl
const (
	Eac3AttenuationControlAttenuate3Db Eac3AttenuationControl = "ATTENUATE_3_DB"
	Eac3AttenuationControlNone         Eac3AttenuationControl = "NONE"
)

func (enum Eac3AttenuationControl) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum Eac3AttenuationControl) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Specify the bitstream mode for the E-AC-3 stream that the encoder emits.
// For more information about the EAC3 bitstream mode, see ATSC A/52-2012 (Annex
// E).
type Eac3BitstreamMode string

// Enum values for Eac3BitstreamMode
const (
	Eac3BitstreamModeCompleteMain     Eac3BitstreamMode = "COMPLETE_MAIN"
	Eac3BitstreamModeCommentary       Eac3BitstreamMode = "COMMENTARY"
	Eac3BitstreamModeEmergency        Eac3BitstreamMode = "EMERGENCY"
	Eac3BitstreamModeHearingImpaired  Eac3BitstreamMode = "HEARING_IMPAIRED"
	Eac3BitstreamModeVisuallyImpaired Eac3BitstreamMode = "VISUALLY_IMPAIRED"
)

func (enum Eac3BitstreamMode) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum Eac3BitstreamMode) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Dolby Digital Plus coding mode. Determines number of channels.
type Eac3CodingMode string

// Enum values for Eac3CodingMode
const (
	Eac3CodingModeCodingMode10 Eac3CodingMode = "CODING_MODE_1_0"
	Eac3CodingModeCodingMode20 Eac3CodingMode = "CODING_MODE_2_0"
	Eac3CodingModeCodingMode32 Eac3CodingMode = "CODING_MODE_3_2"
)

func (enum Eac3CodingMode) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum Eac3CodingMode) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Activates a DC highpass filter for all input channels.
type Eac3DcFilter string

// Enum values for Eac3DcFilter
const (
	Eac3DcFilterEnabled  Eac3DcFilter = "ENABLED"
	Eac3DcFilterDisabled Eac3DcFilter = "DISABLED"
)

func (enum Eac3DcFilter) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum Eac3DcFilter) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Specify the absolute peak level for a signal with dynamic range compression.
type Eac3DynamicRangeCompressionLine string

// Enum values for Eac3DynamicRangeCompressionLine
const (
	Eac3DynamicRangeCompressionLineNone          Eac3DynamicRangeCompressionLine = "NONE"
	Eac3DynamicRangeCompressionLineFilmStandard  Eac3DynamicRangeCompressionLine = "FILM_STANDARD"
	Eac3DynamicRangeCompressionLineFilmLight     Eac3DynamicRangeCompressionLine = "FILM_LIGHT"
	Eac3DynamicRangeCompressionLineMusicStandard Eac3DynamicRangeCompressionLine = "MUSIC_STANDARD"
	Eac3DynamicRangeCompressionLineMusicLight    Eac3DynamicRangeCompressionLine = "MUSIC_LIGHT"
	Eac3DynamicRangeCompressionLineSpeech        Eac3DynamicRangeCompressionLine = "SPEECH"
)

func (enum Eac3DynamicRangeCompressionLine) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum Eac3DynamicRangeCompressionLine) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Specify how the service limits the audio dynamic range when compressing the
// audio.
type Eac3DynamicRangeCompressionRf string

// Enum values for Eac3DynamicRangeCompressionRf
const (
	Eac3DynamicRangeCompressionRfNone          Eac3DynamicRangeCompressionRf = "NONE"
	Eac3DynamicRangeCompressionRfFilmStandard  Eac3DynamicRangeCompressionRf = "FILM_STANDARD"
	Eac3DynamicRangeCompressionRfFilmLight     Eac3DynamicRangeCompressionRf = "FILM_LIGHT"
	Eac3DynamicRangeCompressionRfMusicStandard Eac3DynamicRangeCompressionRf = "MUSIC_STANDARD"
	Eac3DynamicRangeCompressionRfMusicLight    Eac3DynamicRangeCompressionRf = "MUSIC_LIGHT"
	Eac3DynamicRangeCompressionRfSpeech        Eac3DynamicRangeCompressionRf = "SPEECH"
)

func (enum Eac3DynamicRangeCompressionRf) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum Eac3DynamicRangeCompressionRf) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// When encoding 3/2 audio, controls whether the LFE channel is enabled
type Eac3LfeControl string

// Enum values for Eac3LfeControl
const (
	Eac3LfeControlLfe   Eac3LfeControl = "LFE"
	Eac3LfeControlNoLfe Eac3LfeControl = "NO_LFE"
)

func (enum Eac3LfeControl) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum Eac3LfeControl) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Applies a 120Hz lowpass filter to the LFE channel prior to encoding. Only
// valid with 3_2_LFE coding mode.
type Eac3LfeFilter string

// Enum values for Eac3LfeFilter
const (
	Eac3LfeFilterEnabled  Eac3LfeFilter = "ENABLED"
	Eac3LfeFilterDisabled Eac3LfeFilter = "DISABLED"
)

func (enum Eac3LfeFilter) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum Eac3LfeFilter) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// When set to FOLLOW_INPUT, encoder metadata will be sourced from the DD, DD+,
// or DolbyE decoder that supplied this audio data. If audio was not supplied
// from one of these streams, then the static metadata settings will be used.
type Eac3MetadataControl string

// Enum values for Eac3MetadataControl
const (
	Eac3MetadataControlFollowInput   Eac3MetadataControl = "FOLLOW_INPUT"
	Eac3MetadataControlUseConfigured Eac3MetadataControl = "USE_CONFIGURED"
)

func (enum Eac3MetadataControl) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum Eac3MetadataControl) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// When set to WHEN_POSSIBLE, input DD+ audio will be passed through if it is
// present on the input. this detection is dynamic over the life of the transcode.
// Inputs that alternate between DD+ and non-DD+ content will have a consistent
// DD+ output as the system alternates between passthrough and encoding.
type Eac3PassthroughControl string

// Enum values for Eac3PassthroughControl
const (
	Eac3PassthroughControlWhenPossible  Eac3PassthroughControl = "WHEN_POSSIBLE"
	Eac3PassthroughControlNoPassthrough Eac3PassthroughControl = "NO_PASSTHROUGH"
)

func (enum Eac3PassthroughControl) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum Eac3PassthroughControl) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Controls the amount of phase-shift applied to the surround channels. Only
// used for 3/2 coding mode.
type Eac3PhaseControl string

// Enum values for Eac3PhaseControl
const (
	Eac3PhaseControlShift90Degrees Eac3PhaseControl = "SHIFT_90_DEGREES"
	Eac3PhaseControlNoShift        Eac3PhaseControl = "NO_SHIFT"
)

func (enum Eac3PhaseControl) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum Eac3PhaseControl) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Choose how the service does stereo downmixing. This setting only applies
// if you keep the default value of 3/2 - L, R, C, Ls, Rs (CODING_MODE_3_2)
// for the setting Coding mode (Eac3CodingMode). If you choose a different value
// for Coding mode, the service ignores Stereo downmix (Eac3StereoDownmix).
type Eac3StereoDownmix string

// Enum values for Eac3StereoDownmix
const (
	Eac3StereoDownmixNotIndicated Eac3StereoDownmix = "NOT_INDICATED"
	Eac3StereoDownmixLoRo         Eac3StereoDownmix = "LO_RO"
	Eac3StereoDownmixLtRt         Eac3StereoDownmix = "LT_RT"
	Eac3StereoDownmixDpl2         Eac3StereoDownmix = "DPL2"
)

func (enum Eac3StereoDownmix) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum Eac3StereoDownmix) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// When encoding 3/2 audio, sets whether an extra center back surround channel
// is matrix encoded into the left and right surround channels.
type Eac3SurroundExMode string

// Enum values for Eac3SurroundExMode
const (
	Eac3SurroundExModeNotIndicated Eac3SurroundExMode = "NOT_INDICATED"
	Eac3SurroundExModeEnabled      Eac3SurroundExMode = "ENABLED"
	Eac3SurroundExModeDisabled     Eac3SurroundExMode = "DISABLED"
)

func (enum Eac3SurroundExMode) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum Eac3SurroundExMode) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// When encoding 2/0 audio, sets whether Dolby Surround is matrix encoded into
// the two channels.
type Eac3SurroundMode string

// Enum values for Eac3SurroundMode
const (
	Eac3SurroundModeNotIndicated Eac3SurroundMode = "NOT_INDICATED"
	Eac3SurroundModeEnabled      Eac3SurroundMode = "ENABLED"
	Eac3SurroundModeDisabled     Eac3SurroundMode = "DISABLED"
)

func (enum Eac3SurroundMode) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum Eac3SurroundMode) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Specify whether this set of input captions appears in your outputs in both
// 608 and 708 format. If you choose Upconvert (UPCONVERT), MediaConvert includes
// the captions data in two ways: it passes the 608 data through using the 608
// compatibility bytes fields of the 708 wrapper, and it also translates the
// 608 data into 708.
type EmbeddedConvert608To708 string

// Enum values for EmbeddedConvert608To708
const (
	EmbeddedConvert608To708Upconvert EmbeddedConvert608To708 = "UPCONVERT"
	EmbeddedConvert608To708Disabled  EmbeddedConvert608To708 = "DISABLED"
)

func (enum EmbeddedConvert608To708) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum EmbeddedConvert608To708) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// By default, the service terminates any unterminated captions at the end of
// each input. If you want the caption to continue onto your next input, disable
// this setting.
type EmbeddedTerminateCaptions string

// Enum values for EmbeddedTerminateCaptions
const (
	EmbeddedTerminateCaptionsEndOfInput EmbeddedTerminateCaptions = "END_OF_INPUT"
	EmbeddedTerminateCaptionsDisabled   EmbeddedTerminateCaptions = "DISABLED"
)

func (enum EmbeddedTerminateCaptions) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum EmbeddedTerminateCaptions) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// If set to PROGRESSIVE_DOWNLOAD, the MOOV atom is relocated to the beginning
// of the archive as required for progressive downloading. Otherwise it is placed
// normally at the end.
type F4vMoovPlacement string

// Enum values for F4vMoovPlacement
const (
	F4vMoovPlacementProgressiveDownload F4vMoovPlacement = "PROGRESSIVE_DOWNLOAD"
	F4vMoovPlacementNormal              F4vMoovPlacement = "NORMAL"
)

func (enum F4vMoovPlacement) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum F4vMoovPlacement) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Specify whether this set of input captions appears in your outputs in both
// 608 and 708 format. If you choose Upconvert (UPCONVERT), MediaConvert includes
// the captions data in two ways: it passes the 608 data through using the 608
// compatibility bytes fields of the 708 wrapper, and it also translates the
// 608 data into 708.
type FileSourceConvert608To708 string

// Enum values for FileSourceConvert608To708
const (
	FileSourceConvert608To708Upconvert FileSourceConvert608To708 = "UPCONVERT"
	FileSourceConvert608To708Disabled  FileSourceConvert608To708 = "DISABLED"
)

func (enum FileSourceConvert608To708) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum FileSourceConvert608To708) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Provide the font script, using an ISO 15924 script code, if the LanguageCode
// is not sufficient for determining the script type. Where LanguageCode or
// CustomLanguageCode is sufficient, use "AUTOMATIC" or leave unset.
type FontScript string

// Enum values for FontScript
const (
	FontScriptAutomatic FontScript = "AUTOMATIC"
	FontScriptHans      FontScript = "HANS"
	FontScriptHant      FontScript = "HANT"
)

func (enum FontScript) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum FontScript) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Adaptive quantization. Allows intra-frame quantizers to vary to improve visual
// quality.
type H264AdaptiveQuantization string

// Enum values for H264AdaptiveQuantization
const (
	H264AdaptiveQuantizationOff    H264AdaptiveQuantization = "OFF"
	H264AdaptiveQuantizationLow    H264AdaptiveQuantization = "LOW"
	H264AdaptiveQuantizationMedium H264AdaptiveQuantization = "MEDIUM"
	H264AdaptiveQuantizationHigh   H264AdaptiveQuantization = "HIGH"
	H264AdaptiveQuantizationHigher H264AdaptiveQuantization = "HIGHER"
	H264AdaptiveQuantizationMax    H264AdaptiveQuantization = "MAX"
)

func (enum H264AdaptiveQuantization) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum H264AdaptiveQuantization) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Specify an H.264 level that is consistent with your output video settings.
// If you aren't sure what level to specify, choose Auto (AUTO).
type H264CodecLevel string

// Enum values for H264CodecLevel
const (
	H264CodecLevelAuto    H264CodecLevel = "AUTO"
	H264CodecLevelLevel1  H264CodecLevel = "LEVEL_1"
	H264CodecLevelLevel11 H264CodecLevel = "LEVEL_1_1"
	H264CodecLevelLevel12 H264CodecLevel = "LEVEL_1_2"
	H264CodecLevelLevel13 H264CodecLevel = "LEVEL_1_3"
	H264CodecLevelLevel2  H264CodecLevel = "LEVEL_2"
	H264CodecLevelLevel21 H264CodecLevel = "LEVEL_2_1"
	H264CodecLevelLevel22 H264CodecLevel = "LEVEL_2_2"
	H264CodecLevelLevel3  H264CodecLevel = "LEVEL_3"
	H264CodecLevelLevel31 H264CodecLevel = "LEVEL_3_1"
	H264CodecLevelLevel32 H264CodecLevel = "LEVEL_3_2"
	H264CodecLevelLevel4  H264CodecLevel = "LEVEL_4"
	H264CodecLevelLevel41 H264CodecLevel = "LEVEL_4_1"
	H264CodecLevelLevel42 H264CodecLevel = "LEVEL_4_2"
	H264CodecLevelLevel5  H264CodecLevel = "LEVEL_5"
	H264CodecLevelLevel51 H264CodecLevel = "LEVEL_5_1"
	H264CodecLevelLevel52 H264CodecLevel = "LEVEL_5_2"
)

func (enum H264CodecLevel) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum H264CodecLevel) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// H.264 Profile. High 4:2:2 and 10-bit profiles are only available with the
// AVC-I License.
type H264CodecProfile string

// Enum values for H264CodecProfile
const (
	H264CodecProfileBaseline     H264CodecProfile = "BASELINE"
	H264CodecProfileHigh         H264CodecProfile = "HIGH"
	H264CodecProfileHigh10bit    H264CodecProfile = "HIGH_10BIT"
	H264CodecProfileHigh422      H264CodecProfile = "HIGH_422"
	H264CodecProfileHigh42210bit H264CodecProfile = "HIGH_422_10BIT"
	H264CodecProfileMain         H264CodecProfile = "MAIN"
)

func (enum H264CodecProfile) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum H264CodecProfile) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Choose Adaptive to improve subjective video quality for high-motion content.
// This will cause the service to use fewer B-frames (which infer information
// based on other frames) for high-motion portions of the video and more B-frames
// for low-motion portions. The maximum number of B-frames is limited by the
// value you provide for the setting B frames between reference frames (numberBFramesBetweenReferenceFrames).
type H264DynamicSubGop string

// Enum values for H264DynamicSubGop
const (
	H264DynamicSubGopAdaptive H264DynamicSubGop = "ADAPTIVE"
	H264DynamicSubGopStatic   H264DynamicSubGop = "STATIC"
)

func (enum H264DynamicSubGop) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum H264DynamicSubGop) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Entropy encoding mode. Use CABAC (must be in Main or High profile) or CAVLC.
type H264EntropyEncoding string

// Enum values for H264EntropyEncoding
const (
	H264EntropyEncodingCabac H264EntropyEncoding = "CABAC"
	H264EntropyEncodingCavlc H264EntropyEncoding = "CAVLC"
)

func (enum H264EntropyEncoding) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum H264EntropyEncoding) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Choosing FORCE_FIELD disables PAFF encoding for interlaced outputs.
type H264FieldEncoding string

// Enum values for H264FieldEncoding
const (
	H264FieldEncodingPaff       H264FieldEncoding = "PAFF"
	H264FieldEncodingForceField H264FieldEncoding = "FORCE_FIELD"
)

func (enum H264FieldEncoding) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum H264FieldEncoding) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Adjust quantization within each frame to reduce flicker or 'pop' on I-frames.
type H264FlickerAdaptiveQuantization string

// Enum values for H264FlickerAdaptiveQuantization
const (
	H264FlickerAdaptiveQuantizationDisabled H264FlickerAdaptiveQuantization = "DISABLED"
	H264FlickerAdaptiveQuantizationEnabled  H264FlickerAdaptiveQuantization = "ENABLED"
)

func (enum H264FlickerAdaptiveQuantization) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum H264FlickerAdaptiveQuantization) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// If you are using the console, use the Framerate setting to specify the frame
// rate for this output. If you want to keep the same frame rate as the input
// video, choose Follow source. If you want to do frame rate conversion, choose
// a frame rate from the dropdown list or choose Custom. The framerates shown
// in the dropdown list are decimal approximations of fractions. If you choose
// Custom, specify your frame rate as a fraction. If you are creating your transcoding
// job specification as a JSON file without the console, use FramerateControl
// to specify which value the service uses for the frame rate for this output.
// Choose INITIALIZE_FROM_SOURCE if you want the service to use the frame rate
// from the input. Choose SPECIFIED if you want the service to use the frame
// rate you specify in the settings FramerateNumerator and FramerateDenominator.
type H264FramerateControl string

// Enum values for H264FramerateControl
const (
	H264FramerateControlInitializeFromSource H264FramerateControl = "INITIALIZE_FROM_SOURCE"
	H264FramerateControlSpecified            H264FramerateControl = "SPECIFIED"
)

func (enum H264FramerateControl) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum H264FramerateControl) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Optional. Specify how the transcoder performs framerate conversion. The default
// behavior is to use duplicate drop conversion.
type H264FramerateConversionAlgorithm string

// Enum values for H264FramerateConversionAlgorithm
const (
	H264FramerateConversionAlgorithmDuplicateDrop H264FramerateConversionAlgorithm = "DUPLICATE_DROP"
	H264FramerateConversionAlgorithmInterpolate   H264FramerateConversionAlgorithm = "INTERPOLATE"
)

func (enum H264FramerateConversionAlgorithm) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum H264FramerateConversionAlgorithm) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// If enable, use reference B frames for GOP structures that have B frames >
// 1.
type H264GopBReference string

// Enum values for H264GopBReference
const (
	H264GopBReferenceDisabled H264GopBReference = "DISABLED"
	H264GopBReferenceEnabled  H264GopBReference = "ENABLED"
)

func (enum H264GopBReference) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum H264GopBReference) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Indicates if the GOP Size in H264 is specified in frames or seconds. If seconds
// the system will convert the GOP Size into a frame count at run time.
type H264GopSizeUnits string

// Enum values for H264GopSizeUnits
const (
	H264GopSizeUnitsFrames  H264GopSizeUnits = "FRAMES"
	H264GopSizeUnitsSeconds H264GopSizeUnits = "SECONDS"
)

func (enum H264GopSizeUnits) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum H264GopSizeUnits) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Use Interlace mode (InterlaceMode) to choose the scan line type for the output.
// * Top Field First (TOP_FIELD) and Bottom Field First (BOTTOM_FIELD) produce
// interlaced output with the entire output having the same field polarity (top
// or bottom first). * Follow, Default Top (FOLLOW_TOP_FIELD) and Follow, Default
// Bottom (FOLLOW_BOTTOM_FIELD) use the same field polarity as the source. Therefore,
// behavior depends on the input scan type, as follows. - If the source is interlaced,
// the output will be interlaced with the same polarity as the source (it will
// follow the source). The output could therefore be a mix of "top field first"
// and "bottom field first". - If the source is progressive, the output will
// be interlaced with "top field first" or "bottom field first" polarity, depending
// on which of the Follow options you chose.
type H264InterlaceMode string

// Enum values for H264InterlaceMode
const (
	H264InterlaceModeProgressive       H264InterlaceMode = "PROGRESSIVE"
	H264InterlaceModeTopField          H264InterlaceMode = "TOP_FIELD"
	H264InterlaceModeBottomField       H264InterlaceMode = "BOTTOM_FIELD"
	H264InterlaceModeFollowTopField    H264InterlaceMode = "FOLLOW_TOP_FIELD"
	H264InterlaceModeFollowBottomField H264InterlaceMode = "FOLLOW_BOTTOM_FIELD"
)

func (enum H264InterlaceMode) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum H264InterlaceMode) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Optional. Specify how the service determines the pixel aspect ratio (PAR)
// for this output. The default behavior, Follow source (INITIALIZE_FROM_SOURCE),
// uses the PAR from your input video for your output. To specify a different
// PAR in the console, choose any value other than Follow source. To specify
// a different PAR by editing the JSON job specification, choose SPECIFIED.
// When you choose SPECIFIED for this setting, you must also specify values
// for the parNumerator and parDenominator settings.
type H264ParControl string

// Enum values for H264ParControl
const (
	H264ParControlInitializeFromSource H264ParControl = "INITIALIZE_FROM_SOURCE"
	H264ParControlSpecified            H264ParControl = "SPECIFIED"
)

func (enum H264ParControl) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum H264ParControl) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Optional. Use Quality tuning level (qualityTuningLevel) to choose how you
// want to trade off encoding speed for output video quality. The default behavior
// is faster, lower quality, single-pass encoding.
type H264QualityTuningLevel string

// Enum values for H264QualityTuningLevel
const (
	H264QualityTuningLevelSinglePass   H264QualityTuningLevel = "SINGLE_PASS"
	H264QualityTuningLevelSinglePassHq H264QualityTuningLevel = "SINGLE_PASS_HQ"
	H264QualityTuningLevelMultiPassHq  H264QualityTuningLevel = "MULTI_PASS_HQ"
)

func (enum H264QualityTuningLevel) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum H264QualityTuningLevel) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Use this setting to specify whether this output has a variable bitrate (VBR),
// constant bitrate (CBR) or quality-defined variable bitrate (QVBR).
type H264RateControlMode string

// Enum values for H264RateControlMode
const (
	H264RateControlModeVbr  H264RateControlMode = "VBR"
	H264RateControlModeCbr  H264RateControlMode = "CBR"
	H264RateControlModeQvbr H264RateControlMode = "QVBR"
)

func (enum H264RateControlMode) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum H264RateControlMode) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Places a PPS header on each encoded picture, even if repeated.
type H264RepeatPps string

// Enum values for H264RepeatPps
const (
	H264RepeatPpsDisabled H264RepeatPps = "DISABLED"
	H264RepeatPpsEnabled  H264RepeatPps = "ENABLED"
)

func (enum H264RepeatPps) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum H264RepeatPps) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Enable this setting to insert I-frames at scene changes that the service
// automatically detects. This improves video quality and is enabled by default.
// If this output uses QVBR, choose Transition detection (TRANSITION_DETECTION)
// for further video quality improvement. For more information about QVBR, see
// https://docs.aws.amazon.com/console/mediaconvert/cbr-vbr-qvbr.
type H264SceneChangeDetect string

// Enum values for H264SceneChangeDetect
const (
	H264SceneChangeDetectDisabled            H264SceneChangeDetect = "DISABLED"
	H264SceneChangeDetectEnabled             H264SceneChangeDetect = "ENABLED"
	H264SceneChangeDetectTransitionDetection H264SceneChangeDetect = "TRANSITION_DETECTION"
)

func (enum H264SceneChangeDetect) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum H264SceneChangeDetect) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Enables Slow PAL rate conversion. 23.976fps and 24fps input is relabeled
// as 25fps, and audio is sped up correspondingly.
type H264SlowPal string

// Enum values for H264SlowPal
const (
	H264SlowPalDisabled H264SlowPal = "DISABLED"
	H264SlowPalEnabled  H264SlowPal = "ENABLED"
)

func (enum H264SlowPal) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum H264SlowPal) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Adjust quantization within each frame based on spatial variation of content
// complexity.
type H264SpatialAdaptiveQuantization string

// Enum values for H264SpatialAdaptiveQuantization
const (
	H264SpatialAdaptiveQuantizationDisabled H264SpatialAdaptiveQuantization = "DISABLED"
	H264SpatialAdaptiveQuantizationEnabled  H264SpatialAdaptiveQuantization = "ENABLED"
)

func (enum H264SpatialAdaptiveQuantization) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum H264SpatialAdaptiveQuantization) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Produces a bitstream compliant with SMPTE RP-2027.
type H264Syntax string

// Enum values for H264Syntax
const (
	H264SyntaxDefault H264Syntax = "DEFAULT"
	H264SyntaxRp2027  H264Syntax = "RP2027"
)

func (enum H264Syntax) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum H264Syntax) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// This field applies only if the Streams > Advanced > Framerate (framerate)
// field is set to 29.970. This field works with the Streams > Advanced > Preprocessors
// > Deinterlacer field (deinterlace_mode) and the Streams > Advanced > Interlaced
// Mode field (interlace_mode) to identify the scan type for the output: Progressive,
// Interlaced, Hard Telecine or Soft Telecine. - Hard: produces 29.97i output
// from 23.976 input. - Soft: produces 23.976; the player converts this output
// to 29.97i.
type H264Telecine string

// Enum values for H264Telecine
const (
	H264TelecineNone H264Telecine = "NONE"
	H264TelecineSoft H264Telecine = "SOFT"
	H264TelecineHard H264Telecine = "HARD"
)

func (enum H264Telecine) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum H264Telecine) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Adjust quantization within each frame based on temporal variation of content
// complexity.
type H264TemporalAdaptiveQuantization string

// Enum values for H264TemporalAdaptiveQuantization
const (
	H264TemporalAdaptiveQuantizationDisabled H264TemporalAdaptiveQuantization = "DISABLED"
	H264TemporalAdaptiveQuantizationEnabled  H264TemporalAdaptiveQuantization = "ENABLED"
)

func (enum H264TemporalAdaptiveQuantization) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum H264TemporalAdaptiveQuantization) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Inserts timecode for each frame as 4 bytes of an unregistered SEI message.
type H264UnregisteredSeiTimecode string

// Enum values for H264UnregisteredSeiTimecode
const (
	H264UnregisteredSeiTimecodeDisabled H264UnregisteredSeiTimecode = "DISABLED"
	H264UnregisteredSeiTimecodeEnabled  H264UnregisteredSeiTimecode = "ENABLED"
)

func (enum H264UnregisteredSeiTimecode) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum H264UnregisteredSeiTimecode) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Adaptive quantization. Allows intra-frame quantizers to vary to improve visual
// quality.
type H265AdaptiveQuantization string

// Enum values for H265AdaptiveQuantization
const (
	H265AdaptiveQuantizationOff    H265AdaptiveQuantization = "OFF"
	H265AdaptiveQuantizationLow    H265AdaptiveQuantization = "LOW"
	H265AdaptiveQuantizationMedium H265AdaptiveQuantization = "MEDIUM"
	H265AdaptiveQuantizationHigh   H265AdaptiveQuantization = "HIGH"
	H265AdaptiveQuantizationHigher H265AdaptiveQuantization = "HIGHER"
	H265AdaptiveQuantizationMax    H265AdaptiveQuantization = "MAX"
)

func (enum H265AdaptiveQuantization) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum H265AdaptiveQuantization) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Enables Alternate Transfer Function SEI message for outputs using Hybrid
// Log Gamma (HLG) Electro-Optical Transfer Function (EOTF).
type H265AlternateTransferFunctionSei string

// Enum values for H265AlternateTransferFunctionSei
const (
	H265AlternateTransferFunctionSeiDisabled H265AlternateTransferFunctionSei = "DISABLED"
	H265AlternateTransferFunctionSeiEnabled  H265AlternateTransferFunctionSei = "ENABLED"
)

func (enum H265AlternateTransferFunctionSei) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum H265AlternateTransferFunctionSei) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// H.265 Level.
type H265CodecLevel string

// Enum values for H265CodecLevel
const (
	H265CodecLevelAuto    H265CodecLevel = "AUTO"
	H265CodecLevelLevel1  H265CodecLevel = "LEVEL_1"
	H265CodecLevelLevel2  H265CodecLevel = "LEVEL_2"
	H265CodecLevelLevel21 H265CodecLevel = "LEVEL_2_1"
	H265CodecLevelLevel3  H265CodecLevel = "LEVEL_3"
	H265CodecLevelLevel31 H265CodecLevel = "LEVEL_3_1"
	H265CodecLevelLevel4  H265CodecLevel = "LEVEL_4"
	H265CodecLevelLevel41 H265CodecLevel = "LEVEL_4_1"
	H265CodecLevelLevel5  H265CodecLevel = "LEVEL_5"
	H265CodecLevelLevel51 H265CodecLevel = "LEVEL_5_1"
	H265CodecLevelLevel52 H265CodecLevel = "LEVEL_5_2"
	H265CodecLevelLevel6  H265CodecLevel = "LEVEL_6"
	H265CodecLevelLevel61 H265CodecLevel = "LEVEL_6_1"
	H265CodecLevelLevel62 H265CodecLevel = "LEVEL_6_2"
)

func (enum H265CodecLevel) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum H265CodecLevel) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Represents the Profile and Tier, per the HEVC (H.265) specification. Selections
// are grouped as [Profile] / [Tier], so "Main/High" represents Main Profile
// with High Tier. 4:2:2 profiles are only available with the HEVC 4:2:2 License.
type H265CodecProfile string

// Enum values for H265CodecProfile
const (
	H265CodecProfileMainMain         H265CodecProfile = "MAIN_MAIN"
	H265CodecProfileMainHigh         H265CodecProfile = "MAIN_HIGH"
	H265CodecProfileMain10Main       H265CodecProfile = "MAIN10_MAIN"
	H265CodecProfileMain10High       H265CodecProfile = "MAIN10_HIGH"
	H265CodecProfileMain4228bitMain  H265CodecProfile = "MAIN_422_8BIT_MAIN"
	H265CodecProfileMain4228bitHigh  H265CodecProfile = "MAIN_422_8BIT_HIGH"
	H265CodecProfileMain42210bitMain H265CodecProfile = "MAIN_422_10BIT_MAIN"
	H265CodecProfileMain42210bitHigh H265CodecProfile = "MAIN_422_10BIT_HIGH"
)

func (enum H265CodecProfile) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum H265CodecProfile) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Choose Adaptive to improve subjective video quality for high-motion content.
// This will cause the service to use fewer B-frames (which infer information
// based on other frames) for high-motion portions of the video and more B-frames
// for low-motion portions. The maximum number of B-frames is limited by the
// value you provide for the setting B frames between reference frames (numberBFramesBetweenReferenceFrames).
type H265DynamicSubGop string

// Enum values for H265DynamicSubGop
const (
	H265DynamicSubGopAdaptive H265DynamicSubGop = "ADAPTIVE"
	H265DynamicSubGopStatic   H265DynamicSubGop = "STATIC"
)

func (enum H265DynamicSubGop) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum H265DynamicSubGop) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Adjust quantization within each frame to reduce flicker or 'pop' on I-frames.
type H265FlickerAdaptiveQuantization string

// Enum values for H265FlickerAdaptiveQuantization
const (
	H265FlickerAdaptiveQuantizationDisabled H265FlickerAdaptiveQuantization = "DISABLED"
	H265FlickerAdaptiveQuantizationEnabled  H265FlickerAdaptiveQuantization = "ENABLED"
)

func (enum H265FlickerAdaptiveQuantization) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum H265FlickerAdaptiveQuantization) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// If you are using the console, use the Framerate setting to specify the frame
// rate for this output. If you want to keep the same frame rate as the input
// video, choose Follow source. If you want to do frame rate conversion, choose
// a frame rate from the dropdown list or choose Custom. The framerates shown
// in the dropdown list are decimal approximations of fractions. If you choose
// Custom, specify your frame rate as a fraction. If you are creating your transcoding
// job specification as a JSON file without the console, use FramerateControl
// to specify which value the service uses for the frame rate for this output.
// Choose INITIALIZE_FROM_SOURCE if you want the service to use the frame rate
// from the input. Choose SPECIFIED if you want the service to use the frame
// rate you specify in the settings FramerateNumerator and FramerateDenominator.
type H265FramerateControl string

// Enum values for H265FramerateControl
const (
	H265FramerateControlInitializeFromSource H265FramerateControl = "INITIALIZE_FROM_SOURCE"
	H265FramerateControlSpecified            H265FramerateControl = "SPECIFIED"
)

func (enum H265FramerateControl) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum H265FramerateControl) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Optional. Specify how the transcoder performs framerate conversion. The default
// behavior is to use duplicate drop conversion.
type H265FramerateConversionAlgorithm string

// Enum values for H265FramerateConversionAlgorithm
const (
	H265FramerateConversionAlgorithmDuplicateDrop H265FramerateConversionAlgorithm = "DUPLICATE_DROP"
	H265FramerateConversionAlgorithmInterpolate   H265FramerateConversionAlgorithm = "INTERPOLATE"
)

func (enum H265FramerateConversionAlgorithm) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum H265FramerateConversionAlgorithm) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// If enable, use reference B frames for GOP structures that have B frames >
// 1.
type H265GopBReference string

// Enum values for H265GopBReference
const (
	H265GopBReferenceDisabled H265GopBReference = "DISABLED"
	H265GopBReferenceEnabled  H265GopBReference = "ENABLED"
)

func (enum H265GopBReference) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum H265GopBReference) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Indicates if the GOP Size in H265 is specified in frames or seconds. If seconds
// the system will convert the GOP Size into a frame count at run time.
type H265GopSizeUnits string

// Enum values for H265GopSizeUnits
const (
	H265GopSizeUnitsFrames  H265GopSizeUnits = "FRAMES"
	H265GopSizeUnitsSeconds H265GopSizeUnits = "SECONDS"
)

func (enum H265GopSizeUnits) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum H265GopSizeUnits) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Choose the scan line type for the output. Choose Progressive (PROGRESSIVE)
// to create a progressive output, regardless of the scan type of your input.
// Choose Top Field First (TOP_FIELD) or Bottom Field First (BOTTOM_FIELD) to
// create an output that's interlaced with the same field polarity throughout.
// Choose Follow, Default Top (FOLLOW_TOP_FIELD) or Follow, Default Bottom (FOLLOW_BOTTOM_FIELD)
// to create an interlaced output with the same field polarity as the source.
// If the source is interlaced, the output will be interlaced with the same
// polarity as the source (it will follow the source). The output could therefore
// be a mix of "top field first" and "bottom field first". If the source is
// progressive, your output will be interlaced with "top field first" or "bottom
// field first" polarity, depending on which of the Follow options you chose.
// If you don't choose a value, the service will default to Progressive (PROGRESSIVE).
type H265InterlaceMode string

// Enum values for H265InterlaceMode
const (
	H265InterlaceModeProgressive       H265InterlaceMode = "PROGRESSIVE"
	H265InterlaceModeTopField          H265InterlaceMode = "TOP_FIELD"
	H265InterlaceModeBottomField       H265InterlaceMode = "BOTTOM_FIELD"
	H265InterlaceModeFollowTopField    H265InterlaceMode = "FOLLOW_TOP_FIELD"
	H265InterlaceModeFollowBottomField H265InterlaceMode = "FOLLOW_BOTTOM_FIELD"
)

func (enum H265InterlaceMode) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum H265InterlaceMode) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Optional. Specify how the service determines the pixel aspect ratio (PAR)
// for this output. The default behavior, Follow source (INITIALIZE_FROM_SOURCE),
// uses the PAR from your input video for your output. To specify a different
// PAR in the console, choose any value other than Follow source. To specify
// a different PAR by editing the JSON job specification, choose SPECIFIED.
// When you choose SPECIFIED for this setting, you must also specify values
// for the parNumerator and parDenominator settings.
type H265ParControl string

// Enum values for H265ParControl
const (
	H265ParControlInitializeFromSource H265ParControl = "INITIALIZE_FROM_SOURCE"
	H265ParControlSpecified            H265ParControl = "SPECIFIED"
)

func (enum H265ParControl) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum H265ParControl) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Optional. Use Quality tuning level (qualityTuningLevel) to choose how you
// want to trade off encoding speed for output video quality. The default behavior
// is faster, lower quality, single-pass encoding.
type H265QualityTuningLevel string

// Enum values for H265QualityTuningLevel
const (
	H265QualityTuningLevelSinglePass   H265QualityTuningLevel = "SINGLE_PASS"
	H265QualityTuningLevelSinglePassHq H265QualityTuningLevel = "SINGLE_PASS_HQ"
	H265QualityTuningLevelMultiPassHq  H265QualityTuningLevel = "MULTI_PASS_HQ"
)

func (enum H265QualityTuningLevel) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum H265QualityTuningLevel) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Use this setting to specify whether this output has a variable bitrate (VBR),
// constant bitrate (CBR) or quality-defined variable bitrate (QVBR).
type H265RateControlMode string

// Enum values for H265RateControlMode
const (
	H265RateControlModeVbr  H265RateControlMode = "VBR"
	H265RateControlModeCbr  H265RateControlMode = "CBR"
	H265RateControlModeQvbr H265RateControlMode = "QVBR"
)

func (enum H265RateControlMode) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum H265RateControlMode) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Specify Sample Adaptive Offset (SAO) filter strength. Adaptive mode dynamically
// selects best strength based on content
type H265SampleAdaptiveOffsetFilterMode string

// Enum values for H265SampleAdaptiveOffsetFilterMode
const (
	H265SampleAdaptiveOffsetFilterModeDefault  H265SampleAdaptiveOffsetFilterMode = "DEFAULT"
	H265SampleAdaptiveOffsetFilterModeAdaptive H265SampleAdaptiveOffsetFilterMode = "ADAPTIVE"
	H265SampleAdaptiveOffsetFilterModeOff      H265SampleAdaptiveOffsetFilterMode = "OFF"
)

func (enum H265SampleAdaptiveOffsetFilterMode) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum H265SampleAdaptiveOffsetFilterMode) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Enable this setting to insert I-frames at scene changes that the service
// automatically detects. This improves video quality and is enabled by default.
// If this output uses QVBR, choose Transition detection (TRANSITION_DETECTION)
// for further video quality improvement. For more information about QVBR, see
// https://docs.aws.amazon.com/console/mediaconvert/cbr-vbr-qvbr.
type H265SceneChangeDetect string

// Enum values for H265SceneChangeDetect
const (
	H265SceneChangeDetectDisabled            H265SceneChangeDetect = "DISABLED"
	H265SceneChangeDetectEnabled             H265SceneChangeDetect = "ENABLED"
	H265SceneChangeDetectTransitionDetection H265SceneChangeDetect = "TRANSITION_DETECTION"
)

func (enum H265SceneChangeDetect) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum H265SceneChangeDetect) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Enables Slow PAL rate conversion. 23.976fps and 24fps input is relabeled
// as 25fps, and audio is sped up correspondingly.
type H265SlowPal string

// Enum values for H265SlowPal
const (
	H265SlowPalDisabled H265SlowPal = "DISABLED"
	H265SlowPalEnabled  H265SlowPal = "ENABLED"
)

func (enum H265SlowPal) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum H265SlowPal) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Adjust quantization within each frame based on spatial variation of content
// complexity.
type H265SpatialAdaptiveQuantization string

// Enum values for H265SpatialAdaptiveQuantization
const (
	H265SpatialAdaptiveQuantizationDisabled H265SpatialAdaptiveQuantization = "DISABLED"
	H265SpatialAdaptiveQuantizationEnabled  H265SpatialAdaptiveQuantization = "ENABLED"
)

func (enum H265SpatialAdaptiveQuantization) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum H265SpatialAdaptiveQuantization) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// This field applies only if the Streams > Advanced > Framerate (framerate)
// field is set to 29.970. This field works with the Streams > Advanced > Preprocessors
// > Deinterlacer field (deinterlace_mode) and the Streams > Advanced > Interlaced
// Mode field (interlace_mode) to identify the scan type for the output: Progressive,
// Interlaced, Hard Telecine or Soft Telecine. - Hard: produces 29.97i output
// from 23.976 input. - Soft: produces 23.976; the player converts this output
// to 29.97i.
type H265Telecine string

// Enum values for H265Telecine
const (
	H265TelecineNone H265Telecine = "NONE"
	H265TelecineSoft H265Telecine = "SOFT"
	H265TelecineHard H265Telecine = "HARD"
)

func (enum H265Telecine) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum H265Telecine) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Adjust quantization within each frame based on temporal variation of content
// complexity.
type H265TemporalAdaptiveQuantization string

// Enum values for H265TemporalAdaptiveQuantization
const (
	H265TemporalAdaptiveQuantizationDisabled H265TemporalAdaptiveQuantization = "DISABLED"
	H265TemporalAdaptiveQuantizationEnabled  H265TemporalAdaptiveQuantization = "ENABLED"
)

func (enum H265TemporalAdaptiveQuantization) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum H265TemporalAdaptiveQuantization) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Enables temporal layer identifiers in the encoded bitstream. Up to 3 layers
// are supported depending on GOP structure: I- and P-frames form one layer,
// reference B-frames can form a second layer and non-reference b-frames can
// form a third layer. Decoders can optionally decode only the lower temporal
// layers to generate a lower frame rate output. For example, given a bitstream
// with temporal IDs and with b-frames = 1 (i.e. IbPbPb display order), a decoder
// could decode all the frames for full frame rate output or only the I and
// P frames (lowest temporal layer) for a half frame rate output.
type H265TemporalIds string

// Enum values for H265TemporalIds
const (
	H265TemporalIdsDisabled H265TemporalIds = "DISABLED"
	H265TemporalIdsEnabled  H265TemporalIds = "ENABLED"
)

func (enum H265TemporalIds) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum H265TemporalIds) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Enable use of tiles, allowing horizontal as well as vertical subdivision
// of the encoded pictures.
type H265Tiles string

// Enum values for H265Tiles
const (
	H265TilesDisabled H265Tiles = "DISABLED"
	H265TilesEnabled  H265Tiles = "ENABLED"
)

func (enum H265Tiles) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum H265Tiles) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Inserts timecode for each frame as 4 bytes of an unregistered SEI message.
type H265UnregisteredSeiTimecode string

// Enum values for H265UnregisteredSeiTimecode
const (
	H265UnregisteredSeiTimecodeDisabled H265UnregisteredSeiTimecode = "DISABLED"
	H265UnregisteredSeiTimecodeEnabled  H265UnregisteredSeiTimecode = "ENABLED"
)

func (enum H265UnregisteredSeiTimecode) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum H265UnregisteredSeiTimecode) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// If the location of parameter set NAL units doesn't matter in your workflow,
// ignore this setting. Use this setting only with CMAF or DASH outputs, or
// with standalone file outputs in an MPEG-4 container (MP4 outputs). Choose
// HVC1 to mark your output as HVC1. This makes your output compliant with the
// following specification: ISO IECJTC1 SC29 N13798 Text ISO/IEC FDIS 14496-15
// 3rd Edition. For these outputs, the service stores parameter set NAL units
// in the sample headers but not in the samples directly. For MP4 outputs, when
// you choose HVC1, your output video might not work properly with some downstream
// systems and video players. The service defaults to marking your output as
// HEV1. For these outputs, the service writes parameter set NAL units directly
// into the samples.
type H265WriteMp4PackagingType string

// Enum values for H265WriteMp4PackagingType
const (
	H265WriteMp4PackagingTypeHvc1 H265WriteMp4PackagingType = "HVC1"
	H265WriteMp4PackagingTypeHev1 H265WriteMp4PackagingType = "HEV1"
)

func (enum H265WriteMp4PackagingType) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum H265WriteMp4PackagingType) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

type HlsAdMarkers string

// Enum values for HlsAdMarkers
const (
	HlsAdMarkersElemental       HlsAdMarkers = "ELEMENTAL"
	HlsAdMarkersElementalScte35 HlsAdMarkers = "ELEMENTAL_SCTE35"
)

func (enum HlsAdMarkers) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum HlsAdMarkers) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Use this setting only in audio-only outputs. Choose MPEG-2 Transport Stream
// (M2TS) to create a file in an MPEG2-TS container. Keep the default value
// Automatic (AUTOMATIC) to create a raw audio-only file with no container.
// Regardless of the value that you specify here, if this output has video,
// the service will place outputs into an MPEG2-TS container.
type HlsAudioOnlyContainer string

// Enum values for HlsAudioOnlyContainer
const (
	HlsAudioOnlyContainerAutomatic HlsAudioOnlyContainer = "AUTOMATIC"
	HlsAudioOnlyContainerM2ts      HlsAudioOnlyContainer = "M2TS"
)

func (enum HlsAudioOnlyContainer) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum HlsAudioOnlyContainer) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Four types of audio-only tracks are supported: Audio-Only Variant Stream
// The client can play back this audio-only stream instead of video in low-bandwidth
// scenarios. Represented as an EXT-X-STREAM-INF in the HLS manifest. Alternate
// Audio, Auto Select, Default Alternate rendition that the client should try
// to play back by default. Represented as an EXT-X-MEDIA in the HLS manifest
// with DEFAULT=YES, AUTOSELECT=YES Alternate Audio, Auto Select, Not Default
// Alternate rendition that the client may try to play back by default. Represented
// as an EXT-X-MEDIA in the HLS manifest with DEFAULT=NO, AUTOSELECT=YES Alternate
// Audio, not Auto Select Alternate rendition that the client will not try to
// play back by default. Represented as an EXT-X-MEDIA in the HLS manifest with
// DEFAULT=NO, AUTOSELECT=NO
type HlsAudioTrackType string

// Enum values for HlsAudioTrackType
const (
	HlsAudioTrackTypeAlternateAudioAutoSelectDefault HlsAudioTrackType = "ALTERNATE_AUDIO_AUTO_SELECT_DEFAULT"
	HlsAudioTrackTypeAlternateAudioAutoSelect        HlsAudioTrackType = "ALTERNATE_AUDIO_AUTO_SELECT"
	HlsAudioTrackTypeAlternateAudioNotAutoSelect     HlsAudioTrackType = "ALTERNATE_AUDIO_NOT_AUTO_SELECT"
	HlsAudioTrackTypeAudioOnlyVariantStream          HlsAudioTrackType = "AUDIO_ONLY_VARIANT_STREAM"
)

func (enum HlsAudioTrackType) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum HlsAudioTrackType) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Applies only to 608 Embedded output captions. Insert: Include CLOSED-CAPTIONS
// lines in the manifest. Specify at least one language in the CC1 Language
// Code field. One CLOSED-CAPTION line is added for each Language Code you specify.
// Make sure to specify the languages in the order in which they appear in the
// original source (if the source is embedded format) or the order of the caption
// selectors (if the source is other than embedded). Otherwise, languages in
// the manifest will not match up properly with the output captions. None: Include
// CLOSED-CAPTIONS=NONE line in the manifest. Omit: Omit any CLOSED-CAPTIONS
// line from the manifest.
type HlsCaptionLanguageSetting string

// Enum values for HlsCaptionLanguageSetting
const (
	HlsCaptionLanguageSettingInsert HlsCaptionLanguageSetting = "INSERT"
	HlsCaptionLanguageSettingOmit   HlsCaptionLanguageSetting = "OMIT"
	HlsCaptionLanguageSettingNone   HlsCaptionLanguageSetting = "NONE"
)

func (enum HlsCaptionLanguageSetting) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum HlsCaptionLanguageSetting) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// When set to ENABLED, sets #EXT-X-ALLOW-CACHE:no tag, which prevents client
// from saving media segments for later replay.
type HlsClientCache string

// Enum values for HlsClientCache
const (
	HlsClientCacheDisabled HlsClientCache = "DISABLED"
	HlsClientCacheEnabled  HlsClientCache = "ENABLED"
)

func (enum HlsClientCache) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum HlsClientCache) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Specification to use (RFC-6381 or the default RFC-4281) during m3u8 playlist
// generation.
type HlsCodecSpecification string

// Enum values for HlsCodecSpecification
const (
	HlsCodecSpecificationRfc6381 HlsCodecSpecification = "RFC_6381"
	HlsCodecSpecificationRfc4281 HlsCodecSpecification = "RFC_4281"
)

func (enum HlsCodecSpecification) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum HlsCodecSpecification) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Indicates whether segments should be placed in subdirectories.
type HlsDirectoryStructure string

// Enum values for HlsDirectoryStructure
const (
	HlsDirectoryStructureSingleDirectory       HlsDirectoryStructure = "SINGLE_DIRECTORY"
	HlsDirectoryStructureSubdirectoryPerStream HlsDirectoryStructure = "SUBDIRECTORY_PER_STREAM"
)

func (enum HlsDirectoryStructure) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum HlsDirectoryStructure) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Encrypts the segments with the given encryption scheme. Leave blank to disable.
// Selecting 'Disabled' in the web interface also disables encryption.
type HlsEncryptionType string

// Enum values for HlsEncryptionType
const (
	HlsEncryptionTypeAes128    HlsEncryptionType = "AES128"
	HlsEncryptionTypeSampleAes HlsEncryptionType = "SAMPLE_AES"
)

func (enum HlsEncryptionType) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum HlsEncryptionType) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// When set to INCLUDE, writes I-Frame Only Manifest in addition to the HLS
// manifest
type HlsIFrameOnlyManifest string

// Enum values for HlsIFrameOnlyManifest
const (
	HlsIFrameOnlyManifestInclude HlsIFrameOnlyManifest = "INCLUDE"
	HlsIFrameOnlyManifestExclude HlsIFrameOnlyManifest = "EXCLUDE"
)

func (enum HlsIFrameOnlyManifest) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum HlsIFrameOnlyManifest) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// The Initialization Vector is a 128-bit number used in conjunction with the
// key for encrypting blocks. If set to INCLUDE, Initialization Vector is listed
// in the manifest. Otherwise Initialization Vector is not in the manifest.
type HlsInitializationVectorInManifest string

// Enum values for HlsInitializationVectorInManifest
const (
	HlsInitializationVectorInManifestInclude HlsInitializationVectorInManifest = "INCLUDE"
	HlsInitializationVectorInManifestExclude HlsInitializationVectorInManifest = "EXCLUDE"
)

func (enum HlsInitializationVectorInManifest) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum HlsInitializationVectorInManifest) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Specify whether your DRM encryption key is static or from a key provider
// that follows the SPEKE standard. For more information about SPEKE, see https://docs.aws.amazon.com/speke/latest/documentation/what-is-speke.html.
type HlsKeyProviderType string

// Enum values for HlsKeyProviderType
const (
	HlsKeyProviderTypeSpeke     HlsKeyProviderType = "SPEKE"
	HlsKeyProviderTypeStaticKey HlsKeyProviderType = "STATIC_KEY"
)

func (enum HlsKeyProviderType) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum HlsKeyProviderType) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// When set to GZIP, compresses HLS playlist.
type HlsManifestCompression string

// Enum values for HlsManifestCompression
const (
	HlsManifestCompressionGzip HlsManifestCompression = "GZIP"
	HlsManifestCompressionNone HlsManifestCompression = "NONE"
)

func (enum HlsManifestCompression) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum HlsManifestCompression) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Indicates whether the output manifest should use floating point values for
// segment duration.
type HlsManifestDurationFormat string

// Enum values for HlsManifestDurationFormat
const (
	HlsManifestDurationFormatFloatingPoint HlsManifestDurationFormat = "FLOATING_POINT"
	HlsManifestDurationFormatInteger       HlsManifestDurationFormat = "INTEGER"
)

func (enum HlsManifestDurationFormat) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum HlsManifestDurationFormat) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Enable this setting to insert the EXT-X-SESSION-KEY element into the master
// playlist. This allows for offline Apple HLS FairPlay content protection.
type HlsOfflineEncrypted string

// Enum values for HlsOfflineEncrypted
const (
	HlsOfflineEncryptedEnabled  HlsOfflineEncrypted = "ENABLED"
	HlsOfflineEncryptedDisabled HlsOfflineEncrypted = "DISABLED"
)

func (enum HlsOfflineEncrypted) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum HlsOfflineEncrypted) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Indicates whether the .m3u8 manifest file should be generated for this HLS
// output group.
type HlsOutputSelection string

// Enum values for HlsOutputSelection
const (
	HlsOutputSelectionManifestsAndSegments HlsOutputSelection = "MANIFESTS_AND_SEGMENTS"
	HlsOutputSelectionSegmentsOnly         HlsOutputSelection = "SEGMENTS_ONLY"
)

func (enum HlsOutputSelection) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum HlsOutputSelection) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Includes or excludes EXT-X-PROGRAM-DATE-TIME tag in .m3u8 manifest files.
// The value is calculated as follows: either the program date and time are
// initialized using the input timecode source, or the time is initialized using
// the input timecode source and the date is initialized using the timestamp_offset.
type HlsProgramDateTime string

// Enum values for HlsProgramDateTime
const (
	HlsProgramDateTimeInclude HlsProgramDateTime = "INCLUDE"
	HlsProgramDateTimeExclude HlsProgramDateTime = "EXCLUDE"
)

func (enum HlsProgramDateTime) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum HlsProgramDateTime) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// When set to SINGLE_FILE, emits program as a single media resource (.ts) file,
// uses #EXT-X-BYTERANGE tags to index segment for playback.
type HlsSegmentControl string

// Enum values for HlsSegmentControl
const (
	HlsSegmentControlSingleFile     HlsSegmentControl = "SINGLE_FILE"
	HlsSegmentControlSegmentedFiles HlsSegmentControl = "SEGMENTED_FILES"
)

func (enum HlsSegmentControl) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum HlsSegmentControl) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Include or exclude RESOLUTION attribute for video in EXT-X-STREAM-INF tag
// of variant manifest.
type HlsStreamInfResolution string

// Enum values for HlsStreamInfResolution
const (
	HlsStreamInfResolutionInclude HlsStreamInfResolution = "INCLUDE"
	HlsStreamInfResolutionExclude HlsStreamInfResolution = "EXCLUDE"
)

func (enum HlsStreamInfResolution) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum HlsStreamInfResolution) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Indicates ID3 frame that has the timecode.
type HlsTimedMetadataId3Frame string

// Enum values for HlsTimedMetadataId3Frame
const (
	HlsTimedMetadataId3FrameNone HlsTimedMetadataId3Frame = "NONE"
	HlsTimedMetadataId3FramePriv HlsTimedMetadataId3Frame = "PRIV"
	HlsTimedMetadataId3FrameTdrl HlsTimedMetadataId3Frame = "TDRL"
)

func (enum HlsTimedMetadataId3Frame) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum HlsTimedMetadataId3Frame) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Keep this setting enabled to have MediaConvert use the font style and position
// information from the captions source in the output. This option is available
// only when your input captions are IMSC, SMPTE-TT, or TTML. Disable this setting
// for simplified output captions.
type ImscStylePassthrough string

// Enum values for ImscStylePassthrough
const (
	ImscStylePassthroughEnabled  ImscStylePassthrough = "ENABLED"
	ImscStylePassthroughDisabled ImscStylePassthrough = "DISABLED"
)

func (enum ImscStylePassthrough) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum ImscStylePassthrough) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Enable Deblock (InputDeblockFilter) to produce smoother motion in the output.
// Default is disabled. Only manually controllable for MPEG2 and uncompressed
// video inputs.
type InputDeblockFilter string

// Enum values for InputDeblockFilter
const (
	InputDeblockFilterEnabled  InputDeblockFilter = "ENABLED"
	InputDeblockFilterDisabled InputDeblockFilter = "DISABLED"
)

func (enum InputDeblockFilter) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum InputDeblockFilter) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Enable Denoise (InputDenoiseFilter) to filter noise from the input. Default
// is disabled. Only applicable to MPEG2, H.264, H.265, and uncompressed video
// inputs.
type InputDenoiseFilter string

// Enum values for InputDenoiseFilter
const (
	InputDenoiseFilterEnabled  InputDenoiseFilter = "ENABLED"
	InputDenoiseFilterDisabled InputDenoiseFilter = "DISABLED"
)

func (enum InputDenoiseFilter) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum InputDenoiseFilter) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Use Filter enable (InputFilterEnable) to specify how the transcoding service
// applies the denoise and deblock filters. You must also enable the filters
// separately, with Denoise (InputDenoiseFilter) and Deblock (InputDeblockFilter).
// * Auto - The transcoding service determines whether to apply filtering, depending
// on input type and quality. * Disable - The input is not filtered. This is
// true even if you use the API to enable them in (InputDeblockFilter) and (InputDeblockFilter).
// * Force - The in put is filtered regardless of input type.
type InputFilterEnable string

// Enum values for InputFilterEnable
const (
	InputFilterEnableAuto    InputFilterEnable = "AUTO"
	InputFilterEnableDisable InputFilterEnable = "DISABLE"
	InputFilterEnableForce   InputFilterEnable = "FORCE"
)

func (enum InputFilterEnable) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum InputFilterEnable) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Set PSI control (InputPsiControl) for transport stream inputs to specify
// which data the demux process to scans. * Ignore PSI - Scan all PIDs for audio
// and video. * Use PSI - Scan only PSI data.
type InputPsiControl string

// Enum values for InputPsiControl
const (
	InputPsiControlIgnorePsi InputPsiControl = "IGNORE_PSI"
	InputPsiControlUsePsi    InputPsiControl = "USE_PSI"
)

func (enum InputPsiControl) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum InputPsiControl) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Use Rotate (InputRotate) to specify how the service rotates your video. You
// can choose automatic rotation or specify a rotation. You can specify a clockwise
// rotation of 0, 90, 180, or 270 degrees. If your input video container is
// .mov or .mp4 and your input has rotation metadata, you can choose Automatic
// to have the service rotate your video according to the rotation specified
// in the metadata. The rotation must be within one degree of 90, 180, or 270
// degrees. If the rotation metadata specifies any other rotation, the service
// will default to no rotation. By default, the service does no rotation, even
// if your input video has rotation metadata. The service doesn't pass through
// rotation metadata.
type InputRotate string

// Enum values for InputRotate
const (
	InputRotateDegree0    InputRotate = "DEGREE_0"
	InputRotateDegrees90  InputRotate = "DEGREES_90"
	InputRotateDegrees180 InputRotate = "DEGREES_180"
	InputRotateDegrees270 InputRotate = "DEGREES_270"
	InputRotateAuto       InputRotate = "AUTO"
)

func (enum InputRotate) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum InputRotate) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Use this Timecode source setting, located under the input settings (InputTimecodeSource),
// to specify how the service counts input video frames. This input frame count
// affects only the behavior of features that apply to a single input at a time,
// such as input clipping and synchronizing some captions formats. Choose Embedded
// (EMBEDDED) to use the timecodes in your input video. Choose Start at zero
// (ZEROBASED) to start the first frame at zero. Choose Specified start (SPECIFIEDSTART)
// to start the first frame at the timecode that you specify in the setting
// Start timecode (timecodeStart). If you don't specify a value for Timecode
// source, the service will use Embedded by default. For more information about
// timecodes, see https://docs.aws.amazon.com/console/mediaconvert/timecode.
type InputTimecodeSource string

// Enum values for InputTimecodeSource
const (
	InputTimecodeSourceEmbedded       InputTimecodeSource = "EMBEDDED"
	InputTimecodeSourceZerobased      InputTimecodeSource = "ZEROBASED"
	InputTimecodeSourceSpecifiedstart InputTimecodeSource = "SPECIFIEDSTART"
)

func (enum InputTimecodeSource) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum InputTimecodeSource) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// A job's phase can be PROBING, TRANSCODING OR UPLOADING
type JobPhase string

// Enum values for JobPhase
const (
	JobPhaseProbing     JobPhase = "PROBING"
	JobPhaseTranscoding JobPhase = "TRANSCODING"
	JobPhaseUploading   JobPhase = "UPLOADING"
)

func (enum JobPhase) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum JobPhase) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// A job's status can be SUBMITTED, PROGRESSING, COMPLETE, CANCELED, or ERROR.
type JobStatus string

// Enum values for JobStatus
const (
	JobStatusSubmitted   JobStatus = "SUBMITTED"
	JobStatusProgressing JobStatus = "PROGRESSING"
	JobStatusComplete    JobStatus = "COMPLETE"
	JobStatusCanceled    JobStatus = "CANCELED"
	JobStatusError       JobStatus = "ERROR"
)

func (enum JobStatus) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum JobStatus) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Optional. When you request a list of job templates, you can choose to list
// them alphabetically by NAME or chronologically by CREATION_DATE. If you don't
// specify, the service will list them by name.
type JobTemplateListBy string

// Enum values for JobTemplateListBy
const (
	JobTemplateListByName         JobTemplateListBy = "NAME"
	JobTemplateListByCreationDate JobTemplateListBy = "CREATION_DATE"
	JobTemplateListBySystem       JobTemplateListBy = "SYSTEM"
)

func (enum JobTemplateListBy) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum JobTemplateListBy) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Specify the language, using the ISO 639-2 three-letter code listed at https://www.loc.gov/standards/iso639-2/php/code_list.php.
type LanguageCode string

// Enum values for LanguageCode
const (
	LanguageCodeEng LanguageCode = "ENG"
	LanguageCodeSpa LanguageCode = "SPA"
	LanguageCodeFra LanguageCode = "FRA"
	LanguageCodeDeu LanguageCode = "DEU"
	LanguageCodeGer LanguageCode = "GER"
	LanguageCodeZho LanguageCode = "ZHO"
	LanguageCodeAra LanguageCode = "ARA"
	LanguageCodeHin LanguageCode = "HIN"
	LanguageCodeJpn LanguageCode = "JPN"
	LanguageCodeRus LanguageCode = "RUS"
	LanguageCodePor LanguageCode = "POR"
	LanguageCodeIta LanguageCode = "ITA"
	LanguageCodeUrd LanguageCode = "URD"
	LanguageCodeVie LanguageCode = "VIE"
	LanguageCodeKor LanguageCode = "KOR"
	LanguageCodePan LanguageCode = "PAN"
	LanguageCodeAbk LanguageCode = "ABK"
	LanguageCodeAar LanguageCode = "AAR"
	LanguageCodeAfr LanguageCode = "AFR"
	LanguageCodeAka LanguageCode = "AKA"
	LanguageCodeSqi LanguageCode = "SQI"
	LanguageCodeAmh LanguageCode = "AMH"
	LanguageCodeArg LanguageCode = "ARG"
	LanguageCodeHye LanguageCode = "HYE"
	LanguageCodeAsm LanguageCode = "ASM"
	LanguageCodeAva LanguageCode = "AVA"
	LanguageCodeAve LanguageCode = "AVE"
	LanguageCodeAym LanguageCode = "AYM"
	LanguageCodeAze LanguageCode = "AZE"
	LanguageCodeBam LanguageCode = "BAM"
	LanguageCodeBak LanguageCode = "BAK"
	LanguageCodeEus LanguageCode = "EUS"
	LanguageCodeBel LanguageCode = "BEL"
	LanguageCodeBen LanguageCode = "BEN"
	LanguageCodeBih LanguageCode = "BIH"
	LanguageCodeBis LanguageCode = "BIS"
	LanguageCodeBos LanguageCode = "BOS"
	LanguageCodeBre LanguageCode = "BRE"
	LanguageCodeBul LanguageCode = "BUL"
	LanguageCodeMya LanguageCode = "MYA"
	LanguageCodeCat LanguageCode = "CAT"
	LanguageCodeKhm LanguageCode = "KHM"
	LanguageCodeCha LanguageCode = "CHA"
	LanguageCodeChe LanguageCode = "CHE"
	LanguageCodeNya LanguageCode = "NYA"
	LanguageCodeChu LanguageCode = "CHU"
	LanguageCodeChv LanguageCode = "CHV"
	LanguageCodeCor LanguageCode = "COR"
	LanguageCodeCos LanguageCode = "COS"
	LanguageCodeCre LanguageCode = "CRE"
	LanguageCodeHrv LanguageCode = "HRV"
	LanguageCodeCes LanguageCode = "CES"
	LanguageCodeDan LanguageCode = "DAN"
	LanguageCodeDiv LanguageCode = "DIV"
	LanguageCodeNld LanguageCode = "NLD"
	LanguageCodeDzo LanguageCode = "DZO"
	LanguageCodeEnm LanguageCode = "ENM"
	LanguageCodeEpo LanguageCode = "EPO"
	LanguageCodeEst LanguageCode = "EST"
	LanguageCodeEwe LanguageCode = "EWE"
	LanguageCodeFao LanguageCode = "FAO"
	LanguageCodeFij LanguageCode = "FIJ"
	LanguageCodeFin LanguageCode = "FIN"
	LanguageCodeFrm LanguageCode = "FRM"
	LanguageCodeFul LanguageCode = "FUL"
	LanguageCodeGla LanguageCode = "GLA"
	LanguageCodeGlg LanguageCode = "GLG"
	LanguageCodeLug LanguageCode = "LUG"
	LanguageCodeKat LanguageCode = "KAT"
	LanguageCodeEll LanguageCode = "ELL"
	LanguageCodeGrn LanguageCode = "GRN"
	LanguageCodeGuj LanguageCode = "GUJ"
	LanguageCodeHat LanguageCode = "HAT"
	LanguageCodeHau LanguageCode = "HAU"
	LanguageCodeHeb LanguageCode = "HEB"
	LanguageCodeHer LanguageCode = "HER"
	LanguageCodeHmo LanguageCode = "HMO"
	LanguageCodeHun LanguageCode = "HUN"
	LanguageCodeIsl LanguageCode = "ISL"
	LanguageCodeIdo LanguageCode = "IDO"
	LanguageCodeIbo LanguageCode = "IBO"
	LanguageCodeInd LanguageCode = "IND"
	LanguageCodeIna LanguageCode = "INA"
	LanguageCodeIle LanguageCode = "ILE"
	LanguageCodeIku LanguageCode = "IKU"
	LanguageCodeIpk LanguageCode = "IPK"
	LanguageCodeGle LanguageCode = "GLE"
	LanguageCodeJav LanguageCode = "JAV"
	LanguageCodeKal LanguageCode = "KAL"
	LanguageCodeKan LanguageCode = "KAN"
	LanguageCodeKau LanguageCode = "KAU"
	LanguageCodeKas LanguageCode = "KAS"
	LanguageCodeKaz LanguageCode = "KAZ"
	LanguageCodeKik LanguageCode = "KIK"
	LanguageCodeKin LanguageCode = "KIN"
	LanguageCodeKir LanguageCode = "KIR"
	LanguageCodeKom LanguageCode = "KOM"
	LanguageCodeKon LanguageCode = "KON"
	LanguageCodeKua LanguageCode = "KUA"
	LanguageCodeKur LanguageCode = "KUR"
	LanguageCodeLao LanguageCode = "LAO"
	LanguageCodeLat LanguageCode = "LAT"
	LanguageCodeLav LanguageCode = "LAV"
	LanguageCodeLim LanguageCode = "LIM"
	LanguageCodeLin LanguageCode = "LIN"
	LanguageCodeLit LanguageCode = "LIT"
	LanguageCodeLub LanguageCode = "LUB"
	LanguageCodeLtz LanguageCode = "LTZ"
	LanguageCodeMkd LanguageCode = "MKD"
	LanguageCodeMlg LanguageCode = "MLG"
	LanguageCodeMsa LanguageCode = "MSA"
	LanguageCodeMal LanguageCode = "MAL"
	LanguageCodeMlt LanguageCode = "MLT"
	LanguageCodeGlv LanguageCode = "GLV"
	LanguageCodeMri LanguageCode = "MRI"
	LanguageCodeMar LanguageCode = "MAR"
	LanguageCodeMah LanguageCode = "MAH"
	LanguageCodeMon LanguageCode = "MON"
	LanguageCodeNau LanguageCode = "NAU"
	LanguageCodeNav LanguageCode = "NAV"
	LanguageCodeNde LanguageCode = "NDE"
	LanguageCodeNbl LanguageCode = "NBL"
	LanguageCodeNdo LanguageCode = "NDO"
	LanguageCodeNep LanguageCode = "NEP"
	LanguageCodeSme LanguageCode = "SME"
	LanguageCodeNor LanguageCode = "NOR"
	LanguageCodeNob LanguageCode = "NOB"
	LanguageCodeNno LanguageCode = "NNO"
	LanguageCodeOci LanguageCode = "OCI"
	LanguageCodeOji LanguageCode = "OJI"
	LanguageCodeOri LanguageCode = "ORI"
	LanguageCodeOrm LanguageCode = "ORM"
	LanguageCodeOss LanguageCode = "OSS"
	LanguageCodePli LanguageCode = "PLI"
	LanguageCodeFas LanguageCode = "FAS"
	LanguageCodePol LanguageCode = "POL"
	LanguageCodePus LanguageCode = "PUS"
	LanguageCodeQue LanguageCode = "QUE"
	LanguageCodeQaa LanguageCode = "QAA"
	LanguageCodeRon LanguageCode = "RON"
	LanguageCodeRoh LanguageCode = "ROH"
	LanguageCodeRun LanguageCode = "RUN"
	LanguageCodeSmo LanguageCode = "SMO"
	LanguageCodeSag LanguageCode = "SAG"
	LanguageCodeSan LanguageCode = "SAN"
	LanguageCodeSrd LanguageCode = "SRD"
	LanguageCodeSrb LanguageCode = "SRB"
	LanguageCodeSna LanguageCode = "SNA"
	LanguageCodeIii LanguageCode = "III"
	LanguageCodeSnd LanguageCode = "SND"
	LanguageCodeSin LanguageCode = "SIN"
	LanguageCodeSlk LanguageCode = "SLK"
	LanguageCodeSlv LanguageCode = "SLV"
	LanguageCodeSom LanguageCode = "SOM"
	LanguageCodeSot LanguageCode = "SOT"
	LanguageCodeSun LanguageCode = "SUN"
	LanguageCodeSwa LanguageCode = "SWA"
	LanguageCodeSsw LanguageCode = "SSW"
	LanguageCodeSwe LanguageCode = "SWE"
	LanguageCodeTgl LanguageCode = "TGL"
	LanguageCodeTah LanguageCode = "TAH"
	LanguageCodeTgk LanguageCode = "TGK"
	LanguageCodeTam LanguageCode = "TAM"
	LanguageCodeTat LanguageCode = "TAT"
	LanguageCodeTel LanguageCode = "TEL"
	LanguageCodeTha LanguageCode = "THA"
	LanguageCodeBod LanguageCode = "BOD"
	LanguageCodeTir LanguageCode = "TIR"
	LanguageCodeTon LanguageCode = "TON"
	LanguageCodeTso LanguageCode = "TSO"
	LanguageCodeTsn LanguageCode = "TSN"
	LanguageCodeTur LanguageCode = "TUR"
	LanguageCodeTuk LanguageCode = "TUK"
	LanguageCodeTwi LanguageCode = "TWI"
	LanguageCodeUig LanguageCode = "UIG"
	LanguageCodeUkr LanguageCode = "UKR"
	LanguageCodeUzb LanguageCode = "UZB"
	LanguageCodeVen LanguageCode = "VEN"
	LanguageCodeVol LanguageCode = "VOL"
	LanguageCodeWln LanguageCode = "WLN"
	LanguageCodeCym LanguageCode = "CYM"
	LanguageCodeFry LanguageCode = "FRY"
	LanguageCodeWol LanguageCode = "WOL"
	LanguageCodeXho LanguageCode = "XHO"
	LanguageCodeYid LanguageCode = "YID"
	LanguageCodeYor LanguageCode = "YOR"
	LanguageCodeZha LanguageCode = "ZHA"
	LanguageCodeZul LanguageCode = "ZUL"
	LanguageCodeOrj LanguageCode = "ORJ"
	LanguageCodeQpc LanguageCode = "QPC"
	LanguageCodeTng LanguageCode = "TNG"
)

func (enum LanguageCode) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum LanguageCode) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Selects between the DVB and ATSC buffer models for Dolby Digital audio.
type M2tsAudioBufferModel string

// Enum values for M2tsAudioBufferModel
const (
	M2tsAudioBufferModelDvb  M2tsAudioBufferModel = "DVB"
	M2tsAudioBufferModelAtsc M2tsAudioBufferModel = "ATSC"
)

func (enum M2tsAudioBufferModel) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum M2tsAudioBufferModel) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Controls what buffer model to use for accurate interleaving. If set to MULTIPLEX,
// use multiplex buffer model. If set to NONE, this can lead to lower latency,
// but low-memory devices may not be able to play back the stream without interruptions.
type M2tsBufferModel string

// Enum values for M2tsBufferModel
const (
	M2tsBufferModelMultiplex M2tsBufferModel = "MULTIPLEX"
	M2tsBufferModelNone      M2tsBufferModel = "NONE"
)

func (enum M2tsBufferModel) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum M2tsBufferModel) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// When set to VIDEO_AND_FIXED_INTERVALS, audio EBP markers will be added to
// partitions 3 and 4. The interval between these additional markers will be
// fixed, and will be slightly shorter than the video EBP marker interval. When
// set to VIDEO_INTERVAL, these additional markers will not be inserted. Only
// applicable when EBP segmentation markers are is selected (segmentationMarkers
// is EBP or EBP_LEGACY).
type M2tsEbpAudioInterval string

// Enum values for M2tsEbpAudioInterval
const (
	M2tsEbpAudioIntervalVideoAndFixedIntervals M2tsEbpAudioInterval = "VIDEO_AND_FIXED_INTERVALS"
	M2tsEbpAudioIntervalVideoInterval          M2tsEbpAudioInterval = "VIDEO_INTERVAL"
)

func (enum M2tsEbpAudioInterval) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum M2tsEbpAudioInterval) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Selects which PIDs to place EBP markers on. They can either be placed only
// on the video PID, or on both the video PID and all audio PIDs. Only applicable
// when EBP segmentation markers are is selected (segmentationMarkers is EBP
// or EBP_LEGACY).
type M2tsEbpPlacement string

// Enum values for M2tsEbpPlacement
const (
	M2tsEbpPlacementVideoAndAudioPids M2tsEbpPlacement = "VIDEO_AND_AUDIO_PIDS"
	M2tsEbpPlacementVideoPid          M2tsEbpPlacement = "VIDEO_PID"
)

func (enum M2tsEbpPlacement) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum M2tsEbpPlacement) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Controls whether to include the ES Rate field in the PES header.
type M2tsEsRateInPes string

// Enum values for M2tsEsRateInPes
const (
	M2tsEsRateInPesInclude M2tsEsRateInPes = "INCLUDE"
	M2tsEsRateInPesExclude M2tsEsRateInPes = "EXCLUDE"
)

func (enum M2tsEsRateInPes) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum M2tsEsRateInPes) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Keep the default value (DEFAULT) unless you know that your audio EBP markers
// are incorrectly appearing before your video EBP markers. To correct this
// problem, set this value to Force (FORCE).
type M2tsForceTsVideoEbpOrder string

// Enum values for M2tsForceTsVideoEbpOrder
const (
	M2tsForceTsVideoEbpOrderForce   M2tsForceTsVideoEbpOrder = "FORCE"
	M2tsForceTsVideoEbpOrderDefault M2tsForceTsVideoEbpOrder = "DEFAULT"
)

func (enum M2tsForceTsVideoEbpOrder) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum M2tsForceTsVideoEbpOrder) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// If INSERT, Nielsen inaudible tones for media tracking will be detected in
// the input audio and an equivalent ID3 tag will be inserted in the output.
type M2tsNielsenId3 string

// Enum values for M2tsNielsenId3
const (
	M2tsNielsenId3Insert M2tsNielsenId3 = "INSERT"
	M2tsNielsenId3None   M2tsNielsenId3 = "NONE"
)

func (enum M2tsNielsenId3) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum M2tsNielsenId3) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// When set to PCR_EVERY_PES_PACKET, a Program Clock Reference value is inserted
// for every Packetized Elementary Stream (PES) header. This is effective only
// when the PCR PID is the same as the video or audio elementary stream.
type M2tsPcrControl string

// Enum values for M2tsPcrControl
const (
	M2tsPcrControlPcrEveryPesPacket   M2tsPcrControl = "PCR_EVERY_PES_PACKET"
	M2tsPcrControlConfiguredPcrPeriod M2tsPcrControl = "CONFIGURED_PCR_PERIOD"
)

func (enum M2tsPcrControl) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum M2tsPcrControl) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// When set to CBR, inserts null packets into transport stream to fill specified
// bitrate. When set to VBR, the bitrate setting acts as the maximum bitrate,
// but the output will not be padded up to that bitrate.
type M2tsRateMode string

// Enum values for M2tsRateMode
const (
	M2tsRateModeVbr M2tsRateMode = "VBR"
	M2tsRateModeCbr M2tsRateMode = "CBR"
)

func (enum M2tsRateMode) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum M2tsRateMode) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// For SCTE-35 markers from your input-- Choose Passthrough (PASSTHROUGH) if
// you want SCTE-35 markers that appear in your input to also appear in this
// output. Choose None (NONE) if you don't want SCTE-35 markers in this output.
// For SCTE-35 markers from an ESAM XML document-- Choose None (NONE). Also
// provide the ESAM XML as a string in the setting Signal processing notification
// XML (sccXml). Also enable ESAM SCTE-35 (include the property scte35Esam).
type M2tsScte35Source string

// Enum values for M2tsScte35Source
const (
	M2tsScte35SourcePassthrough M2tsScte35Source = "PASSTHROUGH"
	M2tsScte35SourceNone        M2tsScte35Source = "NONE"
)

func (enum M2tsScte35Source) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum M2tsScte35Source) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Inserts segmentation markers at each segmentation_time period. rai_segstart
// sets the Random Access Indicator bit in the adaptation field. rai_adapt sets
// the RAI bit and adds the current timecode in the private data bytes. psi_segstart
// inserts PAT and PMT tables at the start of segments. ebp adds Encoder Boundary
// Point information to the adaptation field as per OpenCable specification
// OC-SP-EBP-I01-130118. ebp_legacy adds Encoder Boundary Point information
// to the adaptation field using a legacy proprietary format.
type M2tsSegmentationMarkers string

// Enum values for M2tsSegmentationMarkers
const (
	M2tsSegmentationMarkersNone        M2tsSegmentationMarkers = "NONE"
	M2tsSegmentationMarkersRaiSegstart M2tsSegmentationMarkers = "RAI_SEGSTART"
	M2tsSegmentationMarkersRaiAdapt    M2tsSegmentationMarkers = "RAI_ADAPT"
	M2tsSegmentationMarkersPsiSegstart M2tsSegmentationMarkers = "PSI_SEGSTART"
	M2tsSegmentationMarkersEbp         M2tsSegmentationMarkers = "EBP"
	M2tsSegmentationMarkersEbpLegacy   M2tsSegmentationMarkers = "EBP_LEGACY"
)

func (enum M2tsSegmentationMarkers) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum M2tsSegmentationMarkers) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// The segmentation style parameter controls how segmentation markers are inserted
// into the transport stream. With avails, it is possible that segments may
// be truncated, which can influence where future segmentation markers are inserted.
// When a segmentation style of "reset_cadence" is selected and a segment is
// truncated due to an avail, we will reset the segmentation cadence. This means
// the subsequent segment will have a duration of of $segmentation_time seconds.
// When a segmentation style of "maintain_cadence" is selected and a segment
// is truncated due to an avail, we will not reset the segmentation cadence.
// This means the subsequent segment will likely be truncated as well. However,
// all segments after that will have a duration of $segmentation_time seconds.
// Note that EBP lookahead is a slight exception to this rule.
type M2tsSegmentationStyle string

// Enum values for M2tsSegmentationStyle
const (
	M2tsSegmentationStyleMaintainCadence M2tsSegmentationStyle = "MAINTAIN_CADENCE"
	M2tsSegmentationStyleResetCadence    M2tsSegmentationStyle = "RESET_CADENCE"
)

func (enum M2tsSegmentationStyle) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum M2tsSegmentationStyle) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// If INSERT, Nielsen inaudible tones for media tracking will be detected in
// the input audio and an equivalent ID3 tag will be inserted in the output.
type M3u8NielsenId3 string

// Enum values for M3u8NielsenId3
const (
	M3u8NielsenId3Insert M3u8NielsenId3 = "INSERT"
	M3u8NielsenId3None   M3u8NielsenId3 = "NONE"
)

func (enum M3u8NielsenId3) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum M3u8NielsenId3) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// When set to PCR_EVERY_PES_PACKET a Program Clock Reference value is inserted
// for every Packetized Elementary Stream (PES) header. This parameter is effective
// only when the PCR PID is the same as the video or audio elementary stream.
type M3u8PcrControl string

// Enum values for M3u8PcrControl
const (
	M3u8PcrControlPcrEveryPesPacket   M3u8PcrControl = "PCR_EVERY_PES_PACKET"
	M3u8PcrControlConfiguredPcrPeriod M3u8PcrControl = "CONFIGURED_PCR_PERIOD"
)

func (enum M3u8PcrControl) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum M3u8PcrControl) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// For SCTE-35 markers from your input-- Choose Passthrough (PASSTHROUGH) if
// you want SCTE-35 markers that appear in your input to also appear in this
// output. Choose None (NONE) if you don't want SCTE-35 markers in this output.
// For SCTE-35 markers from an ESAM XML document-- Choose None (NONE) if you
// don't want manifest conditioning. Choose Passthrough (PASSTHROUGH) and choose
// Ad markers (adMarkers) if you do want manifest conditioning. In both cases,
// also provide the ESAM XML as a string in the setting Signal processing notification
// XML (sccXml).
type M3u8Scte35Source string

// Enum values for M3u8Scte35Source
const (
	M3u8Scte35SourcePassthrough M3u8Scte35Source = "PASSTHROUGH"
	M3u8Scte35SourceNone        M3u8Scte35Source = "NONE"
)

func (enum M3u8Scte35Source) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum M3u8Scte35Source) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Choose the type of motion graphic asset that you are providing for your overlay.
// You can choose either a .mov file or a series of .png files.
type MotionImageInsertionMode string

// Enum values for MotionImageInsertionMode
const (
	MotionImageInsertionModeMov MotionImageInsertionMode = "MOV"
	MotionImageInsertionModePng MotionImageInsertionMode = "PNG"
)

func (enum MotionImageInsertionMode) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum MotionImageInsertionMode) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Specify whether your motion graphic overlay repeats on a loop or plays only
// once.
type MotionImagePlayback string

// Enum values for MotionImagePlayback
const (
	MotionImagePlaybackOnce   MotionImagePlayback = "ONCE"
	MotionImagePlaybackRepeat MotionImagePlayback = "REPEAT"
)

func (enum MotionImagePlayback) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum MotionImagePlayback) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// When enabled, include 'clap' atom if appropriate for the video output settings.
type MovClapAtom string

// Enum values for MovClapAtom
const (
	MovClapAtomInclude MovClapAtom = "INCLUDE"
	MovClapAtomExclude MovClapAtom = "EXCLUDE"
)

func (enum MovClapAtom) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum MovClapAtom) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// When enabled, file composition times will start at zero, composition times
// in the 'ctts' (composition time to sample) box for B-frames will be negative,
// and a 'cslg' (composition shift least greatest) box will be included per
// 14496-1 amendment 1. This improves compatibility with Apple players and tools.
type MovCslgAtom string

// Enum values for MovCslgAtom
const (
	MovCslgAtomInclude MovCslgAtom = "INCLUDE"
	MovCslgAtomExclude MovCslgAtom = "EXCLUDE"
)

func (enum MovCslgAtom) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum MovCslgAtom) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// When set to XDCAM, writes MPEG2 video streams into the QuickTime file using
// XDCAM fourcc codes. This increases compatibility with Apple editors and players,
// but may decrease compatibility with other players. Only applicable when the
// video codec is MPEG2.
type MovMpeg2FourCCControl string

// Enum values for MovMpeg2FourCCControl
const (
	MovMpeg2FourCCControlXdcam MovMpeg2FourCCControl = "XDCAM"
	MovMpeg2FourCCControlMpeg  MovMpeg2FourCCControl = "MPEG"
)

func (enum MovMpeg2FourCCControl) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum MovMpeg2FourCCControl) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// If set to OMNEON, inserts Omneon-compatible padding
type MovPaddingControl string

// Enum values for MovPaddingControl
const (
	MovPaddingControlOmneon MovPaddingControl = "OMNEON"
	MovPaddingControlNone   MovPaddingControl = "NONE"
)

func (enum MovPaddingControl) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum MovPaddingControl) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Always keep the default value (SELF_CONTAINED) for this setting.
type MovReference string

// Enum values for MovReference
const (
	MovReferenceSelfContained MovReference = "SELF_CONTAINED"
	MovReferenceExternal      MovReference = "EXTERNAL"
)

func (enum MovReference) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum MovReference) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Specify whether the service encodes this MP3 audio output with a constant
// bitrate (CBR) or a variable bitrate (VBR).
type Mp3RateControlMode string

// Enum values for Mp3RateControlMode
const (
	Mp3RateControlModeCbr Mp3RateControlMode = "CBR"
	Mp3RateControlModeVbr Mp3RateControlMode = "VBR"
)

func (enum Mp3RateControlMode) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum Mp3RateControlMode) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// When enabled, file composition times will start at zero, composition times
// in the 'ctts' (composition time to sample) box for B-frames will be negative,
// and a 'cslg' (composition shift least greatest) box will be included per
// 14496-1 amendment 1. This improves compatibility with Apple players and tools.
type Mp4CslgAtom string

// Enum values for Mp4CslgAtom
const (
	Mp4CslgAtomInclude Mp4CslgAtom = "INCLUDE"
	Mp4CslgAtomExclude Mp4CslgAtom = "EXCLUDE"
)

func (enum Mp4CslgAtom) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum Mp4CslgAtom) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Inserts a free-space box immediately after the moov box.
type Mp4FreeSpaceBox string

// Enum values for Mp4FreeSpaceBox
const (
	Mp4FreeSpaceBoxInclude Mp4FreeSpaceBox = "INCLUDE"
	Mp4FreeSpaceBoxExclude Mp4FreeSpaceBox = "EXCLUDE"
)

func (enum Mp4FreeSpaceBox) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum Mp4FreeSpaceBox) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// If set to PROGRESSIVE_DOWNLOAD, the MOOV atom is relocated to the beginning
// of the archive as required for progressive downloading. Otherwise it is placed
// normally at the end.
type Mp4MoovPlacement string

// Enum values for Mp4MoovPlacement
const (
	Mp4MoovPlacementProgressiveDownload Mp4MoovPlacement = "PROGRESSIVE_DOWNLOAD"
	Mp4MoovPlacementNormal              Mp4MoovPlacement = "NORMAL"
)

func (enum Mp4MoovPlacement) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum Mp4MoovPlacement) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Use this setting only in DASH output groups that include sidecar TTML or
// IMSC captions. You specify sidecar captions in a separate output from your
// audio and video. Choose Raw (RAW) for captions in a single XML file in a
// raw container. Choose Fragmented MPEG-4 (FRAGMENTED_MP4) for captions in
// XML format contained within fragmented MP4 files. This set of fragmented
// MP4 files is separate from your video and audio fragmented MP4 files.
type MpdCaptionContainerType string

// Enum values for MpdCaptionContainerType
const (
	MpdCaptionContainerTypeRaw           MpdCaptionContainerType = "RAW"
	MpdCaptionContainerTypeFragmentedMp4 MpdCaptionContainerType = "FRAGMENTED_MP4"
)

func (enum MpdCaptionContainerType) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum MpdCaptionContainerType) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Use this setting only when you specify SCTE-35 markers from ESAM. Choose
// INSERT to put SCTE-35 markers in this output at the insertion points that
// you specify in an ESAM XML document. Provide the document in the setting
// SCC XML (sccXml).
type MpdScte35Esam string

// Enum values for MpdScte35Esam
const (
	MpdScte35EsamInsert MpdScte35Esam = "INSERT"
	MpdScte35EsamNone   MpdScte35Esam = "NONE"
)

func (enum MpdScte35Esam) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum MpdScte35Esam) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Ignore this setting unless you have SCTE-35 markers in your input video file.
// Choose Passthrough (PASSTHROUGH) if you want SCTE-35 markers that appear
// in your input to also appear in this output. Choose None (NONE) if you don't
// want those SCTE-35 markers in this output.
type MpdScte35Source string

// Enum values for MpdScte35Source
const (
	MpdScte35SourcePassthrough MpdScte35Source = "PASSTHROUGH"
	MpdScte35SourceNone        MpdScte35Source = "NONE"
)

func (enum MpdScte35Source) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum MpdScte35Source) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Adaptive quantization. Allows intra-frame quantizers to vary to improve visual
// quality.
type Mpeg2AdaptiveQuantization string

// Enum values for Mpeg2AdaptiveQuantization
const (
	Mpeg2AdaptiveQuantizationOff    Mpeg2AdaptiveQuantization = "OFF"
	Mpeg2AdaptiveQuantizationLow    Mpeg2AdaptiveQuantization = "LOW"
	Mpeg2AdaptiveQuantizationMedium Mpeg2AdaptiveQuantization = "MEDIUM"
	Mpeg2AdaptiveQuantizationHigh   Mpeg2AdaptiveQuantization = "HIGH"
)

func (enum Mpeg2AdaptiveQuantization) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum Mpeg2AdaptiveQuantization) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Use Level (Mpeg2CodecLevel) to set the MPEG-2 level for the video output.
type Mpeg2CodecLevel string

// Enum values for Mpeg2CodecLevel
const (
	Mpeg2CodecLevelAuto     Mpeg2CodecLevel = "AUTO"
	Mpeg2CodecLevelLow      Mpeg2CodecLevel = "LOW"
	Mpeg2CodecLevelMain     Mpeg2CodecLevel = "MAIN"
	Mpeg2CodecLevelHigh1440 Mpeg2CodecLevel = "HIGH1440"
	Mpeg2CodecLevelHigh     Mpeg2CodecLevel = "HIGH"
)

func (enum Mpeg2CodecLevel) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum Mpeg2CodecLevel) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Use Profile (Mpeg2CodecProfile) to set the MPEG-2 profile for the video output.
type Mpeg2CodecProfile string

// Enum values for Mpeg2CodecProfile
const (
	Mpeg2CodecProfileMain       Mpeg2CodecProfile = "MAIN"
	Mpeg2CodecProfileProfile422 Mpeg2CodecProfile = "PROFILE_422"
)

func (enum Mpeg2CodecProfile) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum Mpeg2CodecProfile) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Choose Adaptive to improve subjective video quality for high-motion content.
// This will cause the service to use fewer B-frames (which infer information
// based on other frames) for high-motion portions of the video and more B-frames
// for low-motion portions. The maximum number of B-frames is limited by the
// value you provide for the setting B frames between reference frames (numberBFramesBetweenReferenceFrames).
type Mpeg2DynamicSubGop string

// Enum values for Mpeg2DynamicSubGop
const (
	Mpeg2DynamicSubGopAdaptive Mpeg2DynamicSubGop = "ADAPTIVE"
	Mpeg2DynamicSubGopStatic   Mpeg2DynamicSubGop = "STATIC"
)

func (enum Mpeg2DynamicSubGop) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum Mpeg2DynamicSubGop) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// If you are using the console, use the Framerate setting to specify the frame
// rate for this output. If you want to keep the same frame rate as the input
// video, choose Follow source. If you want to do frame rate conversion, choose
// a frame rate from the dropdown list or choose Custom. The framerates shown
// in the dropdown list are decimal approximations of fractions. If you choose
// Custom, specify your frame rate as a fraction. If you are creating your transcoding
// job specification as a JSON file without the console, use FramerateControl
// to specify which value the service uses for the frame rate for this output.
// Choose INITIALIZE_FROM_SOURCE if you want the service to use the frame rate
// from the input. Choose SPECIFIED if you want the service to use the frame
// rate you specify in the settings FramerateNumerator and FramerateDenominator.
type Mpeg2FramerateControl string

// Enum values for Mpeg2FramerateControl
const (
	Mpeg2FramerateControlInitializeFromSource Mpeg2FramerateControl = "INITIALIZE_FROM_SOURCE"
	Mpeg2FramerateControlSpecified            Mpeg2FramerateControl = "SPECIFIED"
)

func (enum Mpeg2FramerateControl) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum Mpeg2FramerateControl) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Optional. Specify how the transcoder performs framerate conversion. The default
// behavior is to use duplicate drop conversion.
type Mpeg2FramerateConversionAlgorithm string

// Enum values for Mpeg2FramerateConversionAlgorithm
const (
	Mpeg2FramerateConversionAlgorithmDuplicateDrop Mpeg2FramerateConversionAlgorithm = "DUPLICATE_DROP"
	Mpeg2FramerateConversionAlgorithmInterpolate   Mpeg2FramerateConversionAlgorithm = "INTERPOLATE"
)

func (enum Mpeg2FramerateConversionAlgorithm) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum Mpeg2FramerateConversionAlgorithm) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Indicates if the GOP Size in MPEG2 is specified in frames or seconds. If
// seconds the system will convert the GOP Size into a frame count at run time.
type Mpeg2GopSizeUnits string

// Enum values for Mpeg2GopSizeUnits
const (
	Mpeg2GopSizeUnitsFrames  Mpeg2GopSizeUnits = "FRAMES"
	Mpeg2GopSizeUnitsSeconds Mpeg2GopSizeUnits = "SECONDS"
)

func (enum Mpeg2GopSizeUnits) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum Mpeg2GopSizeUnits) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Use Interlace mode (InterlaceMode) to choose the scan line type for the output.
// * Top Field First (TOP_FIELD) and Bottom Field First (BOTTOM_FIELD) produce
// interlaced output with the entire output having the same field polarity (top
// or bottom first). * Follow, Default Top (FOLLOW_TOP_FIELD) and Follow, Default
// Bottom (FOLLOW_BOTTOM_FIELD) use the same field polarity as the source. Therefore,
// behavior depends on the input scan type. - If the source is interlaced, the
// output will be interlaced with the same polarity as the source (it will follow
// the source). The output could therefore be a mix of "top field first" and
// "bottom field first". - If the source is progressive, the output will be
// interlaced with "top field first" or "bottom field first" polarity, depending
// on which of the Follow options you chose.
type Mpeg2InterlaceMode string

// Enum values for Mpeg2InterlaceMode
const (
	Mpeg2InterlaceModeProgressive       Mpeg2InterlaceMode = "PROGRESSIVE"
	Mpeg2InterlaceModeTopField          Mpeg2InterlaceMode = "TOP_FIELD"
	Mpeg2InterlaceModeBottomField       Mpeg2InterlaceMode = "BOTTOM_FIELD"
	Mpeg2InterlaceModeFollowTopField    Mpeg2InterlaceMode = "FOLLOW_TOP_FIELD"
	Mpeg2InterlaceModeFollowBottomField Mpeg2InterlaceMode = "FOLLOW_BOTTOM_FIELD"
)

func (enum Mpeg2InterlaceMode) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum Mpeg2InterlaceMode) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Use Intra DC precision (Mpeg2IntraDcPrecision) to set quantization precision
// for intra-block DC coefficients. If you choose the value auto, the service
// will automatically select the precision based on the per-frame compression
// ratio.
type Mpeg2IntraDcPrecision string

// Enum values for Mpeg2IntraDcPrecision
const (
	Mpeg2IntraDcPrecisionAuto               Mpeg2IntraDcPrecision = "AUTO"
	Mpeg2IntraDcPrecisionIntraDcPrecision8  Mpeg2IntraDcPrecision = "INTRA_DC_PRECISION_8"
	Mpeg2IntraDcPrecisionIntraDcPrecision9  Mpeg2IntraDcPrecision = "INTRA_DC_PRECISION_9"
	Mpeg2IntraDcPrecisionIntraDcPrecision10 Mpeg2IntraDcPrecision = "INTRA_DC_PRECISION_10"
	Mpeg2IntraDcPrecisionIntraDcPrecision11 Mpeg2IntraDcPrecision = "INTRA_DC_PRECISION_11"
)

func (enum Mpeg2IntraDcPrecision) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum Mpeg2IntraDcPrecision) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Optional. Specify how the service determines the pixel aspect ratio (PAR)
// for this output. The default behavior, Follow source (INITIALIZE_FROM_SOURCE),
// uses the PAR from your input video for your output. To specify a different
// PAR in the console, choose any value other than Follow source. To specify
// a different PAR by editing the JSON job specification, choose SPECIFIED.
// When you choose SPECIFIED for this setting, you must also specify values
// for the parNumerator and parDenominator settings.
type Mpeg2ParControl string

// Enum values for Mpeg2ParControl
const (
	Mpeg2ParControlInitializeFromSource Mpeg2ParControl = "INITIALIZE_FROM_SOURCE"
	Mpeg2ParControlSpecified            Mpeg2ParControl = "SPECIFIED"
)

func (enum Mpeg2ParControl) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum Mpeg2ParControl) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Optional. Use Quality tuning level (qualityTuningLevel) to choose how you
// want to trade off encoding speed for output video quality. The default behavior
// is faster, lower quality, single-pass encoding.
type Mpeg2QualityTuningLevel string

// Enum values for Mpeg2QualityTuningLevel
const (
	Mpeg2QualityTuningLevelSinglePass Mpeg2QualityTuningLevel = "SINGLE_PASS"
	Mpeg2QualityTuningLevelMultiPass  Mpeg2QualityTuningLevel = "MULTI_PASS"
)

func (enum Mpeg2QualityTuningLevel) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum Mpeg2QualityTuningLevel) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Use Rate control mode (Mpeg2RateControlMode) to specifiy whether the bitrate
// is variable (vbr) or constant (cbr).
type Mpeg2RateControlMode string

// Enum values for Mpeg2RateControlMode
const (
	Mpeg2RateControlModeVbr Mpeg2RateControlMode = "VBR"
	Mpeg2RateControlModeCbr Mpeg2RateControlMode = "CBR"
)

func (enum Mpeg2RateControlMode) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum Mpeg2RateControlMode) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Enable this setting to insert I-frames at scene changes that the service
// automatically detects. This improves video quality and is enabled by default.
type Mpeg2SceneChangeDetect string

// Enum values for Mpeg2SceneChangeDetect
const (
	Mpeg2SceneChangeDetectDisabled Mpeg2SceneChangeDetect = "DISABLED"
	Mpeg2SceneChangeDetectEnabled  Mpeg2SceneChangeDetect = "ENABLED"
)

func (enum Mpeg2SceneChangeDetect) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum Mpeg2SceneChangeDetect) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Enables Slow PAL rate conversion. 23.976fps and 24fps input is relabeled
// as 25fps, and audio is sped up correspondingly.
type Mpeg2SlowPal string

// Enum values for Mpeg2SlowPal
const (
	Mpeg2SlowPalDisabled Mpeg2SlowPal = "DISABLED"
	Mpeg2SlowPalEnabled  Mpeg2SlowPal = "ENABLED"
)

func (enum Mpeg2SlowPal) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum Mpeg2SlowPal) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Adjust quantization within each frame based on spatial variation of content
// complexity.
type Mpeg2SpatialAdaptiveQuantization string

// Enum values for Mpeg2SpatialAdaptiveQuantization
const (
	Mpeg2SpatialAdaptiveQuantizationDisabled Mpeg2SpatialAdaptiveQuantization = "DISABLED"
	Mpeg2SpatialAdaptiveQuantizationEnabled  Mpeg2SpatialAdaptiveQuantization = "ENABLED"
)

func (enum Mpeg2SpatialAdaptiveQuantization) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum Mpeg2SpatialAdaptiveQuantization) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Produces a Type D-10 compatible bitstream (SMPTE 356M-2001).
type Mpeg2Syntax string

// Enum values for Mpeg2Syntax
const (
	Mpeg2SyntaxDefault Mpeg2Syntax = "DEFAULT"
	Mpeg2SyntaxD10     Mpeg2Syntax = "D_10"
)

func (enum Mpeg2Syntax) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum Mpeg2Syntax) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Only use Telecine (Mpeg2Telecine) when you set Framerate (Framerate) to 29.970.
// Set Telecine (Mpeg2Telecine) to Hard (hard) to produce a 29.97i output from
// a 23.976 input. Set it to Soft (soft) to produce 23.976 output and leave
// converstion to the player.
type Mpeg2Telecine string

// Enum values for Mpeg2Telecine
const (
	Mpeg2TelecineNone Mpeg2Telecine = "NONE"
	Mpeg2TelecineSoft Mpeg2Telecine = "SOFT"
	Mpeg2TelecineHard Mpeg2Telecine = "HARD"
)

func (enum Mpeg2Telecine) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum Mpeg2Telecine) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Adjust quantization within each frame based on temporal variation of content
// complexity.
type Mpeg2TemporalAdaptiveQuantization string

// Enum values for Mpeg2TemporalAdaptiveQuantization
const (
	Mpeg2TemporalAdaptiveQuantizationDisabled Mpeg2TemporalAdaptiveQuantization = "DISABLED"
	Mpeg2TemporalAdaptiveQuantizationEnabled  Mpeg2TemporalAdaptiveQuantization = "ENABLED"
)

func (enum Mpeg2TemporalAdaptiveQuantization) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum Mpeg2TemporalAdaptiveQuantization) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// COMBINE_DUPLICATE_STREAMS combines identical audio encoding settings across
// a Microsoft Smooth output group into a single audio stream.
type MsSmoothAudioDeduplication string

// Enum values for MsSmoothAudioDeduplication
const (
	MsSmoothAudioDeduplicationCombineDuplicateStreams MsSmoothAudioDeduplication = "COMBINE_DUPLICATE_STREAMS"
	MsSmoothAudioDeduplicationNone                    MsSmoothAudioDeduplication = "NONE"
)

func (enum MsSmoothAudioDeduplication) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum MsSmoothAudioDeduplication) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Use Manifest encoding (MsSmoothManifestEncoding) to specify the encoding
// format for the server and client manifest. Valid options are utf8 and utf16.
type MsSmoothManifestEncoding string

// Enum values for MsSmoothManifestEncoding
const (
	MsSmoothManifestEncodingUtf8  MsSmoothManifestEncoding = "UTF8"
	MsSmoothManifestEncodingUtf16 MsSmoothManifestEncoding = "UTF16"
)

func (enum MsSmoothManifestEncoding) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum MsSmoothManifestEncoding) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Optional. When you have AFD signaling set up in your output video stream,
// use this setting to choose whether to also include it in the MXF wrapper.
// Choose Don't copy (NO_COPY) to exclude AFD signaling from the MXF wrapper.
// Choose Copy from video stream (COPY_FROM_VIDEO) to copy the AFD values from
// the video stream for this output to the MXF wrapper. Regardless of which
// option you choose, the AFD values remain in the video stream. Related settings:
// To set up your output to include or exclude AFD values, see AfdSignaling,
// under VideoDescription. On the console, find AFD signaling under the output's
// video encoding settings.
type MxfAfdSignaling string

// Enum values for MxfAfdSignaling
const (
	MxfAfdSignalingNoCopy        MxfAfdSignaling = "NO_COPY"
	MxfAfdSignalingCopyFromVideo MxfAfdSignaling = "COPY_FROM_VIDEO"
)

func (enum MxfAfdSignaling) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum MxfAfdSignaling) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Optional. When you set Noise reducer (noiseReducer) to Temporal (TEMPORAL),
// you can optionally use this setting to apply additional sharpening. The default
// behavior, Auto (AUTO) allows the transcoder to determine whether to apply
// filtering, depending on input type and quality.
type NoiseFilterPostTemporalSharpening string

// Enum values for NoiseFilterPostTemporalSharpening
const (
	NoiseFilterPostTemporalSharpeningDisabled NoiseFilterPostTemporalSharpening = "DISABLED"
	NoiseFilterPostTemporalSharpeningEnabled  NoiseFilterPostTemporalSharpening = "ENABLED"
	NoiseFilterPostTemporalSharpeningAuto     NoiseFilterPostTemporalSharpening = "AUTO"
)

func (enum NoiseFilterPostTemporalSharpening) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum NoiseFilterPostTemporalSharpening) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Use Noise reducer filter (NoiseReducerFilter) to select one of the following
// spatial image filtering functions. To use this setting, you must also enable
// Noise reducer (NoiseReducer). * Bilateral preserves edges while reducing
// noise. * Mean (softest), Gaussian, Lanczos, and Sharpen (sharpest) do convolution
// filtering. * Conserve does min/max noise reduction. * Spatial does frequency-domain
// filtering based on JND principles. * Temporal optimizes video quality for
// complex motion.
type NoiseReducerFilter string

// Enum values for NoiseReducerFilter
const (
	NoiseReducerFilterBilateral NoiseReducerFilter = "BILATERAL"
	NoiseReducerFilterMean      NoiseReducerFilter = "MEAN"
	NoiseReducerFilterGaussian  NoiseReducerFilter = "GAUSSIAN"
	NoiseReducerFilterLanczos   NoiseReducerFilter = "LANCZOS"
	NoiseReducerFilterSharpen   NoiseReducerFilter = "SHARPEN"
	NoiseReducerFilterConserve  NoiseReducerFilter = "CONSERVE"
	NoiseReducerFilterSpatial   NoiseReducerFilter = "SPATIAL"
	NoiseReducerFilterTemporal  NoiseReducerFilter = "TEMPORAL"
)

func (enum NoiseReducerFilter) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum NoiseReducerFilter) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Optional. When you request lists of resources, you can specify whether they
// are sorted in ASCENDING or DESCENDING order. Default varies by resource.
type Order string

// Enum values for Order
const (
	OrderAscending  Order = "ASCENDING"
	OrderDescending Order = "DESCENDING"
)

func (enum Order) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum Order) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Type of output group (File group, Apple HLS, DASH ISO, Microsoft Smooth Streaming,
// CMAF)
type OutputGroupType string

// Enum values for OutputGroupType
const (
	OutputGroupTypeHlsGroupSettings      OutputGroupType = "HLS_GROUP_SETTINGS"
	OutputGroupTypeDashIsoGroupSettings  OutputGroupType = "DASH_ISO_GROUP_SETTINGS"
	OutputGroupTypeFileGroupSettings     OutputGroupType = "FILE_GROUP_SETTINGS"
	OutputGroupTypeMsSmoothGroupSettings OutputGroupType = "MS_SMOOTH_GROUP_SETTINGS"
	OutputGroupTypeCmafGroupSettings     OutputGroupType = "CMAF_GROUP_SETTINGS"
)

func (enum OutputGroupType) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum OutputGroupType) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Selects method of inserting SDT information into output stream. "Follow input
// SDT" copies SDT information from input stream to output stream. "Follow input
// SDT if present" copies SDT information from input stream to output stream
// if SDT information is present in the input, otherwise it will fall back on
// the user-defined values. Enter "SDT Manually" means user will enter the SDT
// information. "No SDT" means output stream will not contain SDT information.
type OutputSdt string

// Enum values for OutputSdt
const (
	OutputSdtSdtFollow          OutputSdt = "SDT_FOLLOW"
	OutputSdtSdtFollowIfPresent OutputSdt = "SDT_FOLLOW_IF_PRESENT"
	OutputSdtSdtManual          OutputSdt = "SDT_MANUAL"
	OutputSdtSdtNone            OutputSdt = "SDT_NONE"
)

func (enum OutputSdt) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum OutputSdt) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Optional. When you request a list of presets, you can choose to list them
// alphabetically by NAME or chronologically by CREATION_DATE. If you don't
// specify, the service will list them by name.
type PresetListBy string

// Enum values for PresetListBy
const (
	PresetListByName         PresetListBy = "NAME"
	PresetListByCreationDate PresetListBy = "CREATION_DATE"
	PresetListBySystem       PresetListBy = "SYSTEM"
)

func (enum PresetListBy) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum PresetListBy) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Specifies whether the pricing plan for the queue is on-demand or reserved.
// For on-demand, you pay per minute, billed in increments of .01 minute. For
// reserved, you pay for the transcoding capacity of the entire queue, regardless
// of how much or how little you use it. Reserved pricing requires a 12-month
// commitment.
type PricingPlan string

// Enum values for PricingPlan
const (
	PricingPlanOnDemand PricingPlan = "ON_DEMAND"
	PricingPlanReserved PricingPlan = "RESERVED"
)

func (enum PricingPlan) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum PricingPlan) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Use Profile (ProResCodecProfile) to specifiy the type of Apple ProRes codec
// to use for this output.
type ProresCodecProfile string

// Enum values for ProresCodecProfile
const (
	ProresCodecProfileAppleProres422      ProresCodecProfile = "APPLE_PRORES_422"
	ProresCodecProfileAppleProres422Hq    ProresCodecProfile = "APPLE_PRORES_422_HQ"
	ProresCodecProfileAppleProres422Lt    ProresCodecProfile = "APPLE_PRORES_422_LT"
	ProresCodecProfileAppleProres422Proxy ProresCodecProfile = "APPLE_PRORES_422_PROXY"
)

func (enum ProresCodecProfile) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum ProresCodecProfile) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// If you are using the console, use the Framerate setting to specify the frame
// rate for this output. If you want to keep the same frame rate as the input
// video, choose Follow source. If you want to do frame rate conversion, choose
// a frame rate from the dropdown list or choose Custom. The framerates shown
// in the dropdown list are decimal approximations of fractions. If you choose
// Custom, specify your frame rate as a fraction. If you are creating your transcoding
// job specification as a JSON file without the console, use FramerateControl
// to specify which value the service uses for the frame rate for this output.
// Choose INITIALIZE_FROM_SOURCE if you want the service to use the frame rate
// from the input. Choose SPECIFIED if you want the service to use the frame
// rate you specify in the settings FramerateNumerator and FramerateDenominator.
type ProresFramerateControl string

// Enum values for ProresFramerateControl
const (
	ProresFramerateControlInitializeFromSource ProresFramerateControl = "INITIALIZE_FROM_SOURCE"
	ProresFramerateControlSpecified            ProresFramerateControl = "SPECIFIED"
)

func (enum ProresFramerateControl) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum ProresFramerateControl) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Optional. Specify how the transcoder performs framerate conversion. The default
// behavior is to use duplicate drop conversion.
type ProresFramerateConversionAlgorithm string

// Enum values for ProresFramerateConversionAlgorithm
const (
	ProresFramerateConversionAlgorithmDuplicateDrop ProresFramerateConversionAlgorithm = "DUPLICATE_DROP"
	ProresFramerateConversionAlgorithmInterpolate   ProresFramerateConversionAlgorithm = "INTERPOLATE"
)

func (enum ProresFramerateConversionAlgorithm) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum ProresFramerateConversionAlgorithm) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Use Interlace mode (InterlaceMode) to choose the scan line type for the output.
// * Top Field First (TOP_FIELD) and Bottom Field First (BOTTOM_FIELD) produce
// interlaced output with the entire output having the same field polarity (top
// or bottom first). * Follow, Default Top (FOLLOW_TOP_FIELD) and Follow, Default
// Bottom (FOLLOW_BOTTOM_FIELD) use the same field polarity as the source. Therefore,
// behavior depends on the input scan type. - If the source is interlaced, the
// output will be interlaced with the same polarity as the source (it will follow
// the source). The output could therefore be a mix of "top field first" and
// "bottom field first". - If the source is progressive, the output will be
// interlaced with "top field first" or "bottom field first" polarity, depending
// on which of the Follow options you chose.
type ProresInterlaceMode string

// Enum values for ProresInterlaceMode
const (
	ProresInterlaceModeProgressive       ProresInterlaceMode = "PROGRESSIVE"
	ProresInterlaceModeTopField          ProresInterlaceMode = "TOP_FIELD"
	ProresInterlaceModeBottomField       ProresInterlaceMode = "BOTTOM_FIELD"
	ProresInterlaceModeFollowTopField    ProresInterlaceMode = "FOLLOW_TOP_FIELD"
	ProresInterlaceModeFollowBottomField ProresInterlaceMode = "FOLLOW_BOTTOM_FIELD"
)

func (enum ProresInterlaceMode) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum ProresInterlaceMode) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Optional. Specify how the service determines the pixel aspect ratio (PAR)
// for this output. The default behavior, Follow source (INITIALIZE_FROM_SOURCE),
// uses the PAR from your input video for your output. To specify a different
// PAR in the console, choose any value other than Follow source. To specify
// a different PAR by editing the JSON job specification, choose SPECIFIED.
// When you choose SPECIFIED for this setting, you must also specify values
// for the parNumerator and parDenominator settings.
type ProresParControl string

// Enum values for ProresParControl
const (
	ProresParControlInitializeFromSource ProresParControl = "INITIALIZE_FROM_SOURCE"
	ProresParControlSpecified            ProresParControl = "SPECIFIED"
)

func (enum ProresParControl) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum ProresParControl) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Enables Slow PAL rate conversion. 23.976fps and 24fps input is relabeled
// as 25fps, and audio is sped up correspondingly.
type ProresSlowPal string

// Enum values for ProresSlowPal
const (
	ProresSlowPalDisabled ProresSlowPal = "DISABLED"
	ProresSlowPalEnabled  ProresSlowPal = "ENABLED"
)

func (enum ProresSlowPal) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum ProresSlowPal) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Only use Telecine (ProresTelecine) when you set Framerate (Framerate) to
// 29.970. Set Telecine (ProresTelecine) to Hard (hard) to produce a 29.97i
// output from a 23.976 input. Set it to Soft (soft) to produce 23.976 output
// and leave converstion to the player.
type ProresTelecine string

// Enum values for ProresTelecine
const (
	ProresTelecineNone ProresTelecine = "NONE"
	ProresTelecineHard ProresTelecine = "HARD"
)

func (enum ProresTelecine) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum ProresTelecine) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Optional. When you request a list of queues, you can choose to list them
// alphabetically by NAME or chronologically by CREATION_DATE. If you don't
// specify, the service will list them by creation date.
type QueueListBy string

// Enum values for QueueListBy
const (
	QueueListByName         QueueListBy = "NAME"
	QueueListByCreationDate QueueListBy = "CREATION_DATE"
)

func (enum QueueListBy) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum QueueListBy) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Queues can be ACTIVE or PAUSED. If you pause a queue, jobs in that queue
// won't begin. Jobs that are running when you pause a queue continue to run
// until they finish or result in an error.
type QueueStatus string

// Enum values for QueueStatus
const (
	QueueStatusActive QueueStatus = "ACTIVE"
	QueueStatusPaused QueueStatus = "PAUSED"
)

func (enum QueueStatus) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum QueueStatus) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Specifies whether the term of your reserved queue pricing plan is automatically
// extended (AUTO_RENEW) or expires (EXPIRE) at the end of the term.
type RenewalType string

// Enum values for RenewalType
const (
	RenewalTypeAutoRenew RenewalType = "AUTO_RENEW"
	RenewalTypeExpire    RenewalType = "EXPIRE"
)

func (enum RenewalType) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum RenewalType) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Specifies whether the pricing plan for your reserved queue is ACTIVE or EXPIRED.
type ReservationPlanStatus string

// Enum values for ReservationPlanStatus
const (
	ReservationPlanStatusActive  ReservationPlanStatus = "ACTIVE"
	ReservationPlanStatusExpired ReservationPlanStatus = "EXPIRED"
)

func (enum ReservationPlanStatus) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum ReservationPlanStatus) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Use Respond to AFD (RespondToAfd) to specify how the service changes the
// video itself in response to AFD values in the input. * Choose Respond to
// clip the input video frame according to the AFD value, input display aspect
// ratio, and output display aspect ratio. * Choose Passthrough to include the
// input AFD values. Do not choose this when AfdSignaling is set to (NONE).
// A preferred implementation of this workflow is to set RespondToAfd to (NONE)
// and set AfdSignaling to (AUTO). * Choose None to remove all input AFD values
// from this output.
type RespondToAfd string

// Enum values for RespondToAfd
const (
	RespondToAfdNone        RespondToAfd = "NONE"
	RespondToAfdRespond     RespondToAfd = "RESPOND"
	RespondToAfdPassthrough RespondToAfd = "PASSTHROUGH"
)

func (enum RespondToAfd) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum RespondToAfd) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Choose an Amazon S3 canned ACL for MediaConvert to apply to this output.
type S3ObjectCannedAcl string

// Enum values for S3ObjectCannedAcl
const (
	S3ObjectCannedAclPublicRead             S3ObjectCannedAcl = "PUBLIC_READ"
	S3ObjectCannedAclAuthenticatedRead      S3ObjectCannedAcl = "AUTHENTICATED_READ"
	S3ObjectCannedAclBucketOwnerRead        S3ObjectCannedAcl = "BUCKET_OWNER_READ"
	S3ObjectCannedAclBucketOwnerFullControl S3ObjectCannedAcl = "BUCKET_OWNER_FULL_CONTROL"
)

func (enum S3ObjectCannedAcl) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum S3ObjectCannedAcl) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Specify how you want your data keys managed. AWS uses data keys to encrypt
// your content. AWS also encrypts the data keys themselves, using a customer
// master key (CMK), and then stores the encrypted data keys alongside your
// encrypted content. Use this setting to specify which AWS service manages
// the CMK. For simplest set up, choose Amazon S3 (SERVER_SIDE_ENCRYPTION_S3).
// If you want your master key to be managed by AWS Key Management Service (KMS),
// choose AWS KMS (SERVER_SIDE_ENCRYPTION_KMS). By default, when you choose
// AWS KMS, KMS uses the AWS managed customer master key (CMK) associated with
// Amazon S3 to encrypt your data keys. You can optionally choose to specify
// a different, customer managed CMK. Do so by specifying the Amazon Resource
// Name (ARN) of the key for the setting KMS ARN (kmsKeyArn).
type S3ServerSideEncryptionType string

// Enum values for S3ServerSideEncryptionType
const (
	S3ServerSideEncryptionTypeServerSideEncryptionS3  S3ServerSideEncryptionType = "SERVER_SIDE_ENCRYPTION_S3"
	S3ServerSideEncryptionTypeServerSideEncryptionKms S3ServerSideEncryptionType = "SERVER_SIDE_ENCRYPTION_KMS"
)

func (enum S3ServerSideEncryptionType) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum S3ServerSideEncryptionType) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Specify how the service handles outputs that have a different aspect ratio
// from the input aspect ratio. Choose Stretch to output (STRETCH_TO_OUTPUT)
// to have the service stretch your video image to fit. Keep the setting Default
// (DEFAULT) to have the service letterbox your video instead. This setting
// overrides any value that you specify for the setting Selection placement
// (position) in this output.
type ScalingBehavior string

// Enum values for ScalingBehavior
const (
	ScalingBehaviorDefault         ScalingBehavior = "DEFAULT"
	ScalingBehaviorStretchToOutput ScalingBehavior = "STRETCH_TO_OUTPUT"
)

func (enum ScalingBehavior) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum ScalingBehavior) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Set Framerate (SccDestinationFramerate) to make sure that the captions and
// the video are synchronized in the output. Specify a frame rate that matches
// the frame rate of the associated video. If the video frame rate is 29.97,
// choose 29.97 dropframe (FRAMERATE_29_97_DROPFRAME) only if the video has
// video_insertion=true and drop_frame_timecode=true; otherwise, choose 29.97
// non-dropframe (FRAMERATE_29_97_NON_DROPFRAME).
type SccDestinationFramerate string

// Enum values for SccDestinationFramerate
const (
	SccDestinationFramerateFramerate2397             SccDestinationFramerate = "FRAMERATE_23_97"
	SccDestinationFramerateFramerate24               SccDestinationFramerate = "FRAMERATE_24"
	SccDestinationFramerateFramerate25               SccDestinationFramerate = "FRAMERATE_25"
	SccDestinationFramerateFramerate2997Dropframe    SccDestinationFramerate = "FRAMERATE_29_97_DROPFRAME"
	SccDestinationFramerateFramerate2997NonDropframe SccDestinationFramerate = "FRAMERATE_29_97_NON_DROPFRAME"
)

func (enum SccDestinationFramerate) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum SccDestinationFramerate) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Enable this setting when you run a test job to estimate how many reserved
// transcoding slots (RTS) you need. When this is enabled, MediaConvert runs
// your job from an on-demand queue with similar performance to what you will
// see with one RTS in a reserved queue. This setting is disabled by default.
type SimulateReservedQueue string

// Enum values for SimulateReservedQueue
const (
	SimulateReservedQueueDisabled SimulateReservedQueue = "DISABLED"
	SimulateReservedQueueEnabled  SimulateReservedQueue = "ENABLED"
)

func (enum SimulateReservedQueue) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum SimulateReservedQueue) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Specify how often MediaConvert sends STATUS_UPDATE events to Amazon CloudWatch
// Events. Set the interval, in seconds, between status updates. MediaConvert
// sends an update at this interval from the time the service begins processing
// your job to the time it completes the transcode or encounters an error.
type StatusUpdateInterval string

// Enum values for StatusUpdateInterval
const (
	StatusUpdateIntervalSeconds10  StatusUpdateInterval = "SECONDS_10"
	StatusUpdateIntervalSeconds12  StatusUpdateInterval = "SECONDS_12"
	StatusUpdateIntervalSeconds15  StatusUpdateInterval = "SECONDS_15"
	StatusUpdateIntervalSeconds20  StatusUpdateInterval = "SECONDS_20"
	StatusUpdateIntervalSeconds30  StatusUpdateInterval = "SECONDS_30"
	StatusUpdateIntervalSeconds60  StatusUpdateInterval = "SECONDS_60"
	StatusUpdateIntervalSeconds120 StatusUpdateInterval = "SECONDS_120"
	StatusUpdateIntervalSeconds180 StatusUpdateInterval = "SECONDS_180"
	StatusUpdateIntervalSeconds240 StatusUpdateInterval = "SECONDS_240"
	StatusUpdateIntervalSeconds300 StatusUpdateInterval = "SECONDS_300"
	StatusUpdateIntervalSeconds360 StatusUpdateInterval = "SECONDS_360"
	StatusUpdateIntervalSeconds420 StatusUpdateInterval = "SECONDS_420"
	StatusUpdateIntervalSeconds480 StatusUpdateInterval = "SECONDS_480"
	StatusUpdateIntervalSeconds540 StatusUpdateInterval = "SECONDS_540"
	StatusUpdateIntervalSeconds600 StatusUpdateInterval = "SECONDS_600"
)

func (enum StatusUpdateInterval) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum StatusUpdateInterval) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// A page type as defined in the standard ETSI EN 300 468, Table 94
type TeletextPageType string

// Enum values for TeletextPageType
const (
	TeletextPageTypePageTypeInitial                 TeletextPageType = "PAGE_TYPE_INITIAL"
	TeletextPageTypePageTypeSubtitle                TeletextPageType = "PAGE_TYPE_SUBTITLE"
	TeletextPageTypePageTypeAddlInfo                TeletextPageType = "PAGE_TYPE_ADDL_INFO"
	TeletextPageTypePageTypeProgramSchedule         TeletextPageType = "PAGE_TYPE_PROGRAM_SCHEDULE"
	TeletextPageTypePageTypeHearingImpairedSubtitle TeletextPageType = "PAGE_TYPE_HEARING_IMPAIRED_SUBTITLE"
)

func (enum TeletextPageType) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum TeletextPageType) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Use Position (Position) under under Timecode burn-in (TimecodeBurnIn) to
// specify the location the burned-in timecode on output video.
type TimecodeBurninPosition string

// Enum values for TimecodeBurninPosition
const (
	TimecodeBurninPositionTopCenter    TimecodeBurninPosition = "TOP_CENTER"
	TimecodeBurninPositionTopLeft      TimecodeBurninPosition = "TOP_LEFT"
	TimecodeBurninPositionTopRight     TimecodeBurninPosition = "TOP_RIGHT"
	TimecodeBurninPositionMiddleLeft   TimecodeBurninPosition = "MIDDLE_LEFT"
	TimecodeBurninPositionMiddleCenter TimecodeBurninPosition = "MIDDLE_CENTER"
	TimecodeBurninPositionMiddleRight  TimecodeBurninPosition = "MIDDLE_RIGHT"
	TimecodeBurninPositionBottomLeft   TimecodeBurninPosition = "BOTTOM_LEFT"
	TimecodeBurninPositionBottomCenter TimecodeBurninPosition = "BOTTOM_CENTER"
	TimecodeBurninPositionBottomRight  TimecodeBurninPosition = "BOTTOM_RIGHT"
)

func (enum TimecodeBurninPosition) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum TimecodeBurninPosition) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Use Source (TimecodeSource) to set how timecodes are handled within this
// job. To make sure that your video, audio, captions, and markers are synchronized
// and that time-based features, such as image inserter, work correctly, choose
// the Timecode source option that matches your assets. All timecodes are in
// a 24-hour format with frame number (HH:MM:SS:FF). * Embedded (EMBEDDED) -
// Use the timecode that is in the input video. If no embedded timecode is in
// the source, the service will use Start at 0 (ZEROBASED) instead. * Start
// at 0 (ZEROBASED) - Set the timecode of the initial frame to 00:00:00:00.
// * Specified Start (SPECIFIEDSTART) - Set the timecode of the initial frame
// to a value other than zero. You use Start timecode (Start) to provide this
// value.
type TimecodeSource string

// Enum values for TimecodeSource
const (
	TimecodeSourceEmbedded       TimecodeSource = "EMBEDDED"
	TimecodeSourceZerobased      TimecodeSource = "ZEROBASED"
	TimecodeSourceSpecifiedstart TimecodeSource = "SPECIFIEDSTART"
)

func (enum TimecodeSource) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum TimecodeSource) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Applies only to HLS outputs. Use this setting to specify whether the service
// inserts the ID3 timed metadata from the input in this output.
type TimedMetadata string

// Enum values for TimedMetadata
const (
	TimedMetadataPassthrough TimedMetadata = "PASSTHROUGH"
	TimedMetadataNone        TimedMetadata = "NONE"
)

func (enum TimedMetadata) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum TimedMetadata) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Pass through style and position information from a TTML-like input source
// (TTML, SMPTE-TT) to the TTML output.
type TtmlStylePassthrough string

// Enum values for TtmlStylePassthrough
const (
	TtmlStylePassthroughEnabled  TtmlStylePassthrough = "ENABLED"
	TtmlStylePassthroughDisabled TtmlStylePassthrough = "DISABLED"
)

func (enum TtmlStylePassthrough) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum TtmlStylePassthrough) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

type Type string

// Enum values for Type
const (
	TypeSystem Type = "SYSTEM"
	TypeCustom Type = "CUSTOM"
)

func (enum Type) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum Type) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Type of video codec
type VideoCodec string

// Enum values for VideoCodec
const (
	VideoCodecFrameCapture VideoCodec = "FRAME_CAPTURE"
	VideoCodecAv1          VideoCodec = "AV1"
	VideoCodecH264         VideoCodec = "H_264"
	VideoCodecH265         VideoCodec = "H_265"
	VideoCodecMpeg2        VideoCodec = "MPEG2"
	VideoCodecProres       VideoCodec = "PRORES"
	VideoCodecVp8          VideoCodec = "VP8"
	VideoCodecVp9          VideoCodec = "VP9"
)

func (enum VideoCodec) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum VideoCodec) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Applies only to H.264, H.265, MPEG2, and ProRes outputs. Only enable Timecode
// insertion when the input frame rate is identical to the output frame rate.
// To include timecodes in this output, set Timecode insertion (VideoTimecodeInsertion)
// to PIC_TIMING_SEI. To leave them out, set it to DISABLED. Default is DISABLED.
// When the service inserts timecodes in an output, by default, it uses any
// embedded timecodes from the input. If none are present, the service will
// set the timecode for the first output frame to zero. To change this default
// behavior, adjust the settings under Timecode configuration (TimecodeConfig).
// In the console, these settings are located under Job > Job settings > Timecode
// configuration. Note - Timecode source under input settings (InputTimecodeSource)
// does not affect the timecodes that are inserted in the output. Source under
// Job settings > Timecode configuration (TimecodeSource) does.
type VideoTimecodeInsertion string

// Enum values for VideoTimecodeInsertion
const (
	VideoTimecodeInsertionDisabled     VideoTimecodeInsertion = "DISABLED"
	VideoTimecodeInsertionPicTimingSei VideoTimecodeInsertion = "PIC_TIMING_SEI"
)

func (enum VideoTimecodeInsertion) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum VideoTimecodeInsertion) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// If you are using the console, use the Framerate setting to specify the frame
// rate for this output. If you want to keep the same frame rate as the input
// video, choose Follow source. If you want to do frame rate conversion, choose
// a frame rate from the dropdown list or choose Custom. The framerates shown
// in the dropdown list are decimal approximations of fractions. If you choose
// Custom, specify your frame rate as a fraction. If you are creating your transcoding
// job specification as a JSON file without the console, use FramerateControl
// to specify which value the service uses for the frame rate for this output.
// Choose INITIALIZE_FROM_SOURCE if you want the service to use the frame rate
// from the input. Choose SPECIFIED if you want the service to use the frame
// rate you specify in the settings FramerateNumerator and FramerateDenominator.
type Vp8FramerateControl string

// Enum values for Vp8FramerateControl
const (
	Vp8FramerateControlInitializeFromSource Vp8FramerateControl = "INITIALIZE_FROM_SOURCE"
	Vp8FramerateControlSpecified            Vp8FramerateControl = "SPECIFIED"
)

func (enum Vp8FramerateControl) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum Vp8FramerateControl) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Optional. Specify how the transcoder performs framerate conversion. The default
// behavior is to use Drop duplicate (DUPLICATE_DROP) conversion. When you choose
// Interpolate (INTERPOLATE) instead, the conversion produces smoother motion.
type Vp8FramerateConversionAlgorithm string

// Enum values for Vp8FramerateConversionAlgorithm
const (
	Vp8FramerateConversionAlgorithmDuplicateDrop Vp8FramerateConversionAlgorithm = "DUPLICATE_DROP"
	Vp8FramerateConversionAlgorithmInterpolate   Vp8FramerateConversionAlgorithm = "INTERPOLATE"
)

func (enum Vp8FramerateConversionAlgorithm) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum Vp8FramerateConversionAlgorithm) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Optional. Specify how the service determines the pixel aspect ratio (PAR)
// for this output. The default behavior, Follow source (INITIALIZE_FROM_SOURCE),
// uses the PAR from your input video for your output. To specify a different
// PAR in the console, choose any value other than Follow source. To specify
// a different PAR by editing the JSON job specification, choose SPECIFIED.
// When you choose SPECIFIED for this setting, you must also specify values
// for the parNumerator and parDenominator settings.
type Vp8ParControl string

// Enum values for Vp8ParControl
const (
	Vp8ParControlInitializeFromSource Vp8ParControl = "INITIALIZE_FROM_SOURCE"
	Vp8ParControlSpecified            Vp8ParControl = "SPECIFIED"
)

func (enum Vp8ParControl) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum Vp8ParControl) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Optional. Use Quality tuning level (qualityTuningLevel) to choose how you
// want to trade off encoding speed for output video quality. The default behavior
// is faster, lower quality, multi-pass encoding.
type Vp8QualityTuningLevel string

// Enum values for Vp8QualityTuningLevel
const (
	Vp8QualityTuningLevelMultiPass   Vp8QualityTuningLevel = "MULTI_PASS"
	Vp8QualityTuningLevelMultiPassHq Vp8QualityTuningLevel = "MULTI_PASS_HQ"
)

func (enum Vp8QualityTuningLevel) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum Vp8QualityTuningLevel) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// With the VP8 codec, you can use only the variable bitrate (VBR) rate control
// mode.
type Vp8RateControlMode string

// Enum values for Vp8RateControlMode
const (
	Vp8RateControlModeVbr Vp8RateControlMode = "VBR"
)

func (enum Vp8RateControlMode) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum Vp8RateControlMode) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// If you are using the console, use the Framerate setting to specify the frame
// rate for this output. If you want to keep the same frame rate as the input
// video, choose Follow source. If you want to do frame rate conversion, choose
// a frame rate from the dropdown list or choose Custom. The framerates shown
// in the dropdown list are decimal approximations of fractions. If you choose
// Custom, specify your frame rate as a fraction. If you are creating your transcoding
// job specification as a JSON file without the console, use FramerateControl
// to specify which value the service uses for the frame rate for this output.
// Choose INITIALIZE_FROM_SOURCE if you want the service to use the frame rate
// from the input. Choose SPECIFIED if you want the service to use the frame
// rate you specify in the settings FramerateNumerator and FramerateDenominator.
type Vp9FramerateControl string

// Enum values for Vp9FramerateControl
const (
	Vp9FramerateControlInitializeFromSource Vp9FramerateControl = "INITIALIZE_FROM_SOURCE"
	Vp9FramerateControlSpecified            Vp9FramerateControl = "SPECIFIED"
)

func (enum Vp9FramerateControl) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum Vp9FramerateControl) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Optional. Specify how the transcoder performs framerate conversion. The default
// behavior is to use Drop duplicate (DUPLICATE_DROP) conversion. When you choose
// Interpolate (INTERPOLATE) instead, the conversion produces smoother motion.
type Vp9FramerateConversionAlgorithm string

// Enum values for Vp9FramerateConversionAlgorithm
const (
	Vp9FramerateConversionAlgorithmDuplicateDrop Vp9FramerateConversionAlgorithm = "DUPLICATE_DROP"
	Vp9FramerateConversionAlgorithmInterpolate   Vp9FramerateConversionAlgorithm = "INTERPOLATE"
)

func (enum Vp9FramerateConversionAlgorithm) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum Vp9FramerateConversionAlgorithm) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Optional. Specify how the service determines the pixel aspect ratio (PAR)
// for this output. The default behavior, Follow source (INITIALIZE_FROM_SOURCE),
// uses the PAR from your input video for your output. To specify a different
// PAR in the console, choose any value other than Follow source. To specify
// a different PAR by editing the JSON job specification, choose SPECIFIED.
// When you choose SPECIFIED for this setting, you must also specify values
// for the parNumerator and parDenominator settings.
type Vp9ParControl string

// Enum values for Vp9ParControl
const (
	Vp9ParControlInitializeFromSource Vp9ParControl = "INITIALIZE_FROM_SOURCE"
	Vp9ParControlSpecified            Vp9ParControl = "SPECIFIED"
)

func (enum Vp9ParControl) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum Vp9ParControl) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Optional. Use Quality tuning level (qualityTuningLevel) to choose how you
// want to trade off encoding speed for output video quality. The default behavior
// is faster, lower quality, multi-pass encoding.
type Vp9QualityTuningLevel string

// Enum values for Vp9QualityTuningLevel
const (
	Vp9QualityTuningLevelMultiPass   Vp9QualityTuningLevel = "MULTI_PASS"
	Vp9QualityTuningLevelMultiPassHq Vp9QualityTuningLevel = "MULTI_PASS_HQ"
)

func (enum Vp9QualityTuningLevel) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum Vp9QualityTuningLevel) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// With the VP9 codec, you can use only the variable bitrate (VBR) rate control
// mode.
type Vp9RateControlMode string

// Enum values for Vp9RateControlMode
const (
	Vp9RateControlModeVbr Vp9RateControlMode = "VBR"
)

func (enum Vp9RateControlMode) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum Vp9RateControlMode) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Optional. Ignore this setting unless Nagra support directs you to specify
// a value. When you don't specify a value here, the Nagra NexGuard library
// uses its default value.
type WatermarkingStrength string

// Enum values for WatermarkingStrength
const (
	WatermarkingStrengthLightest  WatermarkingStrength = "LIGHTEST"
	WatermarkingStrengthLighter   WatermarkingStrength = "LIGHTER"
	WatermarkingStrengthDefault   WatermarkingStrength = "DEFAULT"
	WatermarkingStrengthStronger  WatermarkingStrength = "STRONGER"
	WatermarkingStrengthStrongest WatermarkingStrength = "STRONGEST"
)

func (enum WatermarkingStrength) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum WatermarkingStrength) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// The service defaults to using RIFF for WAV outputs. If your output audio
// is likely to exceed 4 GB in file size, or if you otherwise need the extended
// support of the RF64 format, set your output WAV file format to RF64.
type WavFormat string

// Enum values for WavFormat
const (
	WavFormatRiff WavFormat = "RIFF"
	WavFormatRf64 WavFormat = "RF64"
)

func (enum WavFormat) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum WavFormat) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}
