// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package medialive

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type ListInputDevicesInput struct {
	_ struct{} `type:"structure"`

	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListInputDevicesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListInputDevicesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListInputDevicesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListInputDevicesInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "maxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type ListInputDevicesOutput struct {
	_ struct{} `type:"structure"`

	InputDevices []InputDeviceSummary `locationName:"inputDevices" type:"list"`

	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListInputDevicesOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListInputDevicesOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.InputDevices != nil {
		v := s.InputDevices

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "inputDevices", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opListInputDevices = "ListInputDevices"

// ListInputDevicesRequest returns a request value for making API operation for
// AWS Elemental MediaLive.
//
// List input devices
//
//    // Example sending a request using ListInputDevicesRequest.
//    req := client.ListInputDevicesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListInputDevices
func (c *Client) ListInputDevicesRequest(input *ListInputDevicesInput) ListInputDevicesRequest {
	op := &aws.Operation{
		Name:       opListInputDevices,
		HTTPMethod: "GET",
		HTTPPath:   "/prod/inputDevices",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListInputDevicesInput{}
	}

	req := c.newRequest(op, input, &ListInputDevicesOutput{})

	return ListInputDevicesRequest{Request: req, Input: input, Copy: c.ListInputDevicesRequest}
}

// ListInputDevicesRequest is the request type for the
// ListInputDevices API operation.
type ListInputDevicesRequest struct {
	*aws.Request
	Input *ListInputDevicesInput
	Copy  func(*ListInputDevicesInput) ListInputDevicesRequest
}

// Send marshals and sends the ListInputDevices API request.
func (r ListInputDevicesRequest) Send(ctx context.Context) (*ListInputDevicesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListInputDevicesResponse{
		ListInputDevicesOutput: r.Request.Data.(*ListInputDevicesOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListInputDevicesRequestPaginator returns a paginator for ListInputDevices.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListInputDevicesRequest(input)
//   p := medialive.NewListInputDevicesRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListInputDevicesPaginator(req ListInputDevicesRequest) ListInputDevicesPaginator {
	return ListInputDevicesPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListInputDevicesInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListInputDevicesPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListInputDevicesPaginator struct {
	aws.Pager
}

func (p *ListInputDevicesPaginator) CurrentPage() *ListInputDevicesOutput {
	return p.Pager.CurrentPage().(*ListInputDevicesOutput)
}

// ListInputDevicesResponse is the response type for the
// ListInputDevices API operation.
type ListInputDevicesResponse struct {
	*ListInputDevicesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListInputDevices request.
func (r *ListInputDevicesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
