// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package migrationhub

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListApplicationStatesInput struct {
	_ struct{} `type:"structure"`

	// The configurationIds from the Application Discovery Service that uniquely
	// identifies your applications.
	ApplicationIds []string `min:"1" type:"list"`

	// Maximum number of results to be returned per page.
	MaxResults *int64 `min:"1" type:"integer"`

	// If a NextToken was returned by a previous call, there are more results available.
	// To retrieve the next page of results, make the call again using the returned
	// token in NextToken.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListApplicationStatesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListApplicationStatesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListApplicationStatesInput"}
	if s.ApplicationIds != nil && len(s.ApplicationIds) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ApplicationIds", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListApplicationStatesOutput struct {
	_ struct{} `type:"structure"`

	// A list of Applications that exist in Application Discovery Service.
	ApplicationStateList []ApplicationState `type:"list"`

	// If a NextToken was returned by a previous call, there are more results available.
	// To retrieve the next page of results, make the call again using the returned
	// token in NextToken.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListApplicationStatesOutput) String() string {
	return awsutil.Prettify(s)
}

const opListApplicationStates = "ListApplicationStates"

// ListApplicationStatesRequest returns a request value for making API operation for
// AWS Migration Hub.
//
// Lists all the migration statuses for your applications. If you use the optional
// ApplicationIds parameter, only the migration statuses for those applications
// will be returned.
//
//    // Example sending a request using ListApplicationStatesRequest.
//    req := client.ListApplicationStatesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/AWSMigrationHub-2017-05-31/ListApplicationStates
func (c *Client) ListApplicationStatesRequest(input *ListApplicationStatesInput) ListApplicationStatesRequest {
	op := &aws.Operation{
		Name:       opListApplicationStates,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListApplicationStatesInput{}
	}

	req := c.newRequest(op, input, &ListApplicationStatesOutput{})

	return ListApplicationStatesRequest{Request: req, Input: input, Copy: c.ListApplicationStatesRequest}
}

// ListApplicationStatesRequest is the request type for the
// ListApplicationStates API operation.
type ListApplicationStatesRequest struct {
	*aws.Request
	Input *ListApplicationStatesInput
	Copy  func(*ListApplicationStatesInput) ListApplicationStatesRequest
}

// Send marshals and sends the ListApplicationStates API request.
func (r ListApplicationStatesRequest) Send(ctx context.Context) (*ListApplicationStatesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListApplicationStatesResponse{
		ListApplicationStatesOutput: r.Request.Data.(*ListApplicationStatesOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListApplicationStatesRequestPaginator returns a paginator for ListApplicationStates.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListApplicationStatesRequest(input)
//   p := migrationhub.NewListApplicationStatesRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListApplicationStatesPaginator(req ListApplicationStatesRequest) ListApplicationStatesPaginator {
	return ListApplicationStatesPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListApplicationStatesInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListApplicationStatesPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListApplicationStatesPaginator struct {
	aws.Pager
}

func (p *ListApplicationStatesPaginator) CurrentPage() *ListApplicationStatesOutput {
	return p.Pager.CurrentPage().(*ListApplicationStatesOutput)
}

// ListApplicationStatesResponse is the response type for the
// ListApplicationStates API operation.
type ListApplicationStatesResponse struct {
	*ListApplicationStatesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListApplicationStates request.
func (r *ListApplicationStatesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
