// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package neptune

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/query"
)

type AddRoleToDBClusterInput struct {
	_ struct{} `type:"structure"`

	// The name of the DB cluster to associate the IAM role with.
	//
	// DBClusterIdentifier is a required field
	DBClusterIdentifier *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the IAM role to associate with the Neptune
	// DB cluster, for example arn:aws:iam::123456789012:role/NeptuneAccessRole.
	//
	// RoleArn is a required field
	RoleArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s AddRoleToDBClusterInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddRoleToDBClusterInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AddRoleToDBClusterInput"}

	if s.DBClusterIdentifier == nil {
		invalidParams.Add(aws.NewErrParamRequired("DBClusterIdentifier"))
	}

	if s.RoleArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("RoleArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type AddRoleToDBClusterOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AddRoleToDBClusterOutput) String() string {
	return awsutil.Prettify(s)
}

const opAddRoleToDBCluster = "AddRoleToDBCluster"

// AddRoleToDBClusterRequest returns a request value for making API operation for
// Amazon Neptune.
//
// Associates an Identity and Access Management (IAM) role from an Neptune DB
// cluster.
//
//    // Example sending a request using AddRoleToDBClusterRequest.
//    req := client.AddRoleToDBClusterRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/AddRoleToDBCluster
func (c *Client) AddRoleToDBClusterRequest(input *AddRoleToDBClusterInput) AddRoleToDBClusterRequest {
	op := &aws.Operation{
		Name:       opAddRoleToDBCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddRoleToDBClusterInput{}
	}

	req := c.newRequest(op, input, &AddRoleToDBClusterOutput{})
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)

	return AddRoleToDBClusterRequest{Request: req, Input: input, Copy: c.AddRoleToDBClusterRequest}
}

// AddRoleToDBClusterRequest is the request type for the
// AddRoleToDBCluster API operation.
type AddRoleToDBClusterRequest struct {
	*aws.Request
	Input *AddRoleToDBClusterInput
	Copy  func(*AddRoleToDBClusterInput) AddRoleToDBClusterRequest
}

// Send marshals and sends the AddRoleToDBCluster API request.
func (r AddRoleToDBClusterRequest) Send(ctx context.Context) (*AddRoleToDBClusterResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &AddRoleToDBClusterResponse{
		AddRoleToDBClusterOutput: r.Request.Data.(*AddRoleToDBClusterOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// AddRoleToDBClusterResponse is the response type for the
// AddRoleToDBCluster API operation.
type AddRoleToDBClusterResponse struct {
	*AddRoleToDBClusterOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// AddRoleToDBCluster request.
func (r *AddRoleToDBClusterResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
