// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package neptune

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeDBClusterSnapshotAttributesInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the DB cluster snapshot to describe the attributes for.
	//
	// DBClusterSnapshotIdentifier is a required field
	DBClusterSnapshotIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeDBClusterSnapshotAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDBClusterSnapshotAttributesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeDBClusterSnapshotAttributesInput"}

	if s.DBClusterSnapshotIdentifier == nil {
		invalidParams.Add(aws.NewErrParamRequired("DBClusterSnapshotIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeDBClusterSnapshotAttributesOutput struct {
	_ struct{} `type:"structure"`

	// Contains the results of a successful call to the DescribeDBClusterSnapshotAttributes
	// API action.
	//
	// Manual DB cluster snapshot attributes are used to authorize other AWS accounts
	// to copy or restore a manual DB cluster snapshot. For more information, see
	// the ModifyDBClusterSnapshotAttribute API action.
	DBClusterSnapshotAttributesResult *DBClusterSnapshotAttributesResult `type:"structure"`
}

// String returns the string representation
func (s DescribeDBClusterSnapshotAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeDBClusterSnapshotAttributes = "DescribeDBClusterSnapshotAttributes"

// DescribeDBClusterSnapshotAttributesRequest returns a request value for making API operation for
// Amazon Neptune.
//
// Returns a list of DB cluster snapshot attribute names and values for a manual
// DB cluster snapshot.
//
// When sharing snapshots with other AWS accounts, DescribeDBClusterSnapshotAttributes
// returns the restore attribute and a list of IDs for the AWS accounts that
// are authorized to copy or restore the manual DB cluster snapshot. If all
// is included in the list of values for the restore attribute, then the manual
// DB cluster snapshot is public and can be copied or restored by all AWS accounts.
//
// To add or remove access for an AWS account to copy or restore a manual DB
// cluster snapshot, or to make the manual DB cluster snapshot public or private,
// use the ModifyDBClusterSnapshotAttribute API action.
//
//    // Example sending a request using DescribeDBClusterSnapshotAttributesRequest.
//    req := client.DescribeDBClusterSnapshotAttributesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBClusterSnapshotAttributes
func (c *Client) DescribeDBClusterSnapshotAttributesRequest(input *DescribeDBClusterSnapshotAttributesInput) DescribeDBClusterSnapshotAttributesRequest {
	op := &aws.Operation{
		Name:       opDescribeDBClusterSnapshotAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDBClusterSnapshotAttributesInput{}
	}

	req := c.newRequest(op, input, &DescribeDBClusterSnapshotAttributesOutput{})

	return DescribeDBClusterSnapshotAttributesRequest{Request: req, Input: input, Copy: c.DescribeDBClusterSnapshotAttributesRequest}
}

// DescribeDBClusterSnapshotAttributesRequest is the request type for the
// DescribeDBClusterSnapshotAttributes API operation.
type DescribeDBClusterSnapshotAttributesRequest struct {
	*aws.Request
	Input *DescribeDBClusterSnapshotAttributesInput
	Copy  func(*DescribeDBClusterSnapshotAttributesInput) DescribeDBClusterSnapshotAttributesRequest
}

// Send marshals and sends the DescribeDBClusterSnapshotAttributes API request.
func (r DescribeDBClusterSnapshotAttributesRequest) Send(ctx context.Context) (*DescribeDBClusterSnapshotAttributesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeDBClusterSnapshotAttributesResponse{
		DescribeDBClusterSnapshotAttributesOutput: r.Request.Data.(*DescribeDBClusterSnapshotAttributesOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeDBClusterSnapshotAttributesResponse is the response type for the
// DescribeDBClusterSnapshotAttributes API operation.
type DescribeDBClusterSnapshotAttributesResponse struct {
	*DescribeDBClusterSnapshotAttributesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeDBClusterSnapshotAttributes request.
func (r *DescribeDBClusterSnapshotAttributesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
