// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package networkmanager

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type GetLinksInput struct {
	_ struct{} `type:"structure"`

	// The ID of the global network.
	//
	// GlobalNetworkId is a required field
	GlobalNetworkId *string `location:"uri" locationName:"globalNetworkId" type:"string" required:"true"`

	// One or more link IDs. The maximum is 10.
	LinkIds []string `location:"querystring" locationName:"linkIds" type:"list"`

	// The maximum number of results to return.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next page of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The link provider.
	Provider *string `location:"querystring" locationName:"provider" type:"string"`

	// The ID of the site.
	SiteId *string `location:"querystring" locationName:"siteId" type:"string"`

	// The link type.
	Type *string `location:"querystring" locationName:"type" type:"string"`
}

// String returns the string representation
func (s GetLinksInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetLinksInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetLinksInput"}

	if s.GlobalNetworkId == nil {
		invalidParams.Add(aws.NewErrParamRequired("GlobalNetworkId"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetLinksInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.GlobalNetworkId != nil {
		v := *s.GlobalNetworkId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "globalNetworkId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LinkIds != nil {
		v := s.LinkIds

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.QueryTarget, "linkIds", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "maxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Provider != nil {
		v := *s.Provider

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "provider", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SiteId != nil {
		v := *s.SiteId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "siteId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Type != nil {
		v := *s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "type", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type GetLinksOutput struct {
	_ struct{} `type:"structure"`

	// The links.
	Links []Link `type:"list"`

	// The token for the next page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s GetLinksOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetLinksOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Links != nil {
		v := s.Links

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Links", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opGetLinks = "GetLinks"

// GetLinksRequest returns a request value for making API operation for
// AWS Network Manager.
//
// Gets information about one or more links in a specified global network.
//
// If you specify the site ID, you cannot specify the type or provider in the
// same request. You can specify the type and provider in the same request.
//
//    // Example sending a request using GetLinksRequest.
//    req := client.GetLinksRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetLinks
func (c *Client) GetLinksRequest(input *GetLinksInput) GetLinksRequest {
	op := &aws.Operation{
		Name:       opGetLinks,
		HTTPMethod: "GET",
		HTTPPath:   "/global-networks/{globalNetworkId}/links",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetLinksInput{}
	}

	req := c.newRequest(op, input, &GetLinksOutput{})

	return GetLinksRequest{Request: req, Input: input, Copy: c.GetLinksRequest}
}

// GetLinksRequest is the request type for the
// GetLinks API operation.
type GetLinksRequest struct {
	*aws.Request
	Input *GetLinksInput
	Copy  func(*GetLinksInput) GetLinksRequest
}

// Send marshals and sends the GetLinks API request.
func (r GetLinksRequest) Send(ctx context.Context) (*GetLinksResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetLinksResponse{
		GetLinksOutput: r.Request.Data.(*GetLinksOutput),
		response:       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewGetLinksRequestPaginator returns a paginator for GetLinks.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.GetLinksRequest(input)
//   p := networkmanager.NewGetLinksRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewGetLinksPaginator(req GetLinksRequest) GetLinksPaginator {
	return GetLinksPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *GetLinksInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// GetLinksPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type GetLinksPaginator struct {
	aws.Pager
}

func (p *GetLinksPaginator) CurrentPage() *GetLinksOutput {
	return p.Pager.CurrentPage().(*GetLinksOutput)
}

// GetLinksResponse is the response type for the
// GetLinks API operation.
type GetLinksResponse struct {
	*GetLinksOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetLinks request.
func (r *GetLinksResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
