// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package opsworks

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeCommandsInput struct {
	_ struct{} `type:"structure"`

	// An array of command IDs. If you include this parameter, DescribeCommands
	// returns a description of the specified commands. Otherwise, it returns a
	// description of every command.
	CommandIds []string `type:"list"`

	// The deployment ID. If you include this parameter, DescribeCommands returns
	// a description of the commands associated with the specified deployment.
	DeploymentId *string `type:"string"`

	// The instance ID. If you include this parameter, DescribeCommands returns
	// a description of the commands associated with the specified instance.
	InstanceId *string `type:"string"`
}

// String returns the string representation
func (s DescribeCommandsInput) String() string {
	return awsutil.Prettify(s)
}

// Contains the response to a DescribeCommands request.
type DescribeCommandsOutput struct {
	_ struct{} `type:"structure"`

	// An array of Command objects that describe each of the specified commands.
	Commands []Command `type:"list"`
}

// String returns the string representation
func (s DescribeCommandsOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeCommands = "DescribeCommands"

// DescribeCommandsRequest returns a request value for making API operation for
// AWS OpsWorks.
//
// Describes the results of specified commands.
//
// This call accepts only one resource-identifying parameter.
//
// Required Permissions: To use this action, an IAM user must have a Show, Deploy,
// or Manage permissions level for the stack, or an attached policy that explicitly
// grants permissions. For more information about user permissions, see Managing
// User Permissions (https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
//
//    // Example sending a request using DescribeCommandsRequest.
//    req := client.DescribeCommandsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DescribeCommands
func (c *Client) DescribeCommandsRequest(input *DescribeCommandsInput) DescribeCommandsRequest {
	op := &aws.Operation{
		Name:       opDescribeCommands,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeCommandsInput{}
	}

	req := c.newRequest(op, input, &DescribeCommandsOutput{})

	return DescribeCommandsRequest{Request: req, Input: input, Copy: c.DescribeCommandsRequest}
}

// DescribeCommandsRequest is the request type for the
// DescribeCommands API operation.
type DescribeCommandsRequest struct {
	*aws.Request
	Input *DescribeCommandsInput
	Copy  func(*DescribeCommandsInput) DescribeCommandsRequest
}

// Send marshals and sends the DescribeCommands API request.
func (r DescribeCommandsRequest) Send(ctx context.Context) (*DescribeCommandsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeCommandsResponse{
		DescribeCommandsOutput: r.Request.Data.(*DescribeCommandsOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeCommandsResponse is the response type for the
// DescribeCommands API operation.
type DescribeCommandsResponse struct {
	*DescribeCommandsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeCommands request.
func (r *DescribeCommandsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
