// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package organizations

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CancelHandshakeInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier (ID) of the handshake that you want to cancel. You
	// can get the ID from the ListHandshakesForOrganization operation.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) for handshake ID string
	// requires "h-" followed by from 8 to 32 lowercase letters or digits.
	//
	// HandshakeId is a required field
	HandshakeId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CancelHandshakeInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelHandshakeInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CancelHandshakeInput"}

	if s.HandshakeId == nil {
		invalidParams.Add(aws.NewErrParamRequired("HandshakeId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CancelHandshakeOutput struct {
	_ struct{} `type:"structure"`

	// A structure that contains details about the handshake that you canceled.
	Handshake *Handshake `type:"structure"`
}

// String returns the string representation
func (s CancelHandshakeOutput) String() string {
	return awsutil.Prettify(s)
}

const opCancelHandshake = "CancelHandshake"

// CancelHandshakeRequest returns a request value for making API operation for
// AWS Organizations.
//
// Cancels a handshake. Canceling a handshake sets the handshake state to CANCELED.
//
// This operation can be called only from the account that originated the handshake.
// The recipient of the handshake can't cancel it, but can use DeclineHandshake
// instead. After a handshake is canceled, the recipient can no longer respond
// to that handshake.
//
// After you cancel a handshake, it continues to appear in the results of relevant
// APIs for only 30 days. After that, it's deleted.
//
//    // Example sending a request using CancelHandshakeRequest.
//    req := client.CancelHandshakeRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/CancelHandshake
func (c *Client) CancelHandshakeRequest(input *CancelHandshakeInput) CancelHandshakeRequest {
	op := &aws.Operation{
		Name:       opCancelHandshake,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CancelHandshakeInput{}
	}

	req := c.newRequest(op, input, &CancelHandshakeOutput{})

	return CancelHandshakeRequest{Request: req, Input: input, Copy: c.CancelHandshakeRequest}
}

// CancelHandshakeRequest is the request type for the
// CancelHandshake API operation.
type CancelHandshakeRequest struct {
	*aws.Request
	Input *CancelHandshakeInput
	Copy  func(*CancelHandshakeInput) CancelHandshakeRequest
}

// Send marshals and sends the CancelHandshake API request.
func (r CancelHandshakeRequest) Send(ctx context.Context) (*CancelHandshakeResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CancelHandshakeResponse{
		CancelHandshakeOutput: r.Request.Data.(*CancelHandshakeOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CancelHandshakeResponse is the response type for the
// CancelHandshake API operation.
type CancelHandshakeResponse struct {
	*CancelHandshakeOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CancelHandshake request.
func (r *CancelHandshakeResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
