// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package organizations

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListDelegatedAdministratorsInput struct {
	_ struct{} `type:"structure"`

	// The total number of results that you want included on each page of the response.
	// If you do not include this parameter, it defaults to a value that is specific
	// to the operation. If additional items exist beyond the maximum you specify,
	// the NextToken response element is present and has a value (is not null).
	// Include that value as the NextToken request parameter in the next call to
	// the operation to get the next part of the results. Note that Organizations
	// might return fewer results than the maximum even when there are more results
	// available. You should check NextToken after every operation to ensure that
	// you receive all of the results.
	MaxResults *int64 `min:"1" type:"integer"`

	// The parameter for receiving additional results if you receive a NextToken
	// response in a previous request. A NextToken response indicates that more
	// output is available. Set this parameter to the value of the previous call's
	// NextToken response to indicate where the output should continue from.
	NextToken *string `type:"string"`

	// Specifies a service principal name. If specified, then the operation lists
	// the delegated administrators only for the specified service.
	//
	// If you don't specify a service principal, the operation lists all delegated
	// administrators for all services in your organization.
	ServicePrincipal *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListDelegatedAdministratorsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDelegatedAdministratorsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListDelegatedAdministratorsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ServicePrincipal != nil && len(*s.ServicePrincipal) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ServicePrincipal", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListDelegatedAdministratorsOutput struct {
	_ struct{} `type:"structure"`

	// The list of delegated administrators in your organization.
	DelegatedAdministrators []DelegatedAdministrator `type:"list"`

	// If present, indicates that more output is available than is included in the
	// current response. Use this value in the NextToken request parameter in a
	// subsequent call to the operation to get the next part of the output. You
	// should repeat this until the NextToken response element comes back as null.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListDelegatedAdministratorsOutput) String() string {
	return awsutil.Prettify(s)
}

const opListDelegatedAdministrators = "ListDelegatedAdministrators"

// ListDelegatedAdministratorsRequest returns a request value for making API operation for
// AWS Organizations.
//
// Lists the AWS accounts that are designated as delegated administrators in
// this organization.
//
// This operation can be called only from the organization's master account
// or by a member account that is a delegated administrator for an AWS service.
//
//    // Example sending a request using ListDelegatedAdministratorsRequest.
//    req := client.ListDelegatedAdministratorsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/ListDelegatedAdministrators
func (c *Client) ListDelegatedAdministratorsRequest(input *ListDelegatedAdministratorsInput) ListDelegatedAdministratorsRequest {
	op := &aws.Operation{
		Name:       opListDelegatedAdministrators,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDelegatedAdministratorsInput{}
	}

	req := c.newRequest(op, input, &ListDelegatedAdministratorsOutput{})

	return ListDelegatedAdministratorsRequest{Request: req, Input: input, Copy: c.ListDelegatedAdministratorsRequest}
}

// ListDelegatedAdministratorsRequest is the request type for the
// ListDelegatedAdministrators API operation.
type ListDelegatedAdministratorsRequest struct {
	*aws.Request
	Input *ListDelegatedAdministratorsInput
	Copy  func(*ListDelegatedAdministratorsInput) ListDelegatedAdministratorsRequest
}

// Send marshals and sends the ListDelegatedAdministrators API request.
func (r ListDelegatedAdministratorsRequest) Send(ctx context.Context) (*ListDelegatedAdministratorsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListDelegatedAdministratorsResponse{
		ListDelegatedAdministratorsOutput: r.Request.Data.(*ListDelegatedAdministratorsOutput),
		response:                          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListDelegatedAdministratorsRequestPaginator returns a paginator for ListDelegatedAdministrators.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListDelegatedAdministratorsRequest(input)
//   p := organizations.NewListDelegatedAdministratorsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListDelegatedAdministratorsPaginator(req ListDelegatedAdministratorsRequest) ListDelegatedAdministratorsPaginator {
	return ListDelegatedAdministratorsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListDelegatedAdministratorsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListDelegatedAdministratorsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListDelegatedAdministratorsPaginator struct {
	aws.Pager
}

func (p *ListDelegatedAdministratorsPaginator) CurrentPage() *ListDelegatedAdministratorsOutput {
	return p.Pager.CurrentPage().(*ListDelegatedAdministratorsOutput)
}

// ListDelegatedAdministratorsResponse is the response type for the
// ListDelegatedAdministrators API operation.
type ListDelegatedAdministratorsResponse struct {
	*ListDelegatedAdministratorsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListDelegatedAdministrators request.
func (r *ListDelegatedAdministratorsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
