// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package pinpoint

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DeleteRecommenderConfigurationInput struct {
	_ struct{} `type:"structure"`

	// RecommenderId is a required field
	RecommenderId *string `location:"uri" locationName:"recommender-id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteRecommenderConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRecommenderConfigurationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteRecommenderConfigurationInput"}

	if s.RecommenderId == nil {
		invalidParams.Add(aws.NewErrParamRequired("RecommenderId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteRecommenderConfigurationInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.RecommenderId != nil {
		v := *s.RecommenderId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "recommender-id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DeleteRecommenderConfigurationOutput struct {
	_ struct{} `type:"structure" payload:"RecommenderConfigurationResponse"`

	// Provides information about Amazon Pinpoint configuration settings for retrieving
	// and processing data from a recommender model.
	//
	// RecommenderConfigurationResponse is a required field
	RecommenderConfigurationResponse *RecommenderConfigurationResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s DeleteRecommenderConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteRecommenderConfigurationOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.RecommenderConfigurationResponse != nil {
		v := s.RecommenderConfigurationResponse

		metadata := protocol.Metadata{}
		e.SetFields(protocol.PayloadTarget, "RecommenderConfigurationResponse", v, metadata)
	}
	return nil
}

const opDeleteRecommenderConfiguration = "DeleteRecommenderConfiguration"

// DeleteRecommenderConfigurationRequest returns a request value for making API operation for
// Amazon Pinpoint.
//
// Deletes an Amazon Pinpoint configuration for a recommender model.
//
//    // Example sending a request using DeleteRecommenderConfigurationRequest.
//    req := client.DeleteRecommenderConfigurationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteRecommenderConfiguration
func (c *Client) DeleteRecommenderConfigurationRequest(input *DeleteRecommenderConfigurationInput) DeleteRecommenderConfigurationRequest {
	op := &aws.Operation{
		Name:       opDeleteRecommenderConfiguration,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/recommenders/{recommender-id}",
	}

	if input == nil {
		input = &DeleteRecommenderConfigurationInput{}
	}

	req := c.newRequest(op, input, &DeleteRecommenderConfigurationOutput{})

	return DeleteRecommenderConfigurationRequest{Request: req, Input: input, Copy: c.DeleteRecommenderConfigurationRequest}
}

// DeleteRecommenderConfigurationRequest is the request type for the
// DeleteRecommenderConfiguration API operation.
type DeleteRecommenderConfigurationRequest struct {
	*aws.Request
	Input *DeleteRecommenderConfigurationInput
	Copy  func(*DeleteRecommenderConfigurationInput) DeleteRecommenderConfigurationRequest
}

// Send marshals and sends the DeleteRecommenderConfiguration API request.
func (r DeleteRecommenderConfigurationRequest) Send(ctx context.Context) (*DeleteRecommenderConfigurationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteRecommenderConfigurationResponse{
		DeleteRecommenderConfigurationOutput: r.Request.Data.(*DeleteRecommenderConfigurationOutput),
		response:                             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteRecommenderConfigurationResponse is the response type for the
// DeleteRecommenderConfiguration API operation.
type DeleteRecommenderConfigurationResponse struct {
	*DeleteRecommenderConfigurationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteRecommenderConfiguration request.
func (r *DeleteRecommenderConfigurationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
