// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package pinpoint

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type GetApnsVoipSandboxChannelInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetApnsVoipSandboxChannelInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetApnsVoipSandboxChannelInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetApnsVoipSandboxChannelInput"}

	if s.ApplicationId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApplicationId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetApnsVoipSandboxChannelInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ApplicationId != nil {
		v := *s.ApplicationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "application-id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type GetApnsVoipSandboxChannelOutput struct {
	_ struct{} `type:"structure" payload:"APNSVoipSandboxChannelResponse"`

	// Provides information about the status and settings of the APNs (Apple Push
	// Notification service) VoIP sandbox channel for an application.
	//
	// APNSVoipSandboxChannelResponse is a required field
	APNSVoipSandboxChannelResponse *APNSVoipSandboxChannelResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetApnsVoipSandboxChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetApnsVoipSandboxChannelOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.APNSVoipSandboxChannelResponse != nil {
		v := s.APNSVoipSandboxChannelResponse

		metadata := protocol.Metadata{}
		e.SetFields(protocol.PayloadTarget, "APNSVoipSandboxChannelResponse", v, metadata)
	}
	return nil
}

const opGetApnsVoipSandboxChannel = "GetApnsVoipSandboxChannel"

// GetApnsVoipSandboxChannelRequest returns a request value for making API operation for
// Amazon Pinpoint.
//
// Retrieves information about the status and settings of the APNs VoIP sandbox
// channel for an application.
//
//    // Example sending a request using GetApnsVoipSandboxChannelRequest.
//    req := client.GetApnsVoipSandboxChannelRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApnsVoipSandboxChannel
func (c *Client) GetApnsVoipSandboxChannelRequest(input *GetApnsVoipSandboxChannelInput) GetApnsVoipSandboxChannelRequest {
	op := &aws.Operation{
		Name:       opGetApnsVoipSandboxChannel,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/channels/apns_voip_sandbox",
	}

	if input == nil {
		input = &GetApnsVoipSandboxChannelInput{}
	}

	req := c.newRequest(op, input, &GetApnsVoipSandboxChannelOutput{})

	return GetApnsVoipSandboxChannelRequest{Request: req, Input: input, Copy: c.GetApnsVoipSandboxChannelRequest}
}

// GetApnsVoipSandboxChannelRequest is the request type for the
// GetApnsVoipSandboxChannel API operation.
type GetApnsVoipSandboxChannelRequest struct {
	*aws.Request
	Input *GetApnsVoipSandboxChannelInput
	Copy  func(*GetApnsVoipSandboxChannelInput) GetApnsVoipSandboxChannelRequest
}

// Send marshals and sends the GetApnsVoipSandboxChannel API request.
func (r GetApnsVoipSandboxChannelRequest) Send(ctx context.Context) (*GetApnsVoipSandboxChannelResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetApnsVoipSandboxChannelResponse{
		GetApnsVoipSandboxChannelOutput: r.Request.Data.(*GetApnsVoipSandboxChannelOutput),
		response:                        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetApnsVoipSandboxChannelResponse is the response type for the
// GetApnsVoipSandboxChannel API operation.
type GetApnsVoipSandboxChannelResponse struct {
	*GetApnsVoipSandboxChannelOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetApnsVoipSandboxChannel request.
func (r *GetApnsVoipSandboxChannelResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
