// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package pinpointiface provides an interface to enable mocking the Amazon Pinpoint service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package pinpointiface

import (
	"github.com/aws/aws-sdk-go-v2/service/pinpoint"
)

// ClientAPI provides an interface to enable mocking the
// pinpoint.Client methods. This make unit testing your code that
// calls out to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // Amazon Pinpoint.
//    func myFunc(svc pinpointiface.ClientAPI) bool {
//        // Make svc.CreateApp request
//    }
//
//    func main() {
//        cfg, err := external.LoadDefaultAWSConfig()
//        if err != nil {
//            panic("failed to load config, " + err.Error())
//        }
//
//        svc := pinpoint.New(cfg)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockClientClient struct {
//        pinpointiface.ClientPI
//    }
//    func (m *mockClientClient) CreateApp(input *pinpoint.CreateAppInput) (*pinpoint.CreateAppOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockClientClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type ClientAPI interface {
	CreateAppRequest(*pinpoint.CreateAppInput) pinpoint.CreateAppRequest

	CreateCampaignRequest(*pinpoint.CreateCampaignInput) pinpoint.CreateCampaignRequest

	CreateEmailTemplateRequest(*pinpoint.CreateEmailTemplateInput) pinpoint.CreateEmailTemplateRequest

	CreateExportJobRequest(*pinpoint.CreateExportJobInput) pinpoint.CreateExportJobRequest

	CreateImportJobRequest(*pinpoint.CreateImportJobInput) pinpoint.CreateImportJobRequest

	CreateJourneyRequest(*pinpoint.CreateJourneyInput) pinpoint.CreateJourneyRequest

	CreatePushTemplateRequest(*pinpoint.CreatePushTemplateInput) pinpoint.CreatePushTemplateRequest

	CreateRecommenderConfigurationRequest(*pinpoint.CreateRecommenderConfigurationInput) pinpoint.CreateRecommenderConfigurationRequest

	CreateSegmentRequest(*pinpoint.CreateSegmentInput) pinpoint.CreateSegmentRequest

	CreateSmsTemplateRequest(*pinpoint.CreateSmsTemplateInput) pinpoint.CreateSmsTemplateRequest

	CreateVoiceTemplateRequest(*pinpoint.CreateVoiceTemplateInput) pinpoint.CreateVoiceTemplateRequest

	DeleteAdmChannelRequest(*pinpoint.DeleteAdmChannelInput) pinpoint.DeleteAdmChannelRequest

	DeleteApnsChannelRequest(*pinpoint.DeleteApnsChannelInput) pinpoint.DeleteApnsChannelRequest

	DeleteApnsSandboxChannelRequest(*pinpoint.DeleteApnsSandboxChannelInput) pinpoint.DeleteApnsSandboxChannelRequest

	DeleteApnsVoipChannelRequest(*pinpoint.DeleteApnsVoipChannelInput) pinpoint.DeleteApnsVoipChannelRequest

	DeleteApnsVoipSandboxChannelRequest(*pinpoint.DeleteApnsVoipSandboxChannelInput) pinpoint.DeleteApnsVoipSandboxChannelRequest

	DeleteAppRequest(*pinpoint.DeleteAppInput) pinpoint.DeleteAppRequest

	DeleteBaiduChannelRequest(*pinpoint.DeleteBaiduChannelInput) pinpoint.DeleteBaiduChannelRequest

	DeleteCampaignRequest(*pinpoint.DeleteCampaignInput) pinpoint.DeleteCampaignRequest

	DeleteEmailChannelRequest(*pinpoint.DeleteEmailChannelInput) pinpoint.DeleteEmailChannelRequest

	DeleteEmailTemplateRequest(*pinpoint.DeleteEmailTemplateInput) pinpoint.DeleteEmailTemplateRequest

	DeleteEndpointRequest(*pinpoint.DeleteEndpointInput) pinpoint.DeleteEndpointRequest

	DeleteEventStreamRequest(*pinpoint.DeleteEventStreamInput) pinpoint.DeleteEventStreamRequest

	DeleteGcmChannelRequest(*pinpoint.DeleteGcmChannelInput) pinpoint.DeleteGcmChannelRequest

	DeleteJourneyRequest(*pinpoint.DeleteJourneyInput) pinpoint.DeleteJourneyRequest

	DeletePushTemplateRequest(*pinpoint.DeletePushTemplateInput) pinpoint.DeletePushTemplateRequest

	DeleteRecommenderConfigurationRequest(*pinpoint.DeleteRecommenderConfigurationInput) pinpoint.DeleteRecommenderConfigurationRequest

	DeleteSegmentRequest(*pinpoint.DeleteSegmentInput) pinpoint.DeleteSegmentRequest

	DeleteSmsChannelRequest(*pinpoint.DeleteSmsChannelInput) pinpoint.DeleteSmsChannelRequest

	DeleteSmsTemplateRequest(*pinpoint.DeleteSmsTemplateInput) pinpoint.DeleteSmsTemplateRequest

	DeleteUserEndpointsRequest(*pinpoint.DeleteUserEndpointsInput) pinpoint.DeleteUserEndpointsRequest

	DeleteVoiceChannelRequest(*pinpoint.DeleteVoiceChannelInput) pinpoint.DeleteVoiceChannelRequest

	DeleteVoiceTemplateRequest(*pinpoint.DeleteVoiceTemplateInput) pinpoint.DeleteVoiceTemplateRequest

	GetAdmChannelRequest(*pinpoint.GetAdmChannelInput) pinpoint.GetAdmChannelRequest

	GetApnsChannelRequest(*pinpoint.GetApnsChannelInput) pinpoint.GetApnsChannelRequest

	GetApnsSandboxChannelRequest(*pinpoint.GetApnsSandboxChannelInput) pinpoint.GetApnsSandboxChannelRequest

	GetApnsVoipChannelRequest(*pinpoint.GetApnsVoipChannelInput) pinpoint.GetApnsVoipChannelRequest

	GetApnsVoipSandboxChannelRequest(*pinpoint.GetApnsVoipSandboxChannelInput) pinpoint.GetApnsVoipSandboxChannelRequest

	GetAppRequest(*pinpoint.GetAppInput) pinpoint.GetAppRequest

	GetApplicationDateRangeKpiRequest(*pinpoint.GetApplicationDateRangeKpiInput) pinpoint.GetApplicationDateRangeKpiRequest

	GetApplicationSettingsRequest(*pinpoint.GetApplicationSettingsInput) pinpoint.GetApplicationSettingsRequest

	GetAppsRequest(*pinpoint.GetAppsInput) pinpoint.GetAppsRequest

	GetBaiduChannelRequest(*pinpoint.GetBaiduChannelInput) pinpoint.GetBaiduChannelRequest

	GetCampaignRequest(*pinpoint.GetCampaignInput) pinpoint.GetCampaignRequest

	GetCampaignActivitiesRequest(*pinpoint.GetCampaignActivitiesInput) pinpoint.GetCampaignActivitiesRequest

	GetCampaignDateRangeKpiRequest(*pinpoint.GetCampaignDateRangeKpiInput) pinpoint.GetCampaignDateRangeKpiRequest

	GetCampaignVersionRequest(*pinpoint.GetCampaignVersionInput) pinpoint.GetCampaignVersionRequest

	GetCampaignVersionsRequest(*pinpoint.GetCampaignVersionsInput) pinpoint.GetCampaignVersionsRequest

	GetCampaignsRequest(*pinpoint.GetCampaignsInput) pinpoint.GetCampaignsRequest

	GetChannelsRequest(*pinpoint.GetChannelsInput) pinpoint.GetChannelsRequest

	GetEmailChannelRequest(*pinpoint.GetEmailChannelInput) pinpoint.GetEmailChannelRequest

	GetEmailTemplateRequest(*pinpoint.GetEmailTemplateInput) pinpoint.GetEmailTemplateRequest

	GetEndpointRequest(*pinpoint.GetEndpointInput) pinpoint.GetEndpointRequest

	GetEventStreamRequest(*pinpoint.GetEventStreamInput) pinpoint.GetEventStreamRequest

	GetExportJobRequest(*pinpoint.GetExportJobInput) pinpoint.GetExportJobRequest

	GetExportJobsRequest(*pinpoint.GetExportJobsInput) pinpoint.GetExportJobsRequest

	GetGcmChannelRequest(*pinpoint.GetGcmChannelInput) pinpoint.GetGcmChannelRequest

	GetImportJobRequest(*pinpoint.GetImportJobInput) pinpoint.GetImportJobRequest

	GetImportJobsRequest(*pinpoint.GetImportJobsInput) pinpoint.GetImportJobsRequest

	GetJourneyRequest(*pinpoint.GetJourneyInput) pinpoint.GetJourneyRequest

	GetJourneyDateRangeKpiRequest(*pinpoint.GetJourneyDateRangeKpiInput) pinpoint.GetJourneyDateRangeKpiRequest

	GetJourneyExecutionActivityMetricsRequest(*pinpoint.GetJourneyExecutionActivityMetricsInput) pinpoint.GetJourneyExecutionActivityMetricsRequest

	GetJourneyExecutionMetricsRequest(*pinpoint.GetJourneyExecutionMetricsInput) pinpoint.GetJourneyExecutionMetricsRequest

	GetPushTemplateRequest(*pinpoint.GetPushTemplateInput) pinpoint.GetPushTemplateRequest

	GetRecommenderConfigurationRequest(*pinpoint.GetRecommenderConfigurationInput) pinpoint.GetRecommenderConfigurationRequest

	GetRecommenderConfigurationsRequest(*pinpoint.GetRecommenderConfigurationsInput) pinpoint.GetRecommenderConfigurationsRequest

	GetSegmentRequest(*pinpoint.GetSegmentInput) pinpoint.GetSegmentRequest

	GetSegmentExportJobsRequest(*pinpoint.GetSegmentExportJobsInput) pinpoint.GetSegmentExportJobsRequest

	GetSegmentImportJobsRequest(*pinpoint.GetSegmentImportJobsInput) pinpoint.GetSegmentImportJobsRequest

	GetSegmentVersionRequest(*pinpoint.GetSegmentVersionInput) pinpoint.GetSegmentVersionRequest

	GetSegmentVersionsRequest(*pinpoint.GetSegmentVersionsInput) pinpoint.GetSegmentVersionsRequest

	GetSegmentsRequest(*pinpoint.GetSegmentsInput) pinpoint.GetSegmentsRequest

	GetSmsChannelRequest(*pinpoint.GetSmsChannelInput) pinpoint.GetSmsChannelRequest

	GetSmsTemplateRequest(*pinpoint.GetSmsTemplateInput) pinpoint.GetSmsTemplateRequest

	GetUserEndpointsRequest(*pinpoint.GetUserEndpointsInput) pinpoint.GetUserEndpointsRequest

	GetVoiceChannelRequest(*pinpoint.GetVoiceChannelInput) pinpoint.GetVoiceChannelRequest

	GetVoiceTemplateRequest(*pinpoint.GetVoiceTemplateInput) pinpoint.GetVoiceTemplateRequest

	ListJourneysRequest(*pinpoint.ListJourneysInput) pinpoint.ListJourneysRequest

	ListTagsForResourceRequest(*pinpoint.ListTagsForResourceInput) pinpoint.ListTagsForResourceRequest

	ListTemplateVersionsRequest(*pinpoint.ListTemplateVersionsInput) pinpoint.ListTemplateVersionsRequest

	ListTemplatesRequest(*pinpoint.ListTemplatesInput) pinpoint.ListTemplatesRequest

	PhoneNumberValidateRequest(*pinpoint.PhoneNumberValidateInput) pinpoint.PhoneNumberValidateRequest

	PutEventStreamRequest(*pinpoint.PutEventStreamInput) pinpoint.PutEventStreamRequest

	PutEventsRequest(*pinpoint.PutEventsInput) pinpoint.PutEventsRequest

	RemoveAttributesRequest(*pinpoint.RemoveAttributesInput) pinpoint.RemoveAttributesRequest

	SendMessagesRequest(*pinpoint.SendMessagesInput) pinpoint.SendMessagesRequest

	SendUsersMessagesRequest(*pinpoint.SendUsersMessagesInput) pinpoint.SendUsersMessagesRequest

	TagResourceRequest(*pinpoint.TagResourceInput) pinpoint.TagResourceRequest

	UntagResourceRequest(*pinpoint.UntagResourceInput) pinpoint.UntagResourceRequest

	UpdateAdmChannelRequest(*pinpoint.UpdateAdmChannelInput) pinpoint.UpdateAdmChannelRequest

	UpdateApnsChannelRequest(*pinpoint.UpdateApnsChannelInput) pinpoint.UpdateApnsChannelRequest

	UpdateApnsSandboxChannelRequest(*pinpoint.UpdateApnsSandboxChannelInput) pinpoint.UpdateApnsSandboxChannelRequest

	UpdateApnsVoipChannelRequest(*pinpoint.UpdateApnsVoipChannelInput) pinpoint.UpdateApnsVoipChannelRequest

	UpdateApnsVoipSandboxChannelRequest(*pinpoint.UpdateApnsVoipSandboxChannelInput) pinpoint.UpdateApnsVoipSandboxChannelRequest

	UpdateApplicationSettingsRequest(*pinpoint.UpdateApplicationSettingsInput) pinpoint.UpdateApplicationSettingsRequest

	UpdateBaiduChannelRequest(*pinpoint.UpdateBaiduChannelInput) pinpoint.UpdateBaiduChannelRequest

	UpdateCampaignRequest(*pinpoint.UpdateCampaignInput) pinpoint.UpdateCampaignRequest

	UpdateEmailChannelRequest(*pinpoint.UpdateEmailChannelInput) pinpoint.UpdateEmailChannelRequest

	UpdateEmailTemplateRequest(*pinpoint.UpdateEmailTemplateInput) pinpoint.UpdateEmailTemplateRequest

	UpdateEndpointRequest(*pinpoint.UpdateEndpointInput) pinpoint.UpdateEndpointRequest

	UpdateEndpointsBatchRequest(*pinpoint.UpdateEndpointsBatchInput) pinpoint.UpdateEndpointsBatchRequest

	UpdateGcmChannelRequest(*pinpoint.UpdateGcmChannelInput) pinpoint.UpdateGcmChannelRequest

	UpdateJourneyRequest(*pinpoint.UpdateJourneyInput) pinpoint.UpdateJourneyRequest

	UpdateJourneyStateRequest(*pinpoint.UpdateJourneyStateInput) pinpoint.UpdateJourneyStateRequest

	UpdatePushTemplateRequest(*pinpoint.UpdatePushTemplateInput) pinpoint.UpdatePushTemplateRequest

	UpdateRecommenderConfigurationRequest(*pinpoint.UpdateRecommenderConfigurationInput) pinpoint.UpdateRecommenderConfigurationRequest

	UpdateSegmentRequest(*pinpoint.UpdateSegmentInput) pinpoint.UpdateSegmentRequest

	UpdateSmsChannelRequest(*pinpoint.UpdateSmsChannelInput) pinpoint.UpdateSmsChannelRequest

	UpdateSmsTemplateRequest(*pinpoint.UpdateSmsTemplateInput) pinpoint.UpdateSmsTemplateRequest

	UpdateTemplateActiveVersionRequest(*pinpoint.UpdateTemplateActiveVersionInput) pinpoint.UpdateTemplateActiveVersionRequest

	UpdateVoiceChannelRequest(*pinpoint.UpdateVoiceChannelInput) pinpoint.UpdateVoiceChannelRequest

	UpdateVoiceTemplateRequest(*pinpoint.UpdateVoiceTemplateInput) pinpoint.UpdateVoiceTemplateRequest
}

var _ ClientAPI = (*pinpoint.Client)(nil)
