// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package qldbsession

import (
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

var _ aws.Config
var _ = awsutil.Prettify

// Contains the details of the transaction to abort.
type AbortTransactionRequest struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AbortTransactionRequest) String() string {
	return awsutil.Prettify(s)
}

// Contains the details of the aborted transaction.
type AbortTransactionResult struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AbortTransactionResult) String() string {
	return awsutil.Prettify(s)
}

// Contains the details of the transaction to commit.
type CommitTransactionRequest struct {
	_ struct{} `type:"structure"`

	// Specifies the commit digest for the transaction to commit. For every active
	// transaction, the commit digest must be passed. QLDB validates CommitDigest
	// and rejects the commit with an error if the digest computed on the client
	// does not match the digest computed by QLDB.
	//
	// CommitDigest is automatically base64 encoded/decoded by the SDK.
	//
	// CommitDigest is a required field
	CommitDigest []byte `type:"blob" required:"true"`

	// Specifies the transaction ID of the transaction to commit.
	//
	// TransactionId is a required field
	TransactionId *string `min:"22" type:"string" required:"true"`
}

// String returns the string representation
func (s CommitTransactionRequest) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CommitTransactionRequest) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CommitTransactionRequest"}

	if s.CommitDigest == nil {
		invalidParams.Add(aws.NewErrParamRequired("CommitDigest"))
	}

	if s.TransactionId == nil {
		invalidParams.Add(aws.NewErrParamRequired("TransactionId"))
	}
	if s.TransactionId != nil && len(*s.TransactionId) < 22 {
		invalidParams.Add(aws.NewErrParamMinLen("TransactionId", 22))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the details of the committed transaction.
type CommitTransactionResult struct {
	_ struct{} `type:"structure"`

	// The commit digest of the committed transaction.
	//
	// CommitDigest is automatically base64 encoded/decoded by the SDK.
	CommitDigest []byte `type:"blob"`

	// The transaction ID of the committed transaction.
	TransactionId *string `min:"22" type:"string"`
}

// String returns the string representation
func (s CommitTransactionResult) String() string {
	return awsutil.Prettify(s)
}

// Specifies a request to end the session.
type EndSessionRequest struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s EndSessionRequest) String() string {
	return awsutil.Prettify(s)
}

// Contains the details of the ended session.
type EndSessionResult struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s EndSessionResult) String() string {
	return awsutil.Prettify(s)
}

// Specifies a request to execute a statement.
type ExecuteStatementRequest struct {
	_ struct{} `type:"structure"`

	// Specifies the parameters for the parameterized statement in the request.
	Parameters []ValueHolder `type:"list"`

	// Specifies the statement of the request.
	//
	// Statement is a required field
	Statement *string `min:"1" type:"string" required:"true"`

	// Specifies the transaction ID of the request.
	//
	// TransactionId is a required field
	TransactionId *string `min:"22" type:"string" required:"true"`
}

// String returns the string representation
func (s ExecuteStatementRequest) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExecuteStatementRequest) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ExecuteStatementRequest"}

	if s.Statement == nil {
		invalidParams.Add(aws.NewErrParamRequired("Statement"))
	}
	if s.Statement != nil && len(*s.Statement) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Statement", 1))
	}

	if s.TransactionId == nil {
		invalidParams.Add(aws.NewErrParamRequired("TransactionId"))
	}
	if s.TransactionId != nil && len(*s.TransactionId) < 22 {
		invalidParams.Add(aws.NewErrParamMinLen("TransactionId", 22))
	}
	if s.Parameters != nil {
		for i, v := range s.Parameters {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Parameters", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the details of the executed statement.
type ExecuteStatementResult struct {
	_ struct{} `type:"structure"`

	// Contains the details of the first fetched page.
	FirstPage *Page `type:"structure"`
}

// String returns the string representation
func (s ExecuteStatementResult) String() string {
	return awsutil.Prettify(s)
}

// Specifies the details of the page to be fetched.
type FetchPageRequest struct {
	_ struct{} `type:"structure"`

	// Specifies the next page token of the page to be fetched.
	//
	// NextPageToken is a required field
	NextPageToken *string `min:"4" type:"string" required:"true"`

	// Specifies the transaction ID of the page to be fetched.
	//
	// TransactionId is a required field
	TransactionId *string `min:"22" type:"string" required:"true"`
}

// String returns the string representation
func (s FetchPageRequest) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FetchPageRequest) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "FetchPageRequest"}

	if s.NextPageToken == nil {
		invalidParams.Add(aws.NewErrParamRequired("NextPageToken"))
	}
	if s.NextPageToken != nil && len(*s.NextPageToken) < 4 {
		invalidParams.Add(aws.NewErrParamMinLen("NextPageToken", 4))
	}

	if s.TransactionId == nil {
		invalidParams.Add(aws.NewErrParamRequired("TransactionId"))
	}
	if s.TransactionId != nil && len(*s.TransactionId) < 22 {
		invalidParams.Add(aws.NewErrParamMinLen("TransactionId", 22))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the page that was fetched.
type FetchPageResult struct {
	_ struct{} `type:"structure"`

	// Contains details of the fetched page.
	Page *Page `type:"structure"`
}

// String returns the string representation
func (s FetchPageResult) String() string {
	return awsutil.Prettify(s)
}

// Contains details of the fetched page.
type Page struct {
	_ struct{} `type:"structure"`

	// The token of the next page.
	NextPageToken *string `min:"4" type:"string"`

	// A structure that contains values in multiple encoding formats.
	Values []ValueHolder `type:"list"`
}

// String returns the string representation
func (s Page) String() string {
	return awsutil.Prettify(s)
}

// Specifies a request to start a new session.
type StartSessionRequest struct {
	_ struct{} `type:"structure"`

	// The name of the ledger to start a new session against.
	//
	// LedgerName is a required field
	LedgerName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StartSessionRequest) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartSessionRequest) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StartSessionRequest"}

	if s.LedgerName == nil {
		invalidParams.Add(aws.NewErrParamRequired("LedgerName"))
	}
	if s.LedgerName != nil && len(*s.LedgerName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("LedgerName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the details of the started session.
type StartSessionResult struct {
	_ struct{} `type:"structure"`

	// Session token of the started session. This SessionToken is required for every
	// subsequent command that is issued during the current session.
	SessionToken *string `min:"4" type:"string"`
}

// String returns the string representation
func (s StartSessionResult) String() string {
	return awsutil.Prettify(s)
}

// Specifies a request to start a transaction.
type StartTransactionRequest struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s StartTransactionRequest) String() string {
	return awsutil.Prettify(s)
}

// Contains the details of the started transaction.
type StartTransactionResult struct {
	_ struct{} `type:"structure"`

	// The transaction ID of the started transaction.
	TransactionId *string `min:"22" type:"string"`
}

// String returns the string representation
func (s StartTransactionResult) String() string {
	return awsutil.Prettify(s)
}

// A structure that can contain an Amazon Ion value in multiple encoding formats.
type ValueHolder struct {
	_ struct{} `type:"structure"`

	// An Amazon Ion binary value contained in a ValueHolder structure.
	//
	// IonBinary is automatically base64 encoded/decoded by the SDK.
	IonBinary []byte `min:"1" type:"blob"`

	// An Amazon Ion plaintext value contained in a ValueHolder structure.
	IonText *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ValueHolder) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ValueHolder) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ValueHolder"}
	if s.IonBinary != nil && len(s.IonBinary) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("IonBinary", 1))
	}
	if s.IonText != nil && len(*s.IonText) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("IonText", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}
