// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package quicksight

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DeleteThemeInput struct {
	_ struct{} `type:"structure"`

	// The ID of the AWS account that contains the theme that you're deleting.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// An ID for the theme that you want to delete.
	//
	// ThemeId is a required field
	ThemeId *string `location:"uri" locationName:"ThemeId" min:"1" type:"string" required:"true"`

	// The version of the theme that you want to delete.
	//
	// Note: If you don't provide a version number, you're using this call to DeleteTheme
	// to delete all versions of the theme.
	VersionNumber *int64 `location:"querystring" locationName:"version-number" min:"1" type:"long"`
}

// String returns the string representation
func (s DeleteThemeInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteThemeInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteThemeInput"}

	if s.AwsAccountId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(aws.NewErrParamMinLen("AwsAccountId", 12))
	}

	if s.ThemeId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ThemeId"))
	}
	if s.ThemeId != nil && len(*s.ThemeId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ThemeId", 1))
	}
	if s.VersionNumber != nil && *s.VersionNumber < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("VersionNumber", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteThemeInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.AwsAccountId != nil {
		v := *s.AwsAccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "AwsAccountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ThemeId != nil {
		v := *s.ThemeId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "ThemeId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.VersionNumber != nil {
		v := *s.VersionNumber

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "version-number", protocol.Int64Value(v), metadata)
	}
	return nil
}

type DeleteThemeOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource.
	Arn *string `type:"string"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`

	// An ID for the theme.
	ThemeId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DeleteThemeOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteThemeOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RequestId != nil {
		v := *s.RequestId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RequestId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ThemeId != nil {
		v := *s.ThemeId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ThemeId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	// ignoring invalid encode state, StatusCode. Status
	return nil
}

const opDeleteTheme = "DeleteTheme"

// DeleteThemeRequest returns a request value for making API operation for
// Amazon QuickSight.
//
// Deletes a theme.
//
//    // Example sending a request using DeleteThemeRequest.
//    req := client.DeleteThemeRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteTheme
func (c *Client) DeleteThemeRequest(input *DeleteThemeInput) DeleteThemeRequest {
	op := &aws.Operation{
		Name:       opDeleteTheme,
		HTTPMethod: "DELETE",
		HTTPPath:   "/accounts/{AwsAccountId}/themes/{ThemeId}",
	}

	if input == nil {
		input = &DeleteThemeInput{}
	}

	req := c.newRequest(op, input, &DeleteThemeOutput{})

	return DeleteThemeRequest{Request: req, Input: input, Copy: c.DeleteThemeRequest}
}

// DeleteThemeRequest is the request type for the
// DeleteTheme API operation.
type DeleteThemeRequest struct {
	*aws.Request
	Input *DeleteThemeInput
	Copy  func(*DeleteThemeInput) DeleteThemeRequest
}

// Send marshals and sends the DeleteTheme API request.
func (r DeleteThemeRequest) Send(ctx context.Context) (*DeleteThemeResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteThemeResponse{
		DeleteThemeOutput: r.Request.Data.(*DeleteThemeOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteThemeResponse is the response type for the
// DeleteTheme API operation.
type DeleteThemeResponse struct {
	*DeleteThemeOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteTheme request.
func (r *DeleteThemeResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
