// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package quicksight

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DescribeDataSourcePermissionsInput struct {
	_ struct{} `type:"structure"`

	// The AWS account ID.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The ID of the data source. This ID is unique per AWS Region for each AWS
	// account.
	//
	// DataSourceId is a required field
	DataSourceId *string `location:"uri" locationName:"DataSourceId" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeDataSourcePermissionsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDataSourcePermissionsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeDataSourcePermissionsInput"}

	if s.AwsAccountId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(aws.NewErrParamMinLen("AwsAccountId", 12))
	}

	if s.DataSourceId == nil {
		invalidParams.Add(aws.NewErrParamRequired("DataSourceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeDataSourcePermissionsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.AwsAccountId != nil {
		v := *s.AwsAccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "AwsAccountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DataSourceId != nil {
		v := *s.DataSourceId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "DataSourceId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DescribeDataSourcePermissionsOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the data source.
	DataSourceArn *string `type:"string"`

	// The ID of the data source. This ID is unique per AWS Region for each AWS
	// account.
	DataSourceId *string `type:"string"`

	// A list of resource permissions on the data source.
	Permissions []ResourcePermission `min:"1" type:"list"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation
func (s DescribeDataSourcePermissionsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeDataSourcePermissionsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.DataSourceArn != nil {
		v := *s.DataSourceArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DataSourceArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DataSourceId != nil {
		v := *s.DataSourceId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DataSourceId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Permissions != nil {
		v := s.Permissions

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Permissions", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.RequestId != nil {
		v := *s.RequestId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RequestId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	// ignoring invalid encode state, StatusCode. Status
	return nil
}

const opDescribeDataSourcePermissions = "DescribeDataSourcePermissions"

// DescribeDataSourcePermissionsRequest returns a request value for making API operation for
// Amazon QuickSight.
//
// Describes the resource permissions for a data source.
//
//    // Example sending a request using DescribeDataSourcePermissionsRequest.
//    req := client.DescribeDataSourcePermissionsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDataSourcePermissions
func (c *Client) DescribeDataSourcePermissionsRequest(input *DescribeDataSourcePermissionsInput) DescribeDataSourcePermissionsRequest {
	op := &aws.Operation{
		Name:       opDescribeDataSourcePermissions,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/data-sources/{DataSourceId}/permissions",
	}

	if input == nil {
		input = &DescribeDataSourcePermissionsInput{}
	}

	req := c.newRequest(op, input, &DescribeDataSourcePermissionsOutput{})

	return DescribeDataSourcePermissionsRequest{Request: req, Input: input, Copy: c.DescribeDataSourcePermissionsRequest}
}

// DescribeDataSourcePermissionsRequest is the request type for the
// DescribeDataSourcePermissions API operation.
type DescribeDataSourcePermissionsRequest struct {
	*aws.Request
	Input *DescribeDataSourcePermissionsInput
	Copy  func(*DescribeDataSourcePermissionsInput) DescribeDataSourcePermissionsRequest
}

// Send marshals and sends the DescribeDataSourcePermissions API request.
func (r DescribeDataSourcePermissionsRequest) Send(ctx context.Context) (*DescribeDataSourcePermissionsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeDataSourcePermissionsResponse{
		DescribeDataSourcePermissionsOutput: r.Request.Data.(*DescribeDataSourcePermissionsOutput),
		response:                            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeDataSourcePermissionsResponse is the response type for the
// DescribeDataSourcePermissions API operation.
type DescribeDataSourcePermissionsResponse struct {
	*DescribeDataSourcePermissionsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeDataSourcePermissions request.
func (r *DescribeDataSourcePermissionsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
