// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package quicksight

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type ListTemplatesInput struct {
	_ struct{} `type:"structure"`

	// The ID of the AWS account that contains the templates that you're listing.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The maximum number of results to be returned per request.
	MaxResults *int64 `location:"querystring" locationName:"max-result" min:"1" type:"integer"`

	// The token for the next set of results, or null if there are no more results.
	NextToken *string `location:"querystring" locationName:"next-token" type:"string"`
}

// String returns the string representation
func (s ListTemplatesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTemplatesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListTemplatesInput"}

	if s.AwsAccountId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(aws.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListTemplatesInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.AwsAccountId != nil {
		v := *s.AwsAccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "AwsAccountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "max-result", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "next-token", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type ListTemplatesOutput struct {
	_ struct{} `type:"structure"`

	// The token for the next set of results, or null if there are no more results.
	NextToken *string `type:"string"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`

	// A structure containing information about the templates in the list.
	TemplateSummaryList []TemplateSummary `type:"list"`
}

// String returns the string representation
func (s ListTemplatesOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListTemplatesOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RequestId != nil {
		v := *s.RequestId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RequestId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.TemplateSummaryList != nil {
		v := s.TemplateSummaryList

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "TemplateSummaryList", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	// ignoring invalid encode state, StatusCode. Status
	return nil
}

const opListTemplates = "ListTemplates"

// ListTemplatesRequest returns a request value for making API operation for
// Amazon QuickSight.
//
// Lists all the templates in the current Amazon QuickSight account.
//
//    // Example sending a request using ListTemplatesRequest.
//    req := client.ListTemplatesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListTemplates
func (c *Client) ListTemplatesRequest(input *ListTemplatesInput) ListTemplatesRequest {
	op := &aws.Operation{
		Name:       opListTemplates,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/templates",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTemplatesInput{}
	}

	req := c.newRequest(op, input, &ListTemplatesOutput{})

	return ListTemplatesRequest{Request: req, Input: input, Copy: c.ListTemplatesRequest}
}

// ListTemplatesRequest is the request type for the
// ListTemplates API operation.
type ListTemplatesRequest struct {
	*aws.Request
	Input *ListTemplatesInput
	Copy  func(*ListTemplatesInput) ListTemplatesRequest
}

// Send marshals and sends the ListTemplates API request.
func (r ListTemplatesRequest) Send(ctx context.Context) (*ListTemplatesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListTemplatesResponse{
		ListTemplatesOutput: r.Request.Data.(*ListTemplatesOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListTemplatesRequestPaginator returns a paginator for ListTemplates.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListTemplatesRequest(input)
//   p := quicksight.NewListTemplatesRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListTemplatesPaginator(req ListTemplatesRequest) ListTemplatesPaginator {
	return ListTemplatesPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListTemplatesInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListTemplatesPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListTemplatesPaginator struct {
	aws.Pager
}

func (p *ListTemplatesPaginator) CurrentPage() *ListTemplatesOutput {
	return p.Pager.CurrentPage().(*ListTemplatesOutput)
}

// ListTemplatesResponse is the response type for the
// ListTemplates API operation.
type ListTemplatesResponse struct {
	*ListTemplatesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListTemplates request.
func (r *ListTemplatesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
