// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package quicksight

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type UpdateDashboardInput struct {
	_ struct{} `type:"structure"`

	// The ID of the AWS account that contains the dashboard that you're updating.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The ID for the dashboard.
	//
	// DashboardId is a required field
	DashboardId *string `location:"uri" locationName:"DashboardId" min:"1" type:"string" required:"true"`

	// Options for publishing the dashboard when you create it:
	//
	//    * AvailabilityStatus for AdHocFilteringOption - This status can be either
	//    ENABLED or DISABLED. When this is set to DISABLED, QuickSight disables
	//    the left filter pane on the published dashboard, which can be used for
	//    ad hoc (one-time) filtering. This option is ENABLED by default.
	//
	//    * AvailabilityStatus for ExportToCSVOption - This status can be either
	//    ENABLED or DISABLED. The visual option to export data to .csv format isn't
	//    enabled when this is set to DISABLED. This option is ENABLED by default.
	//
	//    * VisibilityState for SheetControlsOption - This visibility state can
	//    be either COLLAPSED or EXPANDED. This option is COLLAPSED by default.
	DashboardPublishOptions *DashboardPublishOptions `type:"structure"`

	// The display name of the dashboard.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// A structure that contains the parameters of the dashboard. These are parameter
	// overrides for a dashboard. A dashboard can have any type of parameters, and
	// some parameters might accept multiple values.
	Parameters *Parameters `type:"structure"`

	// The entity that you are using as a source when you update the dashboard.
	// In SourceEntity, you specify the type of object you're using as source. You
	// can only update a dashboard from a template, so you use a SourceTemplate
	// entity. If you need to update a dashboard from an analysis, first convert
	// the analysis to a template by using the CreateTemplate API operation. For
	// SourceTemplate, specify the Amazon Resource Name (ARN) of the source template.
	// The SourceTemplate ARN can contain any AWS Account and any QuickSight-supported
	// AWS Region.
	//
	// Use the DataSetReferences entity within SourceTemplate to list the replacement
	// datasets for the placeholders listed in the original. The schema in each
	// dataset must match its placeholder.
	//
	// SourceEntity is a required field
	SourceEntity *DashboardSourceEntity `type:"structure" required:"true"`

	// The Amazon Resource Name (ARN) of the theme that is being used for this dashboard.
	// If you add a value for this field, it overrides the value that was originally
	// associated with the entity. The theme ARN must exist in the same AWS account
	// where you create the dashboard.
	ThemeArn *string `type:"string"`

	// A description for the first version of the dashboard being created.
	VersionDescription *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateDashboardInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDashboardInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateDashboardInput"}

	if s.AwsAccountId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(aws.NewErrParamMinLen("AwsAccountId", 12))
	}

	if s.DashboardId == nil {
		invalidParams.Add(aws.NewErrParamRequired("DashboardId"))
	}
	if s.DashboardId != nil && len(*s.DashboardId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DashboardId", 1))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if s.SourceEntity == nil {
		invalidParams.Add(aws.NewErrParamRequired("SourceEntity"))
	}
	if s.VersionDescription != nil && len(*s.VersionDescription) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("VersionDescription", 1))
	}
	if s.Parameters != nil {
		if err := s.Parameters.Validate(); err != nil {
			invalidParams.AddNested("Parameters", err.(aws.ErrInvalidParams))
		}
	}
	if s.SourceEntity != nil {
		if err := s.SourceEntity.Validate(); err != nil {
			invalidParams.AddNested("SourceEntity", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateDashboardInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.DashboardPublishOptions != nil {
		v := s.DashboardPublishOptions

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "DashboardPublishOptions", v, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Parameters != nil {
		v := s.Parameters

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Parameters", v, metadata)
	}
	if s.SourceEntity != nil {
		v := s.SourceEntity

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "SourceEntity", v, metadata)
	}
	if s.ThemeArn != nil {
		v := *s.ThemeArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ThemeArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.VersionDescription != nil {
		v := *s.VersionDescription

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "VersionDescription", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.AwsAccountId != nil {
		v := *s.AwsAccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "AwsAccountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DashboardId != nil {
		v := *s.DashboardId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "DashboardId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type UpdateDashboardOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource.
	Arn *string `type:"string"`

	// The creation status of the request.
	CreationStatus ResourceStatus `type:"string" enum:"true"`

	// The ID for the dashboard.
	DashboardId *string `min:"1" type:"string"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `type:"integer"`

	// The ARN of the dashboard, including the version number.
	VersionArn *string `type:"string"`
}

// String returns the string representation
func (s UpdateDashboardOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateDashboardOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.CreationStatus) > 0 {
		v := s.CreationStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreationStatus", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.DashboardId != nil {
		v := *s.DashboardId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DashboardId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RequestId != nil {
		v := *s.RequestId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RequestId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Status != nil {
		v := *s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Status", protocol.Int64Value(v), metadata)
	}
	if s.VersionArn != nil {
		v := *s.VersionArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "VersionArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opUpdateDashboard = "UpdateDashboard"

// UpdateDashboardRequest returns a request value for making API operation for
// Amazon QuickSight.
//
// Updates a dashboard in an AWS account.
//
//    // Example sending a request using UpdateDashboardRequest.
//    req := client.UpdateDashboardRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateDashboard
func (c *Client) UpdateDashboardRequest(input *UpdateDashboardInput) UpdateDashboardRequest {
	op := &aws.Operation{
		Name:       opUpdateDashboard,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{AwsAccountId}/dashboards/{DashboardId}",
	}

	if input == nil {
		input = &UpdateDashboardInput{}
	}

	req := c.newRequest(op, input, &UpdateDashboardOutput{})

	return UpdateDashboardRequest{Request: req, Input: input, Copy: c.UpdateDashboardRequest}
}

// UpdateDashboardRequest is the request type for the
// UpdateDashboard API operation.
type UpdateDashboardRequest struct {
	*aws.Request
	Input *UpdateDashboardInput
	Copy  func(*UpdateDashboardInput) UpdateDashboardRequest
}

// Send marshals and sends the UpdateDashboard API request.
func (r UpdateDashboardRequest) Send(ctx context.Context) (*UpdateDashboardResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateDashboardResponse{
		UpdateDashboardOutput: r.Request.Data.(*UpdateDashboardOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateDashboardResponse is the response type for the
// UpdateDashboard API operation.
type UpdateDashboardResponse struct {
	*UpdateDashboardOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateDashboard request.
func (r *UpdateDashboardResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
