// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package quicksight

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type UpdateDataSourcePermissionsInput struct {
	_ struct{} `type:"structure"`

	// The AWS account ID.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The ID of the data source. This ID is unique per AWS Region for each AWS
	// account.
	//
	// DataSourceId is a required field
	DataSourceId *string `location:"uri" locationName:"DataSourceId" type:"string" required:"true"`

	// A list of resource permissions that you want to grant on the data source.
	GrantPermissions []ResourcePermission `min:"1" type:"list"`

	// A list of resource permissions that you want to revoke on the data source.
	RevokePermissions []ResourcePermission `min:"1" type:"list"`
}

// String returns the string representation
func (s UpdateDataSourcePermissionsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDataSourcePermissionsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateDataSourcePermissionsInput"}

	if s.AwsAccountId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(aws.NewErrParamMinLen("AwsAccountId", 12))
	}

	if s.DataSourceId == nil {
		invalidParams.Add(aws.NewErrParamRequired("DataSourceId"))
	}
	if s.GrantPermissions != nil && len(s.GrantPermissions) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("GrantPermissions", 1))
	}
	if s.RevokePermissions != nil && len(s.RevokePermissions) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("RevokePermissions", 1))
	}
	if s.GrantPermissions != nil {
		for i, v := range s.GrantPermissions {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "GrantPermissions", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.RevokePermissions != nil {
		for i, v := range s.RevokePermissions {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "RevokePermissions", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateDataSourcePermissionsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.GrantPermissions != nil {
		v := s.GrantPermissions

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "GrantPermissions", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.RevokePermissions != nil {
		v := s.RevokePermissions

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "RevokePermissions", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.AwsAccountId != nil {
		v := *s.AwsAccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "AwsAccountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DataSourceId != nil {
		v := *s.DataSourceId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "DataSourceId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type UpdateDataSourcePermissionsOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the data source.
	DataSourceArn *string `type:"string"`

	// The ID of the data source. This ID is unique per AWS Region for each AWS
	// account.
	DataSourceId *string `type:"string"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation
func (s UpdateDataSourcePermissionsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateDataSourcePermissionsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.DataSourceArn != nil {
		v := *s.DataSourceArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DataSourceArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DataSourceId != nil {
		v := *s.DataSourceId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DataSourceId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RequestId != nil {
		v := *s.RequestId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RequestId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	// ignoring invalid encode state, StatusCode. Status
	return nil
}

const opUpdateDataSourcePermissions = "UpdateDataSourcePermissions"

// UpdateDataSourcePermissionsRequest returns a request value for making API operation for
// Amazon QuickSight.
//
// Updates the permissions to a data source.
//
//    // Example sending a request using UpdateDataSourcePermissionsRequest.
//    req := client.UpdateDataSourcePermissionsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateDataSourcePermissions
func (c *Client) UpdateDataSourcePermissionsRequest(input *UpdateDataSourcePermissionsInput) UpdateDataSourcePermissionsRequest {
	op := &aws.Operation{
		Name:       opUpdateDataSourcePermissions,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{AwsAccountId}/data-sources/{DataSourceId}/permissions",
	}

	if input == nil {
		input = &UpdateDataSourcePermissionsInput{}
	}

	req := c.newRequest(op, input, &UpdateDataSourcePermissionsOutput{})

	return UpdateDataSourcePermissionsRequest{Request: req, Input: input, Copy: c.UpdateDataSourcePermissionsRequest}
}

// UpdateDataSourcePermissionsRequest is the request type for the
// UpdateDataSourcePermissions API operation.
type UpdateDataSourcePermissionsRequest struct {
	*aws.Request
	Input *UpdateDataSourcePermissionsInput
	Copy  func(*UpdateDataSourcePermissionsInput) UpdateDataSourcePermissionsRequest
}

// Send marshals and sends the UpdateDataSourcePermissions API request.
func (r UpdateDataSourcePermissionsRequest) Send(ctx context.Context) (*UpdateDataSourcePermissionsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateDataSourcePermissionsResponse{
		UpdateDataSourcePermissionsOutput: r.Request.Data.(*UpdateDataSourcePermissionsOutput),
		response:                          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateDataSourcePermissionsResponse is the response type for the
// UpdateDataSourcePermissions API operation.
type UpdateDataSourcePermissionsResponse struct {
	*UpdateDataSourcePermissionsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateDataSourcePermissions request.
func (r *UpdateDataSourcePermissionsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
