// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package rds

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type RegisterDBProxyTargetsInput struct {
	_ struct{} `type:"structure"`

	// One or more DB cluster identifiers.
	DBClusterIdentifiers []string `type:"list"`

	// One or more DB instance identifiers.
	DBInstanceIdentifiers []string `type:"list"`

	// The identifier of the DBProxy that is associated with the DBProxyTargetGroup.
	//
	// DBProxyName is a required field
	DBProxyName *string `type:"string" required:"true"`

	// The identifier of the DBProxyTargetGroup.
	TargetGroupName *string `type:"string"`
}

// String returns the string representation
func (s RegisterDBProxyTargetsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RegisterDBProxyTargetsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RegisterDBProxyTargetsInput"}

	if s.DBProxyName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DBProxyName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type RegisterDBProxyTargetsOutput struct {
	_ struct{} `type:"structure"`

	// One or more DBProxyTarget objects that are created when you register targets
	// with a target group.
	DBProxyTargets []DBProxyTarget `type:"list"`
}

// String returns the string representation
func (s RegisterDBProxyTargetsOutput) String() string {
	return awsutil.Prettify(s)
}

const opRegisterDBProxyTargets = "RegisterDBProxyTargets"

// RegisterDBProxyTargetsRequest returns a request value for making API operation for
// Amazon Relational Database Service.
//
// Associate one or more DBProxyTarget data structures with a DBProxyTargetGroup.
//
//    // Example sending a request using RegisterDBProxyTargetsRequest.
//    req := client.RegisterDBProxyTargetsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/RegisterDBProxyTargets
func (c *Client) RegisterDBProxyTargetsRequest(input *RegisterDBProxyTargetsInput) RegisterDBProxyTargetsRequest {
	op := &aws.Operation{
		Name:       opRegisterDBProxyTargets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RegisterDBProxyTargetsInput{}
	}

	req := c.newRequest(op, input, &RegisterDBProxyTargetsOutput{})

	return RegisterDBProxyTargetsRequest{Request: req, Input: input, Copy: c.RegisterDBProxyTargetsRequest}
}

// RegisterDBProxyTargetsRequest is the request type for the
// RegisterDBProxyTargets API operation.
type RegisterDBProxyTargetsRequest struct {
	*aws.Request
	Input *RegisterDBProxyTargetsInput
	Copy  func(*RegisterDBProxyTargetsInput) RegisterDBProxyTargetsRequest
}

// Send marshals and sends the RegisterDBProxyTargets API request.
func (r RegisterDBProxyTargetsRequest) Send(ctx context.Context) (*RegisterDBProxyTargetsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &RegisterDBProxyTargetsResponse{
		RegisterDBProxyTargetsOutput: r.Request.Data.(*RegisterDBProxyTargetsOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// RegisterDBProxyTargetsResponse is the response type for the
// RegisterDBProxyTargets API operation.
type RegisterDBProxyTargetsResponse struct {
	*RegisterDBProxyTargetsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// RegisterDBProxyTargets request.
func (r *RegisterDBProxyTargetsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
