// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package redshift

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/query"
)

type DeleteUsageLimitInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the usage limit to delete.
	//
	// UsageLimitId is a required field
	UsageLimitId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteUsageLimitInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteUsageLimitInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteUsageLimitInput"}

	if s.UsageLimitId == nil {
		invalidParams.Add(aws.NewErrParamRequired("UsageLimitId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteUsageLimitOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteUsageLimitOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteUsageLimit = "DeleteUsageLimit"

// DeleteUsageLimitRequest returns a request value for making API operation for
// Amazon Redshift.
//
// Deletes a usage limit from a cluster.
//
//    // Example sending a request using DeleteUsageLimitRequest.
//    req := client.DeleteUsageLimitRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteUsageLimit
func (c *Client) DeleteUsageLimitRequest(input *DeleteUsageLimitInput) DeleteUsageLimitRequest {
	op := &aws.Operation{
		Name:       opDeleteUsageLimit,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteUsageLimitInput{}
	}

	req := c.newRequest(op, input, &DeleteUsageLimitOutput{})
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)

	return DeleteUsageLimitRequest{Request: req, Input: input, Copy: c.DeleteUsageLimitRequest}
}

// DeleteUsageLimitRequest is the request type for the
// DeleteUsageLimit API operation.
type DeleteUsageLimitRequest struct {
	*aws.Request
	Input *DeleteUsageLimitInput
	Copy  func(*DeleteUsageLimitInput) DeleteUsageLimitRequest
}

// Send marshals and sends the DeleteUsageLimit API request.
func (r DeleteUsageLimitRequest) Send(ctx context.Context) (*DeleteUsageLimitResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteUsageLimitResponse{
		DeleteUsageLimitOutput: r.Request.Data.(*DeleteUsageLimitOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteUsageLimitResponse is the response type for the
// DeleteUsageLimit API operation.
type DeleteUsageLimitResponse struct {
	*DeleteUsageLimitOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteUsageLimit request.
func (r *DeleteUsageLimitResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
