// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package redshift

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeClusterSecurityGroupsInput struct {
	_ struct{} `type:"structure"`

	// The name of a cluster security group for which you are requesting details.
	// You can specify either the Marker parameter or a ClusterSecurityGroupName
	// parameter, but not both.
	//
	// Example: securitygroup1
	ClusterSecurityGroupName *string `type:"string"`

	// An optional parameter that specifies the starting point to return a set of
	// response records. When the results of a DescribeClusterSecurityGroups request
	// exceed the value specified in MaxRecords, AWS returns a value in the Marker
	// field of the response. You can retrieve the next set of response records
	// by providing the returned marker value in the Marker parameter and retrying
	// the request.
	//
	// Constraints: You can specify either the ClusterSecurityGroupName parameter
	// or the Marker parameter, but not both.
	Marker *string `type:"string"`

	// The maximum number of response records to return in each call. If the number
	// of remaining response records exceeds the specified MaxRecords value, a value
	// is returned in a marker field of the response. You can retrieve the next
	// set of records by retrying the command with the returned marker value.
	//
	// Default: 100
	//
	// Constraints: minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// A tag key or keys for which you want to return all matching cluster security
	// groups that are associated with the specified key or keys. For example, suppose
	// that you have security groups that are tagged with keys called owner and
	// environment. If you specify both of these tag keys in the request, Amazon
	// Redshift returns a response with the security groups that have either or
	// both of these tag keys associated with them.
	TagKeys []string `locationNameList:"TagKey" type:"list"`

	// A tag value or values for which you want to return all matching cluster security
	// groups that are associated with the specified tag value or values. For example,
	// suppose that you have security groups that are tagged with values called
	// admin and test. If you specify both of these tag values in the request, Amazon
	// Redshift returns a response with the security groups that have either or
	// both of these tag values associated with them.
	TagValues []string `locationNameList:"TagValue" type:"list"`
}

// String returns the string representation
func (s DescribeClusterSecurityGroupsInput) String() string {
	return awsutil.Prettify(s)
}

type DescribeClusterSecurityGroupsOutput struct {
	_ struct{} `type:"structure"`

	// A list of ClusterSecurityGroup instances.
	ClusterSecurityGroups []ClusterSecurityGroup `locationNameList:"ClusterSecurityGroup" type:"list"`

	// A value that indicates the starting point for the next set of response records
	// in a subsequent request. If a value is returned in a response, you can retrieve
	// the next set of records by providing this returned marker value in the Marker
	// parameter and retrying the command. If the Marker field is empty, all response
	// records have been retrieved for the request.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeClusterSecurityGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeClusterSecurityGroups = "DescribeClusterSecurityGroups"

// DescribeClusterSecurityGroupsRequest returns a request value for making API operation for
// Amazon Redshift.
//
// Returns information about Amazon Redshift security groups. If the name of
// a security group is specified, the response will contain only information
// about only that security group.
//
// For information about managing security groups, go to Amazon Redshift Cluster
// Security Groups (https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-security-groups.html)
// in the Amazon Redshift Cluster Management Guide.
//
// If you specify both tag keys and tag values in the same request, Amazon Redshift
// returns all security groups that match any combination of the specified keys
// and values. For example, if you have owner and environment for tag keys,
// and admin and test for tag values, all security groups that have any combination
// of those values are returned.
//
// If both tag keys and values are omitted from the request, security groups
// are returned regardless of whether they have tag keys or values associated
// with them.
//
//    // Example sending a request using DescribeClusterSecurityGroupsRequest.
//    req := client.DescribeClusterSecurityGroupsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterSecurityGroups
func (c *Client) DescribeClusterSecurityGroupsRequest(input *DescribeClusterSecurityGroupsInput) DescribeClusterSecurityGroupsRequest {
	op := &aws.Operation{
		Name:       opDescribeClusterSecurityGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeClusterSecurityGroupsInput{}
	}

	req := c.newRequest(op, input, &DescribeClusterSecurityGroupsOutput{})

	return DescribeClusterSecurityGroupsRequest{Request: req, Input: input, Copy: c.DescribeClusterSecurityGroupsRequest}
}

// DescribeClusterSecurityGroupsRequest is the request type for the
// DescribeClusterSecurityGroups API operation.
type DescribeClusterSecurityGroupsRequest struct {
	*aws.Request
	Input *DescribeClusterSecurityGroupsInput
	Copy  func(*DescribeClusterSecurityGroupsInput) DescribeClusterSecurityGroupsRequest
}

// Send marshals and sends the DescribeClusterSecurityGroups API request.
func (r DescribeClusterSecurityGroupsRequest) Send(ctx context.Context) (*DescribeClusterSecurityGroupsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeClusterSecurityGroupsResponse{
		DescribeClusterSecurityGroupsOutput: r.Request.Data.(*DescribeClusterSecurityGroupsOutput),
		response:                            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewDescribeClusterSecurityGroupsRequestPaginator returns a paginator for DescribeClusterSecurityGroups.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.DescribeClusterSecurityGroupsRequest(input)
//   p := redshift.NewDescribeClusterSecurityGroupsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewDescribeClusterSecurityGroupsPaginator(req DescribeClusterSecurityGroupsRequest) DescribeClusterSecurityGroupsPaginator {
	return DescribeClusterSecurityGroupsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *DescribeClusterSecurityGroupsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// DescribeClusterSecurityGroupsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type DescribeClusterSecurityGroupsPaginator struct {
	aws.Pager
}

func (p *DescribeClusterSecurityGroupsPaginator) CurrentPage() *DescribeClusterSecurityGroupsOutput {
	return p.Pager.CurrentPage().(*DescribeClusterSecurityGroupsOutput)
}

// DescribeClusterSecurityGroupsResponse is the response type for the
// DescribeClusterSecurityGroups API operation.
type DescribeClusterSecurityGroupsResponse struct {
	*DescribeClusterSecurityGroupsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeClusterSecurityGroups request.
func (r *DescribeClusterSecurityGroupsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
