// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package redshift

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ModifyClusterIamRolesInput struct {
	_ struct{} `type:"structure"`

	// Zero or more IAM roles to associate with the cluster. The roles must be in
	// their Amazon Resource Name (ARN) format. You can associate up to 10 IAM roles
	// with a single cluster in a single request.
	AddIamRoles []string `locationNameList:"IamRoleArn" type:"list"`

	// The unique identifier of the cluster for which you want to associate or disassociate
	// IAM roles.
	//
	// ClusterIdentifier is a required field
	ClusterIdentifier *string `type:"string" required:"true"`

	// Zero or more IAM roles in ARN format to disassociate from the cluster. You
	// can disassociate up to 10 IAM roles from a single cluster in a single request.
	RemoveIamRoles []string `locationNameList:"IamRoleArn" type:"list"`
}

// String returns the string representation
func (s ModifyClusterIamRolesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyClusterIamRolesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ModifyClusterIamRolesInput"}

	if s.ClusterIdentifier == nil {
		invalidParams.Add(aws.NewErrParamRequired("ClusterIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ModifyClusterIamRolesOutput struct {
	_ struct{} `type:"structure"`

	// Describes a cluster.
	Cluster *Cluster `type:"structure"`
}

// String returns the string representation
func (s ModifyClusterIamRolesOutput) String() string {
	return awsutil.Prettify(s)
}

const opModifyClusterIamRoles = "ModifyClusterIamRoles"

// ModifyClusterIamRolesRequest returns a request value for making API operation for
// Amazon Redshift.
//
// Modifies the list of AWS Identity and Access Management (IAM) roles that
// can be used by the cluster to access other AWS services.
//
// A cluster can have up to 10 IAM roles associated at any time.
//
//    // Example sending a request using ModifyClusterIamRolesRequest.
//    req := client.ModifyClusterIamRolesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifyClusterIamRoles
func (c *Client) ModifyClusterIamRolesRequest(input *ModifyClusterIamRolesInput) ModifyClusterIamRolesRequest {
	op := &aws.Operation{
		Name:       opModifyClusterIamRoles,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyClusterIamRolesInput{}
	}

	req := c.newRequest(op, input, &ModifyClusterIamRolesOutput{})

	return ModifyClusterIamRolesRequest{Request: req, Input: input, Copy: c.ModifyClusterIamRolesRequest}
}

// ModifyClusterIamRolesRequest is the request type for the
// ModifyClusterIamRoles API operation.
type ModifyClusterIamRolesRequest struct {
	*aws.Request
	Input *ModifyClusterIamRolesInput
	Copy  func(*ModifyClusterIamRolesInput) ModifyClusterIamRolesRequest
}

// Send marshals and sends the ModifyClusterIamRoles API request.
func (r ModifyClusterIamRolesRequest) Send(ctx context.Context) (*ModifyClusterIamRolesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ModifyClusterIamRolesResponse{
		ModifyClusterIamRolesOutput: r.Request.Data.(*ModifyClusterIamRolesOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ModifyClusterIamRolesResponse is the response type for the
// ModifyClusterIamRoles API operation.
type ModifyClusterIamRolesResponse struct {
	*ModifyClusterIamRolesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ModifyClusterIamRoles request.
func (r *ModifyClusterIamRolesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
