// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package rekognition

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DeleteProjectVersionInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the model version that you want to delete.
	//
	// ProjectVersionArn is a required field
	ProjectVersionArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteProjectVersionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteProjectVersionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteProjectVersionInput"}

	if s.ProjectVersionArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("ProjectVersionArn"))
	}
	if s.ProjectVersionArn != nil && len(*s.ProjectVersionArn) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("ProjectVersionArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteProjectVersionOutput struct {
	_ struct{} `type:"structure"`

	// The status of the deletion operation.
	Status ProjectVersionStatus `type:"string" enum:"true"`
}

// String returns the string representation
func (s DeleteProjectVersionOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteProjectVersion = "DeleteProjectVersion"

// DeleteProjectVersionRequest returns a request value for making API operation for
// Amazon Rekognition.
//
// Deletes an Amazon Rekognition Custom Labels model.
//
// You can't delete a model if it is running or if it is training. To check
// the status of a model, use the Status field returned from DescribeProjectVersions.
// To stop a running model call StopProjectVersion. If the model is training,
// wait until it finishes.
//
// This operation requires permissions to perform the rekognition:DeleteProjectVersion
// action.
//
//    // Example sending a request using DeleteProjectVersionRequest.
//    req := client.DeleteProjectVersionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) DeleteProjectVersionRequest(input *DeleteProjectVersionInput) DeleteProjectVersionRequest {
	op := &aws.Operation{
		Name:       opDeleteProjectVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteProjectVersionInput{}
	}

	req := c.newRequest(op, input, &DeleteProjectVersionOutput{})

	return DeleteProjectVersionRequest{Request: req, Input: input, Copy: c.DeleteProjectVersionRequest}
}

// DeleteProjectVersionRequest is the request type for the
// DeleteProjectVersion API operation.
type DeleteProjectVersionRequest struct {
	*aws.Request
	Input *DeleteProjectVersionInput
	Copy  func(*DeleteProjectVersionInput) DeleteProjectVersionRequest
}

// Send marshals and sends the DeleteProjectVersion API request.
func (r DeleteProjectVersionRequest) Send(ctx context.Context) (*DeleteProjectVersionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteProjectVersionResponse{
		DeleteProjectVersionOutput: r.Request.Data.(*DeleteProjectVersionOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteProjectVersionResponse is the response type for the
// DeleteProjectVersion API operation.
type DeleteProjectVersionResponse struct {
	*DeleteProjectVersionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteProjectVersion request.
func (r *DeleteProjectVersionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
