// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package rekognition

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DetectLabelsInput struct {
	_ struct{} `type:"structure"`

	// The input image as base64-encoded bytes or an S3 object. If you use the AWS
	// CLI to call Amazon Rekognition operations, passing image bytes is not supported.
	// Images stored in an S3 Bucket do not need to be base64-encoded.
	//
	// If you are using an AWS SDK to call Amazon Rekognition, you might not need
	// to base64-encode image bytes passed using the Bytes field. For more information,
	// see Images in the Amazon Rekognition developer guide.
	//
	// Image is a required field
	Image *Image `type:"structure" required:"true"`

	// Maximum number of labels you want the service to return in the response.
	// The service returns the specified number of highest confidence labels.
	MaxLabels *int64 `type:"integer"`

	// Specifies the minimum confidence level for the labels to return. Amazon Rekognition
	// doesn't return any labels with confidence lower than this specified value.
	//
	// If MinConfidence is not specified, the operation returns labels with a confidence
	// values greater than or equal to 55 percent.
	MinConfidence *float64 `type:"float"`
}

// String returns the string representation
func (s DetectLabelsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DetectLabelsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DetectLabelsInput"}

	if s.Image == nil {
		invalidParams.Add(aws.NewErrParamRequired("Image"))
	}
	if s.Image != nil {
		if err := s.Image.Validate(); err != nil {
			invalidParams.AddNested("Image", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DetectLabelsOutput struct {
	_ struct{} `type:"structure"`

	// Version number of the label detection model that was used to detect labels.
	LabelModelVersion *string `type:"string"`

	// An array of labels for the real-world objects detected.
	Labels []Label `type:"list"`

	// The value of OrientationCorrection is always null.
	//
	// If the input image is in .jpeg format, it might contain exchangeable image
	// file format (Exif) metadata that includes the image's orientation. Amazon
	// Rekognition uses this orientation information to perform image correction.
	// The bounding box coordinates are translated to represent object locations
	// after the orientation information in the Exif metadata is used to correct
	// the image orientation. Images in .png format don't contain Exif metadata.
	//
	// Amazon Rekognition doesn’t perform image correction for images in .png
	// format and .jpeg images without orientation information in the image Exif
	// metadata. The bounding box coordinates aren't translated and represent the
	// object locations before the image is rotated.
	OrientationCorrection OrientationCorrection `type:"string" enum:"true"`
}

// String returns the string representation
func (s DetectLabelsOutput) String() string {
	return awsutil.Prettify(s)
}

const opDetectLabels = "DetectLabels"

// DetectLabelsRequest returns a request value for making API operation for
// Amazon Rekognition.
//
// Detects instances of real-world entities within an image (JPEG or PNG) provided
// as input. This includes objects like flower, tree, and table; events like
// wedding, graduation, and birthday party; and concepts like landscape, evening,
// and nature.
//
// For an example, see Analyzing Images Stored in an Amazon S3 Bucket in the
// Amazon Rekognition Developer Guide.
//
// DetectLabels does not support the detection of activities. However, activity
// detection is supported for label detection in videos. For more information,
// see StartLabelDetection in the Amazon Rekognition Developer Guide.
//
// You pass the input image as base64-encoded image bytes or as a reference
// to an image in an Amazon S3 bucket. If you use the AWS CLI to call Amazon
// Rekognition operations, passing image bytes is not supported. The image must
// be either a PNG or JPEG formatted file.
//
// For each object, scene, and concept the API returns one or more labels. Each
// label provides the object name, and the level of confidence that the image
// contains the object. For example, suppose the input image has a lighthouse,
// the sea, and a rock. The response includes all three labels, one for each
// object.
//
// {Name: lighthouse, Confidence: 98.4629}
//
// {Name: rock,Confidence: 79.2097}
//
// {Name: sea,Confidence: 75.061}
//
// In the preceding example, the operation returns one label for each of the
// three objects. The operation can also return multiple labels for the same
// object in the image. For example, if the input image shows a flower (for
// example, a tulip), the operation might return the following three labels.
//
// {Name: flower,Confidence: 99.0562}
//
// {Name: plant,Confidence: 99.0562}
//
// {Name: tulip,Confidence: 99.0562}
//
// In this example, the detection algorithm more precisely identifies the flower
// as a tulip.
//
// In response, the API returns an array of labels. In addition, the response
// also includes the orientation correction. Optionally, you can specify MinConfidence
// to control the confidence threshold for the labels returned. The default
// is 55%. You can also add the MaxLabels parameter to limit the number of labels
// returned.
//
// If the object detected is a person, the operation doesn't provide the same
// facial details that the DetectFaces operation provides.
//
// DetectLabels returns bounding boxes for instances of common object labels
// in an array of Instance objects. An Instance object contains a BoundingBox
// object, for the location of the label on the image. It also includes the
// confidence by which the bounding box was detected.
//
// DetectLabels also returns a hierarchical taxonomy of detected labels. For
// example, a detected car might be assigned the label car. The label car has
// two parent labels: Vehicle (its parent) and Transportation (its grandparent).
// The response returns the entire list of ancestors for a label. Each ancestor
// is a unique label in the response. In the previous example, Car, Vehicle,
// and Transportation are returned as unique labels in the response.
//
// This is a stateless API operation. That is, the operation does not persist
// any data.
//
// This operation requires permissions to perform the rekognition:DetectLabels
// action.
//
//    // Example sending a request using DetectLabelsRequest.
//    req := client.DetectLabelsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) DetectLabelsRequest(input *DetectLabelsInput) DetectLabelsRequest {
	op := &aws.Operation{
		Name:       opDetectLabels,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DetectLabelsInput{}
	}

	req := c.newRequest(op, input, &DetectLabelsOutput{})

	return DetectLabelsRequest{Request: req, Input: input, Copy: c.DetectLabelsRequest}
}

// DetectLabelsRequest is the request type for the
// DetectLabels API operation.
type DetectLabelsRequest struct {
	*aws.Request
	Input *DetectLabelsInput
	Copy  func(*DetectLabelsInput) DetectLabelsRequest
}

// Send marshals and sends the DetectLabels API request.
func (r DetectLabelsRequest) Send(ctx context.Context) (*DetectLabelsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DetectLabelsResponse{
		DetectLabelsOutput: r.Request.Data.(*DetectLabelsOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DetectLabelsResponse is the response type for the
// DetectLabels API operation.
type DetectLabelsResponse struct {
	*DetectLabelsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DetectLabels request.
func (r *DetectLabelsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
