// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package rekognition

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DetectModerationLabelsInput struct {
	_ struct{} `type:"structure"`

	// Sets up the configuration for human evaluation, including the FlowDefinition
	// the image will be sent to.
	HumanLoopConfig *HumanLoopConfig `type:"structure"`

	// The input image as base64-encoded bytes or an S3 object. If you use the AWS
	// CLI to call Amazon Rekognition operations, passing base64-encoded image bytes
	// is not supported.
	//
	// If you are using an AWS SDK to call Amazon Rekognition, you might not need
	// to base64-encode image bytes passed using the Bytes field. For more information,
	// see Images in the Amazon Rekognition developer guide.
	//
	// Image is a required field
	Image *Image `type:"structure" required:"true"`

	// Specifies the minimum confidence level for the labels to return. Amazon Rekognition
	// doesn't return any labels with a confidence level lower than this specified
	// value.
	//
	// If you don't specify MinConfidence, the operation returns labels with confidence
	// values greater than or equal to 50 percent.
	MinConfidence *float64 `type:"float"`
}

// String returns the string representation
func (s DetectModerationLabelsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DetectModerationLabelsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DetectModerationLabelsInput"}

	if s.Image == nil {
		invalidParams.Add(aws.NewErrParamRequired("Image"))
	}
	if s.HumanLoopConfig != nil {
		if err := s.HumanLoopConfig.Validate(); err != nil {
			invalidParams.AddNested("HumanLoopConfig", err.(aws.ErrInvalidParams))
		}
	}
	if s.Image != nil {
		if err := s.Image.Validate(); err != nil {
			invalidParams.AddNested("Image", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DetectModerationLabelsOutput struct {
	_ struct{} `type:"structure"`

	// Shows the results of the human in the loop evaluation.
	HumanLoopActivationOutput *HumanLoopActivationOutput `type:"structure"`

	// Array of detected Moderation labels and the time, in milliseconds from the
	// start of the video, they were detected.
	ModerationLabels []ModerationLabel `type:"list"`

	// Version number of the moderation detection model that was used to detect
	// unsafe content.
	ModerationModelVersion *string `type:"string"`
}

// String returns the string representation
func (s DetectModerationLabelsOutput) String() string {
	return awsutil.Prettify(s)
}

const opDetectModerationLabels = "DetectModerationLabels"

// DetectModerationLabelsRequest returns a request value for making API operation for
// Amazon Rekognition.
//
// Detects unsafe content in a specified JPEG or PNG format image. Use DetectModerationLabels
// to moderate images depending on your requirements. For example, you might
// want to filter images that contain nudity, but not images containing suggestive
// content.
//
// To filter images, use the labels returned by DetectModerationLabels to determine
// which types of content are appropriate.
//
// For information about moderation labels, see Detecting Unsafe Content in
// the Amazon Rekognition Developer Guide.
//
// You pass the input image either as base64-encoded image bytes or as a reference
// to an image in an Amazon S3 bucket. If you use the AWS CLI to call Amazon
// Rekognition operations, passing image bytes is not supported. The image must
// be either a PNG or JPEG formatted file.
//
//    // Example sending a request using DetectModerationLabelsRequest.
//    req := client.DetectModerationLabelsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) DetectModerationLabelsRequest(input *DetectModerationLabelsInput) DetectModerationLabelsRequest {
	op := &aws.Operation{
		Name:       opDetectModerationLabels,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DetectModerationLabelsInput{}
	}

	req := c.newRequest(op, input, &DetectModerationLabelsOutput{})

	return DetectModerationLabelsRequest{Request: req, Input: input, Copy: c.DetectModerationLabelsRequest}
}

// DetectModerationLabelsRequest is the request type for the
// DetectModerationLabels API operation.
type DetectModerationLabelsRequest struct {
	*aws.Request
	Input *DetectModerationLabelsInput
	Copy  func(*DetectModerationLabelsInput) DetectModerationLabelsRequest
}

// Send marshals and sends the DetectModerationLabels API request.
func (r DetectModerationLabelsRequest) Send(ctx context.Context) (*DetectModerationLabelsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DetectModerationLabelsResponse{
		DetectModerationLabelsOutput: r.Request.Data.(*DetectModerationLabelsOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DetectModerationLabelsResponse is the response type for the
// DetectModerationLabels API operation.
type DetectModerationLabelsResponse struct {
	*DetectModerationLabelsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DetectModerationLabels request.
func (r *DetectModerationLabelsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
