// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package rekognition

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetTextDetectionInput struct {
	_ struct{} `type:"structure"`

	// Job identifier for the text detection operation for which you want results
	// returned. You get the job identifer from an initial call to StartTextDetection.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`

	// Maximum number of results to return per paginated call. The largest value
	// you can specify is 1000.
	MaxResults *int64 `min:"1" type:"integer"`

	// If the previous response was incomplete (because there are more labels to
	// retrieve), Amazon Rekognition Video returns a pagination token in the response.
	// You can use this pagination token to retrieve the next set of text.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s GetTextDetectionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTextDetectionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetTextDetectionInput"}

	if s.JobId == nil {
		invalidParams.Add(aws.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("JobId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetTextDetectionOutput struct {
	_ struct{} `type:"structure"`

	// Current status of the text detection job.
	JobStatus VideoJobStatus `type:"string" enum:"true"`

	// If the response is truncated, Amazon Rekognition Video returns this token
	// that you can use in the subsequent request to retrieve the next set of text.
	NextToken *string `type:"string"`

	// If the job fails, StatusMessage provides a descriptive error message.
	StatusMessage *string `type:"string"`

	// An array of text detected in the video. Each element contains the detected
	// text, the time in milliseconds from the start of the video that the text
	// was detected, and where it was detected on the screen.
	TextDetections []TextDetectionResult `type:"list"`

	// Version number of the text detection model that was used to detect text.
	TextModelVersion *string `type:"string"`

	// Information about a video that Amazon Rekognition analyzed. Videometadata
	// is returned in every page of paginated responses from a Amazon Rekognition
	// video operation.
	VideoMetadata *VideoMetadata `type:"structure"`
}

// String returns the string representation
func (s GetTextDetectionOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetTextDetection = "GetTextDetection"

// GetTextDetectionRequest returns a request value for making API operation for
// Amazon Rekognition.
//
// Gets the text detection results of a Amazon Rekognition Video analysis started
// by StartTextDetection.
//
// Text detection with Amazon Rekognition Video is an asynchronous operation.
// You start text detection by calling StartTextDetection which returns a job
// identifier (JobId) When the text detection operation finishes, Amazon Rekognition
// publishes a completion status to the Amazon Simple Notification Service topic
// registered in the initial call to StartTextDetection. To get the results
// of the text detection operation, first check that the status value published
// to the Amazon SNS topic is SUCCEEDED. if so, call GetTextDetection and pass
// the job identifier (JobId) from the initial call of StartLabelDetection.
//
// GetTextDetection returns an array of detected text (TextDetections) sorted
// by the time the text was detected, up to 50 words per frame of video.
//
// Each element of the array includes the detected text, the precentage confidence
// in the acuracy of the detected text, the time the text was detected, bounding
// box information for where the text was located, and unique identifiers for
// words and their lines.
//
// Use MaxResults parameter to limit the number of text detections returned.
// If there are more results than specified in MaxResults, the value of NextToken
// in the operation response contains a pagination token for getting the next
// set of results. To get the next page of results, call GetTextDetection and
// populate the NextToken request parameter with the token value returned from
// the previous call to GetTextDetection.
//
//    // Example sending a request using GetTextDetectionRequest.
//    req := client.GetTextDetectionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) GetTextDetectionRequest(input *GetTextDetectionInput) GetTextDetectionRequest {
	op := &aws.Operation{
		Name:       opGetTextDetection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetTextDetectionInput{}
	}

	req := c.newRequest(op, input, &GetTextDetectionOutput{})

	return GetTextDetectionRequest{Request: req, Input: input, Copy: c.GetTextDetectionRequest}
}

// GetTextDetectionRequest is the request type for the
// GetTextDetection API operation.
type GetTextDetectionRequest struct {
	*aws.Request
	Input *GetTextDetectionInput
	Copy  func(*GetTextDetectionInput) GetTextDetectionRequest
}

// Send marshals and sends the GetTextDetection API request.
func (r GetTextDetectionRequest) Send(ctx context.Context) (*GetTextDetectionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetTextDetectionResponse{
		GetTextDetectionOutput: r.Request.Data.(*GetTextDetectionOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewGetTextDetectionRequestPaginator returns a paginator for GetTextDetection.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.GetTextDetectionRequest(input)
//   p := rekognition.NewGetTextDetectionRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewGetTextDetectionPaginator(req GetTextDetectionRequest) GetTextDetectionPaginator {
	return GetTextDetectionPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *GetTextDetectionInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// GetTextDetectionPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type GetTextDetectionPaginator struct {
	aws.Pager
}

func (p *GetTextDetectionPaginator) CurrentPage() *GetTextDetectionOutput {
	return p.Pager.CurrentPage().(*GetTextDetectionOutput)
}

// GetTextDetectionResponse is the response type for the
// GetTextDetection API operation.
type GetTextDetectionResponse struct {
	*GetTextDetectionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetTextDetection request.
func (r *GetTextDetectionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
