// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package rekognition

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type StopStreamProcessorInput struct {
	_ struct{} `type:"structure"`

	// The name of a stream processor created by CreateStreamProcessor.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StopStreamProcessorInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopStreamProcessorInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StopStreamProcessorInput"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type StopStreamProcessorOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s StopStreamProcessorOutput) String() string {
	return awsutil.Prettify(s)
}

const opStopStreamProcessor = "StopStreamProcessor"

// StopStreamProcessorRequest returns a request value for making API operation for
// Amazon Rekognition.
//
// Stops a running stream processor that was created by CreateStreamProcessor.
//
//    // Example sending a request using StopStreamProcessorRequest.
//    req := client.StopStreamProcessorRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) StopStreamProcessorRequest(input *StopStreamProcessorInput) StopStreamProcessorRequest {
	op := &aws.Operation{
		Name:       opStopStreamProcessor,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopStreamProcessorInput{}
	}

	req := c.newRequest(op, input, &StopStreamProcessorOutput{})

	return StopStreamProcessorRequest{Request: req, Input: input, Copy: c.StopStreamProcessorRequest}
}

// StopStreamProcessorRequest is the request type for the
// StopStreamProcessor API operation.
type StopStreamProcessorRequest struct {
	*aws.Request
	Input *StopStreamProcessorInput
	Copy  func(*StopStreamProcessorInput) StopStreamProcessorRequest
}

// Send marshals and sends the StopStreamProcessor API request.
func (r StopStreamProcessorRequest) Send(ctx context.Context) (*StopStreamProcessorResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &StopStreamProcessorResponse{
		StopStreamProcessorOutput: r.Request.Data.(*StopStreamProcessorOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// StopStreamProcessorResponse is the response type for the
// StopStreamProcessor API operation.
type StopStreamProcessorResponse struct {
	*StopStreamProcessorOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// StopStreamProcessor request.
func (r *StopStreamProcessorResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
