// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package resourcegroupstaggingapi

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetTagValuesInput struct {
	_ struct{} `type:"structure"`

	// The key for which you want to list all existing values in the specified Region
	// for the AWS account.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// A string that indicates that additional data is available. Leave this value
	// empty for your initial request. If the response includes a PaginationToken,
	// use that string for this value to request an additional page of data.
	PaginationToken *string `type:"string"`
}

// String returns the string representation
func (s GetTagValuesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTagValuesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetTagValuesInput"}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetTagValuesOutput struct {
	_ struct{} `type:"structure"`

	// A string that indicates that the response contains more data than can be
	// returned in a single response. To receive additional data, specify this string
	// for the PaginationToken value in a subsequent request.
	PaginationToken *string `type:"string"`

	// A list of all tag values for the specified key in the AWS account.
	TagValues []string `type:"list"`
}

// String returns the string representation
func (s GetTagValuesOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetTagValues = "GetTagValues"

// GetTagValuesRequest returns a request value for making API operation for
// AWS Resource Groups Tagging API.
//
// Returns all tag values for the specified key in the specified Region for
// the AWS account.
//
//    // Example sending a request using GetTagValuesRequest.
//    req := client.GetTagValuesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/resourcegroupstaggingapi-2017-01-26/GetTagValues
func (c *Client) GetTagValuesRequest(input *GetTagValuesInput) GetTagValuesRequest {
	op := &aws.Operation{
		Name:       opGetTagValues,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"PaginationToken"},
			OutputTokens:    []string{"PaginationToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetTagValuesInput{}
	}

	req := c.newRequest(op, input, &GetTagValuesOutput{})

	return GetTagValuesRequest{Request: req, Input: input, Copy: c.GetTagValuesRequest}
}

// GetTagValuesRequest is the request type for the
// GetTagValues API operation.
type GetTagValuesRequest struct {
	*aws.Request
	Input *GetTagValuesInput
	Copy  func(*GetTagValuesInput) GetTagValuesRequest
}

// Send marshals and sends the GetTagValues API request.
func (r GetTagValuesRequest) Send(ctx context.Context) (*GetTagValuesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetTagValuesResponse{
		GetTagValuesOutput: r.Request.Data.(*GetTagValuesOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewGetTagValuesRequestPaginator returns a paginator for GetTagValues.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.GetTagValuesRequest(input)
//   p := resourcegroupstaggingapi.NewGetTagValuesRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewGetTagValuesPaginator(req GetTagValuesRequest) GetTagValuesPaginator {
	return GetTagValuesPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *GetTagValuesInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// GetTagValuesPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type GetTagValuesPaginator struct {
	aws.Pager
}

func (p *GetTagValuesPaginator) CurrentPage() *GetTagValuesOutput {
	return p.Pager.CurrentPage().(*GetTagValuesOutput)
}

// GetTagValuesResponse is the response type for the
// GetTagValues API operation.
type GetTagValuesResponse struct {
	*GetTagValuesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetTagValues request.
func (r *GetTagValuesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
