// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package resourcegroupstaggingapi

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type StartReportCreationInput struct {
	_ struct{} `type:"structure"`

	// The name of the Amazon S3 bucket where the report will be stored; for example:
	//
	// awsexamplebucket
	//
	// For more information on S3 bucket requirements, including an example bucket
	// policy, see the example S3 bucket policy on this page.
	//
	// S3Bucket is a required field
	S3Bucket *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s StartReportCreationInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartReportCreationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StartReportCreationInput"}

	if s.S3Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("S3Bucket"))
	}
	if s.S3Bucket != nil && len(*s.S3Bucket) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("S3Bucket", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type StartReportCreationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s StartReportCreationOutput) String() string {
	return awsutil.Prettify(s)
}

const opStartReportCreation = "StartReportCreation"

// StartReportCreationRequest returns a request value for making API operation for
// AWS Resource Groups Tagging API.
//
// Generates a report that lists all tagged resources in accounts across your
// organization and tells whether each resource is compliant with the effective
// tag policy. Compliance data is refreshed daily.
//
// The generated report is saved to the following location:
//
// s3://example-bucket/AwsTagPolicies/o-exampleorgid/YYYY-MM-ddTHH:mm:ssZ/report.csv
//
// You can call this operation only from the organization's master account and
// from the us-east-1 Region.
//
//    // Example sending a request using StartReportCreationRequest.
//    req := client.StartReportCreationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/resourcegroupstaggingapi-2017-01-26/StartReportCreation
func (c *Client) StartReportCreationRequest(input *StartReportCreationInput) StartReportCreationRequest {
	op := &aws.Operation{
		Name:       opStartReportCreation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartReportCreationInput{}
	}

	req := c.newRequest(op, input, &StartReportCreationOutput{})

	return StartReportCreationRequest{Request: req, Input: input, Copy: c.StartReportCreationRequest}
}

// StartReportCreationRequest is the request type for the
// StartReportCreation API operation.
type StartReportCreationRequest struct {
	*aws.Request
	Input *StartReportCreationInput
	Copy  func(*StartReportCreationInput) StartReportCreationRequest
}

// Send marshals and sends the StartReportCreation API request.
func (r StartReportCreationRequest) Send(ctx context.Context) (*StartReportCreationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &StartReportCreationResponse{
		StartReportCreationOutput: r.Request.Data.(*StartReportCreationOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// StartReportCreationResponse is the response type for the
// StartReportCreation API operation.
type StartReportCreationResponse struct {
	*StartReportCreationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// StartReportCreation request.
func (r *StartReportCreationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
