// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package route53

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type CreateReusableDelegationSetInput struct {
	_ struct{} `locationName:"CreateReusableDelegationSetRequest" type:"structure" xmlURI:"https://route53.amazonaws.com/doc/2013-04-01/"`

	// A unique string that identifies the request, and that allows you to retry
	// failed CreateReusableDelegationSet requests without the risk of executing
	// the operation twice. You must use a unique CallerReference string every time
	// you submit a CreateReusableDelegationSet request. CallerReference can be
	// any unique string, for example a date/time stamp.
	//
	// CallerReference is a required field
	CallerReference *string `min:"1" type:"string" required:"true"`

	// If you want to mark the delegation set for an existing hosted zone as reusable,
	// the ID for that hosted zone.
	HostedZoneId *string `type:"string"`
}

// String returns the string representation
func (s CreateReusableDelegationSetInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateReusableDelegationSetInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateReusableDelegationSetInput"}

	if s.CallerReference == nil {
		invalidParams.Add(aws.NewErrParamRequired("CallerReference"))
	}
	if s.CallerReference != nil && len(*s.CallerReference) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("CallerReference", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateReusableDelegationSetInput) MarshalFields(e protocol.FieldEncoder) error {

	e.SetFields(protocol.BodyTarget, "CreateReusableDelegationSetRequest", protocol.FieldMarshalerFunc(func(e protocol.FieldEncoder) error {
		if s.CallerReference != nil {
			v := *s.CallerReference

			metadata := protocol.Metadata{}
			e.SetValue(protocol.BodyTarget, "CallerReference", protocol.StringValue(v), metadata)
		}
		if s.HostedZoneId != nil {
			v := *s.HostedZoneId

			metadata := protocol.Metadata{}
			e.SetValue(protocol.BodyTarget, "HostedZoneId", protocol.StringValue(v), metadata)
		}
		return nil
	}), protocol.Metadata{XMLNamespaceURI: "https://route53.amazonaws.com/doc/2013-04-01/"})
	return nil
}

type CreateReusableDelegationSetOutput struct {
	_ struct{} `type:"structure"`

	// A complex type that contains name server information.
	//
	// DelegationSet is a required field
	DelegationSet *DelegationSet `type:"structure" required:"true"`

	// The unique URL representing the new reusable delegation set.
	//
	// Location is a required field
	Location *string `location:"header" locationName:"Location" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateReusableDelegationSetOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateReusableDelegationSetOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.DelegationSet != nil {
		v := s.DelegationSet

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "DelegationSet", v, metadata)
	}
	if s.Location != nil {
		v := *s.Location

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "Location", protocol.StringValue(v), metadata)
	}
	return nil
}

const opCreateReusableDelegationSet = "CreateReusableDelegationSet"

// CreateReusableDelegationSetRequest returns a request value for making API operation for
// Amazon Route 53.
//
// Creates a delegation set (a group of four name servers) that can be reused
// by multiple hosted zones that were created by the same AWS account.
//
// You can also create a reusable delegation set that uses the four name servers
// that are associated with an existing hosted zone. Specify the hosted zone
// ID in the CreateReusableDelegationSet request.
//
// You can't associate a reusable delegation set with a private hosted zone.
//
// For information about using a reusable delegation set to configure white
// label name servers, see Configuring White Label Name Servers (https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/white-label-name-servers.html).
//
// The process for migrating existing hosted zones to use a reusable delegation
// set is comparable to the process for configuring white label name servers.
// You need to perform the following steps:
//
// Create a reusable delegation set.
//
// Recreate hosted zones, and reduce the TTL to 60 seconds or less.
//
// Recreate resource record sets in the new hosted zones.
//
// Change the registrar's name servers to use the name servers for the new hosted
// zones.
//
// Monitor traffic for the website or application.
//
// Change TTLs back to their original values.
//
// If you want to migrate existing hosted zones to use a reusable delegation
// set, the existing hosted zones can't use any of the name servers that are
// assigned to the reusable delegation set. If one or more hosted zones do use
// one or more name servers that are assigned to the reusable delegation set,
// you can do one of the following:
//
//    * For small numbers of hosted zones—up to a few hundred—it's relatively
//    easy to create reusable delegation sets until you get one that has four
//    name servers that don't overlap with any of the name servers in your hosted
//    zones.
//
//    * For larger numbers of hosted zones, the easiest solution is to use more
//    than one reusable delegation set.
//
//    * For larger numbers of hosted zones, you can also migrate hosted zones
//    that have overlapping name servers to hosted zones that don't have overlapping
//    name servers, then migrate the hosted zones again to use the reusable
//    delegation set.
//
//    // Example sending a request using CreateReusableDelegationSetRequest.
//    req := client.CreateReusableDelegationSetRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/CreateReusableDelegationSet
func (c *Client) CreateReusableDelegationSetRequest(input *CreateReusableDelegationSetInput) CreateReusableDelegationSetRequest {
	op := &aws.Operation{
		Name:       opCreateReusableDelegationSet,
		HTTPMethod: "POST",
		HTTPPath:   "/2013-04-01/delegationset",
	}

	if input == nil {
		input = &CreateReusableDelegationSetInput{}
	}

	req := c.newRequest(op, input, &CreateReusableDelegationSetOutput{})

	return CreateReusableDelegationSetRequest{Request: req, Input: input, Copy: c.CreateReusableDelegationSetRequest}
}

// CreateReusableDelegationSetRequest is the request type for the
// CreateReusableDelegationSet API operation.
type CreateReusableDelegationSetRequest struct {
	*aws.Request
	Input *CreateReusableDelegationSetInput
	Copy  func(*CreateReusableDelegationSetInput) CreateReusableDelegationSetRequest
}

// Send marshals and sends the CreateReusableDelegationSet API request.
func (r CreateReusableDelegationSetRequest) Send(ctx context.Context) (*CreateReusableDelegationSetResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateReusableDelegationSetResponse{
		CreateReusableDelegationSetOutput: r.Request.Data.(*CreateReusableDelegationSetOutput),
		response:                          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateReusableDelegationSetResponse is the response type for the
// CreateReusableDelegationSet API operation.
type CreateReusableDelegationSetResponse struct {
	*CreateReusableDelegationSetOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateReusableDelegationSet request.
func (r *CreateReusableDelegationSetResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
