// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package route53

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Lists all the private hosted zones that a specified VPC is associated with,
// regardless of which AWS account created the hosted zones.
type ListHostedZonesByVPCInput struct {
	_ struct{} `type:"structure"`

	// (Optional) The maximum number of hosted zones that you want Amazon Route
	// 53 to return. If the specified VPC is associated with more than MaxItems
	// hosted zones, the response includes a NextToken element. NextToken contains
	// the hosted zone ID of the first hosted zone that Route 53 will return if
	// you submit another request.
	MaxItems *string `location:"querystring" locationName:"maxitems" type:"string"`

	// If the previous response included a NextToken element, the specified VPC
	// is associated with more hosted zones. To get more hosted zones, submit another
	// ListHostedZonesByVPC request.
	//
	// For the value of NextToken, specify the value of NextToken from the previous
	// response.
	//
	// If the previous response didn't include a NextToken element, there are no
	// more hosted zones to get.
	NextToken *string `location:"querystring" locationName:"nexttoken" type:"string"`

	// The ID of the Amazon VPC that you want to list hosted zones for.
	//
	// VPCId is a required field
	VPCId *string `location:"querystring" locationName:"vpcid" type:"string" required:"true"`

	// For the Amazon VPC that you specified for VPCId, the AWS Region that you
	// created the VPC in.
	//
	// VPCRegion is a required field
	VPCRegion VPCRegion `location:"querystring" locationName:"vpcregion" min:"1" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s ListHostedZonesByVPCInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListHostedZonesByVPCInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListHostedZonesByVPCInput"}

	if s.VPCId == nil {
		invalidParams.Add(aws.NewErrParamRequired("VPCId"))
	}
	if len(s.VPCRegion) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("VPCRegion"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListHostedZonesByVPCInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.MaxItems != nil {
		v := *s.MaxItems

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "maxitems", protocol.StringValue(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "nexttoken", protocol.StringValue(v), metadata)
	}
	if s.VPCId != nil {
		v := *s.VPCId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "vpcid", protocol.StringValue(v), metadata)
	}
	if len(s.VPCRegion) > 0 {
		v := s.VPCRegion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "vpcregion", v, metadata)
	}
	return nil
}

type ListHostedZonesByVPCOutput struct {
	_ struct{} `type:"structure"`

	// A list that contains one HostedZoneSummary element for each hosted zone that
	// the specified Amazon VPC is associated with. Each HostedZoneSummary element
	// contains the hosted zone name and ID, and information about who owns the
	// hosted zone.
	//
	// HostedZoneSummaries is a required field
	HostedZoneSummaries []HostedZoneSummary `locationNameList:"HostedZoneSummary" type:"list" required:"true"`

	// The value that you specified for MaxItems in the most recent ListHostedZonesByVPC
	// request.
	//
	// MaxItems is a required field
	MaxItems *string `type:"string" required:"true"`

	// The value that you specified for NextToken in the most recent ListHostedZonesByVPC
	// request.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListHostedZonesByVPCOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListHostedZonesByVPCOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.HostedZoneSummaries != nil {
		v := s.HostedZoneSummaries

		metadata := protocol.Metadata{ListLocationName: "HostedZoneSummary"}
		ls0 := e.List(protocol.BodyTarget, "HostedZoneSummaries", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.MaxItems != nil {
		v := *s.MaxItems

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MaxItems", protocol.StringValue(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.StringValue(v), metadata)
	}
	return nil
}

const opListHostedZonesByVPC = "ListHostedZonesByVPC"

// ListHostedZonesByVPCRequest returns a request value for making API operation for
// Amazon Route 53.
//
// Lists all the private hosted zones that a specified VPC is associated with,
// regardless of which AWS account or AWS service owns the hosted zones. The
// HostedZoneOwner structure in the response contains one of the following values:
//
//    * An OwningAccount element, which contains the account number of either
//    the current AWS account or another AWS account. Some services, such as
//    AWS Cloud Map, create hosted zones using the current account.
//
//    * An OwningService element, which identifies the AWS service that created
//    and owns the hosted zone. For example, if a hosted zone was created by
//    Amazon Elastic File System (Amazon EFS), the value of Owner is efs.amazonaws.com.
//
//    // Example sending a request using ListHostedZonesByVPCRequest.
//    req := client.ListHostedZonesByVPCRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListHostedZonesByVPC
func (c *Client) ListHostedZonesByVPCRequest(input *ListHostedZonesByVPCInput) ListHostedZonesByVPCRequest {
	op := &aws.Operation{
		Name:       opListHostedZonesByVPC,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/hostedzonesbyvpc",
	}

	if input == nil {
		input = &ListHostedZonesByVPCInput{}
	}

	req := c.newRequest(op, input, &ListHostedZonesByVPCOutput{})

	return ListHostedZonesByVPCRequest{Request: req, Input: input, Copy: c.ListHostedZonesByVPCRequest}
}

// ListHostedZonesByVPCRequest is the request type for the
// ListHostedZonesByVPC API operation.
type ListHostedZonesByVPCRequest struct {
	*aws.Request
	Input *ListHostedZonesByVPCInput
	Copy  func(*ListHostedZonesByVPCInput) ListHostedZonesByVPCRequest
}

// Send marshals and sends the ListHostedZonesByVPC API request.
func (r ListHostedZonesByVPCRequest) Send(ctx context.Context) (*ListHostedZonesByVPCResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListHostedZonesByVPCResponse{
		ListHostedZonesByVPCOutput: r.Request.Data.(*ListHostedZonesByVPCOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListHostedZonesByVPCResponse is the response type for the
// ListHostedZonesByVPC API operation.
type ListHostedZonesByVPCResponse struct {
	*ListHostedZonesByVPCOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListHostedZonesByVPC request.
func (r *ListHostedZonesByVPCResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
