// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package route53domains

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// The TransferDomainToAnotherAwsAccount request includes the following elements.
type TransferDomainToAnotherAwsAccountInput struct {
	_ struct{} `type:"structure"`

	// The account ID of the AWS account that you want to transfer the domain to,
	// for example, 111122223333.
	//
	// AccountId is a required field
	AccountId *string `type:"string" required:"true"`

	// The name of the domain that you want to transfer from the current AWS account
	// to another account.
	//
	// DomainName is a required field
	DomainName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s TransferDomainToAnotherAwsAccountInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TransferDomainToAnotherAwsAccountInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TransferDomainToAnotherAwsAccountInput"}

	if s.AccountId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AccountId"))
	}

	if s.DomainName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DomainName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The TransferDomainToAnotherAwsAccount response includes the following elements.
type TransferDomainToAnotherAwsAccountOutput struct {
	_ struct{} `type:"structure"`

	// Identifier for tracking the progress of the request. To query the operation
	// status, use GetOperationDetail (https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html).
	OperationId *string `type:"string"`

	// To finish transferring a domain to another AWS account, the account that
	// the domain is being transferred to must submit an AcceptDomainTransferFromAnotherAwsAccount
	// (https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_AcceptDomainTransferFromAnotherAwsAccount.html)
	// request. The request must include the value of the Password element that
	// was returned in the TransferDomainToAnotherAwsAccount response.
	Password *string `type:"string"`
}

// String returns the string representation
func (s TransferDomainToAnotherAwsAccountOutput) String() string {
	return awsutil.Prettify(s)
}

const opTransferDomainToAnotherAwsAccount = "TransferDomainToAnotherAwsAccount"

// TransferDomainToAnotherAwsAccountRequest returns a request value for making API operation for
// Amazon Route 53 Domains.
//
// Transfers a domain from the current AWS account to another AWS account. Note
// the following:
//
//    * The AWS account that you're transferring the domain to must accept the
//    transfer. If the other account doesn't accept the transfer within 3 days,
//    we cancel the transfer. See AcceptDomainTransferFromAnotherAwsAccount
//    (https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_AcceptDomainTransferFromAnotherAwsAccount.html).
//
//    * You can cancel the transfer before the other account accepts it. See
//    CancelDomainTransferToAnotherAwsAccount (https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_CancelDomainTransferToAnotherAwsAccount.html).
//
//    * The other account can reject the transfer. See RejectDomainTransferFromAnotherAwsAccount
//    (https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_RejectDomainTransferFromAnotherAwsAccount.html).
//
// When you transfer a domain from one AWS account to another, Route 53 doesn't
// transfer the hosted zone that is associated with the domain. DNS resolution
// isn't affected if the domain and the hosted zone are owned by separate accounts,
// so transferring the hosted zone is optional. For information about transferring
// the hosted zone to another AWS account, see Migrating a Hosted Zone to a
// Different AWS Account (https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/hosted-zones-migrating.html)
// in the Amazon Route 53 Developer Guide.
//
// Use either ListOperations (https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ListOperations.html)
// or GetOperationDetail (https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html)
// to determine whether the operation succeeded. GetOperationDetail (https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html)
// provides additional information, for example, Domain Transfer from Aws Account
// 111122223333 has been cancelled.
//
//    // Example sending a request using TransferDomainToAnotherAwsAccountRequest.
//    req := client.TransferDomainToAnotherAwsAccountRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/TransferDomainToAnotherAwsAccount
func (c *Client) TransferDomainToAnotherAwsAccountRequest(input *TransferDomainToAnotherAwsAccountInput) TransferDomainToAnotherAwsAccountRequest {
	op := &aws.Operation{
		Name:       opTransferDomainToAnotherAwsAccount,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TransferDomainToAnotherAwsAccountInput{}
	}

	req := c.newRequest(op, input, &TransferDomainToAnotherAwsAccountOutput{})

	return TransferDomainToAnotherAwsAccountRequest{Request: req, Input: input, Copy: c.TransferDomainToAnotherAwsAccountRequest}
}

// TransferDomainToAnotherAwsAccountRequest is the request type for the
// TransferDomainToAnotherAwsAccount API operation.
type TransferDomainToAnotherAwsAccountRequest struct {
	*aws.Request
	Input *TransferDomainToAnotherAwsAccountInput
	Copy  func(*TransferDomainToAnotherAwsAccountInput) TransferDomainToAnotherAwsAccountRequest
}

// Send marshals and sends the TransferDomainToAnotherAwsAccount API request.
func (r TransferDomainToAnotherAwsAccountRequest) Send(ctx context.Context) (*TransferDomainToAnotherAwsAccountResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &TransferDomainToAnotherAwsAccountResponse{
		TransferDomainToAnotherAwsAccountOutput: r.Request.Data.(*TransferDomainToAnotherAwsAccountOutput),
		response:                                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// TransferDomainToAnotherAwsAccountResponse is the response type for the
// TransferDomainToAnotherAwsAccount API operation.
type TransferDomainToAnotherAwsAccountResponse struct {
	*TransferDomainToAnotherAwsAccountOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// TransferDomainToAnotherAwsAccount request.
func (r *TransferDomainToAnotherAwsAccountResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
