// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sagemaker

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListTrainingJobsInput struct {
	_ struct{} `type:"structure"`

	// A filter that returns only training jobs created after the specified time
	// (timestamp).
	CreationTimeAfter *time.Time `type:"timestamp"`

	// A filter that returns only training jobs created before the specified time
	// (timestamp).
	CreationTimeBefore *time.Time `type:"timestamp"`

	// A filter that returns only training jobs modified after the specified time
	// (timestamp).
	LastModifiedTimeAfter *time.Time `type:"timestamp"`

	// A filter that returns only training jobs modified before the specified time
	// (timestamp).
	LastModifiedTimeBefore *time.Time `type:"timestamp"`

	// The maximum number of training jobs to return in the response.
	MaxResults *int64 `min:"1" type:"integer"`

	// A string in the training job name. This filter returns only training jobs
	// whose name contains the specified string.
	NameContains *string `type:"string"`

	// If the result of the previous ListTrainingJobs request was truncated, the
	// response includes a NextToken. To retrieve the next set of training jobs,
	// use the token in the next request.
	NextToken *string `type:"string"`

	// The field to sort results by. The default is CreationTime.
	SortBy SortBy `type:"string" enum:"true"`

	// The sort order for results. The default is Ascending.
	SortOrder SortOrder `type:"string" enum:"true"`

	// A filter that retrieves only training jobs with a specific status.
	StatusEquals TrainingJobStatus `type:"string" enum:"true"`
}

// String returns the string representation
func (s ListTrainingJobsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTrainingJobsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListTrainingJobsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListTrainingJobsOutput struct {
	_ struct{} `type:"structure"`

	// If the response is truncated, Amazon SageMaker returns this token. To retrieve
	// the next set of training jobs, use it in the subsequent request.
	NextToken *string `type:"string"`

	// An array of TrainingJobSummary objects, each listing a training job.
	//
	// TrainingJobSummaries is a required field
	TrainingJobSummaries []TrainingJobSummary `type:"list" required:"true"`
}

// String returns the string representation
func (s ListTrainingJobsOutput) String() string {
	return awsutil.Prettify(s)
}

const opListTrainingJobs = "ListTrainingJobs"

// ListTrainingJobsRequest returns a request value for making API operation for
// Amazon SageMaker Service.
//
// Lists training jobs.
//
//    // Example sending a request using ListTrainingJobsRequest.
//    req := client.ListTrainingJobsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListTrainingJobs
func (c *Client) ListTrainingJobsRequest(input *ListTrainingJobsInput) ListTrainingJobsRequest {
	op := &aws.Operation{
		Name:       opListTrainingJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTrainingJobsInput{}
	}

	req := c.newRequest(op, input, &ListTrainingJobsOutput{})

	return ListTrainingJobsRequest{Request: req, Input: input, Copy: c.ListTrainingJobsRequest}
}

// ListTrainingJobsRequest is the request type for the
// ListTrainingJobs API operation.
type ListTrainingJobsRequest struct {
	*aws.Request
	Input *ListTrainingJobsInput
	Copy  func(*ListTrainingJobsInput) ListTrainingJobsRequest
}

// Send marshals and sends the ListTrainingJobs API request.
func (r ListTrainingJobsRequest) Send(ctx context.Context) (*ListTrainingJobsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListTrainingJobsResponse{
		ListTrainingJobsOutput: r.Request.Data.(*ListTrainingJobsOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListTrainingJobsRequestPaginator returns a paginator for ListTrainingJobs.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListTrainingJobsRequest(input)
//   p := sagemaker.NewListTrainingJobsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListTrainingJobsPaginator(req ListTrainingJobsRequest) ListTrainingJobsPaginator {
	return ListTrainingJobsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListTrainingJobsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListTrainingJobsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListTrainingJobsPaginator struct {
	aws.Pager
}

func (p *ListTrainingJobsPaginator) CurrentPage() *ListTrainingJobsOutput {
	return p.Pager.CurrentPage().(*ListTrainingJobsOutput)
}

// ListTrainingJobsResponse is the response type for the
// ListTrainingJobs API operation.
type ListTrainingJobsResponse struct {
	*ListTrainingJobsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListTrainingJobs request.
func (r *ListTrainingJobsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
