// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package sagemakeriface provides an interface to enable mocking the Amazon SageMaker Service service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package sagemakeriface

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/service/sagemaker"
)

// ClientAPI provides an interface to enable mocking the
// sagemaker.Client methods. This make unit testing your code that
// calls out to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // SageMaker.
//    func myFunc(svc sagemakeriface.ClientAPI) bool {
//        // Make svc.AddTags request
//    }
//
//    func main() {
//        cfg, err := external.LoadDefaultAWSConfig()
//        if err != nil {
//            panic("failed to load config, " + err.Error())
//        }
//
//        svc := sagemaker.New(cfg)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockClientClient struct {
//        sagemakeriface.ClientPI
//    }
//    func (m *mockClientClient) AddTags(input *sagemaker.AddTagsInput) (*sagemaker.AddTagsOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockClientClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type ClientAPI interface {
	AddTagsRequest(*sagemaker.AddTagsInput) sagemaker.AddTagsRequest

	AssociateTrialComponentRequest(*sagemaker.AssociateTrialComponentInput) sagemaker.AssociateTrialComponentRequest

	CreateAlgorithmRequest(*sagemaker.CreateAlgorithmInput) sagemaker.CreateAlgorithmRequest

	CreateAppRequest(*sagemaker.CreateAppInput) sagemaker.CreateAppRequest

	CreateAutoMLJobRequest(*sagemaker.CreateAutoMLJobInput) sagemaker.CreateAutoMLJobRequest

	CreateCodeRepositoryRequest(*sagemaker.CreateCodeRepositoryInput) sagemaker.CreateCodeRepositoryRequest

	CreateCompilationJobRequest(*sagemaker.CreateCompilationJobInput) sagemaker.CreateCompilationJobRequest

	CreateDomainRequest(*sagemaker.CreateDomainInput) sagemaker.CreateDomainRequest

	CreateEndpointRequest(*sagemaker.CreateEndpointInput) sagemaker.CreateEndpointRequest

	CreateEndpointConfigRequest(*sagemaker.CreateEndpointConfigInput) sagemaker.CreateEndpointConfigRequest

	CreateExperimentRequest(*sagemaker.CreateExperimentInput) sagemaker.CreateExperimentRequest

	CreateFlowDefinitionRequest(*sagemaker.CreateFlowDefinitionInput) sagemaker.CreateFlowDefinitionRequest

	CreateHumanTaskUiRequest(*sagemaker.CreateHumanTaskUiInput) sagemaker.CreateHumanTaskUiRequest

	CreateHyperParameterTuningJobRequest(*sagemaker.CreateHyperParameterTuningJobInput) sagemaker.CreateHyperParameterTuningJobRequest

	CreateLabelingJobRequest(*sagemaker.CreateLabelingJobInput) sagemaker.CreateLabelingJobRequest

	CreateModelRequest(*sagemaker.CreateModelInput) sagemaker.CreateModelRequest

	CreateModelPackageRequest(*sagemaker.CreateModelPackageInput) sagemaker.CreateModelPackageRequest

	CreateMonitoringScheduleRequest(*sagemaker.CreateMonitoringScheduleInput) sagemaker.CreateMonitoringScheduleRequest

	CreateNotebookInstanceRequest(*sagemaker.CreateNotebookInstanceInput) sagemaker.CreateNotebookInstanceRequest

	CreateNotebookInstanceLifecycleConfigRequest(*sagemaker.CreateNotebookInstanceLifecycleConfigInput) sagemaker.CreateNotebookInstanceLifecycleConfigRequest

	CreatePresignedDomainUrlRequest(*sagemaker.CreatePresignedDomainUrlInput) sagemaker.CreatePresignedDomainUrlRequest

	CreatePresignedNotebookInstanceUrlRequest(*sagemaker.CreatePresignedNotebookInstanceUrlInput) sagemaker.CreatePresignedNotebookInstanceUrlRequest

	CreateProcessingJobRequest(*sagemaker.CreateProcessingJobInput) sagemaker.CreateProcessingJobRequest

	CreateTrainingJobRequest(*sagemaker.CreateTrainingJobInput) sagemaker.CreateTrainingJobRequest

	CreateTransformJobRequest(*sagemaker.CreateTransformJobInput) sagemaker.CreateTransformJobRequest

	CreateTrialRequest(*sagemaker.CreateTrialInput) sagemaker.CreateTrialRequest

	CreateTrialComponentRequest(*sagemaker.CreateTrialComponentInput) sagemaker.CreateTrialComponentRequest

	CreateUserProfileRequest(*sagemaker.CreateUserProfileInput) sagemaker.CreateUserProfileRequest

	CreateWorkteamRequest(*sagemaker.CreateWorkteamInput) sagemaker.CreateWorkteamRequest

	DeleteAlgorithmRequest(*sagemaker.DeleteAlgorithmInput) sagemaker.DeleteAlgorithmRequest

	DeleteAppRequest(*sagemaker.DeleteAppInput) sagemaker.DeleteAppRequest

	DeleteCodeRepositoryRequest(*sagemaker.DeleteCodeRepositoryInput) sagemaker.DeleteCodeRepositoryRequest

	DeleteDomainRequest(*sagemaker.DeleteDomainInput) sagemaker.DeleteDomainRequest

	DeleteEndpointRequest(*sagemaker.DeleteEndpointInput) sagemaker.DeleteEndpointRequest

	DeleteEndpointConfigRequest(*sagemaker.DeleteEndpointConfigInput) sagemaker.DeleteEndpointConfigRequest

	DeleteExperimentRequest(*sagemaker.DeleteExperimentInput) sagemaker.DeleteExperimentRequest

	DeleteFlowDefinitionRequest(*sagemaker.DeleteFlowDefinitionInput) sagemaker.DeleteFlowDefinitionRequest

	DeleteHumanTaskUiRequest(*sagemaker.DeleteHumanTaskUiInput) sagemaker.DeleteHumanTaskUiRequest

	DeleteModelRequest(*sagemaker.DeleteModelInput) sagemaker.DeleteModelRequest

	DeleteModelPackageRequest(*sagemaker.DeleteModelPackageInput) sagemaker.DeleteModelPackageRequest

	DeleteMonitoringScheduleRequest(*sagemaker.DeleteMonitoringScheduleInput) sagemaker.DeleteMonitoringScheduleRequest

	DeleteNotebookInstanceRequest(*sagemaker.DeleteNotebookInstanceInput) sagemaker.DeleteNotebookInstanceRequest

	DeleteNotebookInstanceLifecycleConfigRequest(*sagemaker.DeleteNotebookInstanceLifecycleConfigInput) sagemaker.DeleteNotebookInstanceLifecycleConfigRequest

	DeleteTagsRequest(*sagemaker.DeleteTagsInput) sagemaker.DeleteTagsRequest

	DeleteTrialRequest(*sagemaker.DeleteTrialInput) sagemaker.DeleteTrialRequest

	DeleteTrialComponentRequest(*sagemaker.DeleteTrialComponentInput) sagemaker.DeleteTrialComponentRequest

	DeleteUserProfileRequest(*sagemaker.DeleteUserProfileInput) sagemaker.DeleteUserProfileRequest

	DeleteWorkteamRequest(*sagemaker.DeleteWorkteamInput) sagemaker.DeleteWorkteamRequest

	DescribeAlgorithmRequest(*sagemaker.DescribeAlgorithmInput) sagemaker.DescribeAlgorithmRequest

	DescribeAppRequest(*sagemaker.DescribeAppInput) sagemaker.DescribeAppRequest

	DescribeAutoMLJobRequest(*sagemaker.DescribeAutoMLJobInput) sagemaker.DescribeAutoMLJobRequest

	DescribeCodeRepositoryRequest(*sagemaker.DescribeCodeRepositoryInput) sagemaker.DescribeCodeRepositoryRequest

	DescribeCompilationJobRequest(*sagemaker.DescribeCompilationJobInput) sagemaker.DescribeCompilationJobRequest

	DescribeDomainRequest(*sagemaker.DescribeDomainInput) sagemaker.DescribeDomainRequest

	DescribeEndpointRequest(*sagemaker.DescribeEndpointInput) sagemaker.DescribeEndpointRequest

	DescribeEndpointConfigRequest(*sagemaker.DescribeEndpointConfigInput) sagemaker.DescribeEndpointConfigRequest

	DescribeExperimentRequest(*sagemaker.DescribeExperimentInput) sagemaker.DescribeExperimentRequest

	DescribeFlowDefinitionRequest(*sagemaker.DescribeFlowDefinitionInput) sagemaker.DescribeFlowDefinitionRequest

	DescribeHumanTaskUiRequest(*sagemaker.DescribeHumanTaskUiInput) sagemaker.DescribeHumanTaskUiRequest

	DescribeHyperParameterTuningJobRequest(*sagemaker.DescribeHyperParameterTuningJobInput) sagemaker.DescribeHyperParameterTuningJobRequest

	DescribeLabelingJobRequest(*sagemaker.DescribeLabelingJobInput) sagemaker.DescribeLabelingJobRequest

	DescribeModelRequest(*sagemaker.DescribeModelInput) sagemaker.DescribeModelRequest

	DescribeModelPackageRequest(*sagemaker.DescribeModelPackageInput) sagemaker.DescribeModelPackageRequest

	DescribeMonitoringScheduleRequest(*sagemaker.DescribeMonitoringScheduleInput) sagemaker.DescribeMonitoringScheduleRequest

	DescribeNotebookInstanceRequest(*sagemaker.DescribeNotebookInstanceInput) sagemaker.DescribeNotebookInstanceRequest

	DescribeNotebookInstanceLifecycleConfigRequest(*sagemaker.DescribeNotebookInstanceLifecycleConfigInput) sagemaker.DescribeNotebookInstanceLifecycleConfigRequest

	DescribeProcessingJobRequest(*sagemaker.DescribeProcessingJobInput) sagemaker.DescribeProcessingJobRequest

	DescribeSubscribedWorkteamRequest(*sagemaker.DescribeSubscribedWorkteamInput) sagemaker.DescribeSubscribedWorkteamRequest

	DescribeTrainingJobRequest(*sagemaker.DescribeTrainingJobInput) sagemaker.DescribeTrainingJobRequest

	DescribeTransformJobRequest(*sagemaker.DescribeTransformJobInput) sagemaker.DescribeTransformJobRequest

	DescribeTrialRequest(*sagemaker.DescribeTrialInput) sagemaker.DescribeTrialRequest

	DescribeTrialComponentRequest(*sagemaker.DescribeTrialComponentInput) sagemaker.DescribeTrialComponentRequest

	DescribeUserProfileRequest(*sagemaker.DescribeUserProfileInput) sagemaker.DescribeUserProfileRequest

	DescribeWorkforceRequest(*sagemaker.DescribeWorkforceInput) sagemaker.DescribeWorkforceRequest

	DescribeWorkteamRequest(*sagemaker.DescribeWorkteamInput) sagemaker.DescribeWorkteamRequest

	DisassociateTrialComponentRequest(*sagemaker.DisassociateTrialComponentInput) sagemaker.DisassociateTrialComponentRequest

	GetSearchSuggestionsRequest(*sagemaker.GetSearchSuggestionsInput) sagemaker.GetSearchSuggestionsRequest

	ListAlgorithmsRequest(*sagemaker.ListAlgorithmsInput) sagemaker.ListAlgorithmsRequest

	ListAppsRequest(*sagemaker.ListAppsInput) sagemaker.ListAppsRequest

	ListAutoMLJobsRequest(*sagemaker.ListAutoMLJobsInput) sagemaker.ListAutoMLJobsRequest

	ListCandidatesForAutoMLJobRequest(*sagemaker.ListCandidatesForAutoMLJobInput) sagemaker.ListCandidatesForAutoMLJobRequest

	ListCodeRepositoriesRequest(*sagemaker.ListCodeRepositoriesInput) sagemaker.ListCodeRepositoriesRequest

	ListCompilationJobsRequest(*sagemaker.ListCompilationJobsInput) sagemaker.ListCompilationJobsRequest

	ListDomainsRequest(*sagemaker.ListDomainsInput) sagemaker.ListDomainsRequest

	ListEndpointConfigsRequest(*sagemaker.ListEndpointConfigsInput) sagemaker.ListEndpointConfigsRequest

	ListEndpointsRequest(*sagemaker.ListEndpointsInput) sagemaker.ListEndpointsRequest

	ListExperimentsRequest(*sagemaker.ListExperimentsInput) sagemaker.ListExperimentsRequest

	ListFlowDefinitionsRequest(*sagemaker.ListFlowDefinitionsInput) sagemaker.ListFlowDefinitionsRequest

	ListHumanTaskUisRequest(*sagemaker.ListHumanTaskUisInput) sagemaker.ListHumanTaskUisRequest

	ListHyperParameterTuningJobsRequest(*sagemaker.ListHyperParameterTuningJobsInput) sagemaker.ListHyperParameterTuningJobsRequest

	ListLabelingJobsRequest(*sagemaker.ListLabelingJobsInput) sagemaker.ListLabelingJobsRequest

	ListLabelingJobsForWorkteamRequest(*sagemaker.ListLabelingJobsForWorkteamInput) sagemaker.ListLabelingJobsForWorkteamRequest

	ListModelPackagesRequest(*sagemaker.ListModelPackagesInput) sagemaker.ListModelPackagesRequest

	ListModelsRequest(*sagemaker.ListModelsInput) sagemaker.ListModelsRequest

	ListMonitoringExecutionsRequest(*sagemaker.ListMonitoringExecutionsInput) sagemaker.ListMonitoringExecutionsRequest

	ListMonitoringSchedulesRequest(*sagemaker.ListMonitoringSchedulesInput) sagemaker.ListMonitoringSchedulesRequest

	ListNotebookInstanceLifecycleConfigsRequest(*sagemaker.ListNotebookInstanceLifecycleConfigsInput) sagemaker.ListNotebookInstanceLifecycleConfigsRequest

	ListNotebookInstancesRequest(*sagemaker.ListNotebookInstancesInput) sagemaker.ListNotebookInstancesRequest

	ListProcessingJobsRequest(*sagemaker.ListProcessingJobsInput) sagemaker.ListProcessingJobsRequest

	ListSubscribedWorkteamsRequest(*sagemaker.ListSubscribedWorkteamsInput) sagemaker.ListSubscribedWorkteamsRequest

	ListTagsRequest(*sagemaker.ListTagsInput) sagemaker.ListTagsRequest

	ListTrainingJobsRequest(*sagemaker.ListTrainingJobsInput) sagemaker.ListTrainingJobsRequest

	ListTrainingJobsForHyperParameterTuningJobRequest(*sagemaker.ListTrainingJobsForHyperParameterTuningJobInput) sagemaker.ListTrainingJobsForHyperParameterTuningJobRequest

	ListTransformJobsRequest(*sagemaker.ListTransformJobsInput) sagemaker.ListTransformJobsRequest

	ListTrialComponentsRequest(*sagemaker.ListTrialComponentsInput) sagemaker.ListTrialComponentsRequest

	ListTrialsRequest(*sagemaker.ListTrialsInput) sagemaker.ListTrialsRequest

	ListUserProfilesRequest(*sagemaker.ListUserProfilesInput) sagemaker.ListUserProfilesRequest

	ListWorkteamsRequest(*sagemaker.ListWorkteamsInput) sagemaker.ListWorkteamsRequest

	RenderUiTemplateRequest(*sagemaker.RenderUiTemplateInput) sagemaker.RenderUiTemplateRequest

	SearchRequest(*sagemaker.SearchInput) sagemaker.SearchRequest

	StartMonitoringScheduleRequest(*sagemaker.StartMonitoringScheduleInput) sagemaker.StartMonitoringScheduleRequest

	StartNotebookInstanceRequest(*sagemaker.StartNotebookInstanceInput) sagemaker.StartNotebookInstanceRequest

	StopAutoMLJobRequest(*sagemaker.StopAutoMLJobInput) sagemaker.StopAutoMLJobRequest

	StopCompilationJobRequest(*sagemaker.StopCompilationJobInput) sagemaker.StopCompilationJobRequest

	StopHyperParameterTuningJobRequest(*sagemaker.StopHyperParameterTuningJobInput) sagemaker.StopHyperParameterTuningJobRequest

	StopLabelingJobRequest(*sagemaker.StopLabelingJobInput) sagemaker.StopLabelingJobRequest

	StopMonitoringScheduleRequest(*sagemaker.StopMonitoringScheduleInput) sagemaker.StopMonitoringScheduleRequest

	StopNotebookInstanceRequest(*sagemaker.StopNotebookInstanceInput) sagemaker.StopNotebookInstanceRequest

	StopProcessingJobRequest(*sagemaker.StopProcessingJobInput) sagemaker.StopProcessingJobRequest

	StopTrainingJobRequest(*sagemaker.StopTrainingJobInput) sagemaker.StopTrainingJobRequest

	StopTransformJobRequest(*sagemaker.StopTransformJobInput) sagemaker.StopTransformJobRequest

	UpdateCodeRepositoryRequest(*sagemaker.UpdateCodeRepositoryInput) sagemaker.UpdateCodeRepositoryRequest

	UpdateDomainRequest(*sagemaker.UpdateDomainInput) sagemaker.UpdateDomainRequest

	UpdateEndpointRequest(*sagemaker.UpdateEndpointInput) sagemaker.UpdateEndpointRequest

	UpdateEndpointWeightsAndCapacitiesRequest(*sagemaker.UpdateEndpointWeightsAndCapacitiesInput) sagemaker.UpdateEndpointWeightsAndCapacitiesRequest

	UpdateExperimentRequest(*sagemaker.UpdateExperimentInput) sagemaker.UpdateExperimentRequest

	UpdateMonitoringScheduleRequest(*sagemaker.UpdateMonitoringScheduleInput) sagemaker.UpdateMonitoringScheduleRequest

	UpdateNotebookInstanceRequest(*sagemaker.UpdateNotebookInstanceInput) sagemaker.UpdateNotebookInstanceRequest

	UpdateNotebookInstanceLifecycleConfigRequest(*sagemaker.UpdateNotebookInstanceLifecycleConfigInput) sagemaker.UpdateNotebookInstanceLifecycleConfigRequest

	UpdateTrialRequest(*sagemaker.UpdateTrialInput) sagemaker.UpdateTrialRequest

	UpdateTrialComponentRequest(*sagemaker.UpdateTrialComponentInput) sagemaker.UpdateTrialComponentRequest

	UpdateUserProfileRequest(*sagemaker.UpdateUserProfileInput) sagemaker.UpdateUserProfileRequest

	UpdateWorkforceRequest(*sagemaker.UpdateWorkforceInput) sagemaker.UpdateWorkforceRequest

	UpdateWorkteamRequest(*sagemaker.UpdateWorkteamInput) sagemaker.UpdateWorkteamRequest

	WaitUntilEndpointDeleted(context.Context, *sagemaker.DescribeEndpointInput, ...aws.WaiterOption) error

	WaitUntilEndpointInService(context.Context, *sagemaker.DescribeEndpointInput, ...aws.WaiterOption) error

	WaitUntilNotebookInstanceDeleted(context.Context, *sagemaker.DescribeNotebookInstanceInput, ...aws.WaiterOption) error

	WaitUntilNotebookInstanceInService(context.Context, *sagemaker.DescribeNotebookInstanceInput, ...aws.WaiterOption) error

	WaitUntilNotebookInstanceStopped(context.Context, *sagemaker.DescribeNotebookInstanceInput, ...aws.WaiterOption) error

	WaitUntilProcessingJobCompletedOrStopped(context.Context, *sagemaker.DescribeProcessingJobInput, ...aws.WaiterOption) error

	WaitUntilTrainingJobCompletedOrStopped(context.Context, *sagemaker.DescribeTrainingJobInput, ...aws.WaiterOption) error

	WaitUntilTransformJobCompletedOrStopped(context.Context, *sagemaker.DescribeTransformJobInput, ...aws.WaiterOption) error
}

var _ ClientAPI = (*sagemaker.Client)(nil)
