// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package securityhub

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type CreateInsightInput struct {
	_ struct{} `type:"structure"`

	// One or more attributes used to filter the findings included in the insight.
	// The insight only includes findings that match the criteria defined in the
	// filters.
	//
	// Filters is a required field
	Filters *AwsSecurityFindingFilters `type:"structure" required:"true"`

	// The attribute used to group the findings for the insight. The grouping attribute
	// identifies the type of item that the insight applies to. For example, if
	// an insight is grouped by resource identifier, then the insight produces a
	// list of resource identifiers.
	//
	// GroupByAttribute is a required field
	GroupByAttribute *string `type:"string" required:"true"`

	// The name of the custom insight to create.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateInsightInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateInsightInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateInsightInput"}

	if s.Filters == nil {
		invalidParams.Add(aws.NewErrParamRequired("Filters"))
	}

	if s.GroupByAttribute == nil {
		invalidParams.Add(aws.NewErrParamRequired("GroupByAttribute"))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateInsightInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Filters != nil {
		v := s.Filters

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Filters", v, metadata)
	}
	if s.GroupByAttribute != nil {
		v := *s.GroupByAttribute

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "GroupByAttribute", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type CreateInsightOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the insight created.
	//
	// InsightArn is a required field
	InsightArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateInsightOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateInsightOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.InsightArn != nil {
		v := *s.InsightArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "InsightArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opCreateInsight = "CreateInsight"

// CreateInsightRequest returns a request value for making API operation for
// AWS SecurityHub.
//
// Creates a custom insight in Security Hub. An insight is a consolidation of
// findings that relate to a security issue that requires attention or remediation.
//
// To group the related findings in the insight, use the GroupByAttribute.
//
//    // Example sending a request using CreateInsightRequest.
//    req := client.CreateInsightRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/CreateInsight
func (c *Client) CreateInsightRequest(input *CreateInsightInput) CreateInsightRequest {
	op := &aws.Operation{
		Name:       opCreateInsight,
		HTTPMethod: "POST",
		HTTPPath:   "/insights",
	}

	if input == nil {
		input = &CreateInsightInput{}
	}

	req := c.newRequest(op, input, &CreateInsightOutput{})

	return CreateInsightRequest{Request: req, Input: input, Copy: c.CreateInsightRequest}
}

// CreateInsightRequest is the request type for the
// CreateInsight API operation.
type CreateInsightRequest struct {
	*aws.Request
	Input *CreateInsightInput
	Copy  func(*CreateInsightInput) CreateInsightRequest
}

// Send marshals and sends the CreateInsight API request.
func (r CreateInsightRequest) Send(ctx context.Context) (*CreateInsightResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateInsightResponse{
		CreateInsightOutput: r.Request.Data.(*CreateInsightOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateInsightResponse is the response type for the
// CreateInsight API operation.
type CreateInsightResponse struct {
	*CreateInsightOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateInsight request.
func (r *CreateInsightResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
